@extends($_viewFrame)

@section('pageTitleMain')搜索「{{$keywords}}」@endsection
@section('pageKeywords')搜索「{{$keywords}}」@endsection
@section('pageDescription')搜索「{{$keywords}}」@endsection

{!! \ModStart\ModStart::js('asset/common/timeago.js') !!}
{!! \ModStart\ModStart::js('asset/vendor/jqueryMark.js') !!}
{!! \ModStart\ModStart::style('[data-markjs]{color:red !important;background:transparent;}') !!}
{!! \ModStart\ModStart::script("$('.item-d .title').mark(".json_encode($keywords).",{});") !!}


@section('bodyContent')

    <div class="ub-search-block">
        <div class="title">
            {{modstart_config('siteName')}}
        </div>
        <div class="form">
            <form action="{{modstart_web_url('wenda/search')}}" method="get">
                <div class="box">
                    <input type="text" name="keywords" class="form form-lg" value="{{ empty($keywords) ? '' : $keywords }}" placeholder="输入关键词搜索" />
                    <button type="submit" class="btn btn-lg"><i class="iconfont icon-search"></i> 搜索</button>
                </div>
            </form>
        </div>
    </div>

    @if(empty($keywords))
        <div class="ub-empty">
            <div class="icon">
                <div class="iconfont icon-empty-box"></div>
            </div>
            <div class="text">请输入关键词搜索</div>
        </div>
    @else
        <div class="ub-container">
            <div class="ub-breadcrumb">
                <a href="{{modstart_web_url('wenda')}}">问答</a>
                <a href="{{modstart_web_url('wenda/ask')}}">问答库</a>
                <a class="active" href="javascript:;">搜索「{{$keywords}}」</a>
            </div>
            <div class="ub-search-result">
                搜索 <span class="keyword">{{$keywords}}</span> ，共找到 <span class="count">{{$total}}</span> 条记录
            </div>

            <div class="ub-panel">
                <div class="body">
                    @include('module::Wenda.View.pc.wenda.inc.listAsks',['records'=>$records])
                    <div class="ub-page">
                        {!! $pageHtml !!}
                    </div>
                </div>
            </div>
        </div>
    @endif

@endsection
