@extends('module::Wenda.View.pc.wenda.member.frame')

@section('pageTitleMain'){{'用户 '.$memberUser['nickname'].' 的回答'}}@endsection
@section('pageKeywords'){{'用户 '.$memberUser['nickname'].' 的回答'}}@endsection
@section('pageDescription'){{'用户 '.$memberUser['nickname'].' 的回答'}}@endsection

@section('memberContent')

    <div class="ub-panel">
        <div class="body">
            @if(empty($records))
                <div class="ub-empty">
                    <div class="icon">
                        <div class="iconfont icon-empty-box"></div>
                    </div>
                    <div class="text">暂无记录</div>
                </div>
            @endif
            @foreach($records as $record)
                <div class="ub-padding tw-bg-white tw-my-2">
                    <div class="tw-flex tw-flex-wrap">
                        <div class="tw-flex-grow tw-w-full lg:tw-w-auto">
                            <a href="{{modstart_web_url('wenda/ask/'.$record['askId'])}}" class="tw-text-lg tw-text-gray-800">
                                {{$record['_ask']['title']}}
                            </a>
                        </div>
                    </div>
                    <div class="tw-my-2">
                        <div class="ub-html tw-bg-gray-200 tw-p-2 tw-rounded">{!! $record['contentHtml'] !!}</div>
                    </div>
                    <div class="tw-flex">
                        <div class="">
                            <a href="{{modstart_web_url('wenda/ask/'.$record['askId'])}}" class="btn">
                                <i class="iconfont icon-eye"></i>
                                查看回复
                            </a>
                        </div>
                        <div class="tw-inline-block tw-flex-grow ub-text-right tw-leading-8">
                                        <span class="ub-text-muted">
                                            <time datetime="{{$record['created_at']}}"></time>
                                        </span>
                        </div>
                    </div>
                </div>
            @endforeach
            <div class="ub-page">
                {!! $pageHtml !!}
            </div>
        </div>
    </div>

@endsection
