@extends('module::Wenda.View.pc.wenda.member.frame')

@section('pageTitleMain'){{'用户 '.$memberUser['nickname']}}的提问@endsection
@section('pageKeywords'){{'用户 '.$memberUser['nickname']}}的提问@endsection
@section('pageDescription'){{'用户 '.$memberUser['nickname']}}的提问@endsection

@section('memberContent')

    <div class="ub-panel margin-bottom">
        <div class="head">
            <div class="title">TA的提问</div>
        </div>
        <div class="body">
            @if(empty($asks))
                <div class="ub-empty">
                    <div class="icon">
                        <div class="iconfont icon-empty-box"></div>
                    </div>
                    <div class="text">暂无记录</div>
                </div>
            @endif
            @foreach($asks as $record)
                <div class="tw-mb-2 tw-relative tw-overflow-hidden">
                    <div class="tw-bg-white tw-py-6 tw-border-0 tw-border-b tw-border-solid tw-border-gray-100">
                        <div class="tw-flex tw-px-2">
                            <div class="@if($record['replyCount']) ub-bg-primary @else tw-bg-gray-200 @endif lg:tw-py-2 tw-py-0 tw-mr-2 lg:tw-w-14 lg:tw-h-14 tw-w-10 tw-h-10 tw-flex-shrink-0 tw-rounded tw-text-white tw-flex tw-flex-col tw-items-center">
                                <span class="tw-text-lg">{{$record['replyCount']}}</span>
                                <span class="tw-text-xs">回答</span>
                            </div>
                            <div class="tw-bg-gray-200 tw-py-2 lg:tw-flex tw-hidden tw-mr-2 tw-w-14 tw-h-14 tw-flex-shrink-0 tw-rounded tw-text-black tw-flex tw-flex-col tw-items-center">
                                <span class="tw-text-lg">{{$record['viewsCount']}}</span>
                                <span class="tw-text-xs">浏览</span>
                            </div>
                            <div class="tw-pl-2 tw-flex-grow">
                                <a href="{{modstart_web_url('wenda/ask/'.$record['id'])}}" class="tw-block tw-text-black tw-text-lg">
                                    {{$record['title']}}
                                </a>
                                <div class="tw-flex tw-mt-2">
                                    <a href="{{modstart_web_url('wenda/member/'.$record['memberUserId'])}}"
                                       class="tw-block tw-w-4 tw-h-4 tw-bg-cover tw-bg-center tw-rounded-full tw-shadow-inner"
                                       style="background-image:url({{$record['_memberUser']['avatar']}})">
                                    </a>
                                    <div class="tw-flex tw-text-gray-600 tw-ml-2">{{$record['_memberUser']['nickname']}}</div>
                                    <div class="tw-flex tw-ml-2 tw-items-center tw-text-xs tw-text-gray-400">
                                        <span><time datetime="{{$record['created_at']}}"></time></span>
                                        <span class="tw-px-1">•</span>
                                        <span>{{$record['_memberUser']['signature']}}</span>
                                    </div>
                                </div>
                            </div>
                            @if($record['status']==\Module\Wenda\Type\WendaAskStatus::RESOLVED)
                                <div class="tw-bg-blue-200 tw-absolute tw-bg-opacity-50 tw-px-4 tw--right-5 tw-top-2 tw-py-1 tw-w-20 tw-h-6 tw-flex-shrink-0 tw-rounded tw-text-black tw-flex tw-flex-col tw-items-center tw-transform tw-rotate-45">
                                    <span class="tw-text-blue-500 tw-text-sm">已解决</span>
                                </div>
                            @endif
                            @if($record['rewardCredit']>0)
                                <div class="tw-bg-red-200 tw-absolute tw-bg-opacity-50 tw-px-4 tw--right-5 tw-top-2 tw-py-1 tw-w-20 tw-h-6 tw-flex-shrink-0 tw-rounded tw-text-black tw-flex tw-flex-col tw-items-center tw-transform tw-rotate-45">
                                    <span class="tw-text-red-500 tw-text-sm">有悬赏</span>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    <div class="ub-panel">
        <div class="head">
            <div class="title">TA的回复</div>
        </div>
        <div class="body">
            @if(empty($replies))
                <div class="ub-empty">
                    <div class="icon">
                        <div class="iconfont icon-empty-box"></div>
                    </div>
                    <div class="text">暂无记录</div>
                </div>
            @endif
            @foreach($replies as $record)
                <div class="ub-padding tw-bg-white tw-my-2">
                    <div class="tw-flex tw-flex-wrap">
                        <div class="tw-flex-grow tw-w-full lg:tw-w-auto">
                            <a href="{{modstart_web_url('wenda/ask/'.$record['askId'])}}" class="tw-text-lg tw-text-gray-800">
                                {{$record['_ask']['title']}}
                            </a>
                        </div>
                    </div>
                    <div class="tw-my-2">
                        <div class="ub-html tw-bg-gray-200 tw-p-2 tw-rounded">{!! $record['contentHtml'] !!}</div>
                    </div>
                    <div class="tw-flex">
                        <div class="">
                            <a href="{{modstart_web_url('wenda/ask/'.$record['askId'])}}" class="btn">
                                <i class="iconfont icon-eye"></i>
                                查看提问
                            </a>
                        </div>
                        <div class="tw-inline-block tw-flex-grow ub-text-right tw-leading-8">
                                        <span class="ub-text-muted">
                                            <time datetime="{{$record['created_at']}}"></time>
                                        </span>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

@endsection
