@extends($_viewFrame)

@section('pageTitleMain'){{'用户 '.$memberUser['nickname']}}@endsection
@section('pageKeywords'){{'用户 '.$memberUser['nickname']}}@endsection
@section('pageDescription'){{'用户 '.$memberUser['nickname']}}@endsection

{!! \ModStart\ModStart::js('asset/common/timeago.js') !!}
{!! \ModStart\ModStart::styleFile('public/vendor/MemberFollow/asset/memberFollow.css') !!}
{!! \ModStart\ModStart::scriptFile('public/vendor/MemberFollow/asset/memberFollow.js') !!}

@section('bodyContent')

    <div class="ub-container">

        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('wenda')}}">问答</a>
            <a class="active" href="javascript:;">{{$memberUser['nickname']}}</a>
        </div>

        <div class="tw-bg-white tw-rounded tw-shadow">
            <div class="tw-flex tw-p-4 tw-flex-wrap">
                <div class="tw-flex-shrink-0 tw-w-20">
                    <a href="{{modstart_web_url('wenda/member/'.$memberUser['id'])}}" class="tw-block tw-w-16 tw-h-16 ub-cover-1-1 tw-rounded-full tw-shadow"
                       style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($memberUser['avatar'])}})"></a>
                </div>
                <div class="tw-flex-grow">
                    <div class="tw-text-bold">{{$memberUser['nickname']}}</div>
                    <div class="tw-text-gray-400">{{ empty($memberUser['signature']) ? '暂无签名' : $memberUser['signature'] }}</div>
                    <div class="tw-flex tw-mt-3">
                        <a href="{{modstart_web_url('wenda/member/'.$memberUser['id'].'/replies')}}" class="tw-text-center tw-pr-4 tw-text-sm">
                            <div class="tw-text-gray-300">回答</div>
                            <div class="tw-text-gray-900">{{ empty($memberUser['_replyCount']) ? '0' : $memberUser['_replyCount'] }}</div>
                        </a>
                        <a href="{{modstart_web_url('wenda/member/'.$memberUser['id'].'/asks')}}" class="tw-text-center tw-pr-4 tw-text-sm">
                            <div class="tw-text-gray-300">提问</div>
                            <div class="tw-text-gray-900">{{ empty($memberUser['_askCount']) ? '0' : $memberUser['_askCount'] }}</div>
                        </a>
                        <a target="_blank" href="{{modstart_web_url('member_follow/'.$memberUser['id'].'/followers')}}" class="tw-text-center tw-pr-4 tw-text-sm">
                            <div class="tw-text-gray-300">粉丝</div>
                            <div class="tw-text-gray-900">{{ empty($memberUser['followerCount']) ? '0' : $memberUser['followerCount'] }}</div>
                        </a>
                        <a target="_blank" href="{{modstart_web_url('member_follow/'.$memberUser['id'].'/following')}}" class="tw-text-center tw-pr-4 tw-text-sm">
                            <div class="tw-text-gray-300">关注</div>
                            <div class="tw-text-gray-900">{{ empty($memberUser['followCount']) ? '0' : $memberUser['followCount'] }}</div>
                        </a>
                    </div>
                </div>
                <div class="tw-flex tw-items-start tw-w-full tw-flex-shrink-0 tw-ml-20 tw-mt-4 lg:tw-w-auto">
                    <a href="{{modstart_web_url('wenda/ask/edit',['invite'=>$memberUser['id']])}}" class="btn btn-primary tw-mr-1">
                        <i class="iconfont icon-comment"></i>
                        提问
                    </a>
                    @if(\Module\Member\Auth\MemberUser::id()!=$memberUser['id'])
                        <div class="tw-inline-block" data-member-follow-item data-status="{{!empty($memberUser['_isFollow'])?'is_follow':'not_follow'}}" data-id="{{$memberUser['id']}}">
                            <a href="javascript:;" data-action="follow" class="btn btn-primary-line">
                                <i class="iconfont icon-plus"></i>
                                关注
                            </a>
                            <a href="javascript:;" data-action="unfollow" class="btn">
                                <i class="iconfont icon-check"></i>
                                已关注
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="row margin-bottom">
            <div class="col-md-8">
                <div class="ub-nav-tab">
                    <a class="{{modstart_baseurl_active('wenda/member/'.$memberUser['id'])}}" href="{{modstart_web_url('wenda/member/'.$memberUser['id'])}}">动态</a>
                    <a class="{{modstart_baseurl_active('wenda/member/'.$memberUser['id'].'/replies')}}" href="{{modstart_web_url('wenda/member/'.$memberUser['id'].'/replies')}}">回答</a>
                    <a class="{{modstart_baseurl_active('wenda/member/'.$memberUser['id'].'/asks')}}" href="{{modstart_web_url('wenda/member/'.$memberUser['id'].'/asks')}}">提问</a>
                </div>
                <div>
                    @section('memberContent')@show
                </div>
            </div>
            <div class="col-md-4">
                @if($memberUser['_expert'])
                    <div class="ub-panel">
                        <div class="head">
                            <div class="title"><i class="iconfont icon-cart"></i> 认证专家</div>
                        </div>
                        <div class="body">
                            <div class="ub-html lg">
                                {!! \ModStart\Core\Util\HtmlUtil::text2html($memberUser['_expert']['description']) !!}
                            </div>
                        </div>
                    </div>
                @endif
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">基本信息</div>
                    </div>
                    <div class="body">
                        <div class="ub-text-muted">注册于 <time datetime="{{$memberUser['created_at']}}"></time></div>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection
