@extends($_viewFrame)

@section('pageTitle'){{modstart_config('siteName')}} | {{modstart_config('siteSlogan')}}@endsection

@section('bodyContent')

    <div class="ub-container margin-top">
        <div class="row">
            <div class="col-md-9">

                <div class="ub-content-box margin-bottom tw-overflow-hidden" style="padding:0;">
                    {!! \Module\Banner\View\BannerView::basic('wendaHome') !!}
                </div>

                <div class="ub-nav-tab margin-bottom">
                    <a href="{{modstart_web_url('wenda/ask')}}" class="active">最新提问</a>
                    <a href="{{modstart_web_url('wenda/ask',['type'=>'resolving'])}}">待解决</a>
                    <a href="{{modstart_web_url('wenda/ask',['type'=>'resolved'])}}">已解决</a>
                    <a href="{{modstart_web_url('wenda/ask',['type'=>'reward'])}}">积分悬赏</a>
                </div>
                <div class="margin-bottom">
                    @include('module::Wenda.View.pc.wenda.inc.listAsks',['records'=>$asks])
                </div>
                <div class="ub-content-box margin-bottom tw-text-center">
                    <a class="ub-text-muted" href="{{modstart_web_url('wenda/ask',['page'=>2])}}">
                        查看更多
                        <i class="iconfont icon-angle-down"></i>
                    </a>
                </div>
            </div>
            <div class="col-md-3">
                @include('module::Wenda.View.pc.wenda.inc.askButton')
                <div class="margin-bottom ub-bg-white tw-p-4 tw-text-center ub-text-primary tw-rounded">
                    <h1 class="tw-text-2xl">{{modstart_config('siteName','[网站名称]')}}</h1>
                    <div class="ub-text-primary">{{modstart_config('siteSlogan','[网站副标题]')}}</div>
                    <div class="tw-bg-gray-100 tw-rounded tw-text-gray-600 tw-mt-4">
                        <div class="tw-py-2">
                            <div class="tw-py-4">
                                总咨询提问数
                            </div>
                            <div class="tw-text-3xl">
                                {{\Module\Wenda\Util\WendaAskUtil::askTotal()}}个
                            </div>
                        </div>
                    </div>
                </div>
                @if(modstart_module_enabled('Ad'))
                    {!! \Module\Ad\View\AdView::simple('WendaHomeRight') !!}
                @endif
                <div class="tw-text-xl margin-bottom">
                    认证专家
                </div>
                <div class="margin-bottom">
                    @foreach($experts as $expert)
                        <div class="tw-bg-white tw-p-4 tw-rounded tw-mb-2">
                            <div class="tw-flex tw-justify-between tw-items-center">
                                <div class="tw-flex">
                                    <div class="tw-mr-4">
                                        <div class="ub-cover-1-1 tw-shadow tw-w-10 tw-h-10 tw-rounded-full" style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($expert['avatar'])}});">
                                        </div>
                                    </div>
                                    <div>
                                        <div class="tw-font-bold tw-text-gray-700">{{$expert['realname']}}</div>
                                        <div class="tw-text-gray-400 tw-text-sm">
                                            {{$expert['_memberUser']['signature']}}
                                        </div>
                                    </div>
                                </div>
                                <div>
                                    <a href="{{modstart_web_url('wenda/member/'.$expert['memberUserId'])}}" class="btn btn-primary-line btn-round">
                                        提问
                                    </a>
                                </div>
                            </div>
                            <div class="tw-border-0 tw-border-solid tw-border-t tw-border-gray-100 tw-mt-2 tw-pt-2 tw-text-gray-500">
                                {{$expert['description']}}
                            </div>
                        </div>
                    @endforeach
                    <div class="ub-content-box margin-bottom tw-text-center">
                        <a class="ub-text-muted" href="{{modstart_web_url('wenda/expert')}}">
                            查看更多
                            <i class="iconfont icon-angle-down"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="ub-container margin-bottom">
        {!! \Module\Partner\View\PartnerView::simple('wendaHome') !!}
    </div>
@endsection
