@extends($_viewFrame)

@section('pageTitle'){{'专家'}}@endsection
@section('pageKeywords'){{'专家'}}@endsection
@section('pageDescription'){{'专家'}}@endsection

@section('bodyContent')
    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('wenda')}}">问答</a>
            <a class="active" href="{{modstart_web_url('wenda/expert')}}">专家</a>
        </div>
        {{--        --}}
        {{--        <div class="ub-nav">--}}
        {{--            <a class="item" href="#">全部</a>--}}
        {{--            <a class="item active" href="#">分类1</a>--}}
        {{--            <a class="item" href="#">分类2</a>--}}
        {{--            <a class="item" href="#">积分悬赏</a>--}}
        {{--        </div>--}}

        {{--        <div class="ub-nav-tab margin-bottom">--}}
        {{--            <a href="#">全部</a>--}}
        {{--            <a href="#" class="active">免费</a>--}}
        {{--            <a href="#">付费</a>--}}
        {{--        </div>--}}

        <div class="row">
            @foreach($records as $record)
                <div class="col-md-3">
                    <div class="tw-pt-10">
                        <div class="tw-bg-white tw-p-4 tw-shadow-lg tw-rounded-lg tw-text-center">
                            <a href="{{modstart_web_url('wenda/member/'.$record['memberUserId'])}}"
                               class="ub-cover-1-1 tw--mt-10 tw-shadow-lg tw-w-14 tw-h-14 tw-rounded-full tw-mx-auto tw-bg-white"
                               style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['avatar'])}});">
                            </a>
                            <a class="tw-font-bold tw-text-lg tw-text-gray-700 tw-mt-4"
                               href="{{modstart_web_url('wenda/member/'.$record['memberUserId'])}}">
                                {{$record['realname']}}
                                <span class="ub-tag sm success">
                                    <i class="iconfont icon-check-alt"></i>
                                    已认证
                                </span>
                            </a>
                            @if($record['verifyStatus']==\Module\Wenda\Type\WendaExpertVerifyStatus::VERIFYING)
                                <div class="ub-alert warning">
                                    <i class="iconfont icon-warning"></i>
                                    正在审核，只有您自己可见
                                </div>
                            @endif
                            @if($record['verifyStatus']==\Module\Wenda\Type\WendaExpertVerifyStatus::REJECT)
                                <div class="ub-alert danger">
                                    <i class="iconfont icon-warning"></i>
                                    审核失败，只有您自己可见
                                </div>
                            @endif
                            <div class="tw-text-gray-400 tw-text-sm tw-mt-4 tw-truncate">
                                {{$record['description']}}
                            </div>
                            <div class="tw-flex tw-mt-4">
                                <a class="tw-flex-grow"
                                   href="{{modstart_web_url('wenda/member/'.$record['memberUserId'].'/replies')}}">
                                    <div class="tw-text-gray-400">回复</div>
                                    <div class="tw-text-lg tw-text-gray-900">{{ empty($record['replyCount']) ? '0' : $record['replyCount'] }}</div>
                                </a>
                                <a class="tw-flex-grow"
                                   href="{{modstart_web_url('wenda/expert/'.$record['memberUserId'].'/replies')}}">
                                    <div class="tw-text-gray-400">点赞</div>
                                    <div class="tw-text-lg tw-text-gray-900">{{ empty($record['upCount']) ? '0' : $record['upCount'] }}</div>
                                </a>
                                <a class="tw-flex-grow"
                                   href="{{modstart_web_url('member_follow/'.$record['memberUserId'].'/followers')}}">
                                    <div class="tw-text-gray-400">粉丝</div>
                                    <div class="tw-text-lg tw-text-gray-900">{{ empty($record['_memberUser']['followerCount']) ? '0' : $record['_memberUser']['followerCount'] }}</div>
                                </a>
                            </div>
                            <div class="tw-mt-4">
                                <a href="{{modstart_web_url('wenda/ask/edit',['invite'=>$record['memberUserId']])}}"
                                   class="btn btn-primary-line btn-round">
                                    发起提问
                                </a>
                                <a href="{{modstart_web_url('wenda/member/'.$record['memberUserId'])}}"
                                   class="btn btn-primary-line btn-round">
                                    查看
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

    </div>
@endsection
