@extends($_viewFrame)

@section('pageTitleMain'){{$record['title']}}@endsection
@section('pageKeywords'){{$record['title']}}@endsection
@section('pageDescription'){{$record['title']}}@endsection

{!! \ModStart\ModStart::js('asset/common/timeago.js') !!}
{!! \ModStart\ModStart::css('vendor/Vendor/asset/toggle.css') !!}
{!! \ModStart\ModStart::js('vendor/Vendor/asset/toggle.js') !!}

{!! \ModStart\ModStart::script('window.__selectorDialogServer = '.json_encode(modstart_web_url('member_data/file_manager')).';') !!}

@section('bodyContent')
    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('wenda')}}">问答</a>
            <a href="{{modstart_web_url('wenda/ask')}}">问答库</a>
            @if($record['_category'])
                <a href="{{modstart_web_url('wenda/ask?categoryId='.$record['categoryId'])}}">{{$record['_category']['title']}}</a>
            @endif
            <a class="active" href="{{modstart_web_url('wenda/show/'.$record['id'])}}">{{$record['title']}}</a>
        </div>
        <div class="row">
            <div class="col-md-9">
                <div class="ub-content-box">
                    <div class="tw-flex tw-flex-wrap">
                        <div class="tw-flex-grow tw-w-full lg:tw-w-auto">
                            <h1 class="tw-text-lg ub-text-prim ary tw-leading-6">
                                @if($record['rewardCredit'])
                                    <span class="tw-bg-blue-100 tw-text-blue-500 tw-rounded tw-px-2 tw-inline-block">
                                        <i class="iconfont icon-credit"></i>
                                        {{$record['rewardCredit']}}
                                    </span>
                                @endif
                                {{$record['title']}}
                            </h1>
                        </div>
                        <div class="tw-flex tw-mt-2 tw-w-full">
                            <a href="{{modstart_web_url('wenda/member/'.$record['memberUserId'])}}"
                               class="tw-block tw-w-4 tw-h-4 tw-bg-cover tw-bg-center tw-rounded-full tw-shadow-inner"
                               style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($record['_memberUser']['avatar'])}})">
                            </a>
                            <a href="{{modstart_web_url('wenda/member/'.$record['memberUserId'])}}"
                               class="tw-flex tw-text-gray-600 tw-ml-2">{{$record['_memberUser']['nickname']}}</a>
                            <div class="tw-flex tw-ml-2 tw-items-center tw-text-xs tw-text-gray-400">
                                <span><time datetime="{{$record['created_at']}}"></time></span>
                                <span class="tw-px-1">•</span>
                                <span>{{$record['_memberUser']['signature']}}</span>
                            </div>
                        </div>
                    </div>
                    @if($record['_isVerifying'])
                        <div class="ub-alert danger tw-my-4">
                            <i class="iconfont icon-warning"></i>
                            当前问答未发布完成，只有你和管理员可看到
                        </div>
                    @endif
                    <div class="tw-my-4 tw-py-4 tw-border-0 tw-border-t tw-border-solid tw-border-gray-200">
                        <div class="ub-html lg">
                            {!! $record['contentHtml'] !!}
                        </div>
                    </div>
                    <div class="tw-flex">
                        <div class="">
                            <span data-toggle-group="{{modstart_api_url('wenda/ask/follow')}}"
                                  data-id="{{$record['id']}}" data-status="{{$record['_followStatus']}}">
                                <a href="javascript:;" data-action="toggle" class="btn">
                                    <i class="iconfont icon-heart"></i>
                                    关注提问
                                </a>
                                <a href="javascript:;" data-action="untoggle" class="btn btn-primary">
                                    <i class="iconfont icon-heart"></i>
                                    取关提问
                                </a>
                            </span>
                            @if(\Module\Member\Auth\MemberUser::isLogin())
                                <a href="javascript:;" class="btn"
                                   onclick="$('[data-reply-box]').height()?$('[data-reply-box]').css('height','0').css('visibility','hidden'):$('[data-reply-box]').css('height','auto').css('visibility','visible');">
                                    <i class="iconfont icon-edit"></i>
                                    我来回答
                                </a>
                            @else
                                <a href="{{modstart_web_url('login',['redirect'=>\ModStart\Core\Input\Request::currentPageUrl()])}}"
                                   class="btn">
                                    <i class="iconfont icon-edit"></i>
                                    我来回答
                                </a>
                            @endif
                        </div>
                        <div class="tw-inline-block tw-flex-grow tw-flex tw-flex-row-reverse">
                            <div class="tw-flex-shrink-0 tw-w-14 tw-text-center">
                                <div class="tw-inline-block lg:tw-block tw-text-sm tw-text-gray-400">关注</div>
                                <div class="tw-inline-block lg:tw-block tw-text-lg"
                                     data-ask-follow-count-{{$record['id']}}>{{empty($record['followCount'])?'0':$record['followCount']}}</div>
                            </div>
                            <div class="tw-flex-shrink-0 tw-w-14 tw-text-center">
                                <div class="tw-inline-block lg:tw-block tw-text-sm tw-text-gray-400">浏览</div>
                                <div class="tw-inline-block lg:tw-block tw-text-lg">{{ empty($record['viewsCount']) ? '0' : $record['viewsCount'] }}</div>
                            </div>
                        </div>
                    </div>
                    @if(\Module\Member\Auth\MemberUser::isLogin())
                        <div data-reply-box style="overflow:hidden;height:0;visibility:hidden;">
                            <form action="{{modstart_api_url('wenda/ask/reply')}}" data-ajax-form method="post">
                                <input type="hidden" name="id" value="{{$record['id']}}"/>
                                <div class="ub-form vertical">
                                    <div class="line">
                                        <div class="label">回复提问：</div>
                                        <div class="field">
                                            {!! \Module\Wenda\Provider\WendaRichContentProvider::getAskReplyContentEditor()->render('content','') !!}
                                        </div>
                                    </div>
                                    <div class="line">
                                        <div class="field">
                                            <button type="submit" class="btn btn-primary">提交</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    @endif
                </div>
                <div class="margin-bottom">
                    @foreach($replies as $reply)
                        <div class="ub-padding tw-bg-white tw-mb-4 tw-relative tw-overflow-hidden">
                            <div class="tw-flex tw-flex-wrap">
                                <div class="tw-flex">
                                    <a href="{{modstart_web_url('wenda/member/'.$reply['memberUserId'])}}"
                                       class="tw-block tw-w-8 tw-h-8 tw-bg-cover tw-bg-center tw-rounded-full tw-shadow-inner"
                                       style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($reply['_memberUser']['avatar'])}})">
                                    </a>
                                    <a href="{{modstart_web_url('wenda/member/'.$reply['memberUserId'])}}"
                                       class="tw-flex tw-text-gray-600 tw-ml-2 tw-text-lg tw-leading-8">{{$reply['_memberUser']['nickname']}}</a>
                                    <div class="tw-flex tw-ml-2 tw-items-center tw-text-xs tw-text-gray-400">
                                        <span><time datetime="{{$reply['created_at']}}"></time></span>
                                        <span class="tw-px-1">•</span>
                                        <span>{{$reply['_memberUser']['signature']}}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="tw-my-4 tw-py-4 tw-border-0 tw-border-t tw-border-solid tw-border-gray-200">
                                @if($reply['verifyStatus']==\Module\Wenda\Type\WendaAskVerifyStatus::VERIFYING)
                                    <div class="ub-alert warning">
                                        <i class="iconfont icon-warning"></i>
                                        当前内容正在审核，只有您自己可见
                                    </div>
                                @endif
                                @if($reply['verifyStatus']==\Module\Wenda\Type\WendaAskVerifyStatus::REJECT)
                                    <div class="ub-alert danger">
                                        <i class="iconfont icon-warning"></i>
                                        当前内容审核失败，只有您自己可见
                                    </div>
                                @endif
                                <div class="ub-html lg">
                                    {!! $reply['contentHtml'] !!}
                                </div>
                            </div>
                            <div class="tw-flex">
                                <div class="">
                                    <div data-toggle-group="{{modstart_api_url('wenda/ask/reply/up')}}"
                                         data-status="{{ empty($reply['_upStatus']) ? 'not_toggle' : $reply['_upStatus'] }}"
                                         data-id="{{$reply['id']}}">
                                        <a href="javascript:;" class="btn" data-action="toggle">
                                            <i class="iconfont icon-thumb-up"></i>
                                            赞同
                                            <span data-ask-reply-up-count-{{$reply['id']}}>{{empty($reply['upCount'])?'0':$reply['upCount']}}</span>
                                        </a>
                                        <a href="javascript:;" class="btn btn-primary" data-action="untoggle">
                                            <i class="iconfont icon-thumb-up"></i>
                                            赞同
                                            <span data-ask-reply-up-count-{{$reply['id']}}>{{empty($reply['upCount'])?'0':$reply['upCount']}}</span>
                                        </a>
                                    </div>
                                </div>
                                <div class="tw-flex-grow tw-w-rull tw-text-right">
                                    @if($record['status']==\Module\Wenda\Type\WendaAskStatus::RESOLVING)
                                        @if($record['memberUserId']==\Module\Member\Auth\MemberUser::id())
                                            <a class="ub-lister-action" href="javascript:;"
                                               data-confirm="确定设为最佳答案？设置后不可更改" data-ajax-request-loading
                                               data-ajax-request="{{modstart_api_url('wenda/ask/reply/resolve',['_id'=>$reply['id']])}}">
                                                <i class="iconfont icon-checked"></i>
                                                设为最佳答案
                                            </a>
                                        @endif
                                    @endif
                                    @if($reply['memberUserId']==\Module\Member\Auth\MemberUser::id())
                                        <a href="{{modstart_web_url('wenda/ask/reply/edit',['_id'=>$reply['id']])}}"
                                           class="ub-lister-action">
                                            <i class="iconfont icon-edit"></i>
                                            编辑
                                        </a>
                                        <a href="javascript:;" data-confirm="确定删除？" data-ajax-request-loading
                                           data-ajax-request="{{modstart_api_url('wenda/ask/reply/delete',['_id'=>$reply['id']])}}"
                                           class="ub-lister-action ub-text-danger">
                                            <i class="iconfont icon-trash"></i>
                                            删除
                                        </a>
                                    @endif
                                </div>
                            </div>
                            @if($reply['isBest'])
                                <div class="tw-bg-green-200 tw-absolute tw-bg-opacity-50 tw-px-4 tw--right-5 tw-top-2 tw-py-1 tw-w-20 tw-h-6 tw-flex-shrink-0 tw-rounded tw-text-black tw-flex tw-flex-col tw-items-center tw-transform tw-rotate-45">
                                    <span class="tw-text-green-500 tw-text-sm">最佳答案</span>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
            <div class="col-md-3">
                @include('module::Wenda.View.pc.wenda.inc.search')
                @include('module::Wenda.View.pc.wenda.inc.askButton')
                @if(modstart_module_enabled('Ad'))
                    {!! \Module\Ad\View\AdView::simple('WendaShowRight') !!}
                @endif
                @include('module::Wenda.View.pc.wenda.inc.latestAsks')
            </div>
        </div>
    </div>
@endsection

