@extends($_viewFrame)

@section('pageTitleMain'){{'问答库'}}@endsection
@section('pageKeywords'){{'问答库'}}@endsection
@section('pageDescription'){{'问答库'}}@endsection

{!! \ModStart\ModStart::js('asset/common/timeago.js') !!}

@section('bodyContent')

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('wenda')}}">问答</a>
            <a class="active" href="{{modstart_web_url('wenda/ask')}}">问答库</a>
        </div>
        <div class="row">

            <div class="col-md-9">

                <div class="ub-nav margin-bottom">
                    <a class="item @if(!$categoryId) active @endif"
                       href="?{{\ModStart\Core\Input\Request::mergeQueries(['categoryId'=>null])}}">全部</a>
                    @foreach(\Module\Wenda\Util\WendaAskUtil::categories() as $c)
                        <a class="item @if($categoryId==$c['id']) active @endif"
                           href="?{{\ModStart\Core\Input\Request::mergeQueries(['categoryId'=>$c['id']])}}">{{$c['title']}}</a>
                    @endforeach
                </div>

                <div class="ub-nav-tab margin-bottom">
                    <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['type'=>null])}}"
                       @if(!$type) class="active" @endif>全部提问</a>
                    <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['type'=>'resolving'])}}"
                       @if($type=='resolving') class="active" @endif>待解决</a>
                    <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['type'=>'resolved'])}}"
                       @if($type=='resolved') class="active" @endif>已解决</a>
                    <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['type'=>'reward'])}}"
                       @if($type=='reward') class="active" @endif>积分悬赏</a>
                </div>

                <div class="margin-bottom">
                    @include('module::Wenda.View.pc.wenda.inc.listAsks',['records'=>$records])
                </div>
                <div class="margin-bottom">
                    <div class="ub-page">
                        {!! $pageHtml !!}
                    </div>
                </div>

            </div>

            <div class="col-md-3">
                @include('module::Wenda.View.pc.wenda.inc.search')
                @include('module::Wenda.View.pc.wenda.inc.askButton')
                @if(modstart_module_enabled('Ad'))
                    {!! \Module\Ad\View\AdView::simple('WendaListRight') !!}
                @endif
                @include('module::Wenda.View.pc.wenda.inc.latestAsks')
            </div>

        </div>
    </div>
@endsection
