@extends($_viewFrame)

@section('pageTitleMain'){{$record?'编辑提问':'提出提问'}}@endsection
@section('pageKeywords'){{$record?'编辑提问':'提出提问'}}@endsection
@section('pageDescription'){{$record?'编辑提问':'提出提问'}}@endsection

@section('headAppend')
    @parent
    <script>
        window.__selectorDialogServer = "{{modstart_web_url('member_data/file_manager')}}";
    </script>
@endsection

@section('bodyContent')
    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('wenda')}}">问答</a>
            <a class="active" href="{{\ModStart\Core\Input\Request::currentPageUrl()}}">{{$record?'编辑提问':'提出提问'}}</a>
        </div>
        <div class="row">
            <div class="col-md-9">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">{{$record?'编辑提问':'提出提问'}}</div>
                    </div>
                    <div class="body">
                        <form action="{{modstart_api_url('wenda/ask/edit')}}" data-ajax-form method="post">
                            <input type="hidden" name="id" value="{{ empty($record['id']) ? 0 : $record['id'] }}" />
                            <div class="ub-form">
                                @if(!empty($inviteMemberUser))
                                    <div class="line">
                                        <input type="hidden" name="inviteMemberUserId" value="{{$inviteMemberUser['id']}}" />
                                        <div class="label">邀请</div>
                                        <div class="field">
                                            <div class="tw-bg-white tw-p-2 tw-shadow tw-rounded tw-flex tw-justify-between tw-items-center tw-mb-2">
                                                <div class="tw-flex">
                                                    <div class="tw-mr-4">
                                                        <div class="ub-cover-1-1 tw-shadow tw-w-10 tw-h-10 tw-rounded-full"
                                                             style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($inviteMemberUser['_expert']?$inviteMemberUser['_expert']['avatar']:$inviteMemberUser['avatar'])}});">
                                                        </div>
                                                    </div>
                                                    <div>
                                                        <div class="tw-font-bold tw-text-gray-700">{{$inviteMemberUser['_expert']?$inviteMemberUser['_expert']['realname']:$inviteMemberUser['nickname']}}</div>
                                                        <div class="tw-text-gray-400 tw-text-sm">{{$inviteMemberUser['_expert']?$inviteMemberUser['_expert']['signature']:$inviteMemberUser['signature']}}</div>
                                                    </div>
                                                </div>
                                                <a href="javascript:;" class="btn btn-round" onclick="$(this).closest('.line').remove();">
                                                    取消邀请
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                                <div class="line">
                                    <div class="label"><span>*</span> 标题：</div>
                                    <div class="field">
                                        <input type="text" class="form" name="title" value="{{ empty($record['title']) ? '' : $record['title'] }}" placeholder="标题简短，言简意赅，问号结尾" />
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="label">提问补充：</div>
                                    <div class="field">
                                        {!! \Module\Wenda\Provider\WendaRichContentProvider::getAskContentEditor()->render('content',isset($record['content'])?$record['content']:'') !!}
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="label"><span>*</span> 分类：</div>
                                    <div class="field">
                                        <select name="categoryId" class="form">
                                            <option value="">选择分类</option>
                                            @foreach(\Module\Wenda\Util\WendaAskUtil::categoryListWithIndent() as $c)
                                                <option value="{{$c['id']}}" @if($record&&$record['categoryId']==$c['id']) selected @endif>{{$c['title']}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="label">积分奖励：</div>
                                    <div class="field">
                                        @if($record)
                                            <span>{{$record['rewardCredit']}}</span>
                                        @else
                                            <select name="rewardCredit" class="form">
                                                <option value="0">0</option>
                                                @foreach([1,5,10,20,30,40,50,100,500,1000] as $c)
                                                    <option value="{{$c}}" @if($record&&$record['rewardCredit']==$c) selected @endif>{{$c}}</option>
                                                @endforeach
                                            </select>
                                            <span class="ub-text-muted">
                                            <i class="iconfont icon-warning"></i>
                                            创建后积分奖励不能修改
                                        </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="label">&nbsp;</div>
                                    <div class="field">
                                        <button type="submit" class="btn btn-primary">提交</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="ub-panel">
                    <div class="head">
                        <div class="title">说明</div>
                    </div>
                    <div class="body">
                        <div class="ub-text-muted">提问请遵守国家相关法律要求，否则可能追究法律责任。</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

