@extends($_viewFrame)

{!! \ModStart\ModStart::styleFile('public/vendor/MemberFollow/asset/memberFollow.css') !!}
{!! \ModStart\ModStart::scriptFile('public/vendor/MemberFollow/asset/memberFollow.js') !!}
@section('bodyContent')

    <div class="ub-container" style="max-width: 800px;">

        <div class="margin-top tw-bg-white tw-p-4 tw-rounded tw-mb-2">
            <div class="tw-flex tw-justify-between tw-items-center">
                <div class="tw-flex">
                    <div class="tw-mr-4">
                        <div class="ub-cover-1-1 tw-shadow tw-w-20 tw-h-20 tw-rounded-full"
                             style="background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($user['avatar'])}});"></div>
                    </div>
                    <div class="tw-py-3">
                        <div>
                            <span class="tw-font-bold tw-text-xl tw-text-gray-700">{{$user['username']}}</span>
                            @if($user['gender']==\Module\Member\Type\Gender::MALE)
                                <i class="iconfont icon-male tw-text-blue-500 tw-text-sm"></i>
                            @endif
                            @if($user['gender']==\Module\Member\Type\Gender::FEMALE)
                                <i class="iconfont icon-female tw-text-pink-500 tw-text-sm"></i>
                            @endif
                        </div>
                        <div class="tw-mt-2">
                            <div class="tw-flex">
                                <a class="tw-block" href="{{modstart_web_url('member_follow/'.$user['id'].'/following')}}">
                                    <div class="tw-text-lg tw-text-gray-700">{{intval($user['followCount'])}}</div>
                                    <div class="tw-text-gray-400 tw-text-sm">关注</div>
                                </a>
                                <a class="tw-block tw-pl-4" href="{{modstart_web_url('member_follow/'.$user['id'].'/followers')}}">
                                    <div class="tw-text-lg tw-text-gray-700">{{intval($user['followerCount'])}}</div>
                                    <div class="tw-text-gray-400 tw-text-sm">粉丝</div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <div>
                    @if($user['id']!=\Module\Member\Auth\MemberUser::id())
                        <div class="tw-inline-block" data-member-follow-item data-status="{{$user['_isFollow']?'is_follow':'not_follow'}}" data-id="{{$user['id']}}">
                            <a href="javascript:;" data-action="follow" class="btn btn-lg btn-primary-line btn-round">
                                <i class="iconfont icon-plus"></i>
                                关注
                            </a>
                            <a href="javascript:;" data-action="unfollow" class="btn btn-lg btn-round">
                                <i class="iconfont icon-check"></i>
                                已关注
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div class="tw-bg-white tw-rounded">
            <div class="ub-nav-tab margin-top">
                <a href="{{modstart_web_url('member_follow/'.$user['id'].'/following')}}" class="{{modstart_baseurl_active(modstart_web_url('member_follow/'.$user['id'].'/following'))}}">
                    <i class="iconfont icon-list-alt"></i>
                    关注
                </a>
                <a href="{{modstart_web_url('member_follow/'.$user['id'].'/followers')}}" class="{{modstart_baseurl_active(modstart_web_url('member_follow/'.$user['id'].'/followers'))}}">
                    <i class="iconfont icon-list-alt"></i>
                    粉丝
                </a>
            </div>
            <div class="margin-top">
                @include('module::MemberFollow.View.pc.part.users',['users'=>$users])
            </div>
            <div class="ub-page">
                {!! $pageHtml !!}
            </div>
        </div>

    </div>

@endsection
