<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($wT4bq) { return ModelUtil::get('member_user', array('id' => $wT4bq)); } public static function getCached($wT4bq) { return Cache::remember('MemberUser:' . $wT4bq, 60, function () use($wT4bq) { return self::get($wT4bq); }); } public static function processDefault(&$xvIs8) { goto tFMZH; tFMZH: if (empty($xvIs8)) { return; } goto KP2ig; vASNP: if (empty($xvIs8['avatarBig'])) { $xvIs8['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto Ss43w; Hj9J5: if (empty($xvIs8['avatar'])) { $xvIs8['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto CUOLs; CUOLs: if (empty($xvIs8['avatarMedium'])) { $xvIs8['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto vASNP; KP2ig: if (empty($xvIs8['nickname'])) { $xvIs8['nickname'] = $xvIs8['username']; } goto Hj9J5; Ss43w: } private static function processBasicFields($O3eYz) { goto s4E_A; wZBWj: if (null === $O3eYz) { $O3eYz = $cm9fz; } else { goto v08Yw; kptNj: $O3eYz = $s1OX3; goto Lw4xS; v08Yw: $s1OX3 = array(); goto tsWcm; tsWcm: foreach ($O3eYz as $gq1e6) { if ('<basic>' == $gq1e6) { $s1OX3 = array_merge($s1OX3, $cm9fz); } else { $s1OX3[] = $gq1e6; } } goto kptNj; Lw4xS: } goto ouD2C; s4E_A: $cm9fz = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto wZBWj; ouD2C: return $O3eYz; goto G2AQj; G2AQj: } public static function fixAvatar($c7MC6) { return AssetsUtil::fixFullOrDefault($c7MC6, 'asset/image/avatar.svg'); } public static function getBasic($wT4bq, $O3eYz = null) { goto ca_89; Y2KE2: if (empty($C7lKq)) { return null; } goto htOc4; ruqMT: foreach ($O3eYz as $e_A9A) { if (isset($C7lKq[$e_A9A])) { $E5DNx[$e_A9A] = $C7lKq[$e_A9A]; } else { $E5DNx[$e_A9A] = null; } } goto yenom; yir_U: $E5DNx = array(); goto ruqMT; yenom: return $E5DNx; goto IPoOp; BqdOX: $C7lKq['avatar'] = self::fixAvatar($C7lKq['avatar']); goto yir_U; htOc4: if (empty($C7lKq['nickname'])) { $C7lKq['nickname'] = $C7lKq['username']; } goto BqdOX; orgHr: $C7lKq = self::get($wT4bq); goto Y2KE2; ca_89: $O3eYz = self::processBasicFields($O3eYz); goto orgHr; IPoOp: } public static function listViewName($Wacvm) { goto S6Gr6; RF_WL: return $DRvR6; goto bccEv; SbrYv: foreach ($S8xlj as $xvIs8) { $DRvR6[] = self::viewName($xvIs8); } goto RF_WL; S6Gr6: $DRvR6 = array(); goto pAWfo; pAWfo: $S8xlj = ModelUtil::allIn('member_user', 'id', $Wacvm); goto SbrYv; bccEv: } public static function listUsers($Wacvm) { return ModelUtil::allIn('member_user', 'id', $Wacvm); } public static function convertOneToBasic($xvIs8) { return array('id' => $xvIs8['id'], 'username' => $xvIs8['username'], 'nickname' => empty($xvIs8['nickname']) ? $xvIs8['username'] : $xvIs8['nickname'], 'created_at' => $xvIs8['created_at'], 'signature' => isset($xvIs8['signature']) ? $xvIs8['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($xvIs8['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($S8xlj) { return array_map(function ($C7lKq) { return array('id' => $C7lKq['id'], 'username' => $C7lKq['username'], 'nickname' => empty($C7lKq['nickname']) ? $C7lKq['username'] : $C7lKq['nickname'], 'created_at' => $C7lKq['created_at'], 'signature' => isset($C7lKq['signature']) ? $C7lKq['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($C7lKq['avatar'], 'asset/image/avatar.svg')); }, $S8xlj); } public static function listUsersBasic($Wacvm) { return self::convertToBasic(self::listUsers($Wacvm)); } public static function getViewName($wT4bq) { return self::viewName(self::get($wT4bq)); } public static function viewName($xvIs8) { goto mJae1; SalXI: return "ID-{$xvIs8['id']}"; goto FwA_s; Kd3DN: if (!empty($xvIs8['username'])) { return $xvIs8['username']; } goto SalXI; SvmmP: if (!empty($xvIs8['nickname'])) { return $xvIs8['nickname']; } goto Kd3DN; mJae1: if ($xvIs8 && is_numeric($xvIs8)) { return self::getViewName($xvIs8); } goto R6hN9; R6hN9: if (empty($xvIs8)) { return '-'; } goto SvmmP; FwA_s: } public static function update($wT4bq, $Vp49K) { return ModelUtil::update('member_user', array('id' => $wT4bq), $Vp49K); } public static function updateBasicWithUniqueCheck($wT4bq, $Vp49K) { goto gB1Qy; EWR9H: return Response::generate(0, 'ok'); goto hJKb7; X1GQl: self::update($wT4bq, $Vp49K); goto EWR9H; cLWJy: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $M0PwS => $KzdYW) { if (isset($Vp49K[$M0PwS])) { goto HGmy5; Tf0BY: if (count($naDNa) > 1) { return Response::generate(-1, $KzdYW . '重复'); } goto GbEeH; TY3Xp: $naDNa = ModelUtil::all('member_user', array($M0PwS => $Vp49K[$M0PwS])); goto Tf0BY; GbEeH: if (count($naDNa) == 1) { if ($naDNa[0]['id'] != $wT4bq) { return Response::generate(-1, $KzdYW . '重复'); } } goto vj9lL; HGmy5: if (empty($Vp49K[$M0PwS])) { $Vp49K[$M0PwS] = null; continue; } goto TY3Xp; vj9lL: } } goto X1GQl; gB1Qy: if (empty($Vp49K)) { return Response::generate(0, 'ok'); } goto cLWJy; hJKb7: } public static function login($wFy9m = '', $oaeoB = '', $zdkFZ = '', $bUphy = '') { goto Hv6RA; Dspeo: if (!($zdkFZ || $oaeoB || $wFy9m)) { return Response::generate(-1, '所有登录字段均为空'); } goto NV129; Sf4yy: return Response::generateSuccessData($xvIs8); goto WX_qP; Hv6RA: $zdkFZ = trim($zdkFZ); goto yD981; jiIem: if (empty($xvIs8)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto ZHxAM; bU2vK: $wFy9m = trim($wFy9m); goto Dspeo; NV129: if (!$bUphy) { return Response::generate(-2, '密码为空'); } goto nVDDS; mtJ2E: if ($xvIs8['password'] != EncodeUtil::md5WithSalt($bUphy, $xvIs8['passwordSalt'])) { MemberUserLoginFailedEvent::fire($xvIs8['id'], $xvIs8['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto v6jp5; ZHxAM: MemberUserLoginAttemptEvent::fire($xvIs8['id'], Request::ip(), AgentUtil::getUserAgent()); goto mtJ2E; v6jp5: switch ($xvIs8['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto Sf4yy; nVDDS: if ($zdkFZ) { if (!FormatUtil::isEmail($zdkFZ)) { return Response::generate(-3, '邮箱格式不正确'); } $m6mfv = array('email' => $zdkFZ); } else { if ($oaeoB) { if (!preg_match('/(^1[0-9]{10}$)/', $oaeoB)) { return Response::generate(-4, '手机格式不正确'); } $m6mfv = array('phone' => $oaeoB); } else { if ($wFy9m) { if (strpos($wFy9m, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $m6mfv = array('username' => $wFy9m); } } } goto ASVCV; ASVCV: $xvIs8 = ModelUtil::get('member_user', $m6mfv); goto jiIem; yD981: $oaeoB = trim($oaeoB); goto bU2vK; WX_qP: } public static function autoSetUsernameNickname($IHbmn, $REF1k) { goto jXIk_; jXIk_: $ftkPv = 6; goto GexGz; GexGz: if (preg_match('/\\{.*\\}/', $REF1k)) { goto qiWAW; Epdfk: $ftkPv = 0; goto xcanx; h6cI1: $REF1k = str_replace(array_keys($Q_hqC), array_values($Q_hqC), $REF1k); goto Epdfk; qiWAW: $xvIs8 = self::get($IHbmn); goto MuVaX; MuVaX: $Q_hqC = array('{Phone}' => $xvIs8['phone'], '{Phone4}' => substr($xvIs8['phone'], 7), '{Uid}' => $xvIs8['id']); goto h6cI1; xcanx: } goto aE7eu; aE7eu: self::suggestUsernameNickname($IHbmn, $REF1k, $ftkPv); goto Z3n0x; Z3n0x: } public static function getSuggestUsernameNickname($t6RxF) { goto zR5dF; H4ZVP: return $REF1k . Str::random(10); goto btyhE; tvazL: for ($EVpqp = 0; $EVpqp < 20; $EVpqp++) { $NBpIO = ModelUtil::model('member_user')->where(array('username' => $REF1k))->orWhere(array('nickname' => $REF1k))->first(); if (empty($NBpIO)) { return $REF1k; } $REF1k = $REF1k . Str::random(1); } goto H4ZVP; zR5dF: $REF1k = $t6RxF . Str::random(1); goto tvazL; btyhE: } private static function suggestUsernameNickname($IHbmn, $M4H1f = '用户', $ftkPv = 6) { goto K24_j; Viatq: for ($EVpqp = 0; $EVpqp < 20; $EVpqp++) { $NBpIO = ModelUtil::model('member_user')->where(array('username' => $REF1k))->orWhere(array('nickname' => $REF1k))->first(); if (empty($NBpIO)) { break; } $REF1k = $REF1k . Str::random(1); } goto Vey7V; Vey7V: ModelUtil::update('member_user', $IHbmn, array('username' => $REF1k, 'nickname' => $REF1k)); goto imPyH; K24_j: if ($ftkPv > 0) { $REF1k = $M4H1f . RandomUtil::string($ftkPv); } else { $REF1k = $M4H1f; } goto Viatq; imPyH: } public static function registerId($wT4bq, $Vp49K = array()) { $xvIs8 = ModelUtil::insert('member_user', array_merge(array('id' => $wT4bq, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $Vp49K)); return Response::generate(0, 'ok', $xvIs8); } public static function registerUsername($wFy9m) { return self::register($wFy9m, '', '', '', true); } public static function registerUsernameQuick($wFy9m) { goto DDygt; DDygt: $YTVG1 = $wFy9m; goto l6Zid; Jqudk: return Response::generateError('注册失败'); goto M4G9d; l6Zid: for ($EVpqp = 0; $EVpqp < 10; $EVpqp++) { $RUBzh = self::register($YTVG1, '', '', '', true); if ($RUBzh['code']) { $YTVG1 = $YTVG1 . Str::random(1); } else { return $RUBzh; } } goto Jqudk; M4G9d: } public static function register($wFy9m = '', $oaeoB = '', $zdkFZ = '', $bUphy = '', $C7hMG = false) { goto kHLkz; FzNwt: $PY8Y1 = Str::random(16); goto ss7N0; aXHry: if (!($zdkFZ || $oaeoB || $wFy9m)) { return Response::generate(-1, '所有注册字段均为空'); } goto v__nw; VUeva: if ($oaeoB) { $RUBzh = self::uniqueCheck('phone', $oaeoB); if ($RUBzh['code']) { return $RUBzh; } } else { $oaeoB = null; } goto sVVd2; uzWR7: $wFy9m = trim($wFy9m); goto aXHry; kHLkz: $zdkFZ = trim($zdkFZ); goto bxEXb; IxHj7: if (!$C7hMG) { if (empty($bUphy) || strlen($bUphy) < 6) { return Response::generate(-3, '密码不合法'); } } goto FzNwt; v__nw: if ($zdkFZ) { $RUBzh = self::uniqueCheck('email', $zdkFZ); if ($RUBzh['code']) { return $RUBzh; } } else { $zdkFZ = null; } goto VUeva; ss7N0: $xvIs8 = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $wFy9m, 'email' => $zdkFZ, 'phone' => $oaeoB, 'password' => $C7hMG ? null : EncodeUtil::md5WithSalt($bUphy, $PY8Y1), 'passwordSalt' => $C7hMG ? null : $PY8Y1, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto mCy1a; mCy1a: return Response::generate(0, 'ok', $xvIs8); goto DpJMz; sVVd2: if ($wFy9m) { goto ahHjT; ZuXPQ: if (preg_match('/^[0-9]{11}$/', $wFy9m)) { return Response::generate(-1, '用户名不能为纯数字'); } goto xQGy1; OGJgO: if (Str::contains($wFy9m, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto ZuXPQ; hz62W: if ($RUBzh['code']) { return $RUBzh; } goto fxbFi; ahHjT: $RUBzh = self::uniqueCheck('username', $wFy9m); goto hz62W; fxbFi: if (strlen($wFy9m) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto OGJgO; xQGy1: } else { $wFy9m = null; } goto IxHj7; bxEXb: $oaeoB = trim($oaeoB); goto uzWR7; DpJMz: } public static function uniqueCheck($bAfi9, $z6XwA, $biAK3 = 0) { goto tg8vf; WGHvz: $xvIs8 = ModelUtil::get('member_user', array($bAfi9 => $z6XwA)); goto wRw4s; xtVJp: return Response::generate(-2, $c0E_u[$bAfi9] . '已经被占用'); goto gky0Q; tvQRz: $c0E_u = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto G51Td; tg8vf: $z6XwA = trim($z6XwA); goto Mqs9o; wRw4s: if (empty($xvIs8)) { return Response::generate(0, 'ok'); } goto tvQRz; Mqs9o: switch ($bAfi9) { case 'email': if (!FormatUtil::isEmail($z6XwA)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $z6XwA)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($z6XwA, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $bAfi9); } goto WGHvz; G51Td: if ($biAK3 == $xvIs8['id']) { return Response::generate(0, 'ok'); } goto xtVJp; gky0Q: } public static function getByUsername($wFy9m) { return ModelUtil::get('member_user', array('username' => $wFy9m)); } public static function getByEmail($zdkFZ) { return ModelUtil::get('member_user', array('email' => $zdkFZ)); } public static function getByPhone($oaeoB) { return ModelUtil::get('member_user', array('phone' => $oaeoB)); } public static function changeNickname($IHbmn, $VlAlu) { goto m89SE; J8CB1: ModelUtil::update('member_user', $IHbmn, array('nickname' => $VlAlu)); goto Awhye; Awhye: return Response::generate(0, 'ok'); goto ezrwC; m89SE: $RUBzh = self::uniqueCheck('nickname', $VlAlu, $IHbmn); goto utAo8; utAo8: if (Response::isError($RUBzh)) { return $RUBzh; } goto J8CB1; ezrwC: } public static function changePassword($IHbmn, $J0aZ5, $ymwWS = null, $j44Q0 = false) { goto bUa4s; crBQK: if (empty($xvIs8)) { return Response::generate(-1, '用户不存在'); } goto Qqxnd; fh94Y: $PY8Y1 = Str::random(16); goto dwRtD; Qqxnd: if (empty($J0aZ5)) { return Response::generate(-1, '新密码为空'); } goto FXHwQ; XEq3O: $xvIs8 = ModelUtil::get('member_user', array('id' => $IHbmn)); goto crBQK; vjf4d: return Response::generate(0, 'ok'); goto Tx1TM; dwRtD: ModelUtil::update('member_user', array('id' => $xvIs8['id']), array('passwordSalt' => $PY8Y1, 'password' => EncodeUtil::md5WithSalt($J0aZ5, $PY8Y1))); goto vjf4d; bUa4s: if (!$j44Q0 && empty($ymwWS)) { return Response::generate(-1, '旧密码不能为空'); } goto XEq3O; FXHwQ: if (!$j44Q0 && EncodeUtil::md5WithSalt($ymwWS, $xvIs8['passwordSalt']) != $xvIs8['password']) { return Response::generate(-1, '旧密码不正确'); } goto fh94Y; Tx1TM: } public static function setAvatar($nPH4d, $tHCt3, $X6dqs = 'jpg') { goto jB_Ro; iFbci: $RUBzh = DataManager::upload('image', 'U_' . $nPH4d . '_Avatar.' . $X6dqs, $F2kix, null, $g9kn5); goto fF4Nk; PX3oy: $xvIs8 = self::get($nPH4d); goto fsJlj; dME_B: $EmEsa = DataManager::upload('image', 'U' . $nPH4d . '_AvatarBig.' . $X6dqs, $Qlkih, null, $g9kn5); goto FcqjU; CeUkB: $g9kn5 = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto dME_B; qmeQY: $erm9o = (string) Image::make($tHCt3)->resize(200, 200)->encode($X6dqs, 75); goto Ca2Ph; C5bIz: $LN0a6 = DataManager::upload('image', 'U' . $nPH4d . '_AvatarMiddle.' . $X6dqs, $erm9o, null, $g9kn5); goto SwLQn; a1fOt: return Response::generateSuccess(); goto QM_ie; jB_Ro: if (!in_array($X6dqs, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto PX3oy; guayq: self::update($xvIs8['id'], array('avatarBig' => $EmEsa['data']['fullPath'], 'avatarMedium' => $LN0a6['data']['fullPath'], 'avatar' => $RUBzh['data']['fullPath'])); goto a1fOt; fsJlj: if (empty($xvIs8)) { return Response::generate(-1, '用户不存在'); } goto DjiYz; SwLQn: if ($LN0a6['code']) { DataManager::deleteById($EmEsa['data']['id']); if ($EmEsa['code']) { return Response::generate(-1, '头像存储失败（' . $LN0a6['msg'] . '）'); } } goto iFbci; DjiYz: if (empty($tHCt3)) { return Response::generate(-1, '图片数据为空'); } goto Oh1mn; FcqjU: if ($EmEsa['code']) { return Response::generate(-1, '头像存储失败（' . $EmEsa['msg'] . '）'); } goto C5bIz; Oh1mn: $Qlkih = (string) Image::make($tHCt3)->resize(400, 400)->encode($X6dqs, 75); goto qmeQY; fF4Nk: if ($RUBzh['code']) { goto DcCyo; ZW8G0: if ($EmEsa['code']) { return Response::generate(-1, '头像存储失败（' . $RUBzh['msg'] . '）'); } goto t2BRH; wvdKY: DataManager::deleteById($LN0a6['data']['id']); goto ZW8G0; DcCyo: DataManager::deleteById($EmEsa['data']['id']); goto wvdKY; t2BRH: } goto guayq; Ca2Ph: $F2kix = (string) Image::make($tHCt3)->resize(50, 50)->encode($X6dqs, 75); goto CeUkB; QM_ie: } public static function findUsers($oFzJQ) { goto d8VWG; FG4Fn: foreach ($S8xlj as &$TBOF4) { $wrqcc[$TBOF4->id] = $TBOF4->toArray(); } goto XsYQO; d8VWG: if (empty($oFzJQ)) { return array(); } goto CyGhq; XsYQO: return $wrqcc; goto FRZSS; CyGhq: $wrqcc = array(); goto OskGh; OskGh: $S8xlj = ModelUtil::model('member_user')->whereIn('id', $oFzJQ)->get(); goto FG4Fn; FRZSS: } public static function filterUserIds($oFzJQ) { goto EQONJ; tjztc: $Q_hqC = array(); goto PJ91R; PJ91R: $S8xlj = ModelUtil::model('member_user')->whereIn('id', $oFzJQ)->get(array('id')); goto HR4i9; EQONJ: if (empty($oFzJQ)) { return array(); } goto tjztc; Z7VL5: return array_keys($Q_hqC); goto BNPN7; HR4i9: foreach ($S8xlj as &$TBOF4) { $Q_hqC[$TBOF4->id] = true; } goto Z7VL5; BNPN7: } public static function mergeMemberUsers(&$Upw0u, $kh73Q = 'memberUserId', $sMWJu = '_memberUser') { ModelUtil::join($Upw0u, $kh73Q, $sMWJu, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$Upw0u, $kh73Q = 'memberUserId', $sMWJu = '_memberUser', $O3eYz = null) { $O3eYz = self::processBasicFields($O3eYz); if (is_array($Upw0u)) { ModelUtil::join($Upw0u, $kh73Q, $sMWJu, 'member_user', 'id'); foreach ($Upw0u as $gq1e6 => $P0IIm) { goto S0o3K; E8mmm: $xvIs8 = ArrayUtil::keepKeys($P0IIm[$sMWJu], $O3eYz); goto B8ObX; S0o3K: if (empty($P0IIm[$sMWJu])) { continue; } goto E8mmm; uLFNX: $Upw0u[$gq1e6][$sMWJu] = $xvIs8; goto JKTUe; u34uN: if (empty($xvIs8['avatar'])) { $xvIs8['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $xvIs8['avatar'] = AssetsUtil::fixFull($xvIs8['avatar']); } goto uLFNX; B8ObX: if (empty($xvIs8['nickname'])) { $xvIs8['nickname'] = $xvIs8['username']; } goto u34uN; JKTUe: } } else { ModelUtil::joinItems($Upw0u, $kh73Q, $sMWJu, 'member_user', 'id'); foreach ($Upw0u as $C7lKq) { goto vcFOa; Xb5fK: if (empty($xvIs8['avatar'])) { $xvIs8['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $xvIs8['avatar'] = AssetsUtil::fixFull($xvIs8['avatar']); } goto KeVKy; t0z3i: if (empty($xvIs8['nickname'])) { $xvIs8['nickname'] = $xvIs8['username']; } goto Xb5fK; vcFOa: if (empty($C7lKq->{$sMWJu})) { continue; } goto kGl6r; KeVKy: $C7lKq->{$sMWJu} = $xvIs8; goto kwaZ9; kGl6r: $xvIs8 = ArrayUtil::keepKeys($C7lKq->{$sMWJu}, $O3eYz); goto t0z3i; kwaZ9: } } } public static function insert($Vp49K) { return ModelUtil::insert('member_user', $Vp49K); } public static function getIdByOauth($dwoir, $jyK19) { goto L7wP4; fqXmb: return intval($tw31x['memberUserId']); goto bQ1m7; L7wP4: $tw31x = ModelUtil::get('member_oauth', array('type' => $dwoir, 'openId' => $jyK19)); goto uzXJK; uzXJK: if (empty($tw31x)) { return 0; } goto fqXmb; bQ1m7: } public static function getIdByOauthAndCheck($dwoir, $jyK19) { goto HtL5y; qZtA3: return 0; goto BIBAS; HtL5y: $IHbmn = self::getIdByOauth($dwoir, $jyK19); goto RTd2T; RTd2T: if (self::get($IHbmn)) { return $IHbmn; } goto Hhlrq; Hhlrq: MemberUtil::forgetOauth($dwoir, $jyK19); goto qZtA3; BIBAS: } public static function getOauthOpenId($IHbmn, $dwoir) { goto mpROX; J5haF: return $tw31x['openId']; goto FKKv7; mpROX: $m6mfv = array('memberUserId' => $IHbmn, 'type' => $dwoir); goto B6OVJ; HE3EF: if (empty($tw31x)) { return null; } goto J5haF; B6OVJ: $tw31x = ModelUtil::get('member_oauth', $m6mfv); goto HE3EF; FKKv7: } public static function getOauth($IHbmn, $dwoir) { $m6mfv = array('memberUserId' => $IHbmn, 'type' => $dwoir); return ModelUtil::get('member_oauth', $m6mfv); } public static function listOauths($IHbmn) { return ModelUtil::all('member_oauth', array('memberUserId' => $IHbmn), array('*'), array('type', 'asc')); } public static function putOauth($IHbmn, $dwoir, $jyK19, $uE02a = array()) { goto NkAk0; iW2TJ: LockUtil::release($ZxB0B); goto sIUZl; LxLQZ: $ZxB0B = "MemberOauth:{$IHbmn}"; goto DLaD8; NkAk0: $m6mfv = array('memberUserId' => $IHbmn, 'type' => $dwoir); goto LxLQZ; DLaD8: if (!LockUtil::acquire($ZxB0B)) { BizException::throws('正在处理中，请稍后再试'); } goto Pdgqr; Pdgqr: $tw31x = ModelUtil::get('member_oauth', $m6mfv); goto C4UVe; VH2ML: if (empty($tw31x)) { ModelUtil::delete('member_oauth', array('type' => $dwoir, 'openId' => $jyK19)); ModelUtil::insert('member_oauth', array_merge($m6mfv, $YSGFX)); } else { if ($tw31x['openId'] != $jyK19) { ModelUtil::update('member_oauth', $tw31x['id'], $YSGFX); } } goto iW2TJ; C4UVe: $YSGFX = array_merge(array('openId' => $jyK19), $uE02a); goto VH2ML; sIUZl: } public static function forgetOauth($dwoir, $jyK19) { ModelUtil::delete('member_oauth', array('type' => $dwoir, 'openId' => $jyK19)); } public static function updateNewMessageStatus($IHbmn) { ModelUtil::update('member_user', array('id' => $IHbmn), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $IHbmn, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($IHbmn) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $IHbmn), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $IHbmn)))); } } public static function paginate($Wc14T, $S2OqT, $ZWnmj = array()) { return ModelUtil::paginate('member_user', $Wc14T, $S2OqT, $ZWnmj); } public static function updateStatus($Eh7bt, $Pfj5j) { goto rEVly; rEVly: if (!is_array($Eh7bt)) { $Eh7bt = array($Eh7bt); } goto DSclt; DSclt: if (empty($Eh7bt)) { return; } goto amgRr; amgRr: ModelUtil::model('member_user')->whereIn('id', $Eh7bt)->update(array('status' => $Pfj5j)); goto ECaTh; ECaTh: } public static function delete($IHbmn) { goto bsWoE; NL8lv: $S4Oe8 = ModelUtil::all('member_oauth', array('memberUserId' => $xvIs8['id'])); goto cf9TF; R3oZB: ModelUtil::update('member_user', $IHbmn, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto WsIwF; VW_Zj: ModelUtil::insert('member_deleted', array('id' => $xvIs8['id'], 'username' => $xvIs8['username'], 'phone' => $xvIs8['phone'], 'email' => $xvIs8['email'], 'content' => json_encode($a3tUi, JSON_UNESCAPED_UNICODE))); goto R3oZB; H7iX1: ModelUtil::transactionBegin(); goto E9WeL; E9WeL: $a3tUi = array(); goto NL8lv; EtFDZ: BizException::throwsIfEmpty('用户不存在', $xvIs8); goto H7iX1; WsIwF: ModelUtil::transactionCommit(); goto Sjm9x; bsWoE: $xvIs8 = self::get($IHbmn); goto EtFDZ; cf9TF: $a3tUi['oauth'] = ArrayUtil::keepItemsKeys($S4Oe8, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto VW_Zj; Sjm9x: } public static function fireLogin($IHbmn) { goto PMdFU; IAPvk: ModelUtil::update('member_user', $IHbmn, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($idaxP, 20))); goto n6mb4; n6mb4: ModelUtil::insert('member_login_log', array('memberUserId' => $IHbmn, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($idaxP, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto TVMWt; PMdFU: $idaxP = Request::ip(); goto IAPvk; TVMWt: } }