<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $olSrM) { $olSrM->init('member_user')->field(function ($olSrM) { $olSrM->id('id', 'ID'); MemberAdminList::callGridField($olSrM); $olSrM->display('avatar', '头像')->hookRendering(function (AbstractField $M0PwS, $C7lKq, $SfdKK) { $OJPzW = AssetsUtil::fixOrDefault($C7lKq->avatar, 'asset/image/avatar.svg'); $o7HkP = AssetsUtil::fixOrDefault($C7lKq->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$o7HkP}' class='tw-inline-block' data-image-preview>\n                        <img src='{$OJPzW}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $olSrM->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $M0PwS, $C7lKq, $SfdKK) { switch ($M0PwS->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($C7lKq->username), modstart_admin_url('member/show', array('_id' => $C7lKq->id)))->width('90%')->height('90%')->render()); break; } }); $olSrM->text('email', '邮箱'); $olSrM->text('phone', '手机'); $olSrM->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $olSrM->display('_oauth', '授权')->hookRendering(function (AbstractField $M0PwS, $C7lKq, $SfdKK) { $lresx = array(); $DN2Gs = MemberUtil::listOauths($C7lKq->id); foreach ($DN2Gs as $eu3ev) { goto ZzgGW; WV0RL: $QpDmW = $eu3ev['type']; goto Q7B8q; A8AXY: $lresx[] = '<a style="color:' . $otvJ5 . ';" href="javascript:;" data-tip-popover="' . $QpDmW . '"><i class="iconfont icon-dot"></i></a>'; goto vjnAl; TVjqk: if (empty($otvJ5)) { $otvJ5 = ColorUtil::pick($eu3ev['type']); } goto A8AXY; Q7B8q: $eh59z = MemberOauth::getByOauthKey($eu3ev['type']); goto xV_qd; xV_qd: if ($eh59z) { $otvJ5 = $eh59z->color(); $QpDmW = $eh59z->title(); } goto TVjqk; ZzgGW: $otvJ5 = null; goto WV0RL; vjnAl: } return join('', $lresx); }); } $olSrM->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $aNkaY = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($aNkaY) { $olSrM->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $x0c_V = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($x0c_V) { $olSrM->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $olSrM->date('vipExpire', 'VIP过期'); } $olSrM->display('registerIp', '注册IP'); $olSrM->display('created_at', '注册时间'); $olSrM->canBatchSelect(true); $olSrM->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $s6XX3) { $s6XX3->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $s6XX3) { $s6XX3->eq('id', L('ID')); $s6XX3->like('username', '用户名'); $s6XX3->like('email', '邮箱')->autoHide(true); $s6XX3->like('phone', '手机')->autoHide(true); $s6XX3->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $s6XX3->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $s6XX3->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $HNPix) { $C7lKq = $HNPix->item(); $HNPix->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $C7lKq->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $Wc14T) { goto Qxgp8; U5Ddh: $p8wDI->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $p8wDI) { $p8wDI->text('username', '用户名'); $p8wDI->text('phone', '手机'); $p8wDI->text('email', '邮箱'); $p8wDI->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto a42jI; igMHI: $p8wDI->showSubmit(false)->showReset(false); goto h7RaN; h7RaN: return $Wc14T->pageTitle('创建用户')->body($p8wDI)->handleForm($p8wDI, function (Form $p8wDI) { AdminPermission::demoCheck(); $Vp49K = $p8wDI->dataForming(); $wFy9m = !empty($Vp49K['username']) ? $Vp49K['username'] : null; $oaeoB = !empty($Vp49K['phone']) ? $Vp49K['phone'] : null; $zdkFZ = !empty($Vp49K['email']) ? $Vp49K['email'] : null; $MvvHW = ArrayUtil::keepKeys($Vp49K, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $RUBzh = MemberUtil::register($wFy9m, $oaeoB, $zdkFZ, $Vp49K['password']); BizException::throwsIfResponseError($RUBzh); if (!empty($MvvHW)) { if (isset($MvvHW['vipExpire']) && TimeUtil::isDateEmpty($MvvHW['vipExpire'])) { $MvvHW['vipExpire'] = null; } MemberUtil::update($RUBzh['data']['id'], $MvvHW); } EventUtil::fire(new MemberUserRegisteredEvent($RUBzh['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto JhuUZ; a42jI: $p8wDI->layoutPanel('高级', function (Form $p8wDI) { $p8wDI->text('nickname', '昵称'); $p8wDI->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $p8wDI->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $p8wDI->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $p8wDI->date('vipExpire', 'VIP过期'); } }); goto igMHI; Qxgp8: $p8wDI = Form::make(''); goto U5Ddh; JhuUZ: } public function edit(AdminDialogPage $Wc14T) { goto dZfkL; dZfkL: $xvIs8 = ModelUtil::get('member_user', CRUDUtil::id()); goto xHV4p; xHV4p: BizException::throwsIfEmpty('用户不存在', $xvIs8); goto CzaOd; Jd0Xc: return $Wc14T->pageTitle('修改信息')->body($p8wDI)->handleForm($p8wDI, function (Form $p8wDI) use($xvIs8) { AdminPermission::demoCheck(); $Vp49K = $p8wDI->dataForming(); $vP8MN = ArrayUtil::keepKeys($Vp49K, array('username', 'phone', 'email')); $MvvHW = ArrayUtil::keepKeys($Vp49K, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $RUBzh = MemberUtil::updateBasicWithUniqueCheck($xvIs8['id'], $vP8MN); BizException::throwsIfResponseError($RUBzh); if (isset($MvvHW['vipExpire']) && TimeUtil::isDateEmpty($MvvHW['vipExpire'])) { $MvvHW['vipExpire'] = null; } MemberUtil::update($xvIs8['id'], $MvvHW); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto FUZ76; CzaOd: if (Request::isPost()) { goto pmNDv; pmNDv: AdminPermission::demoCheck(); goto E_oIL; E_oIL: $Bq7QA = InputPackage::buildFromInput(); goto g0l9p; g0l9p: switch ($Bq7QA->getTrimString('_action')) { case 'itemCellEdit': goto D4CNI; q4Lab: return Response::generateSuccess(); goto aOOcy; Bfx3s: switch ($Bq7QA->getTrimString('column')) { case 'status': $YSGFX['status'] = $Bq7QA->getInteger('value'); break; } goto Bz83S; Bz83S: if (!empty($YSGFX)) { MemberUtil::update($xvIs8['id'], $YSGFX); } goto q4Lab; D4CNI: $YSGFX = array(); goto Bfx3s; aOOcy: } goto aFXCd; aFXCd: } goto ahULs; Frzlq: $p8wDI->item($xvIs8)->fillFields(); goto XUr5p; W6D17: $p8wDI->layoutPanel('基础', function (Form $p8wDI) { $p8wDI->display('id', '用户ID')->addable(true); $p8wDI->text('username', '用户名'); $p8wDI->text('phone', '手机'); $p8wDI->text('email', '邮箱'); }); goto GlTc2; ahULs: $p8wDI = Form::make(''); goto W6D17; XUr5p: $p8wDI->showSubmit(false)->showReset(false); goto Jd0Xc; GlTc2: $p8wDI->layoutPanel('高级', function (Form $p8wDI) { $p8wDI->text('nickname', '昵称'); $p8wDI->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $p8wDI->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $p8wDI->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $p8wDI->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto Frzlq; FUZ76: } public function select(AdminDialogPage $Wc14T) { goto TsWi5; RK0z6: CRUDUtil::registerGridResource($yTJKF, '\\' . __CLASS__); goto bZbOf; cxywt: $yTJKF->disableCUD(); goto qDwI5; TsWi5: $yTJKF = $this->grid(); goto cxywt; qDwI5: $yTJKF->canSingleSelectItem(true); goto RK0z6; Ivh6T: return $Wc14T->pageTitle('选择用户')->body($yTJKF); goto Tve3n; bZbOf: if (Request::isPost()) { return $yTJKF->request(); } goto Ivh6T; Tve3n: } public function search() { goto wGPHX; eeR3y: $Upw0u = array_map(function ($C7lKq) { return array('value' => intval($C7lKq['id']), 'name' => htmlspecialchars(MemberUtil::viewName($C7lKq)), 'avatar' => AssetsUtil::fixOrDefault($C7lKq['avatar'], 'asset/image/avatar.svg')); }, $TxQwu['records']); goto legDz; kbN92: $ZWnmj['whereOperate'] = array('username', 'like', "%{$D63l6}%"); goto ByF1P; gazYF: $ZWnmj = array(); goto kbN92; wGPHX: $Bq7QA = InputPackage::buildFromInput(); goto IS0ji; legDz: return Response::jsonSuccessData($Upw0u); goto vUvY3; ByF1P: $TxQwu = MemberUtil::paginate(1, 10, $ZWnmj); goto eeR3y; IS0ji: $D63l6 = $Bq7QA->getTrimString('keywords'); goto gazYF; vUvY3: } public function resetPassword(AdminConfigBuilder $olSrM) { goto lB1Bh; lB1Bh: $wT4bq = CRUDUtil::id(); goto I9SOt; u0J3R: $olSrM->useDialog(); goto JPo9R; I9SOt: $xvIs8 = MemberUtil::get($wT4bq); goto Tiq5r; JPo9R: $olSrM->pageTitle('重置密码'); goto ubsgL; sUq1S: if (Request::isPost()) { return $olSrM->formRequest(function (Form $p8wDI) use($xvIs8) { AdminPermission::demoCheck(); $Vp49K = $p8wDI->dataForming(); $RUBzh = MemberUtil::changePassword($xvIs8['id'], $Vp49K['passwordNew'], null, true); BizException::throwsIfResponseError($RUBzh); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto l0KQS; l0KQS: return $olSrM; goto GreSw; Tiq5r: BizException::throwsIfEmpty('用户不存在', $xvIs8); goto u0J3R; ubsgL: $olSrM->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto sUq1S; GreSw: } public function sendMessage(AdminConfigBuilder $olSrM) { goto f3ebu; mJmSl: if (Request::isPost()) { return $olSrM->formRequest(function (Form $p8wDI) use($xvIs8) { AdminPermission::demoCheck(); $Vp49K = $p8wDI->dataForming(); $RUBzh = MemberMessageUtil::send($xvIs8['id'], $Vp49K['content']); BizException::throwsIfResponseError($RUBzh); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto GBd3z; AolmN: $olSrM->useDialog(); goto rAITC; zjEZo: $xvIs8 = MemberUtil::get($wT4bq); goto OmXnD; f3ebu: $wT4bq = CRUDUtil::id(); goto zjEZo; NMqHR: $olSrM->richHtml('content', '消息内容')->required(); goto mJmSl; rAITC: $olSrM->pageTitle('发送消息'); goto NMqHR; GBd3z: return $olSrM; goto YaS8y; OmXnD: BizException::throwsIfEmpty('用户不存在', $xvIs8); goto AolmN; YaS8y: } public function show() { goto PGaLO; PGaLO: $gG0oU = MemberUtil::get(CRUDUtil::id()); goto p8Fiq; p8Fiq: $aVQkL = MemberAdminShowPanelProvider::listAll(); goto TAabb; TAabb: return view('module::Member.View.admin.memberUser.show', array('record' => $gG0oU, 'showPanelProviders' => $aVQkL)); goto OZKYt; OZKYt: } public function delete() { goto VmB1F; K0sYC: return Response::redirect(CRUDUtil::jsGridRefresh()); goto atOY4; cWPmQ: MemberUtil::delete(CRUDUtil::id()); goto K0sYC; VmB1F: AdminPermission::demoCheck(); goto cWPmQ; atOY4: } public function statusForbidden() { goto y1vCS; XkJNT: return Response::redirect(CRUDUtil::jsGridRefresh()); goto xVAcf; y1vCS: AdminPermission::demoCheck(); goto hFelU; hFelU: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto XkJNT; xVAcf: } public function export(ExportHandle $fpOsk) { $ng5c2 = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $fpOsk->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($ng5c2)->handleFetch(function ($Wc14T, $S2OqT, $A3CwS, $jibT_) { $PB2PO = ModelUtil::model('member_user'); $PB2PO = $PB2PO->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($A3CwS as $W68VP) { if (!empty($W68VP['id']['eq'])) { $PB2PO = $PB2PO->where('id', $W68VP['id']['eq']); } elseif (!empty($W68VP['status']['eq'])) { $PB2PO = $PB2PO->where('status', $W68VP['status']['eq']); } elseif (!empty($W68VP['groupId']['eq'])) { $PB2PO = $PB2PO->where('groupId', $W68VP['groupId']['eq']); } elseif (!empty($W68VP['vipId']['eq'])) { $PB2PO = $PB2PO->where('vipId', $W68VP['vipId']['eq']); } elseif (!empty($W68VP['username']['like'])) { $PB2PO = $PB2PO->where('username', 'like', '%' . $W68VP['username']['like'] . '%'); } elseif (!empty($W68VP['email']['like'])) { $PB2PO = $PB2PO->where('email', 'like', '%' . $W68VP['email']['like'] . '%'); } elseif (!empty($W68VP['phone']['like'])) { $PB2PO = $PB2PO->where('phone', 'like', '%' . $W68VP['phone']['like'] . '%'); } } $E5DNx = $PB2PO->paginate($S2OqT, array('*'), 'page', $Wc14T)->toArray(); $Qf52C = array(); foreach ($E5DNx['data'] as $C7lKq) { goto xB6Kn; LJOlz: $xS6Af[] = $C7lKq['realname']; goto Vpp_2; cbLQp: $xS6Af[] = $C7lKq['username']; goto yVOkJ; e2y8v: $xS6Af[] = $C7lKq['phone']; goto E8_a9; E8_a9: $xS6Af[] = $C7lKq['created_at']; goto pG0Zj; pG0Zj: $xS6Af[] = TypeUtil::name(Gender::class, $C7lKq['gender']); goto LJOlz; Vpp_2: $xS6Af[] = $C7lKq['signature']; goto ZmKPw; ZmKPw: $Qf52C[] = $xS6Af; goto wkwOS; yVOkJ: $xS6Af[] = $C7lKq['email']; goto e2y8v; xB6Kn: $xS6Af = array(); goto vmAyv; vmAyv: $xS6Af[] = $C7lKq['id']; goto cbLQp; wkwOS: } return array('list' => $Qf52C, 'total' => $E5DNx['total']); })->performCommon(); } }