@if(!empty($ads))
<?php $bannerId = \ModStart\Core\Util\IdUtil::generate('Banner'); ?>
{!! \ModStart\ModStart::css('asset/vendor/swiper/swiper.css') !!}
{!! \ModStart\ModStart::js('asset/vendor/swiper/swiper.js') !!}
<div class="ub-banner margin-bottom ub-content-bg tw-rounded-lg" id="{{$bannerId}}">
    <div class="swiper-container tw-rounded-lg">
        <div class="swiper-wrapper">
            @foreach($ads as $a)
                <div class="swiper-slide tw-rounded-lg">
                    @if($a['link'])
                        <a href="{{$a['link']}}" target="_blank">
                            <img src="{{$a['image']}}" width="100%" />
                        </a>
                    @else
                        <img src="{{$a['image']}}" width="100%" />
                    @endif
                </div>
            @endforeach
        </div>
        @if(count($ads)>1)
            <div class="swiper-pagination swiper-pagination-white"></div>
        @endif
    </div>
</div>
<script>
    $(function () {
        var swiper = new Swiper('#{{$bannerId}} .swiper-container', {
            pagination: {
                el: '.swiper-pagination',
                clickable: true
            },
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            loop: true,
            autoplay: {
                delay: 5000
            },
            observer: true,
            observeParents: true,
            on: {
                observerUpdate: function(){
                    swiperRefresh();
                },
                resize: function () {
                    swiperRefresh();
                }
            }
        });
        var swiperRefresh = function(){
            setTimeout(function(){
                swiper.update();
            }, 500);
        };
    });
</script>
@endif

