<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace ModStart\Form; use Closure; use Illuminate\Contracts\Support\Renderable; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Collection; use Illuminate\Support\Facades\Input; use Illuminate\Support\Str; use Illuminate\Validation\Validator; use ModStart\Core\Dao\DynamicModel; use ModStart\Core\Exception\BizException; use ModStart\Core\Exception\ResultException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Type\SortDirection; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\IdUtil; use ModStart\Core\Util\SerializeUtil; use ModStart\Detail\Detail; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Display; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Concern\HasCascadeFields; use ModStart\Form\Type\FormEngine; use ModStart\Form\Type\FormMode; use ModStart\Grid\Concerns\HasSort; use ModStart\Repository\Filter\HasRepositoryFilter; use ModStart\Repository\Filter\HasScopeFilter; use ModStart\Repository\Repository; use ModStart\Repository\RepositoryUtil; use ModStart\Support\Concern\HasBuilder; use ModStart\Support\Concern\HasFields; use ModStart\Support\Concern\HasFluentAttribute; use ModStart\Support\Manager\FieldManager; use stdClass; class Form implements Renderable { use HasFields, HasBuilder, HasFluentAttribute, HasSort, HasCascadeFields, HasScopeFilter, HasRepositoryFilter; public $id; private $repository; private $view = 'modstart::core.form.index'; protected $fluentAttributes = array('engine', 'builder', 'mode', 'title', 'showSubmit', 'showReset', 'itemId', 'item', 'hookSubmitted', 'hookSaving', 'hookSaved', 'hookDeleting', 'hookDeleted', 'hookChanged', 'dataSubmitted', 'dataForming', 'dataAdding', 'dataEditing', 'canAdd', 'canEdit', 'canDelete', 'canSort', 'canCopy', 'sortAddPosition', 'formClass', 'treeMaxLevel', 'treeRootPid', 'formUrl', 'ajax', 'formAttr'); private $engine = 'basic'; private $mode = 'form'; private $title; private $showSubmit = true; private $showReset = true; private $itemId = null; private $item; private $hookSubmitted; private $hookSaving; private $hookSaved; private $hookDeleting; private $hookDeleted; private $hookChanged; private $dataSubmitted; private $dataForming; private $dataAdding; private $dataEditing; private $canAdd = true; private $canEdit = true; private $canDelete = true; private $canSort = false; private $canCopy = false; private $sortAddPosition = false; private $formClass = ''; private $treeMaxLevel = 99; private $treeRootPid = 0; private $formUrl = null; private $ajax = true; private $formAttr = ''; public function __construct($kZXWm, \Closure $p40Fy = null) { goto B9a8U; mUX_C: $this->fieldDefaultRenderMode(FieldRenderMode::FORM); goto KlWDN; KlWDN: $this->setupRepositoryFilter(); goto S8rUk; B9a8U: $this->id = IdUtil::generate('Grid'); goto ivWTA; ivWTA: $this->repository = Repository::instance($kZXWm); goto DalZL; S8rUk: $this->builder($p40Fy); goto XMKJv; DalZL: $this->setupFields(); goto mUX_C; XMKJv: } public static function make($xTADA = null, \Closure $p40Fy = null) { if (is_object($xTADA) || class_exists($xTADA) && is_subclass_of($xTADA, Model::class)) { return new Form($xTADA, $p40Fy); } return new Form(DynamicModel::make($xTADA), $p40Fy); } public function asTree($lwKEo = 'id', $ggQwu = 'pid', $T9Z9v = 'sort', $uNsqC = 'title') { goto Z0etE; FTb3a: $this->repository->setTreeTitleColumn($uNsqC); goto l1ano; V2PIt: $this->repository->setSortColumn($T9Z9v); goto FTb3a; yK0sl: return $this; goto dXmTu; HuZjS: $this->repository->setTreePidColumn($ggQwu); goto V2PIt; l1ano: $this->engine = FormEngine::TREE; goto qc4ho; Z0etE: $this->repository->setKeyName($lwKEo); goto HuZjS; qc4ho: $this->canSort(true); goto yK0sl; dXmTu: } public function asTreeMass($m7eoQ = 0, $lwKEo = 'id', $ggQwu = 'pid', $T9Z9v = 'sort', $uNsqC = 'title') { goto EiduL; k0bsu: $this->repository->setTreePidColumn($ggQwu); goto oBzPd; oBzPd: $this->repository->setSortColumn($T9Z9v); goto qTN3H; cuHlU: $this->engine = FormEngine::TREE_MASS; goto ggaRJ; TQgsj: return $this; goto I6P6e; ggaRJ: $this->canSort(true); goto TQgsj; EiduL: $this->repository->setKeyName($lwKEo); goto k0bsu; qTN3H: $this->repository->setTreeTitleColumn($uNsqC); goto cuHlU; I6P6e: } private function build() { $this->runBuilder(); if ($this->engine == FormEngine::TREE) { if ($this->treeMaxLevel > 1) { $E8QRJ = FieldManager::make($this, 'select', $this->repository->getTreePidColumn(), L('Parent')); $E8QRJ->optionRepositoryTreeItems($this->repository, $this->treeMaxLevel); } else { $E8QRJ = FieldManager::make($this, 'hidden', $this->repository->getTreePidColumn(), L('Parent')); $E8QRJ->value(0); } $this->prependField($E8QRJ); } else { if ($this->engine == FormEngine::TREE_MASS) { goto ubY2L; b9K1V: $E8QRJ->hookRendering(function (AbstractField $E8QRJ, $OV1o4, $xlsSz) { if (empty($OV1o4)) { $Ez_15 = InputPackage::buildFromInput()->get('_pid', $this->treeRootPid); } else { $Ez_15 = $OV1o4->{$this->repository->getTreePidColumn()}; } $this->repository()->setArgument('treePid', $Ez_15); $VX_Z2 = $this->repository->getTreeAncestorItems(); $Q1WHV = array(); $Q1WHV[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . L('Root'); foreach ($VX_Z2 as $UY3qE) { $Q1WHV[] = '<span class="ub-text-muted"><i class="icon iconfont icon-angle-right"></i></span> ' . htmlspecialchars($UY3qE->{$this->repository->getTreeTitleColumn()}); } $Q1WHV[] = '<input type="hidden" name="' . $this->repository->getTreePidColumn() . '" value="' . htmlspecialchars($Ez_15) . '" />'; return AutoRenderedFieldValue::make(join('', $Q1WHV)); }); goto nOocE; ubY2L: $E8QRJ = FieldManager::make($this, 'display', $this->repository->getTreePidColumn(), L('Parent')); goto weTKo; nOocE: $this->prependField($E8QRJ); goto cEttl; weTKo: $E8QRJ->addable(true)->editable(true)->listable(false); goto b9K1V; cEttl: } } } public function repository() { return $this->repository; } private function fieldValidateMessages($WJIdC, $sYsuI) { goto i07xu; oq7me: foreach ($WJIdC as $E8QRJ) { if (!($HROoj = $E8QRJ->getValidator($sYsuI))) { continue; } if ($HROoj instanceof Validator) { try { if (!$HROoj->passes()) { $ET0Kf[] = $HROoj; } } catch (\Exception $SwVsw) { BizException::throws('Form.fieldValidateMessages.Error - ' . SerializeUtil::jsonEncode($HROoj->getRules())); } } } goto j3tfV; gaOtP: return $KlO1f; goto pdNHC; j3tfV: $KlO1f = array(); goto NOPG3; i07xu: $ET0Kf = array(); goto oq7me; QzT8o: if (empty($KlO1f)) { return false; } goto gaOtP; NOPG3: foreach ($ET0Kf as $HROoj) { foreach ($HROoj->messages()->getMessages() as $BlfaU => $qFzW7) { $KlO1f[$BlfaU] = $qFzW7; } } goto QzT8o; pdNHC: } private function convertBizExceptionToResponse($tDUwy) { goto d_tfh; x8hiL: $CpflZ = array(array('FieldTooLong:', 'Field %s Too Long'), array('FieldFormatError:', 'Field %s Format Error')); goto I6FH1; I6FH1: foreach ($CpflZ as $Ipdv9) { if (Str::startsWith($wCo7_, $Ipdv9[0])) { goto f2jM6; jSJZU: if ($E8QRJ) { return Response::jsonError(L($Ipdv9[1], $E8QRJ->label())); } goto qOmhP; f2jM6: list($n_Lkt, $xLxQi) = explode(':', $wCo7_); goto n7ziV; n7ziV: $E8QRJ = $this->getFieldByColumn($xLxQi); goto jSJZU; qOmhP: } } goto DNSL5; d_tfh: $wCo7_ = $tDUwy->getMessage(); goto x8hiL; DNSL5: return Response::jsonError($wCo7_); goto AHu4q; AHu4q: } private function validateFields($WJIdC, $zonFp) { goto iujOw; BaHB4: foreach ($wC66x as $BlfaU => $KlO1f) { foreach ($KlO1f as $N0Z_W) { return Response::generateError($N0Z_W); } } goto EWTcu; EWTcu: return Response::generateSuccess(); goto KZtAL; T_F1s: if ($eGoDD = $this->fieldValidateMessages($WJIdC, $zonFp)) { $wC66x = array_merge($wC66x, $eGoDD); } goto BaHB4; iujOw: $wC66x = array(); goto T_F1s; KZtAL: } private function removeReservedFields() { goto rtw2N; tNFEt: $theZU = function (AbstractField $E8QRJ) use(&$x3jwR) { return in_array($E8QRJ->column(), $x3jwR, true) && $E8QRJ instanceof \ModStart\Field\Display; }; goto PREqe; rtw2N: $x3jwR = array($this->repository->getKeyName(), $this->repository->getCreatedAtColumn(), $this->repository->getUpdatedAtColumn()); goto tNFEt; PREqe: $this->fields = $this->fields()->reject($theZU); goto OUR7t; OUR7t: } public function hookCall($uTSeU) { if ($uTSeU instanceof Closure) { $Z5nZL = call_user_func($uTSeU, $this); if (null !== $Z5nZL) { return $Z5nZL; } } return Response::generateSuccess(); } public function isModeForm() { return $this->mode === FormMode::FORM; } public function isModeAdd() { return $this->mode === FormMode::ADD; } public function isModeEdit() { return $this->mode === FormMode::EDIT; } public function isModeDelete() { return $this->mode === FormMode::DELETE; } public function formRequest($uTSeU, array $zonFp = null) { goto vR6KA; QkBHz: $this->build(); goto lMeFv; lMeFv: $this->dataSubmitted = $zonFp ? $zonFp : Input::all(); goto jva28; jva28: try { goto x0HE6; x0HE6: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto yip3r; gs4LJ: ResultException::throwsIfFail($this->hookCall($this->hookSaved)); goto ofERR; tQkAU: $Z5nZL = call_user_func($uTSeU, $this); goto HJ6TU; xALEC: if (null !== $Z5nZL) { return Response::jsonFromGenerate($Z5nZL); } goto n8COm; n8COm: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto E_suZ; HJ6TU: if (null !== $Z5nZL) { if (Response::isError($Z5nZL)) { return Response::jsonFromGenerate($Z5nZL); } } goto gs4LJ; E_suZ: return Response::jsonSuccess(L('Save Success')); goto eE8O2; I6Ncl: foreach ($this->addableFields() as $E8QRJ) { goto g2rue; JBkn5: $this->dataForming[$E8QRJ->column()] = $HDpl6; goto x4zjL; g2rue: if ($E8QRJ->isLayoutField()) { continue; } goto w8ZAf; qHRlO: $HDpl6 = $E8QRJ->prepareInput($HDpl6, $this->dataSubmitted); goto UzYLx; w8ZAf: $HDpl6 = isset($this->dataSubmitted[$E8QRJ->column()]) ? $this->dataSubmitted[$E8QRJ->column()] : null; goto qHRlO; UzYLx: $HDpl6 = $E8QRJ->serializeValue($HDpl6, $E8QRJ); goto cYFHJ; cYFHJ: if ($E8QRJ->hookValueSerialize()) { $HDpl6 = call_user_func($E8QRJ->hookValueSerialize(), $HDpl6, $E8QRJ); } goto JBkn5; x4zjL: } goto kC8KV; kC8KV: ResultException::throwsIfFail($this->hookCall($this->hookSaving)); goto tQkAU; yip3r: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto Fb7qi; ofERR: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto xALEC; Fb7qi: $this->dataForming = array(); goto Lp8rq; Lp8rq: $this->removeReservedFields(); goto I6Ncl; eE8O2: } catch (BizException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } catch (ResultException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } goto ZDCEc; vR6KA: $this->mode(FormMode::FORM); goto QkBHz; ZDCEc: } public function add() { goto AG6Z6; j8kRE: if ($p6m4a) { $this->fillFields(); } goto D77_w; D77_w: return $this; goto DtjJK; ez6s_: $this->build(); goto j8kRE; OQnJG: if ($this->canCopy()) { $Y6feE = CRUDUtil::copyId(); if ($Y6feE) { goto XkGea; BIX6R: $this->item($this->repository()->editing($this)); goto nx00s; XkGea: $this->itemId($Y6feE); goto BIX6R; Gc2mv: $p6m4a = true; goto HJKvE; nx00s: $this->itemId(0); goto Gc2mv; HJKvE: } } goto ez6s_; AG6Z6: $this->mode(FormMode::ADD); goto J_vGH; J_vGH: $p6m4a = false; goto OQnJG; DtjJK: } public function addRequest(array $zonFp = null) { goto ETjH8; swWOq: $this->dataSubmitted = $zonFp ? $zonFp : Input::all(); goto RB2dv; RB2dv: try { goto ySS_d; Rs7MU: $D_1N9 = $this->repository->add($this); goto TOmNn; j_kLg: foreach ($this->addableFields() as $E8QRJ) { goto Hvvmv; Hvvmv: if ($E8QRJ->isLayoutField() || $E8QRJ->isCustomField()) { continue; } goto kMBI2; MJVtx: if ($E8QRJ->hookValueSerialize()) { $HDpl6 = call_user_func($E8QRJ->hookValueSerialize(), $HDpl6, $E8QRJ); } goto I2tWO; b80rj: $HDpl6 = $E8QRJ->serializeValue($HDpl6, $E8QRJ); goto MJVtx; kMBI2: $HDpl6 = isset($this->dataSubmitted[$E8QRJ->column()]) ? $this->dataSubmitted[$E8QRJ->column()] : null; goto GkPuC; I2tWO: $this->dataAdding[$E8QRJ->column()] = $HDpl6; goto FNVZA; GkPuC: $HDpl6 = $E8QRJ->prepareInput($HDpl6, $this->dataSubmitted); goto b80rj; FNVZA: } goto Rs7MU; BsKVx: return Response::jsonSuccess(L('Add Success')); goto o010a; oIuwT: $this->dataAdding = array(); goto wS2Uz; ySS_d: ResultException::throwsIfFail($this->validateFields($this->addableFields(), $this->dataSubmitted)); goto g2pVM; g2pVM: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto oIuwT; wS2Uz: $this->removeReservedFields(); goto j_kLg; TOmNn: foreach ($this->addableFields() as $E8QRJ) { if ($E8QRJ->hookValueSaved()) { call_user_func($E8QRJ->hookValueSaved(), $D_1N9, $E8QRJ); } } goto X8sEa; X8sEa: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto BsKVx; o010a: } catch (BizException $SwVsw) { return $this->convertBizExceptionToResponse($SwVsw); } catch (ResultException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } goto rgehg; v9OIT: $this->build(); goto swWOq; i3nK5: $this->mode(FormMode::ADD); goto v9OIT; ETjH8: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto i3nK5; rgehg: } public function edit($D_1N9) { try { goto si4xJ; JiV0t: $this->fillFields(); goto VvG6r; vrak6: $this->itemId($D_1N9); goto cxC90; VvG6r: return $this; goto JJLal; cxC90: $this->item($this->repository()->editing($this)); goto cbpS2; cbpS2: BizException::throwsIfEmpty(L('Record Not Exists'), $this->item); goto A8QB1; A8QB1: $this->build(); goto JiV0t; si4xJ: $this->mode(FormMode::EDIT); goto vrak6; JJLal: } catch (BizException $SwVsw) { return Response::sendError($SwVsw->getMessage()); } } public function editRequest($D_1N9, array $zonFp = null) { goto KFNlV; swx71: try { goto goh09; hwSto: ResultException::throwsIfFail($this->validateFields($this->editableFields(), $this->dataSubmitted)); goto ZJEyX; UH3rg: if ('itemCellEdit' == $x6cQE) { foreach ($this->editableFields() as $E8QRJ) { if ($E8QRJ->column() == $BlfaU && $E8QRJ->hookValueSaved()) { call_user_func($E8QRJ->hookValueSaved(), $this->itemId(), $E8QRJ); } } } else { foreach ($this->editableFields() as $E8QRJ) { if ($E8QRJ->hookValueSaved()) { call_user_func($E8QRJ->hookValueSaved(), $this->itemId(), $E8QRJ); } } } goto IAjWC; np4O2: return Response::jsonSuccess(L('Edit Success')); goto XvmIK; IAjWC: if (!empty($this->dataSubmitted['_redirect'])) { return Response::json(0, null, null, $this->dataSubmitted['_redirect']); } goto np4O2; ZJEyX: ResultException::throwsIfFail($this->hookCall($this->hookSubmitted)); goto wyVJK; oH97n: $this->removeReservedFields(); goto HVraf; wyVJK: $this->dataEditing = array(); goto oH97n; goh09: $this->edit($D_1N9); goto hwSto; jSth_: if ('itemCellEdit' == $x6cQE) { goto o_GJH; k7FvU: BizException::throwsIfEmpty('Data Error', $this->dataEditing); goto cGqyu; mE5KR: if ($BlfaU) { foreach ($this->editableFields() as $E8QRJ) { if ($E8QRJ->isLayoutField() || $E8QRJ->isCustomField()) { continue; } if ($E8QRJ->column() == $BlfaU) { goto waKPl; waKPl: $HDpl6 = $E8QRJ->prepareInput($HDpl6, $this->dataSubmitted); goto cXz9t; U6tXq: break; goto p_J8U; Enz1N: $this->dataEditing[$E8QRJ->column()] = $HDpl6; goto U6tXq; cXz9t: $HDpl6 = $E8QRJ->serializeValue($HDpl6, $E8QRJ); goto OPqjI; OPqjI: if ($E8QRJ->hookValueSerialize()) { $HDpl6 = call_user_func($E8QRJ->hookValueSerialize(), $HDpl6, $E8QRJ); } goto Enz1N; p_J8U: } } } goto k7FvU; Mc2Vf: $HDpl6 = isset($this->dataSubmitted['value']) ? $this->dataSubmitted['value'] : null; goto mE5KR; o_GJH: $BlfaU = isset($this->dataSubmitted['column']) ? $this->dataSubmitted['column'] : null; goto Mc2Vf; cGqyu: } else { foreach ($this->editableFields() as $E8QRJ) { goto yVe05; yVe05: if ($E8QRJ->isLayoutField() || $E8QRJ->isCustomField()) { continue; } goto bSiFq; IPrH0: if ($E8QRJ->hookValueSerialize()) { $HDpl6 = call_user_func($E8QRJ->hookValueSerialize(), $HDpl6, $E8QRJ); } goto rI_bI; rI_bI: $this->dataEditing[$E8QRJ->column()] = $HDpl6; goto S2brl; bSiFq: $HDpl6 = isset($this->dataSubmitted[$E8QRJ->column()]) ? $this->dataSubmitted[$E8QRJ->column()] : null; goto S8_zL; mpFPa: $HDpl6 = $E8QRJ->serializeValue($HDpl6, $E8QRJ); goto IPrH0; S8_zL: $HDpl6 = $E8QRJ->prepareInput($HDpl6, $this->dataSubmitted); goto mpFPa; S2brl: } } goto uXD8T; uXD8T: $this->repository()->edit($this); goto UH3rg; HVraf: $x6cQE = isset($this->dataSubmitted['_action']) ? $this->dataSubmitted['_action'] : null; goto jSth_; XvmIK: } catch (BizException $SwVsw) { return $this->convertBizExceptionToResponse($SwVsw); } catch (ResultException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } goto kqEui; REmb8: $this->dataSubmitted = $zonFp ? $zonFp : Input::all(); goto swx71; KFNlV: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto REmb8; kqEui: } public function deleteRequest($OZklk) { goto EEoL9; z0qwK: try { goto R5eMf; TllhY: $this->itemId(collect($zonFp)->map(function ($xQd0K) { return $xQd0K->{$this->repository()->getKeyName()}; })->toArray()); goto uWHrI; uWHrI: $GlTLE = $this->repository->delete($this, $zonFp); goto KfO0z; KfO0z: return Response::jsonSuccess(L('Delete Success')); goto mLRSS; R5eMf: $zonFp = $this->repository->deleting($this); goto k5Hy6; k5Hy6: $this->item($zonFp); goto TllhY; mLRSS: } catch (BizException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } catch (ResultException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } goto Q3K_O; PteLg: $this->itemId($OZklk); goto T_mGw; qs0cp: $this->mode(FormMode::DELETE); goto PteLg; T_mGw: $this->build(); goto z0qwK; EEoL9: if (!$this->canDelete) { return Response::pagePermissionDenied(); } goto qs0cp; Q3K_O: } public function sortRequest($OZklk) { goto PCd1h; pwv0W: $this->mode(FormMode::SORT); goto fZqKD; pjIBl: $this->build(); goto FtGLd; FtGLd: try { goto Ko_Ux; AMu0j: return Response::jsonSuccess(L('Operate Success')); goto MchXh; dryVd: ResultException::throwsIfFail($this->hookCall($this->hookChanged)); goto AMu0j; Ko_Ux: $GlTLE = $this->repository->sortEdit($this); goto dryVd; MchXh: } catch (BizException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } catch (ResultException $SwVsw) { return Response::jsonError($SwVsw->getMessage()); } goto CN67k; Va2ck: $this->repository->setArgument('direction', $sYsuI->getType('direction', SortDirection::class)); goto pjIBl; PCd1h: if (!$this->canSort) { return Response::pagePermissionDenied(); } goto pwv0W; Gibu_: $sYsuI = InputPackage::buildFromInput(); goto Va2ck; fZqKD: $this->itemId($OZklk); goto Gibu_; CN67k: } public function render() { goto xfEPi; xfEPi: $zonFp = array(); goto JZcK0; JZcK0: switch ($this->mode) { case FormMode::FORM: $zonFp['fields'] = $this->addableFields(true); break; case FormMode::ADD: goto fqM2x; j5N0X: $zonFp['fields'] = $this->addableFields(true); goto ziqc4; fqM2x: if (!$this->canAdd) { return Response::pagePermissionDenied(); } goto j5N0X; ziqc4: break; goto ytPPr; ytPPr: case FormMode::EDIT: goto yxmTR; A1zx6: break; goto Ud2mF; yxmTR: if (!$this->canEdit) { return Response::pagePermissionDenied(); } goto cBMmH; cBMmH: $zonFp['fields'] = $this->editableFields(true); goto A1zx6; Ud2mF: default: return Response::sendError('Form.render mode error : ' . $this->mode); } goto tnRb0; FsE7a: return view($this->view, $zonFp)->render(); goto RpuY3; tnRb0: $zonFp = array_merge($this->fluentAttributeVariables(), $zonFp); goto FsE7a; RpuY3: } public function __call($fVu6a, $RSGSj) { goto JuDJ5; UUhX1: return FieldManager::call($this, $fVu6a, $RSGSj); goto BWte3; G9ZRS: if ($this->isFluentAttribute($fVu6a)) { switch ($fVu6a) { case 'item': if (isset($RSGSj[0]) && is_array($RSGSj[0])) { $RSGSj[0] = RepositoryUtil::itemFromArray($RSGSj[0]); } break; } return $this->fluentAttribute($fVu6a, $RSGSj); } goto UUhX1; JuDJ5: switch ($fVu6a) { case 'enablePagination': case 'defaultOrder': case 'canShow': case 'canExport': case 'canImport': case 'canBatchDelete': case 'canMultiSelectItem': case 'addBlankPage': case 'editBlankPage': case 'disableCUD': case 'hookItemOperateRendering': case 'addDialogSize': case 'editDialogSize': case 'dialogSizeSmall': case 'gridFilter': case 'gridOperateAppend': case 'bodyAppend': case 'operateFixed': case 'defaultPageSize': case 'pageSizes': case 'canBatchSelect': case 'batchOperatePrepend': case 'gridToolbar': case 'pageJumpEnable': case 'textEdit': case 'gridTableTopView': case 'gridBeforeRequestScriptView': case 'gridRequestScript': return $this; } goto G9ZRS; BWte3: } public function __toString() { try { return $this->render(); } catch (\Exception $SwVsw) { return $SwVsw->getMessage(); } } }