@extends('modstart::admin.dialogFrame')

@section('pageTitle')模板可用变量@endsection

{!! \ModStart\ModStart::js('asset/common/clipboard.js') !!}

@section('bodyContent')

    <div class="tw-bg-white tw-rounded tw-p-4">
        <table class="ub-table border">
            <thead>
            <tr>
                <th width="200">变量</th>
                <th>说明</th>
            </tr>
            </thead>
            <tbody>
            @foreach(\Module\Edm\Util\EdmTemplateUtil::getParam() as $k=>$v)
                <tr>
                    <td>
                        <a href="javascript:;" data-clipboard-text="{{'{'.$k.'}'}}">
                            <i class="iconfont icon-copy"></i>
                        </a>
                        <code>{{'{'.$k.'}'}}</code>
                    </td>
                    <td>{{$v}}</td>
                </tr>
            @endforeach
            @foreach(['image'=>'图片','text'=>'文本','rich'=>'富文本'] as $k=>$v)
                <tr>
                    <td>
                        <a href="javascript:;" data-clipboard-text="{{'{random:'.$k.':标签}'}}">
                            <i class="iconfont icon-copy"></i>
                        </a>
                        <code>{{'{random:'.$k.':标签}'}}</code>
                    </td>
                    <td>
                        随机{{$v}}
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

@endsection
