// Copyright 2020 Simon Hoinkis
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once

#include <string>
#include <yaml-cpp/yaml.h>
namespace csf
{
namespace tui
{
class Window;
}
struct MqttConfig
{
    std::string hostAddress;
    uint16_t port;
    std::string clientId;
    std::string password;
};
class ConfigParser
{
  public:
    ConfigParser(tui::Window& window, std::string yamlFile);

    virtual ~ConfigParser() = default;

    ConfigParser(const ConfigParser&) = delete;
    ConfigParser(ConfigParser&&) = delete;
    ConfigParser& operator=(const ConfigParser&) = delete;
    ConfigParser& operator=(ConfigParser&&) = delete;

    const MqttConfig getMqttConfig() const;

  private:
    const std::string getHostAddress() const;
    const uint16_t getPort() const;
    const std::string getClientId() const;
    const std::string getPassword() const;

    YAML::Node m_config;
};

} // namespace csf
