# ![cosyfir logo](/doc/cosyfir-logo-small.jpg) **CO**ntrol **SY**stem **F**or **IR**rigation

> **_Disclaimer:_** This is a personal project and not affiliated with my employer

Cosyfir shall help you watering your plants.

The node software runs on an STM32 ARM Cortex microcontroller. The server software runs on UNIX-based systems like Debian. The following picture depicts an example setup:

     []         \ /       +--+         \  /        \o/
     []  <->     |   <->  |  |  <->   ( )( )  <->   |
     \/  LoRa    |        +--+  MQTT   (  )   SSH  / \

    Sensor    LoRaWAN     TTN          RPi        User
     Node     Gateway    Server       @home

    ./node/* (Not part of cosyfir)  ./server/*

This readme describes both the server (e.g. Raspberry Pi) and the sensor node software in the following sections.

## Server

The cosyfird application is a daemon, which receives messages from sensor nodes via TTN server and displays the last
message.

### Required hard- and software

* Computer running UNIX-like OS e.g. Raspberry Pi with Raspbian

Install the following software packages e.g. for Debian do:

    sudo apt install libncurses6 libmosquittopp1 libssl1.1 libyaml-cpp0.6 gcc cmake libjsoncpp1 libb64-0d

C++17 compiler is required. GCC 8.3.0 is recommended.

## Sensor node

This section describes the sensor node software which communicates based on [LoRa](https://en.wikipedia.org/wiki/LoRa) and [TTN](https://www.thethingsnetwork.org/).

### Required hard- and software

* [LSN50 v1.2](http://www.dragino.com/products/lora-lorawan-end-node/item/128-lsn50.html) from Dragino (I bought it [here](https://www.exp-tech.de/plattformen/internet-of-things-iot/8377/dragino-lsn50-868-12-waterproof-long-range-wireless-lora-sensor-node))
  * STM32L072CZT6
  * SX1276
  * Battery
  * IP66 case
* DS18B20 temperature sensor
* Watermark soil moistore sensor (Model 200SS) (I bought it [here](https://www.mmm-tech.de/de/watermark/wms))
* FTDI UART cable
* UNIX machine
  * [stm32flash](https://sourceforge.net/p/stm32flash/wiki/Home/) version  >=0.5

[LSN50-V2](http://www.dragino.com/products/lora-lorawan-end-node/item/155-lsn50-v2.html) should most likely work as well.

Install the following packages:

    sudo apt install stm32flash arm-none-eabi-gcc

## Build and setup

Before building the binaries, register your cosyfir application on the TTN website.

### Setup cosyfird and cosyfir-node with TTN

The following is a YAML configuration file template for cosyfird:

```yaml
MqttConfig:
    HostAddress: region.thethings.network
    Port: 8883
    ClientId: application-id
    Password: secret
```

TTN uses port `8883` with SSL and the host address `region.thethings.network` where `region` can be e.g. `eu`.

First of all, create a client identifier on the TTN site by clicking "Add application" on your personal
[network console](https://console.thethingsnetwork.org/). The application access key can be found at the bottom after
you have created an application. It acts as the password for the MQTT connection.

Here's an overview of the LoRa terminology:

| LoRa              | Explanation                           | From where?                          | Where to put?                   |
| ------------------|---------------------------------------|--------------------------------------|:-------------------------------:|
| DevEUI            | 64-bit end-device identifier (unique) | On device box                        | TTN console ("Register device") |
| AppEUI or JoinEUI | 64-bit application identifier         | Issued by TTN ("Add application")    | Commissioning.h                 |
| NwkKey or AppKey  | Data encryption key (TTN <-> server)  | Generated by TTN ("Add application") | Commissioning.h                 |
| DevAddr           | 32-bit address (non-unique)           | Assigned when node joins TTN         | -                               |

The activation method will always be over-the-air-activation (OTAA). The file is preconfigured to run in Europe.

Fill the preprocessor defines into `node/Commissioning_template.h` as described in the table. Then rename the file:

    mv node/common/Commissioning_template.h node/common/Commissioning.h

### Start the build

Run the build script in root to build both server and node binary.

    ./build_all.sh

Available parameters to the script are:

* `clean`: Perform a clean build
* `debug`: Build with debug symbols

### How to flash the sensor node

Flashing LSN50 can be done with a simple FTDI UART cable using the ISP boot mode.

Connect the UART as described below:

    GND (black):  JP4 Pin11 GND
    TXD (orange): JP3 Pin9  PA3 (USART1)
    RXD (yellow): JP3 Pin10 PA2 (USART1)

Find out where your USB serial device is mounted:

    journalctl -k -n 100

Set the switch from FLASH mode to ISP mode and then do:

    sudo stm32flash -w node/build/sensor-node.hex /dev/ttyUSBx

## Get cosyfir running

Connect the sensors:

    # DS18B20
    GND (blue):   JP3 Pin2 GND
    DQ  (yellow): JP3 Pin4 PA9 (Half-duplex single-wire using only TX)
    VDD (red):    JP3 Pin1 VDD

    # Watermark 200SS (tbd)
    JP3 Pin12 PA0
    JP3 Pin5  PA4
    # 10k resistor between PA4 and PA1

[More information](https://www.irrometer.com/200ss.html) about the Watermark sensor.

Check your local [TTN coverage](https://ttnmapper.org/) and make sure a gateway is nearby. Start
`./cosyfird --config-file /path/to/cosyfird.yaml` and power on the LSN50 with the boot switch set to FLASH.
After a few moments you should see messages arrive. In debug mode, messages are sent every 30 seconds.
In release mode every half an hour.

Example message payload in hex:

    | 42 | BE | EF | CA | FE |
      ^
      Battery level
           ^
           Temperature (resolution 0.0625 °C)
                     ^
                     Soil water tension
                     (tbd)

## Development

For development the following packages might be necessary:

    sudo apt install clang-format libmosquittopp-dev libssl-dev libyaml-cpp-dev libjsoncpp-dev libb64-dev libncurses-dev

### Debugging with STM32

Get an ST-LINK V2 debugger and install these packages:

    sudo apt install stmlink-tools gdb-multiarch

Three applications are available after installation:

* **st-flash**, for flashing binaries
* **st-info**, get infos about the microcontroller
* **st-utils**, attach GDB to the microcontroller

Connect as described below:

    GND:   JP4 Pin11 GND
    SWCLK: JP4 Pin4  PA14
    SWDIO: JP4 Pin9  PA13
    RST:   JP4 Pin1  NRST

Set the boot switch to ISP and try:

    st-info --probe

If everything is running correctly, you should see the serial and other infos about the microcontroller.
In case you don't see the infos, try swapping SWDIO and SWCLK. Some ST-LINK V2 debugger are wrongly labeled.

You can flash and debug your code with:

    st-util -p 1234
    (gdb-multiarch) set arch arm
    (gdb-multiarch) target extended-remote localhost:1234
    (gdb-multiarch) load sensor-node

To be able to jump back to user code, set the boot switch back to FLASH. Then you can set breakpoints and run the code
as usual:

    (gdb-multiarch) break foo.c:42
    (gdb-multiarch) run

Just loading the symbols without flashing is possible:

    (gdb-multiarch) file sensor-node

To do a warm restart, jump to the start of the flash:

    (gdb-multiarch) jump *0x08000000

To be able to see the printf's connect an FTDI on the same PINs as for flashing via bootloader/ISP boot mode and run:

    screen /dev/ttyUSB3 38400
