本电子书开源，欢迎 star 🌟，关注《LLM 应用开发实践笔记》

我的新书[《LangChain编程从入门到实践》](https://u.jd.com/V8pkqFY) 已经开售！推荐正在学习AI应用开发的朋友购买阅读！
[![LangChain编程从入门到实践](../../images/langchain-book.jpg "LangChain编程从入门到实践")](https://u.jd.com/V8pkqFY) ![](../images/group.png)
 

## A16Z推荐的AI学习清单


下面A16Z整理的一份人工智能领域的学习清单，涵盖各个方面，每一篇都是该领域的经典之作。从介绍神经网络、Transformer和大模型开始，包括LLM构建实践指南、提示工程和市场分析，最后列举了具有里程碑意义的研究成果论文列表。这是一份非常不错的由浅入深的学习路径，也是非常有价值的学习资源，从初学者到专业人士都可以从中受益，希望对大家有所帮助。

---
## 轻松入门🥳
> 这些文章不需要专门的背景知识，可以帮助你快速理解现代AI浪潮的最重要部分。

**[Software 2.0](https://karpathy.medium.com/software-2-0-a64152b37c35)** ：Andrej Karpathy是最早清楚解释（在2017年！）为什么新的AI浪潮真正重要的人之一。他的论点是，AI是一种新的、强大的编程计算机的方式。随着大语言模型(LLMs)的快速改进，这个论点被证明是有先见之明的，并为AI市场的可能进展提供了一个良好的思维模型。[中文翻译：颠覆式编程：软件2.0](https://zhuanlan.zhihu.com/p/366808383)

**[State of GPT](https://build.microsoft.com/en-US/sessions/db3f4859-cd30-4445-a0cd-553c3304f8e2)** ：这也是Karpathy的文章，这是一个非常容易理解的解释，说明了ChatGPT / GPT模型一般如何工作，如何使用它们，以及研发可能采取的方向。[中文翻译：State of GPT：大神Andrej揭秘OpenAI大模型原理和训练过程](https://mp.weixin.qq.com/s?__biz=MzIxODUzNTg2MA==&mid=2247485342&idx=1&sn=770152ca8a00f2e3d87ed2a09e131e11)

**[What is ChatGPT doing … and why does it work?](https://writings.stephenwolfram.com/2023/02/what-is-chatgpt-doing-and-why-does-it-work/)** ：计算机科学家和企业家Stephen Wolfram给出了一篇长而易读的解释，从一开始的原理解释了现代AI模型是如何工作的。他跟随从早期神经网络到今天的LLMs和ChatGPT的时间线。[中文翻译：ChatGPT在做什么...为什么它能够成功](https://zhuanlan.zhihu.com/p/607601817)

**[Transformers, explained](https://daleonai.com/transformers-explained)** ：这篇文章由Dale Markowitz撰写，是对“什么是LLM，它是如何工作的？”这个问题的一个更短、更直接的回答。这是一种很好的方式，可以轻松地进入这个主题，并对这项技术建立直观理解。这篇文章是关于GPT-3的，但仍适用于新的模型。[中文翻译：解析Tansformer模型—理解GPT-3, BERT和T5背后的模型](https://mp.weixin.qq.com/s/kfsW7ccYUAGp1AHWWF6c1w)，说明了Transformer模型中的三个核心组成部分：位置编码、注意力机制和自注意力机制的含义，它们共同作用于输入序列，使得模型可以更好地处理序列数据，并在NLP和其他序列数据处理任务中取得很好的表现

**[How Stable Diffusion works](https://mccormickml.com/2022/12/21/how-stable-diffusion-works/)** ：这是一篇与上一篇文章在计算机视觉领域的对应文章。Chris McCormick为非专业人士解释了Stable Diffusion是如何工作的，并从文本到图像模型的角度，帮助你对这种技术建立直观理解。如果你希望更轻松地理解这个概念，可以查看来自r/StableDiffusion的这个[漫画](https://www.reddit.com/r/StableDiffusion/comments/zs5dk5/i_made_an_infographic_to_explain_how_stable/)。(这部分我更推荐 知乎@小小将 写的文章，对照代码讲的很清楚，[文生图模型之Stable Diffusion](https://zhuanlan.zhihu.com/p/617134893))

## 基础学习：神经网络、反向传播和嵌入💪

> 这些资源为你提供了机器学习和AI基本概念的基础理解，从深度学习的基础知识到AI专家的大学水平课程。

**[Deep learning in a nutshell: core concepts](https://developer.nvidia.com/blog/deep-learning-nutshell-core-concepts/)** ：这是Nvidia的四部分系列文章，介绍了2015年实践中的深度学习基础，对于刚开始学习AI的人来说是一个很好的资源。

**[Practical deep learning for coders](https://course.fast.ai/)** ：通过实用的例子和代码，解释了AI基础知识的全面、免费的课程。

**[Word2vec explained](https://towardsdatascience.com/word2vec-explained-49c52b4ccb71)** ：对嵌入和令牌的简单介绍，它们是LLMs（和所有语言模型）的构建块。

**[Yes you should understand backprop](https://karpathy.medium.com/yes-you-should-understand-backprop-e2f06eab496b)** ：如果你想理解细节，这是关于反向传播更深入的文章。如果你想了解更多，可以看看[Youtube 上的Stanford CS231n 讲座](https://www.youtube.com/watch?v=i94OvYb6noo)。

### 课程
**[Stanford CS229](https://www.youtube.com/playlist?list=PLoROMvodv4rMiGQp3WXShtMGgzqpfVfbU)** ：Andrew Ng的机器学习入门课程，覆盖了机器学习的基础知识。

**[Stanford CS224N](https://www.youtube.com/playlist?list=PLoROMvodv4rOSH4v6133s9LFPRHjEmbmJ)** ：Chris Manning的深度学习自然语言处理(NLP)课程，通过第一代 LLM 介绍涵盖了 NLP 基础知识。

## 技术深度探讨：了解transformers和大模型🤯

> 有无数的资源（有些内容更好些）试图解释大语言模型(LLMs)的工作原理。以下是我们的一些最爱，面向广泛的读者/观众。

**[The illustrated transformer](https://jalammar.github.io/illustrated-transformer/)** ：Jay Alammar 对transformer架构的更多技术概述。

**[The annotated transformer](http://nlp.seas.harvard.edu/annotated-transformer/)** ：如果你想在源代码级别理解transformer模型，这是一篇深度文章。需要一些PyTorch的知识。

**[Let’s build GPT: from scratch, in code, spelled out](https://www.youtube.com/watch?v=kCc8FmEb1nY)** ：从零开始，通过代码，详细解释：对于工程师们，Karpathy做了一个如何构建GPT模型的视频演示。

**[The illustrated Stable Diffusion](https://jalammar.github.io/illustrated-stable-diffusion/)**** ：**对潜在扩散模型的介绍，这是最常见的用于图像生成的AI模型。

**[RLHF: Reinforcement Learning from Human Feedback](https://huyenchip.com/2023/05/02/rlhf.html)** ：Chip Huyen解释了RLHF（基于人类反馈的强化学习 ），它可以使LLMs的行为更可预测、更符合人类的友好方式。这是像ChatGPT这样的系统中最重要但最不好理解的方面之一。

**[Reinforcement learning from human feedback](https://www.youtube.com/watch?v=hhiLw5Q_UFg)** ：计算机科学家和OpenAI联合创始人John Shulman在这个精彩的演讲中更深入地探讨了LLMs（大语言模型）与RLHF（基于人类反馈的强化学习 ）的当前状态、进展和限制。

### 课程

**[Stanford CS25](https://www.youtube.com/watch?v=P127jhj-8-Y)** ：Transformer技术联盟，关于Transformer技术的在线研讨会。

**[Stanford CS324](https://stanford-cs324.github.io/winter2022/)** ：由Percy Liang, Tatsu Hashimoto和Chris Re主讲的《大型语言模型》课程，涵盖了大型语言模型的各种技术和非技术方面。

### 参考和评论

**[Predictive learning, NIPS 2016](https://www.youtube.com/watch?v=Ount2Y4qxQo&t=1072s)** ：在这次早期的演讲中，Yann LeCun强烈主张无监督学习是大规模AI模型架构的关键元素。跳到[19:20](https://youtu.be/Ount2Y4qxQo?t=1160)查看他著名的蛋糕类比，这仍然是现代AI最好的心智模型之一。

**[AI for full-self driving at Tesla:](https://www.youtube.com/watch?v=hx7BXih7zx8)** ：另一个经典的Karpathy演讲，这次他介绍了特斯拉的数据收集引擎。从[8:35](https://youtu.be/hx7BXih7zx8?t=515)开始，他进行了一次伟大的AI演讲，解释了为什么长尾问题（在这种情况下是停车标志检测）如此困难。

**[The scaling hypothesis](https://gwern.net/scaling-hypothesis)** ：大型语言模型最令人惊讶的方面之一：规模化（增加更多的数据和计算）会继续提高准确性。GPT-3是第一个清楚展示这一点的模型，Gwern的文章很好地解释了其背后的直觉。

**[Chinchilla's wild implications](https://www.lesswrong.com/posts/6Fpvch8RR29qLEWNH/chinchilla-s-wild-implications)** ：名义上是对重要的Chinchilla论文的解释，这篇文章触及了LLM规模化的大问题的核心：我们是否正在耗尽数据？这篇文章在上面文章的基础上，给出了对规模化规律的新鲜视角。

**[A survey of large language models](https://arxiv.org/pdf/2303.18223v4.pdf)** ：对当前LLM的全面分析，包括发展时间线、规模、训练策略、训练数据、硬件等。

**[Sparks of artificial general intelligence: Early experiments with GPT-4](https://arxiv.org/abs/2303.12712)** ：微软研究部对当前最先进的LLM（GPT-4）相对于人类智能能力的早期分析。

**[The AI revolution: How Auto-GPT unleashes a new era of automation and creativity](https://pub.towardsai.net/the-ai-revolution-how-auto-gpt-unleashes-a-new-era-of-automation-and-creativity-2008aa2ca6ae)** ：介绍Auto-GPT和AI Agents。这项技术还很早期，但重要的是要理解它——它使用互联网访问和自我生成的子任务来解决特定的、复杂的问题或目标。

**[The Waluigi Effect](https://www.lesswrong.com/posts/D7PumeYTDPfBTp3i7/the-waluigi-effect-mega-post)** ：名义上是对“Waluigi 效应”的解释（即，为什么LLM行为中会出现“另我”）【注：在回应不同的提示或问题时，它可能会表现出不同的“个性”或“角色”】的解释，但其主要的有趣之处在于它对LLM提示理论的深入研究。

## 使用 LLM 进行构建的实用指南🧑🏻‍💻

> 新的应用栈正在以LLM为核心形成。虽然目前还没有很多关于此主题的正规教育课程，但我们找到了一些最有用的资源。

**[Build a GitHub support bot with GPT3, LangChain, and Python](https://dagster.io/blog/chatgpt-langchain)** ：这是关于现代LLM应用栈的最早的公开解释之一。这里的一些建议可能已经过时，但在很多方面，它开启了新一代AI应用的广泛接受和实践。

**[Building LLM applications for production](https://huyenchip.com/2023/04/11/llm-engineering.html)** ：Chip Huyen讨论了构建LLM应用的许多关键挑战，如何解决这些挑战，以及哪种类型的用例最有意义。

**[Prompt Engineering Guide](https://www.promptingguide.ai/)** ：对于任何编写LLM提示的人——包括应用开发者——这是最全面的指南，对一些流行模型提供了具体示例。如果想要更轻松、更富有对话性的处理，可以尝试阅读[Brex的提示工程指南](https://github.com/brexhq/prompt-engineering)。

**[Prompt injection: What’s the worst that can happen?](https://simonwillison.net/2023/Apr/14/worst-that-can-happen/)** 可能会发生什么最糟糕的事情？提示注入是LLM应用潜在的严重安全漏洞，目前还没有完美的解决方案。Simon Willison在这篇文章中对这个问题给出了最终的描述。Simon关于AI的几乎所有内容都是非常棒的。

**[OpenAI cookbook](https://github.com/openai/openai-cookbook/tree/main)** ：对于开发者来说，这是使用OpenAI API的指南和代码示例的最权威收集。它会不断更新新的代码示例。

**[Pinecone learning center](https://www.pinecone.io/learn/)** ：许多LLM应用都是基于向量搜索范式。尽管Pinecone的学习中心是其品牌所提供的内容，但它提供了如何在这种模式中构建的最有用的指导。

**[LangChain docs](https://python.langchain.com/en/latest/index.html)** ：作为LLM应用的默认协调层，LangChain将堆栈中的所有其他部分连接在一起。因此，他们的文档对于理解整个技术栈以及各部分如何协同工作提供了实用的参考。

### 课程

**[LLM Bootcamp](https://fullstackdeeplearning.com/llm-bootcamp/)** ：这是一个实践课程，由Charles Frye、Sergey Karayev和Josh Tobin主导，专注于构建基于LLM的应用。

**[Hugging Face Transformers](https://huggingface.co/learn/nlp-course/chapter1/1)** ：这是一个指南，教你如何使用Hugging Face transformers库中的开源LLM。

**LLM基准**

**[Chatbot Arena](https://lmsys.org/blog/2023-05-03-arena/)** ：这是一个由UC Berkeley的团队领导的，采用Elo评分系统对热门LLM进行排名的平台。用户也可以通过进行模型间的直接比较参与其中。

**[Open LLM Leaderboard](https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard)** ：是一个由Hugging Face提供的排行榜，比较开源LLM在一系列标准基准和任务中的表现。

## 里程碑式的研究成果🔬

> 我们今天所见的许多令人惊奇的AI产品，都是由大公司和顶级大学的专家进行的令人惊奇的研究成果。最近，我们也看到了个人和开源社区对流行项目进行的卓越工作，例如，通过创建自动化代理或将大模型移植到算力更弱的硬件上运行。以下是这些论文和项目的集合，供真正想深入研究生成性AI的人参考。（对于研究论文和项目，我们还包括了相关的博客文章或网站的链接（如果有的话），这些内容往往以更高的水平做出了解释。我们也包括了原始出版年份，以便您可以追踪基础研究的发展。）

### 大型语言模型

#### 新模型

**[Attention is all you need](https://arxiv.org/abs/1706.03762)** (2017)：这是由Google Brain部门发布的，引发了所有转变的原始Transformer工作和研究论文。（[博客文章](https://ai.googleblog.com/2017/08/transformer-novel-neural-network.html)）

**[BERT: pre-training of deep bidirectional transformers for language understanding](https://arxiv.org/abs/1810.04805)** （2018 年）：这是首批公开可用的LLM之一，至今仍有许多变体在使用。（[博客文章](https://ai.googleblog.com/2018/11/open-sourcing-bert-state-of-art-pre.html)）

**[Improving language understanding by generative pre-training](https://cdn.openai.com/research-covers/language-unsupervised/language_understanding_paper.pdf)** (2018)：这是OpenAI发布的首篇论文，涵盖了GPT架构，它已成为LLM发展的主要路径。（[博客文章](https://openai.com/research/language-unsupervised)）

**[Language models are few-shot learners](https://arxiv.org/abs/2005.14165)** (2020)：这是OpenAI的论文，描述了GPT-3和现代LLM的仅解码器架构。（Decoder-only architecture）

**[Training language models to follow instructions with human feedback](https://arxiv.org/abs/2203.02155)** (2022)：这是OpenAI的论文，解释了InstructGPT，它利用了人在循环训练模型，从而更好地遵循提示中的指令。这是使LLM能够为消费者（例如，通过ChatGPT）使用的关键突破之一。（[博客文章](https://openai.com/research/instruction-following)）

**[LaMDA: language models for dialog applications](https://arxiv.org/abs/2201.08239)** （2022 年）：这是Google专门设计的模型，用于人类和聊天机器人在各种主题上的自由对话。（[博客文章](https://blog.google/technology/ai/lamda/)） 

**[PaLM: Scaling language modeling with pathways](https://arxiv.org/abs/2204.02311)** （2022 年）：Google的PaLM利用了一种新系统，可以在数千个芯片上训练LLM，并且随着模型规模的增大，在某些任务上展示出了超预期的改进。（[博客文章](https://ai.googleblog.com/2022/04/pathways-language-model-palm-scaling-to.html)）。另请参阅[PaLM-2 技术报告](https://arxiv.org/abs/2305.10403)。

**[OPT：Open Pre-trained Transformer language models](https://arxiv.org/abs/2205.01068)** (2022)：OPT是表现最优秀的全开源LLM之一。这个拥有1750亿参数的模型的发布附带了代码，并在公开可用的数据集上进行了训练。（[博客文章](https://ai.facebook.com/blog/democratizing-access-to-large-scale-language-models-with-opt-175b/)）

**[Training compute-optimal large language models](https://arxiv.org/abs/2203.15556)**(2022)：Chinchilla论文。它提出大多数模型受到数据限制，而不是计算限制，并改变了对LLM规模的共识。（[博客文章](https://www.deepmind.com/blog/an-empirical-analysis-of-compute-optimal-large-language-model-training)）

**[GPT-4 technical report](https://arxiv.org/abs/2303.08774)** （2023 年）：来自OpenAI的最新和最伟大的论文，最为人所知的是它揭示的信息之少！（[博客文章](https://openai.com/research/gpt-4)）。[GPT-4 系统卡片](https://cdn.openai.com/papers/gpt-4-system-card.pdf)揭示了OpenAI如何处理幻觉、隐私、安全性和其他问题。。

**[LLaMA: Open and efficient foundation language models](https://arxiv.org/abs/2302.13971)** (2023)：来自Meta的模型（几乎）开始了一个开源LLM革命。与许多最好的闭源模型竞争，但只对研究人员开放了有限制的许可。（[博客文章](https://ai.facebook.com/blog/large-language-model-llama-meta-ai/)）

**[Alpaca: A strong, replicable instruction-following model](https://crfm.stanford.edu/2023/03/13/alpaca.html)** （2023 年）：来自斯坦福大学的这种模型展示了指令调整的力量，特别是在较小的开源模型中，相比于纯粹的规模。

#### 模型改进（例如微调、检索、注意力）

**[Deep reinforcement learning from human preferences](https://proceedings.neurips.cc/paper_files/paper/2017/file/d5e2c0adad503c91f91df240d0cd4e49-Paper.pdf)** (2017)：关于游戏和机器人环境中强化学习的研究，结果证明这是 LLM 的绝佳工具。

**[Retrieval-augmented generation for knowledge-intensive NLP tasks](https://arxiv.org/abs/2005.11401)** (2020)：由 Facebook 开发，RAG 是通过信息检索提高 LLM 准确性的两个主要研究路径之一。（[博客文章](https://ai.facebook.com/blog/retrieval-augmented-generation-streamlining-the-creation-of-intelligent-natural-language-processing-models/)）

**[Improving language models by retrieving from trillions of tokens ](https://arxiv.org/abs/2112.04426)** （2021 年）：RETRO，即“检索增强型 TRansfOrmers”，这是另一种由DeepMind提出的通过访问训练数据中未包含的信息来提高LLM准确性的方法。（[博客文章](https://www.deepmind.com/blog/improving-language-models-by-retrieving-from-trillions-of-tokens)）

**[LoRA：Low-rank adaptation of large language models](https://arxiv.org/abs/2106.09685)** (2021)：这项来自Microsoft的研究为在新数据上训练LLM提供了一种比微调更有效的替代方案。它现在已经成为社区微调的标准，特别是对于图像模型。

**[Constitutional AI ](https://arxiv.org/abs/2212.08073)**(2022)：Anthropic团队介绍了来自AI反馈的强化学习（RLAIF）的概念。主要的想法是我们可以在其他AI的监督下开发出一个无害的AI助手。

**[FlashAttention: Fast and memory-efficient exact attention with IO-awareness](https://arxiv.org/abs/2205.14135)** （2022）：这项来自斯坦福的研究为最先进的模型打开了理解更长文本序列（和高分辨率图像）而无需高昂的训练时间和成本的大门。（[博客文章](https://ai.stanford.edu/blog/longer-sequences-next-leap-ai/)）

**[Hungry hungry hippos: Towards language modeling with state space models](https://arxiv.org/abs/2212.14052)** (2022)：同样来自斯坦福，这篇论文描述了语言建模中注意力的主要替代方案之一。这是一条通向更好的扩展和训练效率的有前途的路径。（[博客文章](https://hazyresearch.stanford.edu/blog/2023-01-20-h3)）

### 图像生成模型

**[Learning transferable visual models from natural language supervision](https://arxiv.org/abs/2103.00020)** (2021)：这篇论文介绍了一种基础模型 CLIP ，将文本描述与图像联系起来。这是计算机视觉中首次有效的大规模使用基础模型。（[博客文章](https://openai.com/research/clip)）

**[Zero-shot text-to-image generation](https://arxiv.org/abs/2102.12092)** (2021)：这篇论文介绍了DALL-E，这是一种将上述的CLIP和GPT-3结合起来，根据文本提示自动生成图像的模型。它的后继者，DALL-E 2，在2022年引发了基于图像的生成式AI热潮。（[博客文章](https://openai.com/research/dall-e)）

**[High-resolution image synthesis with latent diffusion models](https://arxiv.org/abs/2112.10752)** (2021)：描述稳定扩散的论文（在发布和爆炸性开源增长之后）。

**[Photorealistic text-to-image diffusion models with deep language understanding](https://arxiv.org/abs/2205.11487)** （2022 年）：Imagen是Google进入AI图像生成领域的尝试。尽管在宣布后的一年多时间里，该模型截止到本文发布日期仍未公开发布。（[网站](https://imagen.research.google/)）

**[DreamBooth：Fine tuning text-to-image diffusion models for subject-driven generation](https://arxiv.org/abs/2208.12242)** (2022)：DreamBooth是Google开发的一种系统，用于训练模型识别用户提交的主题，并将其应用到提示的上下文中（例如 [用户] 在艾菲尔铁塔下微笑）。（[网站](https://dreambooth.github.io/)）

**[Adding conditional control to text-to-image diffusion models](https://arxiv.org/abs/2302.05543)** (2023)：这篇来自斯坦福的论文介绍了ControlNet，这现在是一种非常流行的工具，用于对使用潜在扩散模型的图像生成进行细粒度控制。

### Agents（智能体代理）

**[A path to autonomous machine intelligence](https://openreview.net/pdf?id=BZ5a1r-kVsf)** (2022)：Meta AI领导者和纽约大学教授Yann LeCun提出的关于如何构建真正理解周围世界的自主智能代理的建议。

**[ReAct：Synergizing reasoning and acting in language models](https://arxiv.org/abs/2210.03629)** (2022)：普林斯顿大学和Google的一个项目，用来测试和提高LLM（大型语言模型）的推理和规划能力。（[博客文章](https://ai.googleblog.com/2022/11/react-synergizing-reasoning-and-acting.html)）

**[Generative agents: Interactive simulacra of human behavior](https://arxiv.org/abs/2304.03442)** (2023)：斯坦福大学和Google的研究人员使用LLM驱动代理，在类似于“The Sims”（模拟人生）这样的环境中，其互动是自发的，而不是由编程驱动的。

**[Reflexion: an autonomous agent with dynamic memory and self-reflection](https://arxiv.org/abs/2303.11366)** (2023)：来自东北大学和MIT的研究人员的工作，他们通过从错误和过去的经验中学习，教导LLM更可靠地解决问题。

**[Toolformer：Language models can teach themselves to use tools](https://arxiv.org/abs/2302.04761)** (2023)：这个来自Meta的项目训练LLM使用外部工具（在这种情况下，API指向搜索引擎和计算器等东西），以提高准确性，而不增加模型大小。 

**[Auto-GPT: An autonomous GPT-4 experiment](https://github.com/Significant-Gravitas/Auto-GPT)** : 一个开源实验项目，通过给GPT-4提供一组工具（互联网访问、文件存储等）并选择使用哪些工具来解决特定任务，以扩大GPT-4的能力。

**[BabyAGI](https://github.com/yoheinakajima/babyagi)** ：这个Python脚本使用GPT-4和向量数据库（用来存储上下文），以便计划并执行一系列解决更广泛目标的任务。

### 其他数据模态

#### 代码生成

**[Evaluating large language models trained on code](https://arxiv.org/abs/2107.03374)** (2021)：这是OpenAI关于Codex的研究论文，Codex是GitHub Copilot产品背后的代码生成模型。（[博客文章](https://openai.com/blog/openai-codex)）

**[Competition-level code generation with AlphaCode](https://www.science.org/stoken/author-tokens/ST-905/full)** （2021 年）：这项来自DeepMind的研究展示了一种模型，能够比人类程序员编写更好的代码。（[博客文章](https://www.deepmind.com/blog/competitive-programming-with-alphacode)）

**[CodeGen: An open large language model for code with multi-turn program synthesis](https://arxiv.org/abs/2203.13474)** （2022 年）：CodeGen来自Salesforce的AI研究部门，目前支持Replit Ghostwriter的代码生成产品。（[博客文章](https://blog.salesforceairesearch.com/codegen/)）

#### 视频生成

**[Make-A-Video: Text-to-video generation without text-video data ](https://arxiv.org/abs/2209.14792)** （2022）：来自Meta的一个模型，可以根据文本提示创建短视频，也可以给静态照片输入添加动作，或者创建现有视频的变体。（[博客文章](https://makeavideo.studio/)）

**[Imagen Video: High definition video generation with diffusion models](https://arxiv.org/abs/2210.02303)** （2022 年）：顾名思义：谷歌基于图像的 Imagen 模型的一个版本，专门用于根据文本提示生成短视频。（[网站](https://imagen.research.google/video/)）

#### 人类生物学和医学数据

**[Strategies for pre-training graph neural networks](https://arxiv.org/pdf/1905.12265.pdf)** (2020)：这篇出版物为有效的预训练方法奠定了基础，这些方法对于药物发现的各种应用都很有用，比如分子性质预测和蛋白质功能预测。（[博客文章](https://snap.stanford.edu/gnn-pretrain/)）

**[Improved protein structure prediction using potentials from deep learning](https://www.nature.com/articles/s41586-019-1923-7)** （2020 年）：DeepMind的以蛋白质为中心的Transformer模型AlphaFold，使得能够从序列预测蛋白质结构——这是一个真正的突破，已经对理解生物过程和开发新的疾病治疗方法产生了深远影响。（[博客文章](https://www.deepmind.com/blog/alphafold-a-solution-to-a-50-year-old-grand-challenge-in-biology)）（[解释器](https://www.blopig.com/blog/2021/07/alphafold-2-is-here-whats-behind-the-structure-prediction-miracle/)）

**[Large language models encode clinical knowledge](https://arxiv.org/abs/2212.13138)** （2022）：Med-PaLM是一个能够正确回答美国医疗执照考试风格问题的LLM。该团队已经公布了Med-PaLM2的表现结果，其得分与“专家”考试者相当。其他团队已经用[ChatGPT](https://www.medrxiv.org/content/10.1101/2022.12.19.22283643v2)和[GPT-4](https://arxiv.org/abs/2303.13375)进行了类似的实验。（[视频](https://www.youtube.com/watch?v=saWEFDRuNJc)）

#### 音频生成

**[Jukebox: A generative model for music](https://arxiv.org/abs/2005.00341)** （2020 年）：OpenAI使用transformer进行音乐生成的尝试，能够在最小的训练下生成音乐、声音和歌词。（[博客文章](https://openai.com/research/jukebox)）

**[AudioLM: a language modeling approach to audio generation](https://arxiv.org/pdf/2209.03143.pdf)** (2022)：AudioLM是Google的一个项目，用于生成多种类型的音频，包括语音和乐器演奏。（[博客文章](https://ai.googleblog.com/2022/10/audiolm-language-modeling-approach-to.html)）

**[MusicLM: Generating nusic from text](https://arxiv.org/abs/2301.11325)** (2023)：当前基于AI的音乐生成的最新技术，展示出比以前尝试更高的质量和连贯性。（[博客文章](https://google-research.github.io/seanet/musiclm/examples/)）

#### 多维图像生成

**[NeRF：Representing scenes as neural radiance fields for view synthesis](https://arxiv.org/abs/2003.08934)** (2020)：来自以加州大学伯克利分校为主的团队的研究，使用5D坐标“合成复杂场景的新视图”。（[网站](https://www.matthewtancik.com/nerf)）

**[DreamFusion: Text-to-3D using 2D diffusion](https://arxiv.org/pdf/2209.14988.pdf)** (2022)：来自Google和加州大学伯克利分校的研究人员的工作，基于NeRF从2D输入生成3D图像。（[网站](https://dreamfusion3d.github.io/)）
