本电子书开源，欢迎 star 🌟，关注《LLM 应用开发实践笔记》

我的新书[《LangChain编程从入门到实践》](https://u.jd.com/V8pkqFY) 已经开售！推荐正在学习AI应用开发的朋友购买阅读！
[![LangChain编程从入门到实践](../../images/langchain-book.jpg "LangChain编程从入门到实践")](https://u.jd.com/V8pkqFY) ![](../images/group.png)

## 什么是 AI 代理

AI代理（AI agent）是指使用 AI 技术设计和编程的一种计算机程序，其可以独立地进行某些任务并对环境做出反应。AI代理可以被视为一个智能体，它能够感知其环境，通过自己的决策和行动来改变环境，并通过学习和适应来提高其性能。这种智能体同时使用短期记忆（上下文学习）和长期记忆（从外部向量存储中检索信息），有能力通过逐步“思考”来计划、将目标分解为更小的任务 ，并反思自己的表现。AI代理通常包含多种技术，如机器学习、自然语言处理、计算机视觉、规划和推理等，这些技术使代理能够自主地处理信息并作出决策。

### 什么是 LLM 支持的自主代理
OpenAI AI应用研究主管 Lilian Weng 最近发布了一篇关于 AI 代理的万字长文：[《大语言模型（LLM）支持的自主代理》](https://lilianweng.github.io/posts/2023-06-23-agent/)，深度解读了什么是由 LLM 训练构建的 AI 代理应用。LLM 支持的 AI 代理现在已经出现了很多优秀的应用，例如 AutoGPT、GPT-Engineer、BabyAGI 和 SuperAGI 等。在LLM 支持的自主代理系统中，LLM 充当代理的大脑，并由几个关键组件进行补充：规划（Planning）、内存（Memory）、工具使用（Tool Use)。

![agent-overview](../images/agent-overview.png)

### 任务规划

- **任务拆分**：复杂任务不是一次性就能解决的，需要拆分成多个并行或串行的子任务来进行求解，任务规划的目标是找到一条最优的、能够解决问题的路线

- **自我反省**：自我反思是一个重要的方面，它允许自主代理通过完善过去的行动决策和纠正以前的错误来迭代改进。它在不可避免地会出现试错的现实任务中发挥着至关重要的作用。**ReAct (**[Yao et al. 2023](https://arxiv.org/abs/2210.03629)**)**  发现让Agents执行下一步action的时候，加上LLM自己的思考过程，并将思考过程、执行的工具及参数、执行的结果放到prompt中，就能使得模型对当前和先前的任务完成度有更好的反思能力，从而提升模型的问题解决能力。

  ```text
  Thought: ... 
  Action: ... 
  Observation: ... 
  ...(重复以上过程）
  ```

- **思想链**：已成为增强复杂任务模型性能的标准提示技术。该模型被指示“一步一步思考”，以利用更多的测试时间计算将困难任务分解为更小、更简单的步骤。 CoT 将大型任务转化为多个可管理的任务，并阐明模型思维过程的解释。
- **思维树**：通过在每一步探索多种推理可能性来扩展 CoT。它首先将问题分解为多个思考步骤，并在每个步骤中生成多个思考，从而创建树结构。搜索过程可以是 BFS（广度优先搜索）或 DFS（深度优先搜索），每个状态由分类器（通过提示）或多数投票进行评估。

### 记忆

- **感知记忆**：这是记忆的最早阶段，提供在原始刺激结束后保留感觉信息（视觉、听觉等）印象的能力。感知记忆通常只能持续几秒钟。子类别包括图像记忆（视觉）、回声记忆（听觉）和触觉记忆（触摸）。感知记忆作为原始输入的学习嵌入表示，包括文本、图像或其他形式。

- **短期记忆**：它存储我们当前意识到的以及执行学习和推理等复杂认知任务所需的信息。短期记忆被认为具有大约 7 个项目的容量（Miller 1956）并且持续 20-30 秒。短期记忆作为情境学习。它是短且有限的，因为它受到 Transformer 有限上下文窗口长度的限制。

- **长期记忆（LTM）**：长期记忆可以存储相当长的时间信息，从几天到几十年不等，存储容量基本上是无限的。 LTM 有两种亚型：

  1. 外显/陈述性记忆：这是对事实和事件的记忆，是指那些可以有意识地回忆起来的记忆，包括情景记忆（事件和经历）和语义记忆（事实和概念）。
  2. 内隐/程序性记忆：这种类型的记忆是无意识的，涉及自动执行的技能和例程，例如骑自行车或在键盘上打字。

  长期记忆作为代理在查询时可以处理的外部向量存储，可通过快速检索进行访问。

### 工具使用

- 代理学习调用外部 API 来获取模型权重中缺失的额外信息（通常在预训练后很难更改），包括当前信息、代码执行能力、对专有信息源的访问等。
- API-Bank ([Li et al. 2023](https://arxiv.org/abs/2304.08244))  是评估工具增强LLM性能的基准。它包含 53 个常用的 API 工具、一个完整的工具增强的 LLM 工作流程，以及涉及 568 个 API 调用的 264 个带注释的对话。API的选择非常多样化，包括搜索引擎，计算器，日历查询，智能家居控制，日程安排管理，健康数据管理，帐户身份验证工作流程等。因为有大量的API，LLM首先可以访问API搜索引擎找到合适的API调用，然后使用相应的文档进行调用。
- 清华发表的**ToolLLM**（[Qin et al. 2023](https://arxiv.org/pdf/2307.16789.pdf)）中大模型能够使用的API高达16000多个。

### 参考链接
