本电子书开源，欢迎 star 🌟，关注《LLM 应用开发实践笔记》

我的新书[《LangChain编程从入门到实践》](https://u.jd.com/V8pkqFY) 已经开售！推荐正在学习AI应用开发的朋友购买阅读！
[![LangChain编程从入门到实践](../../images/langchain-book.jpg "LangChain编程从入门到实践")](https://u.jd.com/V8pkqFY) ![](../images/group.png)

## 狭义 LLMOps

狭义的LLMOps不包括大模型的训练，相关的项目应关注两点产品适应性:

1. 首先能为项目和社区创造价值;

2. 其次是在业务实践中,构建一个可靠、适应性强的基础设施和工具层,以帮助用户充分发挥LLM的潜力。

LLMOps的初创公司主要关注LLM应用栈的开发,可以大致分为以下几类:

- 提示管理和评估（提示工程、审核、跟踪、A/B测试、提示链接、调试提示、评估等），包括跨多个基础模型提供商进行提示链接；
- 无代码/低代码微调/嵌入管理（包括用于在特定数据集上重新训练通用模型的工具，标记、清洗等）
- 代理集成/基于行动的LLM决策，执行行动，目标规划，与外部世界接口等；
- 分析/可观察性——成本、延迟、速率限制管理、可解释性等

下面是一些符合上面要求的一些 LLMOps 平台

### [Relevance AI](https://relevanceai.com/blog)

服务了 20 多家企业级客户，包括联合利华这样的公司。

- **构建能与任何东西交互的AI应用**：不再受文件限制和复杂模板的约束。轻松将ChatGPT等语言模型与向量数据库、PDF OCR等技术整合。
- **利用链条自定义每一个细节**：通过链式提示和转换,从模板到自适应链条,构建定制的AI体验。

- **独特的LLM优先功能**：通过质量控制、语义缓存等独特LLM功能,防止脱离现实,节省成本。

- **无模型供应商锁定**：在OpenAI、Cohere、Anthropic等顶级LLM提供商中随意切换。

- **完全托管服务**：我们负责基础设施管理、托管和扩容。

### [HoneyHive](https://honeyhive.ai/)

1. **内置版本控制和日志记录**: 可以在Playground中进行实验，并记录每次的变化和修改，以便跟踪模型的演化过程。

2. **试验新的提示、模型和超参数设置**: 在Playground中尝试不同的提示文本、模型架构和超参数设置，以寻找最佳的组合。

3. **使用NLP指标、基于LLM的评估模块、单元测试和人工反馈**: 使用自然语言处理（NLP）指标对模型性能进行评估，利用基于语言模型的评估模块，执行单元测试以确保模型质量，并结合人工反馈进行优化。

4. **测试提示模型变体**: 针对专有数据集测试不同的提示模型变体，以确定哪种模型变体在特定任务上表现最佳。

5. **可视化自定义指标、比较数据切片、检测异常**: 可以根据需要定制指标并对其进行可视化，比较不同数据切片的性能，识别异常情况。

6. **找到改进生产中模型的方法**: 通过检测最终用户与软件开发工具包（SDK）的交互，找到改进生产中模型的方法。

7. **微调所有主要模型提供商的自定义模型**: 通过微调各种主要模型提供商的自定义模型，优化模型的成本、延迟和性能。

8. **添加对生产数据的更正**: 在生产环境中，可以轻松添加对实际生产数据的更正，以提高模型的准确性。

9. **被动收集高质量数据集**: 通过被动地收集高质量数据集，用于进一步的微调和模型蒸馏（distillation）。

### [Stack AI](https://www.stack-ai.com/)

是一种无代码工具，允许使用 ChatGPT 等模型设计、测试和部署 AI 工作流程，设计并测试工作流程后，可以一键将其部署为 API，此外还可以优化提示、收集数据并微调 LLM 工作流程，已经有付费企业用户在使用了。

- 聊天机器人和助手：使用内部数据和 API 与用户交互、回答问题并完成任务。
- 文档处理：从任何文档中提取见解、提供摘要并回答问题，无论其长度如何。
- 回答有关数据库的问题：将 ChatGPT 等模型连接到 Notion、Airtable 或 Postgres 等数据库，以获得有关您的组织的宝贵见解。
- 内容创建：生成标签、摘要，并在文档和数据源之间无缝传输样式或格式。
