本电子书开源，欢迎 star 🌟，关注《LLM 应用开发实践笔记》

我的新书[《LangChain编程从入门到实践》](https://u.jd.com/V8pkqFY) 已经开售！推荐正在学习AI应用开发的朋友购买阅读！
[![LangChain编程从入门到实践](../../images/langchain-book.jpg "LangChain编程从入门到实践")](https://u.jd.com/V8pkqFY) ![](../images/group.png)

## Model 模型层

大模型服务层分为具备提供大模型能力的 **LLM-as-a-Service 服务**，比如OpenAI；以及为训练、部署、微调开源大模型等环节提供专有解决方案的 **Custom LLM stack 服务**，比如 Replicate。

### LLM 即服务

LLM 即服务是指供应商在其基础设施上将 LLM 作为 API 提供，这主要是闭源模型的交付方式。

- [Anthropic](https://www.anthropic.com/research)：Anthropic是由OpenAI的前成员创立的专注人工智能安全和研究的初创公司，并秉承负责任的AI使用理念，Claude 聊天机器人背后的研发公司。
- [Cohere](https://txt.cohere.com/)
- [OpenAI](https://openai.com/blog)
- [Inflection AI](https://inflection.ai/)：Pi 所在的公司

### 定制 LLM 服务

定制 LLM 服务是一个更广泛的工具类别，用于微调和部署基于开源模型构建的专有解决方案。

#### Deployment 部署推理

- [Replicate](https://replicate.com/blog)：一个开源AI模型托管云平台，其核心产品理念是，所有开源AI模型都应该能在一个地方找到，并且易于使用。开发者应该能在没有任何机器学习工作、托管设置的情况下，立即启动并运行大语言模型。将几个模型组合成一个管道应该很容易。并且，当应用程序规模扩大时，开发者应该能够使用简单的工具进行微调并托管自己的模型。
- [MosaicML](https://www.mosaicml.com/blog)：一家AI服务提供商，聚焦于企业端的需求，其提供了一个平台，让各个企业都能够在安全环境中训练和部署AI模型，并且帮助企业降低AI系统的开销。MosaicML的产品组合主要包括开源的、商业授权的MPT Foundation系列模型和MosaicML 推理和训练服务，为企业提供了一系列的工具。
- [OctoML](https://octoml.ai/blog/)
- [Amazon SageMaker](https://aws.amazon.com/cn/blogs/machine-learning/tag/amazon-sagemaker/)：

#### Experiment Tracking 实验追踪

- [WandB](https://wandb.ai/fully-connected): 一家机器学习性能可视化工具开发商，面向面向机器学习从业人员提供机器学习性能可视化工具。
- [neptune.ai](https://neptune.ai/blog)：一个实验管理工具，它可以实现多人合作管理实验，追踪团队中每个人的实验，同时也可以对实验结果进行标记、过滤、分组、排序和比较等功能
- [comet](https://www.comet.com/site/resources/)：

#### Orchestration 训练编排

- [Abacus.AI](https://abacus.ai/)：提供了一个端到端的自主平台，用于训练自定义深度学习模型并进行部署。
- [Valohai](https://valohai.com/blog/)：一家芬兰机器学习解决方案提供商，可为大型机器学习解决方案的公司实现自动化训练和部署基础架构，平台使数据科学家能够对其数据应用特征提取，快速迭代实验，通过并行培训进行超参数优化，并将模型可靠地部署到生产环境中。
- [Amazon SageMaker](https://aws.amazon.com/cn/blogs/machine-learning/tag/amazon-sagemaker/)：
- MLflow
- [Modal](https://modal.com/blog)：End-to-end cloud compute.
- [ModelZ](https://modelz.ai/)：deploy your AI Application second
- [BentoML](https://www.bentoml.com/)：Build, Ship, Scale AI Applications

#### Data Management 数据管理

- [activeloop](https://www.activeloop.ai/resources/)：Deep Lake是一个多模态的向量存储库，存储嵌入和它们的元数据，包括文本、json、图像、音频、视频等。它会在本地、您的云存储或Activeloop storage上保存数据。 它能执行包括嵌入和它们的属性的混合搜索。
