本电子书开源，欢迎 star 🌟，关注《LLM 应用开发实践笔记》

> 我的新书[《LangChain编程从入门到实践》](https://u.jd.com/V8pkqFY) 已经开售！推荐正在学习AI应用开发的朋友购买阅读！
![](../images/group.png)
 [![LangChain编程从入门到实践](../../images/langchain-book.jpg "LangChain编程从入门到实践")](https://u.jd.com/V8pkqFY)

## transformers 库基础组件


### Pipline 组件

#### pipeline的定义和组成

- 流水线是将数据预处理、模型调用和模型结果后处理组装成一个流水线。
- 流水线简化了推理代码，让用户能够直接输入文本并得到最终结果。
- 流水线的工作包括tokenization、输入转换、模型预测、soft max和标签映射等。
- 可以通过调用流水线来完成不同模型的推理，无需关注细节，流水线支持多种任务类型。

#### pipeline支持的任务类型

```
from transformers.pipelines import SUPPORTED_TASKS, get_supported_tasks

print(SUPPORTED_TASKS.items(), get_supported_tasks())
```

![image-20230827212802627](https://s2.loli.net/2023/08/27/bRksWOhtHNEmBof.png)

#### pipeline的创建和使用方式

1. 根据任务类型直接创建Pipeline, 默认都是英文的模型

```
from transformers import pipeline

pipe = pipeline("text-classification")
pipe("very good!")
# [{'label': 'POSITIVE', 'score': 0.9998525381088257}]
```

2. 指定任务类型，再指定模型，创建基于指定模型的Pipeline

```
from transformers import pipeline

# https://huggingface.co/models
pipe = pipeline("text-classification", 
                model="uer/roberta-base-finetuned-dianping-chinese")
pipe("我觉得不太行！")
# [{'label': 'negative (stars 1, 2 and 3)', 'score': 0.9735506772994995}]
```

3. 预先加载模型，再创建Pipeline

```
from transformers import AutoModelForSequenceClassification, AutoTokenizer, pipeline

model = AutoModelForSequenceClassification.from_pretrained("uer/roberta-base-finetuned-dianping-chinese")
tokenizer = AutoTokenizer.from_pretrained("uer/roberta-base-finetuned-dianping-chinese")

pipe = pipeline("text-classification", model=model, tokenizer=tokenizer)
pipe("你真是个人才！")
# [{'label': 'positive (stars 4 and 5)', 'score': 0.8717765808105469}]
```

4. GPU推理加速

```
pipe = pipeline("text-classification", model="uer/roberta-base-finetuned-dianping-chinese", device=0)
pipe.model.device
# device(type='cuda', index=0)
```

#### pipeline的实现原理

1. 初始化Tokenizer：  `tokenizer = AutoTokenizer.from_pretrained("uer/roberta-base-finetuned-dianping-chinese")`
2. 初始化Model： `model = AutoModelForSequenceClassification.from_pretrained("uer/roberta-base-finetuned-dianping-chinese")`

3. 数据预处理：

   ```
   input_text ="我觉得不太行！"
   inputs = tokenizer(input_text, return_ tensors="pt")
   ```

4. 模型预测：`res = model(**inputs).logits`

5. 结果后处理

   ```
   pred = torch.argmax(torch.softmax(logits, dim=-1)).item()
   result = model.config.id2label.get(pred)
   ```

### [Hugging Face 的 Transformers 库快速入门](https://xiaosheng.blog/archive?tag=Transformers)