本电子书开源，欢迎 star 🌟，关注《LLM 应用开发实践笔记》

我的新书[《LangChain编程从入门到实践》](https://u.jd.com/V8pkqFY) 已经开售！推荐正在学习AI应用开发的朋友购买阅读！
[![LangChain编程从入门到实践](../../images/langchain-book.jpg "LangChain编程从入门到实践")](https://u.jd.com/V8pkqFY) ![](../images/group.png)

## 你好, ChatGPT

ChatGPT 是OpenAI开发的人工智能聊天机器人程序，于2022年11月推出。该程序使用基于 GPT-3.5、GPT-4 架构的大语言模型并以强化学习训练。ChatGPT目前仍以文字方式交互，而除了可以用人类自然对话方式来交互，还可以用于甚为复杂的语言工作，包括自动生成文本、自动问答、自动摘要等多种任务。


### ChatGPT的诞生
#### 演进过程
1. 在 **2020 年 7 月**，OpenAI 发布了模型名称为的 `davinci` 的初代 GPT-3
2. 在 **2021 年 7 月**，Codex 的论文发布，其中初始的 Codex 是根据 120 亿参数的 GPT-3 变体进行微调的。后来这个 120 亿参数的模型演变成 OpenAI API 中的`code-cushman-001`
3. 在 **2022 年 3 月**，OpenAI 发布了指令微调 (instruction tuning) 的论文，其监督微调 (supervised instruction tuning) 的部分对应了`davinci-instruct-beta`和`text-davinci-001`
4. 在 **2022 年 4 月至 7 月的**，OpenAI 开始对`code-davinci-002`模型进行 Beta 测试，也称其为 Codex

5. `text-davinci-002`、`text-davinci-003`和`ChatGPT` 都是从`code-davinci-002`进行指令微调得到的。详细信息请参阅[OpenAI的模型索引文档](https://platform.openai.com/docs/model-index-for-researchers)
6. **2022 年 5-6 月**发布的`text-davinci-002`是一个基于`code-davinci-002`的有监督指令微调 (supervised instruction tuned) 模型。在`text-davinci-002`上面进行**指令微调**很可能降低了模型的上下文学习能力，但是增强了模型的零样本能力。
7. `text-davinci-003`和 `ChatGPT`，它们都在 **2022 年 11 月**发布，是使用的基于人类反馈的强化学习的版本指令微调 (instruction tuning with reinforcement learning from human feedback) 模型的两种不同变体。`text-davinci-003` 恢复了（但仍然比`code-davinci-002`差）一些在`text-davinci-002` 中丢失的部分上下文学习能力，并进一步改进了零样本能力（得益于RLHF）。另一方面，ChatGPT 似乎牺牲了几乎所有的上下文学习的能力来换取建模对话历史的能力。

![](https://yaofu.notion.site/image/https%3A%2F%2Fs3-us-west-2.amazonaws.com%2Fsecure.notion-static.com%2Fb9f99cde-06ab-473c-b67d-f08447a7f3ce%2FUntitled.png?id=a2e435ee-1709-4b3c-ab8c-ac16261ff848&table=block&spaceId=281b3c78-d734-43fb-aa33-707babff9463&width=1340&userId=&cache=v2)

#### 总结
- 语言生成能力 + 基础世界知识 + 上下文学习都是来自于预训练（`davinci`）
- 存储大量知识的能力来自 1750 亿的参数量
- 遵循指令和泛化到新任务的能力来自于扩大指令学习中指令的数量（`davinci-instruct-beta`）
- 执行复杂推理的能力很可能来自于代码训练（`code-davinci-002`）
- 生成中立、客观的能力、安全和翔实的答案来自与人类的对齐。具体来说：
  - 如果是监督学习版，得到的模型是`text-davinci-002`
  - 如果是强化学习版 (RLHF) ，得到的模型是`text-davinci-003`
  - 无论是有监督还是 RLHF ，模型在很多任务的性能都无法超过 code-davinci-002 ，这种因为对齐而造成性能衰退的现象叫做对齐税。
- 对话能力也来自于 RLHF（`ChatGPT`），具体来说它牺牲了上下文学习的能力，来换取：
  - 建模对话历史
  - 增加对话信息量
  - 拒绝模型知识范围之外的问题

### 训练
训练有四个主要阶段：预训练、有监督微调、奖励建模、强化学习

#### Pretraining 预训练
1. 数据收集：CommonCrawl，C4也是common crawl，然后还有一些高质量的数据集，例如GitHub、维基百科、书籍、ArXiv论文存档、StackExchange问答网站等，这些都混合在一起，然后根据给定的比例进行采样。
2. 标记化（tokenization）：标记化是文本片段和标记与整数之间的一种无损转换，是将互联网上抓取的原始文本翻译成整数序列。
![](https://i0.hdslb.com/bfs/note/8d0fa5a1778ea893aac0a66a3efb12d696ebbd68.png@!web-comment-note.avif)
3. [训练过程，可以查观看这个视频进行了解](https://www.bilibili.com/video/BV1ts4y1T7UH/?share_source=copy_web&vd_source=0b5a0297824b7741bbe169c01f734989&t=353)

#### Supervised Finetuning 监督微调
- 假设已经有了一个非常聪明的学生（即GPT-3模型），他已经学会了很多知识，并且可以在各种不同的主题上写文章。但是想让他专注于某个特定的主题，并且写出更好的文章。这就需要使用监督微调技术来让他集中精力并提高他在这个特定主题上的表现。
- 可以使用一个新的数据集来让这个学生熟悉这个领域的特定要求。例如为他提供一些示例文章，这些文章符合这个领域的要求，并让他通过学习这些文章来了解这个领域的特点和要求。这就像在学习一门新的科目时，我们需要先了解这门科目的基本概念和原理，然后通过实践来巩固这些知识。
- 一旦这位学生掌握了这个领域的基础知识，就可以开始进行实践并进行监督微调。可以让他写一些文章，并根据这些文章的质量来指导他的学习和进一步的改进。这就像在学习一门新的科目时，需要不断地进行实践和练习，以巩固我们的知识并提高我们的技能水平。最终，通过不断的实践和练习，这位学生将能够在这个特定的领域中表现出色，并写出符合要求的文章。

#### Reward Modeling 奖励建模
- 将奖励建模类比为让聪明的学生（即GPT-3模型）学习一门新的技能，例如学习打篮球。在学习打篮球的过程中，可以将得分作为奖励信号，以评估学生的表现。首先需要告诉学生如何打篮球，例如传球、投篮、防守等基本技能。这就像在奖励建模中，我们需要提供一些示例，以便模型可以了解任务的要求。
- 然后可以让学生在训练场上进行练习，并根据他们的表现来给予奖励。例如，如果学生成功投篮得分，我们可以给予他们一定的奖励分数。这就像在奖励建模中，可以根据模型的表现来生成奖励信号。如果模型成功完成任务，例如正确地回答问题或生成准确的文本，可以给予它一定的奖励分数。
- 通过不断的练习和奖励，学生将学会如何打篮球，并且在比赛中表现出色。同样地，通过奖励建模技术，我们可以训练GPT-3模型在特定任务中表现出色，并生成符合要求的文本。通过最大化奖励信号，模型可以学习如何有效地完成任务，并不断改进自己的表现。

#### Reinforcement Learning 强化学习
- 奖励建模的例子中，将奖励信号定义为每次得分的分数。如果聪明的学生成功地将篮球投入篮筐，给予它一定数量的分数；如果它没有得分，那么不给予它分数。在奖励建模中，可以使用这些分数作为奖励信号，来训练模型。我们的目标是最大化总得分，因为总得分是我们想要优化的目标函数。
- 强化学习中需要定义状态空间、行动空间和奖励函数，以让聪明的学生了解任务的要求。状态空间可以包括学生的位置、篮球的位置和篮筐的位置等信息，行动空间可以包括传球、投篮、防守等动作，奖励函数可以根据得分、失误、防守成功等情况来定义。然后让聪明的学生与环境交互，并根据当前状态和策略采取行动，并从环境中获得奖励或惩罚信号，聪明的学生可以不断更新策略，以最大化长期奖励，即总得分。
- 奖励建模使用奖励信号来指导模型的优化方向，而强化学习使用奖励信号来指导模型的行动选择。

### 特点
1. 作为辅助工具，并与人工监督结合起来，在不注重可靠性和安全性的应用程序中使用
2. 可以编写和调试计算机程序
3. 具备创作音乐、电视剧、童话故事和学生论文的能力
4. ChatGPT 能够记住与用户之前的对话内容和给它的提示
5. 可以回答测试问题（在某些测试情境下，水平甚至高于普通人类测试者）
6. ChatGPT 输入内容会由审核API过滤，以减少生成冒犯言论

### 局限
1. [人工智能幻觉](https://zh.wikipedia.org/zh-sg/%E5%B9%BB%E8%A7%89_%E4%BA%BA%E5%B7%A5%E6%99%BA%E8%83%BD) ：有时会写出看似合理但不正确或荒谬的答案
2. [古德哈特定律](https://zh.wikipedia.org/zh-sg/%E5%8F%A4%E5%BE%B7%E5%93%88%E7%89%B9%E5%AE%9A%E5%BE%8B)：奖励模型围绕人类监督而设计，可能导致过度优化，从而影响性能
3. 意识形态偏见：研究表明，ChatGPT对两个投票建议应用程序的政治声明表明立场时，表现出亲环境主义。

### 参考链接
1. [对GPT系列模型能力的溯源](https://yaofu.notion.site/How-does-GPT-Obtain-its-Ability-Tracing-Emergent-Abilities-of-Language-Models-to-their-Sources-b9a57ac0fcf74f30a1ab9e3e36fa1dc1)：详细分析OpenAI各个模型的演进关系，对理解OpenAI中各个模型API能力及ChatGPT发展历史很有帮助
2. [State of GPT](https://build.microsoft.com/en-US/sessions/db3f4859-cd30-4445-a0cd-553c3304f8e2)：大神Andrej揭秘OpenAI大模型原理和训练过程
3. [ChatGPT](https://zh.wikipedia.org/zh-sg/ChatGPT#cite_note-CNNInfo-29)：维基百科ChatGPT词条
