本电子书开源，欢迎 star 🌟，关注《LLM 应用开发实践笔记》

我的新书[《LangChain编程从入门到实践》](https://u.jd.com/V8pkqFY) 已经开售！推荐正在学习AI应用开发的朋友购买阅读！
[![LangChain编程从入门到实践](../../images/langchain-book.jpg "LangChain编程从入门到实践")](https://u.jd.com/V8pkqFY) ![](../images/group.png)

## 大语言模型概况

### 定义
（个人理解的）大语言模型（Large Language Model）是一种基于深度学习技术的自然语言处理通用模型，它可以通过学习大规模文本数据的模式和规律，从而实现对自然语言的理解和生成。`通用型`：在广泛的任务中表现出色，而不是针对一项特定任务，`规模大`：参数数量在数十亿或更多数量级的深度学习模型。

> 🤖️ 大模型在 NLP 任务中的出色表现确实为人工智能领域带来了新的发展和探索方向。语言作为思想的符号，是人类交流和表达的主要方式，因此理解和生成自然语言是通往通用人工智能（AGI）之路的一个重要方向。大模型的出现和不断优化，使得计算机能够更好地理解自然语言的含义和上下文，进而提供更准确、更自然的语言交互和信息处理。然而，要实现真正的通用人工智能，还需要解决许多挑战和问题，例如：如何将机器学习模型从“短期记忆”转变为“长期记忆”，如何让机器具备更深入的理解和推理能力，以及如何解决数据隐私和安全等问题。

### 关键概念说明
- **Transformer 架构**：Transformer 是 Google 于 2017 年提出的一种全新的神经网络架构，主要用于自然语言处理。它抛弃了 RNN 和 CNN，而是引入了注意力机制，实现 Encoder-Decoder 架构。Transformer 结构清晰，计算效率高，并可以进行并行计算，这使其在 NLP 任务上表现优异。

- **编码器模型**：Encoder 用于理解输入的句子表达，输出向量表示输入句子的特征信息，例如`输入“I love NLP”，输出[0.1, 0.2, 0.3, 0.4]`。

- **解码器模型**：Decoder 则基于 Encoder 的输出以及自身的上下文信息生成输出句子。例如`输入[0.1, 0.2, 0.3, 0.4]，输出”I love machine learning“`。编码器和解码器通过注意力机制交互。

- **注意力机制**：下面的例子演示了编码器和解码器通过注意力机制的交互过程，在这个过程中，编码器输出一次编码向量，代表输入句子信息。解码器每生成一个词，就会查询一次编码器的输出。并生成注意力分布，指出当前最重要的编码器输出内容。解码器结合注意力信息和自己的上下文，产生新的预测词。解码器每预测一个词，就将其加入到上下文，用于生成下个词。这个动态查询-生成的过程，就是编码器和解码器通过注意力机制进行交互。
    ```
    输入句子：I love NLP。

    编码器：
    输入：I love NLP。
    输出：向量[0.1, 0.2, 0.3, 0.4] 表示输入句子的特征信息。

    解码器：
    输入：[0.1, 0.2, 0.3, 0.4]  
    输出：I 
    (此时解码器只生成了第一个词 I，将其作为上下文信息。)

    注意力：解码器的注意力机制会查询编码器的输出[0.1, 0.2, 0.3, 0.4]，并生成注意力分布[0.6, 0.2, 0.1, 0.1]，表示解码器当前更关注编码器第1个输出元素。

    解码器:
    输入：[0.1, 0.2, 0.3, 0.4]，[0.6, 0.2, 0.1, 0.1]  
    上下文：I
    输出：love  
    (解码器利用注意力分布所强调的编码器输出信息，以及自己的上下文I，生成love为当前最佳输出。)
    .....
    解码器最终生成：I love machine learning。
    ```
- **自回归模型**：Transformer 的 Decoder 需要每步生成一个词元，并将当前生成的词元信息加入到上下文中，用于生成下一个词元，例如模型`输入“I love”，输出“I love NLP”，然后基于“I love NLP”生成“I love natural language processing”`，每一步都基于前面生成的内容生成新的输出，这一生成策略被称为自回归(Auto-regressive)。典型的 autoregressive 模型有 GPT-2、GPT-3 等。

- **掩码模型**：掩码语言模型(MLM)需要对输入文本中的一些词元进行掩码，然后训练模型基于上下文来预测被掩码的词元，例如`输入句子“I love [MASK] learning”，输出“I love machine learning”`，模型需要填充[MASK]来预测掩码词，实现对上下文的理解。BERT 就是一种典型的掩码语言模型。

### 👏发展
大语言模型进化树追溯了 LLM 的发展历程，重点统计了相对知名的模型，同一分支上的模型关系更近。不基于 Transformer 的模型用灰色表示，decoder-only模型是蓝色分支，encoder-only模型是粉色分支，encoder-decoder模型是绿色分支。模型在时间轴的竖直位置表示其发布时间。实心方块表示开源模型，空心方块则是闭源模型。右下角的堆积条形图是指各家公司和机构的模型数量。

![大语言模型进化树](https://raw.githubusercontent.com/Mooler0410/LLMsPracticalGuide/main/imgs/qr_version.jpg)

#### encoder-only 模型
掩码语言模型是一种常用的训练方法，它基于上下文来预测句子中被遮掩的词，使得模型能够更深刻地理解词与其上下文之间的关系。这些模型使用 Transformer 架构等技术在大型文本语料上训练，并在许多 NLP 任务中取得了最佳表现，如情感分析和命名实体识别。著名的掩码语言模型有 BERT、RoBERTa 和 T5。由于其在多种任务上的成功表现，掩码语言模型已成为自然语言处理领域的一种重要工具，但这些方法需要基于具体下游任务的数据集进行微调。在 LLM 的早期发展阶段，BERT 为仅编码器模型带来了初始的爆发式增长。（BERT主要用于自然语言**理解任务**：双向预训练语言模型+fine-tuning（微调））

#### decoder-only 模型
扩增语言模型的规模就能显著提升其在少样本或零样本时的表现，最成功的模型是自回归语言模型，它的训练方式是根据给定序列中前面的词来生成下一个词。这些模型已被广泛用于文本生成和问答等下游任务。自回归语言模型包括 GPT-3、PaLM 和 BLOOM。变革性的 GPT-3 首次表明通过提示和上下文学习能在少 / 零样本时给出合理结果，并由此展现了自回归语言模型的优越性。另外还有针对具体任务优化的模型，比如用于代码生成的 CodeX 以及用于金融领域的 BloombergGPT。在 2021 年GPT-3 的出现之后，仅解码器模型经历了爆发式的发展，仅编码器模型却渐渐淡出了视野。（GPT主要用于自然语言**生成任务**：自回归预训练语言模型+Prompting（指示/提示））

### 适用方向
* 自然语言理解：当实际数据不在训练数据的分布范围内或训练数据非常少时，可利用 LLM 那出色的泛化能力。 
* 自然语言生成：使用 LLM 的能力为各种应用创造连贯的、上下文相关的和高质量的文本。 
* 知识密集型任务：利用 LLM 中存储的广博知识来处理需要特定专业知识或一般性世界知识的任务。 
* 推理能力：理解和利用 LLM 的推理能力来提升各种情形中制定决策和解决问题的能力。

### 参考链接
1. [大语言模型发展历程](https://briefgpt.xyz/lm)：通过时间线的方式展示大模型的发布情况，从最初的GPT1到最新的PaLM2，非常清晰，而且是实时更新的
2. [大型语言模型的实用指南](https://github.com/Mooler0410/LLMsPracticalGuide)：如果想了解在自己的业务中使用大语言模型，这里是一些最佳实践

