/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.gui.Console;
import bitronix.tm.journal.TransactionLogHeader;
import bitronix.tm.utils.Decoder;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogHeaderPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogHeaderPanel.class);
    private final JTextField logFileField = new JTextField();
    private final JTextField timestampField = new JTextField();
    private final JTextField stateField = new JTextField();
    private final JTextField positionField = new JTextField();

    public TransactionLogHeaderPanel() {
        this.logFileField.setEditable(false);
        this.timestampField.setEditable(false);
        this.stateField.setEditable(false);
        this.positionField.setEditable(false);
        this.logFileField.setBorder(null);
        this.timestampField.setBorder(null);
        this.stateField.setBorder(null);
        this.positionField.setBorder(null);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.logFileField);
        this.add(this.timestampField);
        this.add(this.stateField);
        this.add(this.positionField);
    }

    public void setLogFile(File logFile) {
        this.logFileField.setText(logFile.getName());
    }

    public void setTimestamp(long timestamp) {
        this.timestampField.setText(Console.dateFormatter.format(new Date(timestamp)));
    }

    public void setState(byte state) {
        this.stateField.setText(Decoder.decodeHeaderState(state));
    }

    public void setPosition(long position) {
        this.positionField.setText("" + position);
    }

    public void read(File logFile, boolean active) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(logFile, "r");
        TransactionLogHeader header = new TransactionLogHeader(raf.getChannel(), 0L);
        raf.close();
        if (log.isDebugEnabled()) {
            log.debug("read header: " + header);
        }
        this.setLogFile(logFile);
        this.setTimestamp(header.getTimestamp());
        this.setState(header.getState());
        this.setPosition(header.getPosition());
        Font font = active ? this.logFileField.getFont().deriveFont(1) : this.logFileField.getFont().deriveFont(0);
        this.logFileField.setFont(font);
        this.timestampField.setFont(font);
        this.stateField.setFont(font);
        this.positionField.setFont(font);
    }
}

