/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.utils.ClassLoaderUtils;
import bitronix.tm.utils.InitializationException;
import bitronix.tm.utils.PropertyException;
import bitronix.tm.utils.PropertyUtils;
import bitronix.tm.utils.Service;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements Service {
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    private static final int MAX_SERVER_ID_LENGTH = 51;
    private static final Charset SERVER_ID_CHARSET = Charset.forName("US-ASCII");
    private volatile String serverId;
    private final AtomicReference<byte[]> serverIdArray = new AtomicReference();
    private volatile String logPart1Filename;
    private volatile String logPart2Filename;
    private volatile boolean forcedWriteEnabled;
    private volatile boolean forceBatchingEnabled;
    private volatile int maxLogSizeInMb;
    private volatile boolean filterLogStatus;
    private volatile boolean skipCorruptedLogs;
    private volatile boolean asynchronous2Pc;
    private volatile boolean warnAboutZeroResourceTransaction;
    private volatile boolean debugZeroResourceTransaction;
    private volatile int defaultTransactionTimeout;
    private volatile int gracefulShutdownInterval;
    private volatile int backgroundRecoveryIntervalSeconds;
    private volatile boolean disableJmx;
    private volatile boolean synchronousJmxRegistration;
    private volatile String jndiUserTransactionName;
    private volatile String jndiTransactionSynchronizationRegistryName;
    private volatile String journal;
    private volatile String exceptionAnalyzer;
    private volatile boolean currentNodeOnlyRecovery;
    private volatile boolean allowMultipleLrc;
    private volatile String resourceConfigurationFilename;
    private volatile boolean conservativeJournaling;
    private volatile String jdbcProxyFactoryClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configuration() {
        try {
            Properties properties;
            InputStream in = null;
            try {
                String configurationFilename = System.getProperty("bitronix.tm.configuration");
                if (configurationFilename != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("loading configuration file " + configurationFilename);
                    }
                    in = new FileInputStream(configurationFilename);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("loading default configuration");
                    }
                    in = ClassLoaderUtils.getResourceAsStream("bitronix-default-config.properties");
                }
                properties = new Properties();
                if (in != null) {
                    properties.load(in);
                } else if (log.isDebugEnabled()) {
                    log.debug("no configuration file found, using default settings");
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.serverId = Configuration.getString(properties, "bitronix.tm.serverId", null);
            this.logPart1Filename = Configuration.getString(properties, "bitronix.tm.journal.disk.logPart1Filename", "btm1.tlog");
            this.logPart2Filename = Configuration.getString(properties, "bitronix.tm.journal.disk.logPart2Filename", "btm2.tlog");
            this.forcedWriteEnabled = Configuration.getBoolean(properties, "bitronix.tm.journal.disk.forcedWriteEnabled", true);
            this.forceBatchingEnabled = Configuration.getBoolean(properties, "bitronix.tm.journal.disk.forceBatchingEnabled", true);
            this.maxLogSizeInMb = Configuration.getInt(properties, "bitronix.tm.journal.disk.maxLogSize", 2);
            this.filterLogStatus = Configuration.getBoolean(properties, "bitronix.tm.journal.disk.filterLogStatus", false);
            this.skipCorruptedLogs = Configuration.getBoolean(properties, "bitronix.tm.journal.disk.skipCorruptedLogs", false);
            this.asynchronous2Pc = Configuration.getBoolean(properties, "bitronix.tm.2pc.async", false);
            this.warnAboutZeroResourceTransaction = Configuration.getBoolean(properties, "bitronix.tm.2pc.warnAboutZeroResourceTransactions", true);
            this.debugZeroResourceTransaction = Configuration.getBoolean(properties, "bitronix.tm.2pc.debugZeroResourceTransactions", false);
            this.defaultTransactionTimeout = Configuration.getInt(properties, "bitronix.tm.timer.defaultTransactionTimeout", 60);
            this.gracefulShutdownInterval = Configuration.getInt(properties, "bitronix.tm.timer.gracefulShutdownInterval", 60);
            this.backgroundRecoveryIntervalSeconds = Configuration.getInt(properties, "bitronix.tm.timer.backgroundRecoveryIntervalSeconds", 60);
            this.disableJmx = Configuration.getBoolean(properties, "bitronix.tm.disableJmx", false);
            this.synchronousJmxRegistration = Configuration.getBoolean(properties, "bitronix.tm.jmx.sync", false);
            this.jndiUserTransactionName = Configuration.getString(properties, "bitronix.tm.jndi.userTransactionName", "java:comp/UserTransaction");
            this.jndiTransactionSynchronizationRegistryName = Configuration.getString(properties, "bitronix.tm.jndi.transactionSynchronizationRegistryName", "java:comp/TransactionSynchronizationRegistry");
            this.journal = Configuration.getString(properties, "bitronix.tm.journal", "disk");
            this.exceptionAnalyzer = Configuration.getString(properties, "bitronix.tm.exceptionAnalyzer", null);
            this.currentNodeOnlyRecovery = Configuration.getBoolean(properties, "bitronix.tm.currentNodeOnlyRecovery", true);
            this.allowMultipleLrc = Configuration.getBoolean(properties, "bitronix.tm.allowMultipleLrc", false);
            this.resourceConfigurationFilename = Configuration.getString(properties, "bitronix.tm.resource.configuration", null);
            this.conservativeJournaling = Configuration.getBoolean(properties, "bitronix.tm.conservativeJournaling", false);
            this.jdbcProxyFactoryClass = Configuration.getString(properties, "bitronix.tm.jdbcProxyFactoryClass", "auto");
        }
        catch (IOException ex) {
            throw new InitializationException("error loading configuration", ex);
        }
    }

    public String getServerId() {
        return this.serverId;
    }

    public Configuration setServerId(String serverId) {
        this.checkNotStarted();
        this.serverId = serverId;
        return this;
    }

    public String getLogPart1Filename() {
        return this.logPart1Filename;
    }

    public Configuration setLogPart1Filename(String logPart1Filename) {
        this.checkNotStarted();
        this.logPart1Filename = logPart1Filename;
        return this;
    }

    public String getLogPart2Filename() {
        return this.logPart2Filename;
    }

    public Configuration setLogPart2Filename(String logPart2Filename) {
        this.checkNotStarted();
        this.logPart2Filename = logPart2Filename;
        return this;
    }

    public boolean isForcedWriteEnabled() {
        return this.forcedWriteEnabled;
    }

    public Configuration setForcedWriteEnabled(boolean forcedWriteEnabled) {
        this.checkNotStarted();
        this.forcedWriteEnabled = forcedWriteEnabled;
        return this;
    }

    public boolean isForceBatchingEnabled() {
        return this.forceBatchingEnabled;
    }

    public Configuration setForceBatchingEnabled(boolean forceBatchingEnabled) {
        this.checkNotStarted();
        log.warn("forceBatchingEnabled is not longer used");
        this.forceBatchingEnabled = forceBatchingEnabled;
        return this;
    }

    public int getMaxLogSizeInMb() {
        return this.maxLogSizeInMb;
    }

    public Configuration setMaxLogSizeInMb(int maxLogSizeInMb) {
        this.checkNotStarted();
        this.maxLogSizeInMb = maxLogSizeInMb;
        return this;
    }

    public boolean isFilterLogStatus() {
        return this.filterLogStatus;
    }

    public Configuration setFilterLogStatus(boolean filterLogStatus) {
        this.checkNotStarted();
        this.filterLogStatus = filterLogStatus;
        return this;
    }

    public boolean isSkipCorruptedLogs() {
        return this.skipCorruptedLogs;
    }

    public Configuration setSkipCorruptedLogs(boolean skipCorruptedLogs) {
        this.checkNotStarted();
        this.skipCorruptedLogs = skipCorruptedLogs;
        return this;
    }

    public boolean isAsynchronous2Pc() {
        return this.asynchronous2Pc;
    }

    public Configuration setAsynchronous2Pc(boolean asynchronous2Pc) {
        this.checkNotStarted();
        this.asynchronous2Pc = asynchronous2Pc;
        return this;
    }

    public boolean isWarnAboutZeroResourceTransaction() {
        return this.warnAboutZeroResourceTransaction;
    }

    public Configuration setWarnAboutZeroResourceTransaction(boolean warnAboutZeroResourceTransaction) {
        this.checkNotStarted();
        this.warnAboutZeroResourceTransaction = warnAboutZeroResourceTransaction;
        return this;
    }

    public boolean isDebugZeroResourceTransaction() {
        return this.debugZeroResourceTransaction;
    }

    public Configuration setDebugZeroResourceTransaction(boolean debugZeroResourceTransaction) {
        this.checkNotStarted();
        this.debugZeroResourceTransaction = debugZeroResourceTransaction;
        return this;
    }

    public int getDefaultTransactionTimeout() {
        return this.defaultTransactionTimeout;
    }

    public Configuration setDefaultTransactionTimeout(int defaultTransactionTimeout) {
        this.checkNotStarted();
        this.defaultTransactionTimeout = defaultTransactionTimeout;
        return this;
    }

    public int getGracefulShutdownInterval() {
        return this.gracefulShutdownInterval;
    }

    public Configuration setGracefulShutdownInterval(int gracefulShutdownInterval) {
        this.checkNotStarted();
        this.gracefulShutdownInterval = gracefulShutdownInterval;
        return this;
    }

    @Deprecated
    public int getBackgroundRecoveryInterval() {
        return this.getBackgroundRecoveryIntervalSeconds() / 60;
    }

    @Deprecated
    public Configuration setBackgroundRecoveryInterval(int backgroundRecoveryInterval) {
        log.warn("setBackgroundRecoveryInterval() is deprecated, consider using setBackgroundRecoveryIntervalSeconds() instead.");
        this.setBackgroundRecoveryIntervalSeconds(backgroundRecoveryInterval * 60);
        return this;
    }

    public int getBackgroundRecoveryIntervalSeconds() {
        return this.backgroundRecoveryIntervalSeconds;
    }

    public Configuration setBackgroundRecoveryIntervalSeconds(int backgroundRecoveryIntervalSeconds) {
        this.checkNotStarted();
        this.backgroundRecoveryIntervalSeconds = backgroundRecoveryIntervalSeconds;
        return this;
    }

    public boolean isDisableJmx() {
        return this.disableJmx;
    }

    public Configuration setDisableJmx(boolean disableJmx) {
        this.checkNotStarted();
        this.disableJmx = disableJmx;
        return this;
    }

    public boolean isSynchronousJmxRegistration() {
        return this.synchronousJmxRegistration;
    }

    public Configuration setSynchronousJmxRegistration(boolean synchronousJmxRegistration) {
        this.checkNotStarted();
        this.synchronousJmxRegistration = synchronousJmxRegistration;
        return this;
    }

    public String getJndiUserTransactionName() {
        return this.jndiUserTransactionName;
    }

    public Configuration setJndiUserTransactionName(String jndiUserTransactionName) {
        this.checkNotStarted();
        this.jndiUserTransactionName = jndiUserTransactionName;
        return this;
    }

    public String getJndiTransactionSynchronizationRegistryName() {
        return this.jndiTransactionSynchronizationRegistryName;
    }

    public Configuration setJndiTransactionSynchronizationRegistryName(String jndiTransactionSynchronizationRegistryName) {
        this.checkNotStarted();
        this.jndiTransactionSynchronizationRegistryName = jndiTransactionSynchronizationRegistryName;
        return this;
    }

    public String getJournal() {
        return this.journal;
    }

    public Configuration setJournal(String journal) {
        this.checkNotStarted();
        this.journal = journal;
        return this;
    }

    public String getExceptionAnalyzer() {
        return this.exceptionAnalyzer;
    }

    public Configuration setExceptionAnalyzer(String exceptionAnalyzer) {
        this.checkNotStarted();
        this.exceptionAnalyzer = exceptionAnalyzer;
        return this;
    }

    public boolean isCurrentNodeOnlyRecovery() {
        return this.currentNodeOnlyRecovery;
    }

    public Configuration setCurrentNodeOnlyRecovery(boolean currentNodeOnlyRecovery) {
        this.checkNotStarted();
        this.currentNodeOnlyRecovery = currentNodeOnlyRecovery;
        return this;
    }

    public boolean isAllowMultipleLrc() {
        return this.allowMultipleLrc;
    }

    public Configuration setAllowMultipleLrc(boolean allowMultipleLrc) {
        this.checkNotStarted();
        this.allowMultipleLrc = allowMultipleLrc;
        return this;
    }

    public boolean isConservativeJournaling() {
        return this.conservativeJournaling;
    }

    public Configuration setConservativeJournaling(boolean conservativeJournaling) {
        this.checkNotStarted();
        this.conservativeJournaling = conservativeJournaling;
        return this;
    }

    public String getJdbcProxyFactoryClass() {
        return this.jdbcProxyFactoryClass;
    }

    public void setJdbcProxyFactoryClass(String jdbcProxyFactoryClass) {
        this.jdbcProxyFactoryClass = jdbcProxyFactoryClass;
    }

    public String getResourceConfigurationFilename() {
        return this.resourceConfigurationFilename;
    }

    public Configuration setResourceConfigurationFilename(String resourceConfigurationFilename) {
        this.checkNotStarted();
        this.resourceConfigurationFilename = resourceConfigurationFilename;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] buildServerIdArray() {
        byte[] id = this.serverIdArray.get();
        if (id == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                while ((id = this.serverIdArray.get()) == null) {
                    try {
                        id = this.serverId.getBytes(SERVER_ID_CHARSET);
                        String transcodedId = new String(id, SERVER_ID_CHARSET);
                        if (!transcodedId.equals(this.serverId)) {
                            log.warn("The given server ID '" + this.serverId + "' is not compatible with the ID charset '" + SERVER_ID_CHARSET.displayName() + "' as it transcodes to '" + transcodedId + "'. It is highly recommended that you specify a compatible server ID using only characters that are allowed in the ID charset.");
                        }
                    }
                    catch (Exception ex) {
                        log.warn("Cannot get the unique server ID for this JVM ('bitronix.tm.serverId'). Make sure it is configured and you use only " + SERVER_ID_CHARSET.displayName() + " characters. Will use IP address instead (unsafe for production usage!).");
                        try {
                            id = InetAddress.getLocalHost().getHostAddress().getBytes(SERVER_ID_CHARSET);
                        }
                        catch (Exception ex2) {
                            String unknownServerId = "unknown-server-id";
                            log.warn("Cannot get the local IP address. Please verify your network configuration. Will use the constant 'unknown-server-id' as server ID (highly unsafe!).", (Throwable)ex2);
                            id = "unknown-server-id".getBytes();
                        }
                    }
                    if (id.length > 51) {
                        byte[] truncatedServerId = new byte[51];
                        System.arraycopy(id, 0, truncatedServerId, 0, 51);
                        log.warn("The applied server ID '" + new String(id) + "' has to be truncated to " + 51 + " chars (builtin hard limit) resulting in " + new String(truncatedServerId) + ". This may be highly unsafe if IDs differ with suffixes only!");
                        id = truncatedServerId;
                    }
                    if (!this.serverIdArray.compareAndSet(null, id)) continue;
                    String idAsString = new String(id, SERVER_ID_CHARSET);
                    if (this.serverId == null) {
                        this.serverId = idAsString;
                    }
                    log.info("JVM unique ID: <" + idAsString + "> - Using this server ID to ensure uniqueness of transaction IDs across the network.");
                }
            }
        }
        return id;
    }

    @Override
    public void shutdown() {
        this.serverIdArray.set(null);
    }

    public String toString() {
        StringBuilder sb;
        block2: {
            sb = new StringBuilder(512);
            sb.append("a Configuration with [");
            try {
                sb.append(PropertyUtils.propertiesToString(this));
            }
            catch (PropertyException ex) {
                sb.append("???");
                if (!log.isDebugEnabled()) break block2;
                log.debug("error accessing properties of Configuration object", (Throwable)ex);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private void checkNotStarted() {
        if (TransactionManagerServices.isTransactionManagerRunning()) {
            throw new IllegalStateException("cannot change the configuration while the transaction manager is running");
        }
    }

    static String getString(Properties properties, String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null && (value = properties.getProperty(key)) == null) {
            return defaultValue;
        }
        return Configuration.evaluate(properties, value);
    }

    static boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        return Boolean.valueOf(Configuration.getString(properties, key, "" + defaultValue));
    }

    static int getInt(Properties properties, String key, int defaultValue) {
        return Integer.parseInt(Configuration.getString(properties, key, "" + defaultValue));
    }

    private static String evaluate(Properties properties, String value) {
        String result = value;
        int startIndex = value.indexOf(36);
        if (startIndex > -1 && value.length() > startIndex + 1 && value.charAt(startIndex + 1) == '{') {
            int endIndex = value.indexOf(125);
            if (startIndex + 2 == endIndex) {
                throw new IllegalArgumentException("property ref cannot refer to an empty name: ${}");
            }
            if (endIndex == -1) {
                throw new IllegalArgumentException("unclosed property ref: ${" + value.substring(startIndex + 2));
            }
            String subPropertyKey = value.substring(startIndex + 2, endIndex);
            String subPropertyValue = Configuration.getString(properties, subPropertyKey, null);
            result = result.substring(0, startIndex) + subPropertyValue + result.substring(endIndex + 1);
            return Configuration.evaluate(properties, result);
        }
        return result;
    }
}

