# Product CRUD App

## Description

The Product CRUD App is a Spring MVC web application designed to help you efficiently manage product information. It stores data in the 'product_details' table and offers three main views: Home, Update, and Add.

### Home View
![Home View](https://i.ibb.co/yVQ5yLM/home.png)

*The Home view displays a list of products with attributes such as ID, Product Name, Description, Price, and Action. Users can perform update or delete operations on each product by clicking the corresponding buttons.*

### Add Product View
![Home View](https://i.ibb.co/3zbKz6z/Add.png)

*Clicking on the "Add Product" button in the Home view redirects the user to the Add Product page. This page allows users to input new product details and add them to the database.*

### Update Product View
![Home View](https://i.ibb.co/f0vXVJK/update.png)

*Clicking on the "Update" button in the Home view redirects the user to the Update Product page. Here, the product details are pre-filled, allowing the user to edit or update the information. Users can also go back to the Home page.*


## Installation

### Prerequisites
- Java
- IntelliJ IDEA
- Tomcat Server (version 9)
- Maven

### Steps
<ol>
    <li>Clone the repository.</li>
    <li>Open the project in IntelliJ IDEA.</li>
    <li>Configure Tomcat server (version 9) in IntelliJ IDEA.</li>
    <li>Build the project using Maven.</li>
</ol>

## Technologies Used
- Java
- Hibernate ORM
- Spring MVC
- HTML CSS
- Bootstrap
- JSP
- SQL
    
## Features
- C: Add new products.
- R: View a list of products with their details.
- U: Update existing products.
- D: Delete products.

## Usage
1. Launch the application on a Tomcat Server.
2. Navigate to the Home view to manage products.
3. Click on "Update" or "Delete" buttons to perform actions on products.
4. Use the "Add Product" button to add new products.

## Contributing
If you'd like to contribute to this project, please follow these steps:

1. Fork the repository.
2. Create a new branch for your feature or bug fix.
3. Make your changes and commit them with descriptive messages.
4. Push your changes to your fork.
5. Create a pull request.

## License
This project is licensed under the [MIT License](LICENSE).