if (typeof(MIDI) === 'undefined') var MIDI = {};
if (typeof(MIDI.Soundfont) === 'undefined') MIDI.Soundfont = {};

// all the other notes are fake

// use the instrument "gunshot" since that's what I told the code I would use
// there does not seem to be a way to map in new instruments in MIDI.js
//MIDI.Soundfont.mikes_gretsch_usa_custom_drums = {
MIDI.Soundfont.gunshot = {
/* 0  21 snare ghost*/  "A0": "data:audio/mp3;base64,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",
/* 1  22 snare accent*/ "Bb0" : "data:audio/mp3;base64,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",
/* 2  23*/ "B0": "",
/* 3  24*/ "C1": "",
/* 4  25*/ "Db1": "",
/* 5  26*/ "D1": "",
/* 6  27*/ "Eb1": "",
/* 7  28*/ "E1": "",
/* 8  29*/ "F1": "",
/* 9  30*/ "Gb1": "",
/* 10 31*/ "G1":  "",
/* 11 32*/ "Ab1":  "",
/* 12 33*/ "A1":  "",
/* 13 34*/ "Bb1":  "",
/* 14 35 kick        */ "B1": "data:audio/mp3;base64,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",
/* 15 36*/ "C2":  "",
/* 16 37 snare cross */ "Db2":  "data:audio/mp3;base64,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",
/* 17 38 snare normal*/ "D2":  "data:audio/mp3;base64,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",
/* 18 39*/ "Eb2": "",
/* 19 40*/ "E2":  "",
/* 20 41 Low Tom 2   */ "F2":  "",
/* 21 42 hh normal   */ "Gb2": "data:audio/mp3;base64,//uQxAAAAAAAAAAAAAAAAAAAAAAAWGluZwAAAA8AAAASAAARTAAhISEhIUJCQkJCQlZWVlZWZ2dnZ2dnd3d3d3eEhISEhISSkpKSkp+fn5+fn6ysrKysurq6urq6xcXFxcXF09PT09Pd3d3d3d3l5eXl5ezs7Ozs7PLy8vLy+fn5+fn5//////8AAAA8TEFNRTMuOTlyBa8AAAAALMYAADUgJAZmQQABzAAAEUxs0l5eAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//ugxAAACJjfYfQRACQ3Qqq/M5AAvMt4icqG7AAJwKYxzgBjGPIQmc76nf5CN+d6EI2n+Qn876EJkITOd0Oc9CEZQAAIynO5AMDOUBBwIHP/lz//6gQh+/hi2iZ+9vpxWg0h1gIAAEJIFk4GgEYKZ4w6TFKZjqa6RkRjIHTCyQOEKC1AxkA0jloiKtwUkQEKLIxBu62nJcF02YLA0jM4BgOOS2GmnSuClZmIy6XP8sx+30YUzeTwTI4EfN/5xyKsvksioH6oeTszWvTcRkOFSu7NOo6zqRqbLtqTsahNn6WmvSr90lmG1krKYQuuA6HcYgqC31fqIzGF3GKxmUxGRRW5jhLbU/Wm7ne2OZyGJT1BTfhTfNdws4zlXK5T7wqxfLO3NUtzDOns51MqvdYVMJ7WPf1Ywu2c71+rZqdtTvcJVP0ne95h3DD/////////////+/zLHn4//////////////5bt3LG1lb+IimU8AAAaZJTMIyDtFmUo+XxJC5C4pZFjRThtsIgCgcBtSVOcaqOPpjl4jut5q3OxBOkpUiFQ7kkcOU2bNMkkVmj2I4PQOhCuWHtBdHjjj5UQGGHKPFRCOUhxw8fQ/tLpVR7uudfqrVYvpnuIbmv5iP+/am6S7HUt+pUDVZIi/uCDx8U0r6cLozLCdfnkm8z/upqHbVAAFFPBfKpxCQHJ//ugxFEAEiG7Udz0AAnaMWq9hg1YRPawj08qgyqsuFIgkQ6I5XLJrp8mXdFoGwyBBRuFgpKgpktuaMGb75+epmcPy7rKUIkNhThaZXKZwl19meGsFN7HSlntp0vdP+cM+e2qfmcHtJD/hkftlnnkjYglIp3gNZgWhjmVuK+7ypdaySAUQRsd4kBvhcwB5BAiZFoZ5DyAAgBIYk4kldk9MXKq+NWtUWZYTKzl532hO8eU/VnIjLUu1xB1rJIHfex+hk1bw6EO4Eg7zaqR34sU+TuMy9/8O/mgbVtKtt8d7hVFC/5Yqdc834S9xe5lZTvkmQCkJiOgAXg8QXo8qpxnF8AtMgcghYnqxlCfGpYOBm2DUF5UnFW8vnxtev8rYJe3KpPs8iYAkHw4MFhQWJhJjgMaGMhZ5QAPYSNp0puHr8M3D5WWQg65TCOABItAcfJAyBA2PCbphH2Kyd68q7lvI0Ek0cAEsmAxhHllpAi1JEwHEOk4VmIrDgZDRePmbSuk78DIABCSgmizgptUKgMSR5ltCowRqJjHmKNSlfVfbMz4fSKXGNja7QgaCWPQUAJB8j9oosZexvdSerEKFjVRKLjTqFlgu1MPl7lXLrIiCSUDSOEJeFQBGJQiIZJgfJNDQJ0YinTsiuAVwA1oqF4bLv9m/ANq5pazgeSu+jtS9UhroW3fZuHKXuRn//twxMeADdS/T+ewasm7EOl89hlQoxlEan6kGNrhdS8zi7pTPh8/NjpflfmUnD8v9f+5+2eS8yJr2rwyO8yIF/LqiuqYyru6lk1TIKUJAGkJQOQG4XdIKo1CeH2mlEmCxH7IaaRZnq7IEGJTkioOGcKLjs1I+7moMqIrUSSkTDRcvIrTsKtT7NerMxZkmuaxJDOXt6lQ6Gea/ZW391Npuunp+p2ejIqIUoZyQjR5w3X9h6iZuXdHESAkknlhxCQWOnC4EetwY87DYwsZpzJ3if+0MiJF0SMldVUBmfTgegnVhxpn4QOItQF0k65HDbNYjPVrV0fKL8ZSmUML6ueTVYy5w/PgohV7MNV9W2ID9kN6LP9+Kt/8ix5zAPabzDvOX+LftWaXeIiHSREAkoWOoYsIXuSZWbNWs//7YMTqgA2840nsPGWBxbFoPPMN4cCJAwTgSGRUcIXijxQoNa2Vp5GsrYydzf/pF1SWXL9mRI7zKHnWvzcmPPJWM7W9XIFRqoR9iarf6/+ybv02LrhX8dfo3/m7+NfUVautav5Uh1znakhGeFZ2RpCSQSkah5yxlSzNvKFSCmbB7KQN3LzPV9EbajCrZR0UQzWfTiN5HptnPY0Y1fvDJp2CdGqQnh2KIPIQGb2LAU+XInihmwUYPDFzkwkR28csscU0KnTcxEaG13/3qmeFZmdmWNMkEkOIEZIYSYsROPtJ0yrM0KJIF4oagPCvVpo9yzFsdBjNqO5kimYcSUpDxjIGQoOnuf/7YMTygA2hcz/njFGJyZ+m/YSNyRR3b/txZcJYCYoGQANFFCoNKXRuDBBq0te+8Rx0qts+cenlU2Lq8VTOoTt9rv7rEkJcGcLcF+q0SWHNPlI3pAxGkwjgh2KYkJouynKGKqaCMtdnkUnLOutZSQmIZxLB06HjguFXlYgHDHhdCrnaw8g+zVFmmWIMI7yeU9t8r5DHVbtZLdbLEiSAD8EfRqeTaIvPSkTL4ViaxxwVdGS2sBym0a9OSaGe+rKRyQOSaqdv9mUQkC/j4ynDJPJ16R936qpUdxxJoHiMNh0iwBBdrpgMhYeF4ScxdKNN/qjLG2cZ/RoWiauq2SyskAAExIEVMv/7UMT6gA0wzTPsJGnJhpmmPYMNKDDIpLvtPMN6QIEVHV94Hq7zEHIVDeCwK40XS4daHucRSzckstGcUeYUVPS6xcGTi1RUKChsUD7FC6xsicVUiy57ibHevdsRH//uD01kcRsV30ru22sbSRA8xqYBKPxLyU0c+MYweIgGKgaK6DjBxW1cMkGNsUK0t4nif2poxufVVRkQKeZOsb/anBnmZsEP9ZqGoFUImiMepJYKLSKnS7NrCPMG/1dvYn//r2jdsk2rZQBA01tSETJLW9//+1DE8gBMbLkv55hnwVcSZfTzDLDr07nU3U3yja+S8oIBCQ5N9OSRlOzF2ZzZVE9cE4bIgq4h/kVCJJ/HY3Ckd7COkOUpGYjTC50krFEzT6aXUheYZAMj5T++36fVSrmnG7JK0gCQTkRYRc5I16WDIlKwDwZVxc1MYUzRXJB6OM8Lq9HuwdV6l/EiWKSPiQq8PKLQKEVDjxEKCSQC7xHYAkmA+HBhbYHUgZjIUHISwdAawo+QEXvmKb6VV7tu7VtqR2VxIgAB7DbenIkNAq2s//tQxPKADFDRK6eYa8FvEyU1gwk4CMU0piAIywVFhAHoREAmKiE+Iziw2WOCRgOsDTYGSMg+bED3iJ1CDFIKLpdJkzQ+LKsluw+xyve5ds0nrchr9MvqsjbrrlsTIID4AkSxxqE4uYsOdxLglbyNMoDDEcB9YdFGpruYRJgvnz8wqC2UxNr8TEhsDuBpwdUEgnU4A3o3PIF5cM2okY2NvohMb/9lH5fvrkbQTkscSRIAgdi3MozKy9c2jFBSE5mGRQpQQdfJpDKmZXOorZn+pf/7UMTwgAtY2y2sPGBBZ5plNYMNOLFKqNGIln+qmpK71sx3hQSigRPOQKh94DMpioHCaQwoUQHVNUwYrkPbvFZ29+pG1XRVsaSbbkjSIIBNdiAvLRm5CO6zKKcYP+ZUgTqVZHVoOISKCogARHLipUVKDGGjTZGpCGlg7Coxj0nhVhECNPjBw9DWXEW97/Rb6F+r1n1W6tMgTYbLlsSIIIcn0M10MTXiIh+tPzKIpaDvbSKwU4kGLBA65aihJMJQgXls9PZqcI2MIpXyQiFQJBX/+1DE84AL8JUnp7xgAU4GpPTwjFhws8GRcVtfMlkUFHpjUxQa1hwPkrq/0dv6VeQZr/6AB/FbPFfyl07El2+sd0MjvNGpk69nu9FLCRCVSJ4Fk3qWq0YzWjbuFGOucMiHIE6UPDIRaikNgKkNppEwWuBah6dplVaKNRKe1zqF06UrcQABAKcZRAAmQG4td3//v72t0dEVSmDCpcOB5QjFBUyuQgZp9ISjBNSsGyyzY4/uN6AwSdk9jdVXb//3Ptc18gINuNIgANBEjFdF/pf9//tAxPeACjihJ6YEZAFhl6S08QxgnReYiyV3jhaIBUkYGA0bDjXNJWgZM2LKEJcmBAZmjlsxUp/UUYWTf6KPm+ABArlABGEUpM3//1vY6qnOuVWCAQaOemHzQ9Mthpy0PCqSa3sDo8rOBNqFNzK0Je5tfsSwggSK7EUq//9i2AggOIAGxXAgG5VvFf/i7nN0yk59xY0oUCoSAZHS/sT6r+1Gz+/X/pgMAGCjv//+Y27UrW//qpf/+1DE8oAJ/FUlrCxgAUmYZLTwjHjO6v+u7/R////+qkxBTUUzLjk5LjWqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqEj///////Ve6ygkOImi/nfZ/pkxBTUUzLjk5LjWqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqTEFNRTMuOTkuNaqqqqqqqqqq//swxP6ACmDFHyeEYoD7DSQ0sAiYqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqpMQU1FMy45OS41qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq//sgxPkAB0BnIUUEacD2jOOk8Ahgqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqv/7EMTzgQUQBR8mAAAAaADjlJAAAqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq//sQxN+DwlgFGAEAAAAAAD/AAAAEqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqr/+xDE1gPAAAH+AAAAIAAAP8AAAASqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqv/7EMTWA8AAAaQAAAAgAAA0gAAABKqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq",
/* 22 43 Low Tom 1   */ "G2":  "data:audio/mp3;base64,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",
/* 23 44 hh foot     */ "Ab2": "data:audio/mp3;base64,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",
/* 24 45 Mid Tom 2   */ "A2":  "",
/* 25 46 hh open     */ "Bb2": "data:audio/mp3;base64,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",
/* 26 47 Mid Tom 1   */ "B2":  "",
/* 27 48 Hi Tom 2    */ "C3":  "data:audio/mp3;base64,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",
/* 28 49 crash       */ "Db3": "data:audio/mp3;base64,//uQxAAAAAAAAAAAAAAAAAAAAAAAWGluZwAAAA8AAAA3AAA07gAKFBQaGh8fJCQqMDA2Njw8QkJISE1TU1hYXl5jY2lvb3R0eXl+foODiI2NkZGWlpqan6SkqKitrbGxtbW5vb3CwsbGysrO0tLV1dnZ3Nzg4OTn5+vr7u7x8fT39/n5+/v9/f8AAAA8TEFNRTMuOTlyBa8AAAAALDkAADUgJANkQQABzAAANO5P3jPTAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//ugxAAAB2wBW/QQACQDOut/M5BA7ruZzKrJCSAHwfUIDhQMOB/B8/BMH+CEuf+D/+D5/BMPqBBwIAgcg4GP/rBA5/B8Hw/Lg//5CIAQ4nP00blfV2zxEsiwyBAEhQOGAItNcEfKMmEKkIj2DQ3vP8UWEDhACmTDPMbSbcwYErapU3qmjU4rLG3gAs2yBFKNeipH0JbX0eEAAzAdYg4NJIki03Bq1G/zKq8XrhgspeZVeAnVgSBJfjfiGEihtkrQ20UgkZDu7MtlEBdkcqgOjjuEscSErgjSsa2YtE3Dzjl+xK5vKxXt4YVYNh50Voscv4aoZ+GJdTT8ZppTMxOAcojIZdIKlztx/qOxXt3aCksct71TUMqz7dv5Ydzt9sZcyq5UXe4cvdiXLvcqG1Vr2+4dntT9bu+dr5YUeerf9/////////////////93NpX/9Krs3e7byIrSIU2ESCvCyURRiCESIeXoG8YKPTaTOtMncHSCkYBERJQmhMhkI0Qu9TDNLs9ylxMpNN7vG8RxpdJ/HbRtdxzTT/FrEol1dTt8/X/3OjTH1O3d6vdf261XfEKcxolCKC4fsWRHm16lLW6gJB+qcvs26ZnjIALmplTIyK0BYT+iAS32JKCL8YEvB0ozTSxps49ko0SJECByZEnEKdTZSckYtAVcEIK8kpG0q7oYpCWh2dDq//ugxFwADlk3afz0AAHaL6y9gwoYgJgTs9lfYy7x1c1GVVWbpvZSKcrbv92d3R7IbZttpNv2u5wakdnRSmQu0UgJkFJRemq8/o3HdjiIBUvQdUAQmlQSBEiOGBgiA2yF1mluEztoQHChZUGT9JpLVVhE6B1FoYJsO48XP5jx34Wzm7sxdsNluSeXDVPJptU/LVtDncyy/+xYLc0BN/3Jv/H7W5gZ/3at0qsJI7c02gavnVreql7zszLiWMgAAJ4B2JaBiMYOoOccxLF8QNPjpJc2FsQhu5EKJgIWglfd7LcmDzTNfM7tt6ZvpamMTc99TH2++TUTsPTcmcScPGmmKVoOhD3OUnQnQXu6qq7+fl5qy5rIp3Kf/n7F/e1fL7lIX+kYwFci7KmI2TZAuZwwqY6HuqzPu5iWUAABS8GSqQHcuIOs3yCiGDBJiXYsiC7L4tFicXiMb46J51IHOREd58+7qC3edSUQPR2PrQYhFJvRcKJQm7BzJWnCL6Zuo6XNq2WxoDF0QPs0N30yIzxa/eSy7F+ZH3z0hztTkO/88o34/yHJKOUaTub3f2Q3d/fXVK5EArR4A8MuS6Cs6SIdJrzxpDLNfhdbOpXATz2VHk6YDhxelIM4ohmXJ1IG1JtTOSOGpCkSniNxOZKlCqADwFWE9IwCoUgwDiJdCTapbuwKlUZ9ajKkAREM//twxOGADdj7Z+wkbInzMGz88w39cxbNAddhzGQSmVLL3N/7Uzw4ZA2ZfGH2gUDCikIiEF1MaKrc5+yMe6i9Vb3/3biFNAAAKcGc4moY4CMyAmBzBhiLm0jyxHTGYDqXlIqqqdJDpYe2olyDKRpo2XskbKi2sP4dIJIMCQXMGUpKkRZW5NaUaXHPzNUAFFVe1jR33znISzQ/bfu19dPIsQU94s8CPjAM42g65tpVecPRZpNhNVJ2tF6L3+/bZkQAAAB8TkloMYuINVYGMN4aYLlWDsQlBmwf7hBY2RZ1mDiyx2tOYsxFlfafooyaRdUwd7rMHKAtXNGJ8qJKei8npUMDWui0c1VWiRpf2P1jpPhRY3yEuXqsgxFGdtlRSwwoho3FvW1uC1nsb3Xv7/hrgiolDLZFL6uytf/7YMT9gI9Nb2PnmHGKHCBrvYSOMF7XMKK4dBxkawVJkbJOPa7+ysllQgAAF9WVmxa1oSSLRgURgTdUWKrZVVntfiPxh08JNYoeWpmtFAjWSYpKEI1VO1HnttUh3GCeKjah2aqyNhyszC+YAwJBe5o0ZL116VQPbM3J2Pq3OhZpVM+w2ZWanSv3bjOpQIR1epVbVi6E+6oq0zo1lpn6Jsex28KCNiCzGxW4/XOfl5LIYAAAAvAPA4AJsfIGcKwGyXkNc5x6CAFKgiaJkha89tEj9ZHPZY/iOWoGvouWOIJ7Z1lSWClGdG5fTMo1S4CoelRgGyYSSWZikThoPEXEsx9gAzKpqP/7YMT0gA8w82nnoNFiOS2sfPYKfBoXInbBQVIjhRYkxEk2TEaIZPT6JpWOTjvQya+Z3/wxLsFyN3DsmIDGj0BsMQ0OXNLOCl21CprvzcdmMAAABZeTmLaZ0GGWuzFNVeqibLFDpI0KVP/Uh2VTNqtQUsq79r/bUrWXYcQ1zvNS1SB+9SfqGRknJ2VDpOM7rzg6O5StojMtlYrkwxgZO08LKsnIPK7lM88+jWX1DgQ0RIGsssIcKqyalM2aFJuRUEp3VnX1XZP2vSoY2dbUhSosQJyghehTV7qr2vqoYwAAPA2ULjkppQTDyFBeqGWxK96ji6zrNvJr0Dw/KLGG93f5q3nA8//7cMTogBDta2XsJFPiPCBrPPYluI8zSNiI7HVGFysyggW66fHBTJhPIhcPF48j0H4Bjslo1a0cgF0HiMcieREyxJESmOYV8TjgkwKFvJDldqVyxT1tapW0yX605rGJ7DDICtVUJX7W9TFZbsHAZRC2DuRF3AViFxyxJell/d/sx2MQAAAHjWLH4kakrVyMaXoqu46VbeO8o3GWvEp8tEBTR2fYplu9hLzWe1VuY2viff99ccI6QtShLj4S9JI3IZW1dyrZUGhwmUUVMkbCM+2iNiID0zq5EmTYRlFCh46RCnYFTEB315/eomUlVM35KkCyuvKgsDow0AN58MF4bcBnDATPe1NZqJr8mEUgACoFYTwJCbxIiUhiCxDhDVCYx3g7HRScmY4K3D+ry45+Kz5/AeNNFdWjdPD/+3DE7wCR0TNh7DBT4kymav2WCnj0/fdQIQ8lYcrJVSKtDrs6Hp9LrCMZjOfj0oxDk0b6MtdRL0IykgiYbW5MqrRzGkEvKqF/byRRwMscrttfx5rtqqzfzQrT12vhZ4wsPFjrARYu+RUDZRU/52UFDTWtIN7TSJ7P6ZZiAAAAG9aB0jfBWFEX0GCAiikgJ5DEochSoQonSTduD69vbjnZmJdZ2YUJ5tNGWGbMVPp44hWadadFR88ffuLS86hmJUTqknLXFB0ZpWKR5jLD8EbTzKz4LRP2VAscx2MzNQRtHFLwSuZS2N0v6Rl3yYTkXdFO851055ZNcnVCBfeBGsbMtn67KllQQC8WZcsv3E5Ok4GOAxVbV6xJlwOHo0m4MD1Ek5RZ8xtt7+xZS7GQV7TBMKC+7HH51Yt3//twxPAAkVD7YeyxLeJOHSq89j1wEkuLyuNA+XHhBNQBhKNvEgTAOSAy6TZ4qmRkIIliNdSaIENeocZKsOZZQIFz482oziFt8Emltz0UhaIz1tRvMjNb01tWkgIsc19cLuBKCxVxE+qxrc+bpmMQAAAb2YJdkRFpQkv+W4fWFLwSrZyyl83rlE5EKR5JHT83WtbKPWsyrPwlLC0MMTaKKpVMdWOEZjJNWKw00XUPlMkBSJEmqiZkqosqiTJRY8QMU213W1GdtNL9k4unsPsPc+lsLIQadOr19bfOiHLRWRtjMw2qltwdHqYgcTr+d93L/v7blpQgAACcI8XYBWPYTMDVJ+A+iCmiTwR9JHkWxAoctLiHp5EepFmq11czL25e7o1c04rqNyg58k00bDSpCfQ7etTSBaOYqP/7cMTzAJE5a1vnsHHCMB9q/YYleKDSJshjKEkZAsrMrKJtZuOQLllkJB1DV7k4K7HLuDuhGtLOsflPqEXlw1N1TX5E/3MjKU81Ol5hkuWtkL71Ks/t7LmIEAAABZBOlipSjySDblI13Kqt+nNAT0SOBWbbgavqC52rKH0af8zrvTraXqDSjVZ5hOYp1gRF0SMgVIW0xCkJCRnEAgSBcdJlVxwhI2cVZGFTR0NENrqjaQWLloEt+2LKx14lYK9KSpnl1SXHOOShZXdWR1r/P2d61V/taWmjEbszHR9RFvq0X/d3ZDOYBeUTn3hFjMmZwpFuzJ2eOEw2StJXtSbfj4pY+CRxC3Z0LW2vsGblobb3JS5KRo4WUSOKLS51kNWTgOKm5U8jNmJz84WfU2jMsYRxq6vSU7E0tBP/+2DE+gAQ0Vtb7CRTyh6tLHz0jny8vx8JHSTp1SCrZFFNGJmELEgRFYlE4txikS2bV6vd3Y3P3JZ0MAAABYTSCBASaRDoC1nkSACdU5TvTbLlSOlFaqo8amIdpt+C0mqxd6RFqqBtqJVhDNsxJONTjdG5pnlXI2y9lXwEgoOtgYNoESNUYXmqTFUZPZibcXKZgHxBLQsSrmYztVu8akH4WUpxWOnC4Z22f34cLKfLO3/yP/IWLk3kJt49xfG1u/f0yKICnGBP6HDVvS8QALWR7WY0NK1sTIojATvQJmWaeZLYhW+31popSVlFfz6TN2kgrULCvfjSUDhenOPt1JUeMCY8zNz/+3DE6oCRhXlf7CRT4eMfbD2DJixNY8odHDMLBB3CGgoXg0QK49xTmoDTZO0oKPKRyDEQxCFYf0CwnNFTF7LmEKwAZjVvFSCKfQqv7tzHZCAAAAWNK3/RnWQtovq1BpCRqyFmMqelxlG0a4NBQlQNyy29q4sxQTaOwqbSiFlE0nqjWEjpto2lxOTFRt4rTkjNnVR5NQ0UoraJLoUtJLtuwGo7Eh2M7LBw6lbaTnQfnrNh4uqPoHFrLDlK+ucCQMnAcQee2J2vREEjGW6Uy5EF7QpQFDzKrGz2/2ZEKiAAAL4mJNgUhXBqE+D4NACGX0MET43iHCQj4VTtVQoeH2CVmornkYLNOZbYPOggkaTIvHXE0UQYQ7h1RYFG5WHiwliPQHJlli5hdxUNEn7yqU+wjiQmOy5SMITt//tgxPoAkQ1bXeekc+H0H2s9hI34vDkSg8VCikDS0xeoXSGRqWb2yXCRKkofUk6quMTVj9/rmGY0AAA91EnES2ZNFkslYQuNH5CQqVSt743JIdhcgiMas5Y0sclhN76i0adaDX3VBcAMs1LUCVpTXSKT4kkQDrHJOfpWR2TQFYWZp0Dh+XrxafO3B1TlV7oj1+UyNc+Tp0ntyHCqZIkHsVEPiqDU/t+iP3tqXZTAAAAfDqNUDXLsG8DHBUhxm4Qk4CdNZLm0uTaik7R/rc+4k9ORwz7Fb2hi5v2nT3HjKp0xXluaoPGDg/P7svGpbBuV2aCAkQRwHOA5jSHWobpgEq9ZeFGd//twxO8AEZTtW+wljeH6G+v88yYsNxMrXLmbmFRUtVdreNxLIZverjsp4paffR/3QSFxOFWij9qUQCGBKMGXP4p1Kp7f3LZmMgAAB8EFctCYwNFqNNRVQVyvVWRtX4d534AicPPvFKef1q1PfltYY7c+C1qVufHLrNT815u8XM8to43tjo+9ICJKedOzM7WmWGQ/RwHdCIrSnbD5qtbUXq1ZizjS6jqeJCh9hDo3XZy2yltrcl+k32cxqSMf/W/9iqlDGYHXMdy1DL7+zIVlBTYaUWve9LVHxdiIChqrXZWw5rfzWT51Cea1yD6nUzMw2W68f9faQIag6K0dTtxlZieq2iR15iPTlS6doh+oZk5GPUKiIDwrHqg+WeACoAAc9ZMmEIpJIqNBmKEA4TRLqMAoqeYRvWuPb//7YMT7AA6ZKVvsGFOCKaTrfPYKfG+V+3/btv3/7hTTIfNrDMU2KL3INVVDO51dnd7MhWYAAAAFxkzqJcKSUgtBb6l7D2ztEbm6zhSo6Lk6Bc8DL2zyv25z2edXZtbHhscJQVQnBWXal8WNGhcShLOJXFQ/K44CCGRTLR0ZjiXrnYkktanP3HLmI9UgxYleV3Wve+mJCyIcTHt3G0OzsceWWWy1dZtAg9tR5FBcjKqr/JCNSiRA4KNGD1rjN/KtUUQA+ISagC2SEQsYh6BXB1kVMIYlCjPZXOaHAy5PTpz/lloQlk4qLXYOwWmS1x1eeVtp0ksHNIDs8J5SNh0NxhU8OIzV2P/7cMTzANDhb1vsMFPiIqUrOYYZ/JcHR06Zsk2q5k/bPC+xZdb1yha60hnB7I4uUj36MMszH+suUnd1RJphHFG4oJ61puqBF9EIlxVdyUo0qqr+vKdmIgAAF8SG05oDjI+EyGWIIlyU0MNVbu8z8hQaCNo3gwu0si+fXTayrjcuqyqomVPIhSy+R70jD4iEhEMsDkyYnwYtvDljK4zXCWJInQI3k7BhYhOFidOrpFO2msZ4/5/dpzv/fvsXfevT0zHFTZ9S3daO9TU7IAEzwsZyXVO51W6OpAAAAPoBJOoMu0SWt8wQXQuhZFzKNCIYcNqxeI5oWx5Ly5tbfq5ClpV0yxx/7r1VzJl07O9eOFuD8brhbAoOYhLJqYYEEuhUdGKGAKNjY4BN4eYsOC8Pxm+2TNOjlcicIG3/+2DE/QCRiPtX7CWNohOfqvzzMeRczx4GR6WdaLswwMLOZvSH3wsfMCJTbDD3UqNhhp94Balt0+foNWNZQOftVc7NyodVEgAAB8SirsSTJE6E+20aygIbukTBjVYhL6Z75ShmjDC+JMvm2ZVc1LtqrZ2zrmviaoxWz+K9XrIi8ZIyKWwidfRCUsJpSCi5aaPCqRm1rTqxOiHEYhSozEYLSVekskhTanNs6WbX6P66eooV8lPHw7fV0FosX6Ev48Nkn25vrjb3MhVQADOJCrlCmlLDusngw5lCGiwrG2NxytE4k+sBNchmrBp+90D7MDjy+KOPU/0SEFShoeXOqsITZkEqQGr/+3DE7AAQLPtZ7CWN4kkd6n2HsJQlCWIS8wXieGoFzMQSeK4j0loAnA8qKSOBKdNgBPjkVVhOg6zaB7aYLC4okRxjCX3qy9ssOr9g+DTpw1J4VUOIKA+SQ9rVCUZAhlqirnjNFyqczt2lVRAAABnAgqgBgehAVKAgHAHGLmLkeYfgmyOgvTyVHdKq0Vh38wVgx2CKjUL3x2nYHTSJulubzl6GcIjJSyYL0aGbjykWozgcjDVZ4Mh7UNl3fPFg8IJbQaHEsp1J5xy84cf80ldD8CymuwxbQ75GlIjlVdensc1vPXd/sl0xjKKuPjG/1VX9eS6GAAmBxhABW1BJOBJyXCZL5ukzM5C0OGyopUVXY3pEnjkHljOoIXpO9kUymwdIWJm1RIOOyIwJlhZEPV6Ht8JXC8MhGsK8//twxPQAkHj7VewxL+JBnyp9hiX8gUSmV3VgWGeZUxGF8unRdXGeR7NEjRHsd7EiNqVam7DVFtXzbpuP3bcosFg69hlWzIyjIntHNtctSmOeyp3f3Kl3MAAAPgBSbQVKDBnktEhOMzisNUbxKl0rGNoTKo1HW7tAQV5+5J27Z7LNqXijNJJyXSu7TR40RZUFZxEwsqdEJOxkEJEpBXVVU2EiR/xZRhSSkGGQPOggVylPrvciikmCIdDXXzrXW93vsPe98NSUz6r9/cmHVEQAA6AVK2AaRASQkj0G0XQsJ2nTFMXKGnwnnI2zizR06qmz8SmuqgdKfVp2RZYgvFadYrbj7CPCyBOakxwUmIo5pQTb2Cq5fJ7oqnb2ZjukxE4Qva8RDdobf/9aKxbGyxkRVtZU5oigCmqv/v/7YMT7gJEdXVXnsFPiGp2qPPS9tO64dkAAAAwQTs3EKWvpCNZbZqSNjclordbVh8AVnMfizNWcyjQzMOUWEUM6rtNso3oaJgzVPeuh6jgeV5LsPg5UPg6JFXXDsPRQxlUWMIa0Mp+LRzGICnCiGVbEKolLt7///+JIYNVm275ymq/bqYVUMB8BTyQCZ7UQAJRFcjd1FFgmIzE03zlxGW0M3LZ2WMNtlato2L3s1dhszaazFLdw5dY912TmOTTRBZuDaoqEROTNHyc8ymZmSmbGkmdUlHL210ql6hw6mbXPs//i6uDOITXfjo6gw80MJ8//zKh2ZEAAPgKFSwBh1rI/MvmVav/7YMTrgA6xN1nnpLHpux9rPPSZ/FgmXNQlEqizlX4KjW4ryrWpI9PjDGsiRFA6KSOJ4dE4Z+DGHV6+2tRI4vTUaZRZx6AEpyMoFJ2m4DOiVqGD2OiFglBoQxHloVmK7SKXIzr/r/B5jFskZh+qTM65OZ+XiqiEgAGcA6zGCTDDDyT80waQdxdTwD+GSiTdwDAUOKCD+Zx9oK0WxADrLGv91ZlPIzXVVWY7SaYaSUROsw6DpGXFuNE24UYJLzDu+9kfjwqVFcuiASeJ5XNOJmVtv9ForEwd9Sp6z5pjUhAAACwBTG+S1dBDeqUFT1fYrK9qq73Q9GJXBu4Al07anUKn2Ysuv//7YMTxAI3BI1nsIFHpu5+p/YSOOA8s4sguaYfrXElkBaOZjZmC5du3DRMVb1gSrxSTS+hOOfRcVR4ZOlkZw1V6F/kNZTYGm3WrMPMJh0NQ6OzPW1NUdlLM///uZ1Zy1EmE9dQ+2q7/vrl1UkAALgNNuBsCHhVhhAczSOUh4gZKQn0xIh+NKR0pUAi0QOCZZidqN0q4a26V3iD5kt4dRT3hjVLnxEp6jduWK8wqjW72mto1rjKp2KUdEscpamLJrOx9nwgfBQNjAmacPY251d/+zpeGJgAAPgH+EFDPEaKwEGQceonpNhVmSiTUpcvFXERsXbKKLwueOECqqbMiHLygT3CyUf/7UMT6gA4dO1nsGFNpnRnqPPSZoD40DC8GIgNqGEgFFKYoxw5DhqOECvRBpEZ5CCB4wLPBaLkFpYROiz0U7NBl62A25NFiZ/92sd2MAAAHAMLQp/N+je2qullGGLOjDXM1GrxYCQwJQbWbVcDW/tpvWTVTR0qx0Mdm2LkloUTeyVWkvRou0aF04KIIN0shZQoU2bNpKIGG06OIF2mFE5W9K65E1xOgfm9MMjViq2xBvbTwbYBwKCjxrhgtGOWO/8ymVDAAACwRW2gHcQ0KC4j/+2DE64APoTdJ7DCxyaGZqvz2GVS9Ystp6nCiyx2FtWdkqEjGDuQWakq/G7W1cum6slVK9aGIUkSuYdlglO23q+ns1dYiGdDMWNwGQIkQVZ6lIC32MPZRa60+udtv68Fgq5BmaDIeNmntj+PMIM1OMF1oVn/9/LuZDimRJEF90W2loGqFsNaS4a0SwBl8rEUnECXVnutw/k1dxeU3me3aPFugL5yRDkPh7EgKCkFGScSrNIAyYrUfYlgRMgONR+suC4zsX4+GbRxoXW84aFjsLqHX3WMwRtBUJB/Um1WOz7p2YyAAABwKg40whQBYJ+S4yPa7VYUxH6gJ7NSB/YAhrGcjezL/+2DE8IANCMNX56Ru4dkbqj2HpNQTbpQxql9Ptx1G5l23aMkmGCRiWoI1JJijrU2NpqkyzjiltSZNsRmbyVLkUEOa221UJYZzOZiAZJpDOWYUrqyIk3//pdyrV7QyFPY4zRud+S6sxALBNIOejS+4kAfJCaiSjRLJYM5NQw0HTIeFAjCxRkEQ16g6p6cTY+jU+ff5qOw/F0GVm44k5ubNHJSYTPrKxJm2hMs9fZySVxdnLXnk5TyuupNFNC/PXk6ZFjx4PqPXpfblRdYmFgcYSbSqn968pnU0AAC+AZh4gUiWDhJmErUp5F5JePSmDHbJmBHx4q6UB1CF1itJjd01WezpPv//+1DE+QDOFN1R7CTN4aaaKjmGGWy9SsTqUIUqd9WgQvGXSzaAxsNJZh9kTvF371BHMzP3zRO4qoSoDSSTFV/kkGE2CDY1+fvdkM6mQAAHwZyoEhIaw6mz9qDtzLhF9FaYgwKQV6dyYsRDZEhVcRLyptOTKhDc07mltLe2mrIy9qxidipq+DcKQdWTNdCrmuSg+T12JOh4siyBsVGqzsJ/xqwjScErxvpyoKMQDKaYqtGs37uGQgAAACoIUqxoTnReVEJxlLlpJWq2PK0yJxoS//tgxOkAjo03T+wkUeG/G+n9h6RkkJWCZB5TTvJpU5ko5prxIWHauyQuplFNv8jOATOlHjZBj2VMKyxwKUUJkGMSNPTRwDgkZs0lZ+4pH0djnlI0sEjbAaSPdDiEq7qCQeGST+hUXu3sM5gQAAXwhQx9TuqUFQFS9sq6Eqkb3KcJvpbD0qkduGJRAGFibs+7NSGHjtRbuLtRo6jlE4P4ogjXoLkscZJBQ2WHnCeiiC1OqRUdStXb7ljBj25IirMH0OuKSlrrudQjE33p3p/Rt2UUeFWvrnKVrO/almUgAAA+AFo/CAEYHmOQHELgBQBpmrO4i+srF0/yrYUSuU5jZOcplHfE//tQxO6ADGzfU+eYcaGqG+o9hI38uXDWg0N9QwOsTsxL+kU9/6tTeYCscmQwohWb5hTOJb+0iWWkxf/PcvMOEWsXN7tABVWMa2xNZ3VVS6EQAAJwXfIkl8X7e1kgdFckQYg1B03CZtDkBQw31JOyqV4XI9ctjaPMUuYKZLAEGTiiJMFEBCSkboeYwEHXpRGeVgg6gVRpfuyaEmzEwizY2EoabvK6Zl8M/8vBkS4uRYx9SNTwqEnM32rIKo3+raaGEAAArgDK3gPROD4BOE1EaP/7YMTlAA3010vsJM3hx6YpvYQKfZOY49IdxZLk00VKzR3sJYyxqtQZ42lumi/vIGw0wfmAcJETTBeVIhzhOFFWoOmkjZSSVCdA4ZjRNqeRxhVVD6AayDgOWPEZ1qen6WEFte3HuMTvfmU7GRAACnADMJcNEwC+API8Ad4hYL0kqlHOnox3pJgLITDH5Vi5M+E5L5OWtSNJumc6ajbptTD8EWSJEykVk3faVbhFltyEgqCcbBKEFypPR6UIEIFA0VUfmGLfbvUKYtdep+9XBPKEllFVmt2smXUgAAVeAUVwimUjAXopJcSjNwWwYxglgVr06ENARAJkhKd6+4ul6/x55G11RP/7YMTsAAxU80/nmHNhvh4pvYMObNj0SmA+ciNNwkfJ4WcZbj5NKAgvZgczvoABGdkybsBaGeJQwW78Me7+NPgiIBAXLe8cgVFI19a4EAS3vfvJZlEgAAzgHCcAcqnICIOHETwvoCaiRcZUCaTBUOgkbQKLnDsf5jGPkwim3QKv5iSLkRWeBzuctd8FZOIwpIkcAkmWjPMemxjSmnZz8M/3vftYjSFyQXAJbJMPDvZpIiMUWkkqLt0qzv/et1MgAAVOABWQsByF2E0FNEsMovIgBLwyx6xioANAm5IcV+fGI23HNn6jG6y5Zq1py22JQlziPHOTcJaqFASO6OrjFJ1S6EBwjf/7UMT6gAzUz03nmHNhsx+pvPSN/E0GhE9gUUIAIOsKlWrHKOTvX3B4hmbU1XvfnW8MYIAL3AI5EyIDfJ3v2zFPZtlbV4t2e1+XzlEkgWOPzfdulpQ/Mcc3mZaKXj79toaSMOkXsXL2iMX8yEBQKMNLNIKxBck6nBbkUEBgYhUj5YMAEkPW40p9xujRWq/0Vd//3pZlVEAF7gWGnqHKWhDstgB9C0aKDS3Bvt5ScdinKKE2xoPq5TN+kUUXeZiLVfqLx4NXJSnw93bJ2X1dMtX/+2DE7gANcOtN55hv4aOZ6Xz0mZSxZef8xKDE3aruzrDrHCLIvIKORlpnWcw0yp7ayFUvf/nkR3deu7qJQAK+AGvcLsVoRYUAvoQ+hTgjIm7cauapViakiq4h6xnbldRBwyDkWfSBT477B5cg6RRp0drnQTfNsE2BBmhwxpWd4Yx07iQTcZ7o8Uo/BP5wvajBojazwYDi5oaAjavS7pV979y4dSIABXAYpIhwUMvRbYAhPLiXWHMOcp93qbBQv2EBD2CJxQirWiIm/GlB/LZNiQ3viQGqQG6rqLwn8ZQpC4HVDXqCaZe4Yfa+fOTM79BPVVBkUR+3n8rP7Op2YSACnuAJo0D/+1DE+4AMfM1N56Rt4Ykbqf2DDiwd7MKVREm2bguYMgMmANyqyaH2LqFppWxb2PQgaTRcEZGvR7uDjGpErREmGChjTHgpqD0Wg5hxn5YkjzIEiC4HQecQcwWOg8Dh4EkKq0q51GnqnP7PuGcgAAZgA9DpBxJgYAOdAHMtC1i9frlnGMlMpek7grIN1w+fCsQIE+ZWFWxiJ7Xg1HdCfB2utPIuaiYG9yZT5m7l+tx72F3vzBh9FM7596Uvtltgk4FJqi18f/3mO7IngANV+DLA//tQxPWADET7T+wYr+GdoSl88w4sziRAjIdY0TTC6FhWi5HIXBFI9+vxHyTo/fumxTC41qy1wggZqYKUn2wzoxnQjMrrrwYjuVD3ICsFiyNQfp0ivKwUx/evlyRd84S52zdfxY3trKd1IkAFUBFCrTJ/BwpA7LFCRRAB+KUplWKB1MD9pBX25O881RaU3pic6s7EJp7szp3RoSn+5ZV3nYbrame/Yrc2s9e1PnZ6Q7b3HORcJNibZDYfKIUnqrv/cmnU0AilgCox+F4pFDjOQP/7UMTuAAsw803sJGypehnpvPYNJDGmh+i1E9FF0E8XSKRhEikybiDp5KdMTn0br9SEXsJyV91pgizJHKQOqpvZkuTtdLMbfPqmLC446dGlnCr3u4ghcFaBs+22lZzcyqh1IgAJYADeCJMAuZJz0Q+OT0M9GFKQMsLK5HiStC1TCWJei31Yroc9mq7zK7nO9cJjaSy4cUGoYXG1SoxWwxMfoYDVoG0QG6NKJDmQUvR4ZbvbdIHs8tJv1n3cu5ZUIAABUAIXBNAa4wCTD9PQaIv/+1DE74CLlOlL54zTIWuaqXzxmnVwnwab4AB+Qy01Q9MGYF5YfpkxiL2x1NFiZpAFSQReSnQhMq5aH3ipOKTS5KzFP46HxozWlPznbOzdixMpNmSve0t2x9/LqTEKdZJ6TKqt/byodCZIKWAMQEInkpE+0YkNST8TY1ysZ0C8WDRSLC0yqbe2qOVXFAaBnE1BiMMIYFB0fGINmxy0ymiVPFy7KJtycJdYZnuZdTJg45QGeLJ4IiMPkLWUV/dm3DKjIRc4AqLqQiuzQJsSJAmG//tQxPEACzjPSeewzGFnFel9h5hsH9FKUyWSMeiqV+LdUxaCLD7GNh1waqnqzHle01hEJBAgbITjdhKzkyLHzAh1JIkJT9H5h2g0LKBR6pRSX7tC2KqNzcx2ZBAAAVABTklEeBUoeSERAcpwGOiDbTiAgH8hURxVLtD4+1zrfE3ajvc2rLrLOSsQV5S1ebHQZhT6RxnJ5eCQNF3jeXS87l5gqIzACZ8eIlCYkoUjszMh2UyQElgAoWCyUaPT2IEqZ9YU+SayKhCCl0cBAMKOnf/7UMT0gAugw0fnmHLpjJ5ofPYZXBUL4ATbs6STbANLa5VPBaSQhR5Xui2NucwvMLwxGJgoNr4QOVF1xuZnK1RvtUOOOhiOLv67NnSe935378at3eq3mERBMnAIBNairvuUv2eaShIb942YwQ4rpEYbNAuNCz2ye9yym6UmCsISPBAU5Nq6YXhH0WolHI0NKUpebyMBAZhhZEcNNDfMyyd485SP7+xkuIJxWHFY98XeXcu7EgAG6AAzIyA4H8lWUvpVFATUbxKDvdHqoE4PMKH/+1DE8YALBMtJ7DxloVWZqX2HjHTBjjcZ7W4E0OYa2ZOqYs6yKeMuDEy4nmLbPmfMv/4VoaOzk43fVXV50b3Nm7SxJwy5NC2kL+xdFZvNzKiVRAlSgAF23x8rg+zyJgYBUEFShnaQalQ5UpMv683x9L7yGYJTdGJkLO3sJmT9nFuP1XqO8/fRWLnu6UvXhdn8vul+yT/toiXTbz2Exb8s27uqZWNEJTgAluHnQpkrGWprrwtwtocq+aKOinJDR7kzTuVsIl/0BxTi0YXKIoPG//tQxPgACujLQ+eYcuF/Fqh9hhlVMOnizM2oUEDVFMIJZTeRCE/WEup+wpSC5FIZwv8WKAhhzqHAZPQzanu5moVVJAlOgADUeMJ0iGkPmdKaCEwdxnIJ+mE/M6vHmj2QydGTxyYAWSNOa47TjGgSaE1Ze0a1RIHEcuMMj306EJM3GiaCD1LYi5+1CrAdXfWXl3MO5Egq8AMmHixd9G72bsBqGSxOhdjrNCvS6yy2Xz16etS59pCvXBzMmmjnW4gqJESnBKNUs/3nHZrUU5eRsf/7UMT6AAuE+0fsJGzhZRpofPSZzFafbeZueo7EiIXlV0rC9auru5dVMgpTgABbO9jTpwqk/mcfAsgsItx1vy4mbC72HlqasL7Ld7A2a8NVXT2j3xInrJ7uZZ3D5URrWVxjiVEEIXRYoUYcHk6+a089hb5xxozlPybyrqmdUQLewADJGsYbgoilZOLsuB4l9WEOUSTQtDDZallhPCg2MxLMeaimLyPgR1kqFlQHhOZps/x1/c9svaP1lbTWYvbCWudIFuq8qql3VEYBT4AACgD/+0DE/IAKUM9H54zSqV+b6D2HjHlMDMUx6RXqsJ03TPjDUbipUeXhtWb2fxVxWYTI0GWQsnpfNisHYXocrCm0dNz8zLZUMhUCzyXpQ4vF/v+yKwM+G73juXeXUIhkhqYAA4w2leMpgK3F6V/n9UXZ0qq+0NRyvDV7iEaSQnJMEvbYX6VrbO21bvyfrikElYuUrjIox5ixVCFCmd0zZDgJF/1TUlBX1DE3tjWaupundBZId4AADv/7QMT3gAoszz3nmHMBQBkoPYGaaJCUy3nMTZBvH1AjAmZpNMBja1IxTM6kfburTJxLEHYSLLCwUvVg4ER1JqJKLpS746HyszkFPGYFx4e8f7X2v2k7A4lrSP+5NVUy6mSjAUhZt43OKOW2ZwRxIC/o4jn5Rom6fIhHwWn9Mltl8yehNVUJ0ke//quiazqdsm/9/a6bxrfumMvaad93Oxf7S2oueFazUz9ZiYeZhWQUQ3eAAlhz//tAxPcACojbP+eYcwktlmg88ZohI5cx43u/UhPCagqcrhBE82XljYYccM05aGEnKFgNPB0SfZTTcEDDOGDiowQ6OYVVqqkA6FOCX4aHfIyi8MoYUmxgs7elLDxEy7IgkgmYAA4UR5kTj1yWjD1YPgsL5duaEF+vThCwsNSAyjAsJaPBbizz6rRGHmCzx3XXnf8VCPzPc60Kf8nTczGKWWi/8nWYiJiGdjJCk4AEnhJRiZ4rRBn/+0DE94AJ3Nc955hySUoaaD2DDfXQtKOEYxLQF9ZN8yGajfRPPbQaIZjnl8IQyJKi6YumZD7Os9O3DTufUmuFPhx+RtvSZX0M7OWmCyyp1ij+2+vEPEOqEJQSuAAMBlT2YDLF7DHaz9MJCV8ubJnCWiarLtyqU3lKiz+gSyll7XkghW4QNQ7gywYxk2YW9PJC55DjdFdDFpFhVrHNFFqXdoiVVxIKd4AFrLDDi9FsuGoSpBqJBf/7QMT3AEosyTvnjNMJOZpneYeYMVK4kxHzhYYKh8VTcjUWoLBidITGxlTcCGorFQlYLFQyU9DTMcyYE0+Ih4YUub75K8yGAe0vzu9NDvDw6IBBLuAAA6toucy1RpWFBZCDVZRolxRtnB1Hh1XoJdO4sKiTM7yuQ4fWyHQDjEHV59FBukcJDBh7xqY/bLQb4BIeS/39VndWeYZVIAJ2gAH4a769Mz7jPSQMxkODKMgu1Mcg2X1L//tAxPeACjTbOeewaskjmmb89gx5niHAo5HIYhNDPRE5w5RLIpGqd9XISSDXiysgrJ02YscmzZu6tUsrMzsqEQE4AAAbCaRYt/e1haenoXJUJKIqAtiN0GNkeYTlnU14Pvt9m6hGTh25UIhBt6dLhrc5fk04aURyWyFdzB6Wdnd2VkbDmAAAaYIlKf/VkS2J/47oahlG8SmoxNVZkULLq7RpaANMW7+cpmrGdMyD5R9PjG2dLTX/+0DE+oAKFMc355hzSSwW5rz0jajcrWxtboM54KG0dl+kz28JIjoAAAzKwbc7AwBcoG4YAsWFGgpCUD50tqNYuzcapSW0GYXjds/NVdVgutdbJNn10d/TrkrJcXdC+NTVhmV3d2U2g5gAAvhRw85xktRL+ObsCt0wucxFtf51SfupswBaVYbRhItv5C50RCtI0eWmFeD/lb/iEgjZLFkdbI5o4Eg5AAAW1dTemvz1zA2bKZ7kqP/7MMT9AAnMrzXnsGPJJZQmfMeM6XWG5K7rdI6NDQoHFIGFgkarxWjbgxwpvX8tCXICWklteFmt5P2m0UbmgIF4AMDaAnvyF1Nam94ZSBJcGIuxzZ6LRNydTdmMppVUy+RJTORJiPPO12/v/tiLDgdDQs3WytwBuStQ2EeVLPsloLsjwtCgYkwzuXDMIolXvJVLxvouPc7DPV11Nv/7MMT0gAikvTPnpGyBCpJl/PYgecfM+nmAQsYlhACTbMjgACeFrf62Jdwl+RSiSzocvYKBr10H0EEmTxAyhS+/jXT+ywSdUrMM1moACnZYfHbSLsuu9OhvZ5IHlwJqT++amhmVF5FQ5h7tW4kkb1FxrExBTUUzLjk5LjVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVgABVZAAA2v/7MMT0AAiQrzPmsMWI/pOltPGYWd7asmZQw9hUzyoJEKKFBRSnIwoFCFb1h///rGEgyRWIiqpMQU1FMy45OS41qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqkxBTUUzLjk5LjWqqqqqqqqqqv/7MMT1AAfckzHnsGXI8JKldMGWYaqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqv/7IMT7AEdIkyeMJMHAuhFksIAYSKqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqr/+xDE/QBF4JshhphpgJgP4+QQGCSqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqv/7EMTqgcPEbR0hAEFgKABjgBAABKqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq//sQxNYDwAAB/gAAACAAADSAAAAEqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqo=",
/* 29 50 Hi Tom 1    */ "D3":  "",
/* 30 51 ride        */ "Eb3": "data:audio/mp3;base64,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",
/* 31 52 stacker     */ "E3":  "data:audio/mp3;base64,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",
/* 32 53 ride bell   */ "F3":  "data:audio/mp3;base64,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",
/* 33 54*/ "Gb3": "",
/* 34 55*/ "G3":  "",
/* 35 56*/ "Ab3": "",
/* 36 57*/ "A3":  "",
/* 37 58*/ "Bb3": "",
/* 38 59*/ "B3":  "",
/* 39 60*/ "C4":  "",
/* 40 61*/ "Db4": "",
/* 41 62*/ "D4":  "",
/* 42 63*/ "Eb4": "",
/* 43 64*/ "E4":  "",
/* 44 65*/ "F4":  "",
/* 45 66*/ "Gb4": "",
/* 46 67*/ "G4":  "",
/* 47 68*/ "Ab4": "",
/* 48 69*/ "A4":  "",
/* 59 70*/ "Bb4": "",
/* 60 71*/ "B4":  "",
/* 51 72*/ "C5":  "",
/* 52 73*/ "Db5": "",
/* 53 74*/ "D5":  "",
/* 54 75*/ "Eb5": "",
/* 55 76 Metronome 1 count*/   "E5": "data:audio/mp3;base64,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",
/* 56 77 Metronome click*/     "F5":  "data:audio/mp3;base64,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",
/* 57 78 Metronome sub click*/ "Gb5": "",
/* 58 79*/ "G5":  "",
/* 59 80*/ "Ab5": "",
/* 60 81*/ "A5":  "",
/* 61 82*/ "Bb5": "",
/* 62 83*/ "B5":  "",
/* 63 84*/ "C6":  "",
/* 64 85*/ "Db6": "",
/* 65 86*/ "D6":  "",
/* 66 87*/ "Eb6": "",
/* 67 88*/ "E6":  "",
/* 68 89*/ "F6":  "",
/* 69 90*/ "Gb6": "",
/* 70 91*/ "G6":  "",
/* 71 92*/ "Ab6": "",
/* 72 93*/ "A6":  "",
/* 73 94*/ "Bb6": "",
/* 74 95*/ "B6":  "",
/* 75 96*/ "C7":  "",
/* 76 97*/ "Db7": "",
/* 77 98*/ "D7":  "",
/* 78 99*/ "Eb7": "",
/* 79 100*/"E7":  "",
/* 80 101*/"F7":  "",
/* 81 102*/"Gb7": "",
/* 82 103*/"G7": "",
/* 83 104 buzz roll */   "Ab7": "data:audio/mp3;base64,//uQxAAAAAAAAAAAAAAAAAAAAAAAWGluZwAAAA8AAAAhAAAhzAAQEBAgICAqKioyMjI4ODhAQEBISEhRUVFXV1dfX19nZ2dubm52dnZ+fn6GhoaMjIyVlZWbm5ujo6Orq6uysrK6urrAwMDHx8fNzc3V1dXc3Nzi4uLp6env7+/29vb8/Pz///8AAAA8TEFNRTMuOTlyBa8AAAAALFgAADUgJAWvQQABzAAAIcxqNd6bAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//ugxAAABrABVbQAACMsJ6p/NYAAYDb9e0isbm40TnygJn3ygPvUCBkH3iA54Jv5eIAwUBA5wQDESBjgh/5+XB9//wfP//UCDsEDELeoiEhmZlZppJXpfvvRDJsyiGHICgmMPI0YgsdsIRFTCnAa0AKONBQAIhqcyGZUDu21IOuhEnuy6yytVZsbMZQqefibxxd/IIas2z7wK7jSoYja6o+7k9BToyO86jvPk8sTi+MViEglcshuHaWQxbdd/ZmSROkxu3ZXnK71S85MVr4ZSiLU9JhYi+Uhrz1DcoLmE/dcmAZmrEre827SCG4YkNuV51K9qk/V/ONY1Leu9w+7+fMvr5537dJhvGuFTYsSBVam/4QWyXVAaFRTIhIABKvQRGXQndMESLIWTFz3hRvaTm5UONEnZmAiosHEjD+Oy0v2YNHzM+XrUUbp+3CvPTpeqRo7na0vqyVx0YVSGloEaiA/O9Pi6uLqQvD0SGCxxIf8kNltOrOx8OQjJzpiXDwqRFwczsZDTGPINHVxdETrQikuHyJolvWLCQlkpYtPMYlQeLNVRcvTLF7j60sks5KK4QFZQFgpXVK58nEtUTdOSYIHREIshOKTwmFpUJANzBIVHyoXdUNHh0jYRNPJUTpUHY1LR6mc65wftWmZD26maRIJdzADeM1DbCXkTwiJVFLWAabW6jM/IoCp//ugxHoAGn2jU/2GACHAKKw9hI2ZBkkQ9rTDE0T6cxqsARmBkQWf00LhlCMHlVqIfztQyeb8exzv0Hnm59yDSxVIs87DPzMj/+Fv2T98pPrdjJpoZgvbkFE55T4fbfCWs5X/7bpiuriWZTZIRKleAgqNXhQG8wWNJHpbPc3qwrc34jrb3JqX3KeQ+wpFBPov41WEmzX12qWPQV5/pvOvju/+kAN8c3TIcvHevmMaSU96tfDfSIrz7+fe29ml/75Mdz/3TB0ljs57m9KLVtdsZdR5lt+x7MjdQ8szESAQXMSIBTAsI4nIKZaB9E8GmFgRm50AXKkxhUyTHYDt28NFFjQqxE1JdTyRXPs1JTM1sySLzJY7gDx4Tz5BYW+noycbT3CoJ5iFmttW/7ffRLXtTRBwnW5t/Ng5gXYc37v1979pScOreIdTRkkgqVBg6DFlQykgulZqvaZYZ+lrQp+mWwI/EUAJNQKS0JOWgT8MnwlE2XdsOtRb5O5ErLdkrl2xj71K3fPdN6nXz2Js0kiJdlZjFRe56Sma3f181rdqurBEOezArxrFqZJg+0i0VXn3HTlNnUxMMxlGgSXMtgJHDIIOedJmSqbW1B2YTjIp6QiyMW42jItYST2eQtZhghtdiVzhBLOn+VzafRcU1xWWRm6BcfzJD+01SbHV7coNbX6hnWz//sQ9GNJe//twxNKADiUtX+wYcYmvE6v89g0pfqZ3IiOW2NKS0qRFnTOfw77HmS+PYA1jRu+A5VXUyomXVEiCRTuXmNsA04QRCL9OUkKudliQVG1VrcQaAIKSIMFQyjeu2ijFptUHCFm+b1Sy4tfPYEFPZTqEJ1QSdnbTJv3IjrR/dywQkXQxRIZofr7u5LCv3LTaFwy+xXLM28UVlXy6x/3NnSmTDrXw7yw+gt6mHRESJIKeixVM5uy4iAHTnKbrraAs5m0NO+677UJGHDlyEJwWjUxijQxcFk6ikQqQxuKTQhEKKtyYzo8zf4Psx7k1rp1WPvaI3YOkdK/393/6c/+Wdv2e/1c7++1JJSo8akgXjXlO5fpkvIynVUTKCUu2OiAW4GCGqCPmnRNMFWwj8qGCKQcaJlHB8g1ZFiHzTf/7YMT2AA4VOV/sGE/Bzq3r/ZSNsN21lR3omSLasxPnQgV4iJSeZ6F7ZL+8c2PEHXYz+vLPphHjE5AiyflDX1KK6hf3cnjxqvfSFhUL6OueKaCfsSdy/6//t2juZd4RDKIJKekACwAhChtCXdBKySA+nIxhc8qpvWDRhKxrjRGikGDjfG5daVmIrF0zZGbZ9nz+ua1jSItDmLIZ6LVJDjrIZrMQZ9Qrsxn9R3JZfpFd8isyPOUyyzhH31c/WT88/v/3LwmWRo5zEqsPjK0NRFalypqYVUbJBUvjxZAOlGVGJCU4lEcOcToiiNKJgOs6jVYHbXM87jZaBZUJQ3uAAlQOoWkSsf/7UMT7gA5ZM1/sJGzJrJJrvYMN0ZaHrXSE0mbevZ0leeWXN0lIsLKWFH5AZw4k4V9Shl1csi4rMeg99FAjZmZGzzJsjIEe7+mHMBZeLynxEIb3hO38dKqKmGVKyiFJtg1hqW19iBABxET59fSb7bStckUIB4IIiaaMyP6qx4PXbnaFwPAJHBNi0kTaPTgKCiMKyNa6vTTpqSrfQzy8oRFLWcMisez4Qi75GldTMQwJhAVQAcq0c4xvWdCuiNMlhxEK5ZpNtw0ZRaOqeoc0Nkj/+2DE6gANyPVf7CRsydYu6zzzDlgguaMktjC6NKCqZ0RZyu3VHWGBGCJcHJ4HNlqU2WswNN2ZcrrzTX0BEUJUSuIqh86kKeTPnsR+eVmenn4+ehn9p0dVzEpaIs5tlmVeYyGSH/2a67Ec6oPf9v7vW6XeCkYbtHv8B5CUr+Le2uSl3UXLIaYJBUysCHgKKVBpDhGUARiajkSJaGQQRFzqpGqarlWLEw8ZQIkMlhkJsFxhj7w3Ivro5qXyhoSMbL5MZxS/1zt8qGqE7ZGTUple9pdvLZtr/bR0Kg3WDr3/ax5/GnEvqgm3WTeJdra5m5mmZDaIILlUZIYkW1Y2ZJhRNKpkDJ3/+2DE8AAOwUtb7Dxjycqfqz2EjaCZtZaHBcNAICCBRYACQY5/FCp1nkxZ0ZDEYUoQe4ZLgyXMzX6FYnUUs3YTffM7nmXbfayiYgZoSKlc3xAZCqX5B+RzH5qBeNrHa5K7rmW6zGjvlta391KRMU0KhAoglSw6FCnwbNhZTWc0+JIqFK2DamnHilZY5gcnaRA3Y5C01OE7ynOBgEFKQUuEpPUVkaIjLyHTsuRoThZLuaIm/Yrw7a/Fuls/qxPP375G0//Mi3wU0hAZU1lwsLF3GzV5C+bemnK9nYhkNlAEuaGVDkxqO8FgPEFGP6XWWIoKNZYD0agREY0KReW0LbB2IDe6Wsr/+2DE84AOVStX7DBrSbElqvzxinnQiKpyopClQXB8rVLpuvH8rPMvWpuyqeVJSJ+ElqxW7fn/DqnztRyeaqp/x58VCnVzpFGtO/mR9HBUcD5Bhc5LkreN1Jucl2U2iUE5gB+dwGFSC4jzNUV9ThQThFoSB3k+UL1KMSpgKawaFE1lxuHYfLBFI5RFh1XciNcETk0fsiuPuq7tkRUoflSPufSIgYpG2zpXOm0PK2iL/Ujc+012+G/DyP9fNvVofzBws7p2YT0THtDeusdG5VJ7iodjGIghOWUCqw4U6hpG2drAL5d5kikXw1uLiuY1LJGVrej/LlAYEF0OFPZekhrXZnpf9df/+1DE/AANzMtT7BhtCaylqj2DDcjyd+jQYubmrfmR6ka5mZ65kQMDEqCUTgEXAANsCjaSwrpA8ULvfUAOLOYp8LJRvuNuFTVQymTRIKdyPAZRNciuiYF3JKT8NQSZKl+JSzvGJQsGFuRBdvzDfzySJ1gcxhdYUn5o7RW4jMMtPHqkZsUrQs+bfoxE53bFVgHNTFUMmWm+i7keLIk5kdnnvqaHDJ2CYrQ2sWv8llKuTINg4YzRRO2OvnbneTt/pZTK25ZkNokEuZ2GwA7Gsmwg//tgxOyADiFbU+wwasHWqyn88w4RadAkgEgFKIMikaW4u40cJyBGOWS+u7rjxBJDBEtojBMsSqRk7ZoPc1pHW94Jp9Q+MGJzk+kzbjY8xFkRF2O4+yoFTeSqm2UL7K/yrlG+RP+t8Jo4wWY0sY12v0SE/kJF1lMyk2QSncpohJEY3XVrZY/iQLOGVsERUXG7L7AFOA2iONE+MIVc8x1FKHkIRlHDDCrnatX6TFGh/RpVhZKiZQpkpSeluYkiE/WdMxWcpZIRdI1Iz/P/KZfS3nOdE3OocCwMJ1+i6y8yc1Ev/f+qjaqhmsi3RUkKAUvLEByJlONA26gqw0jmiFYC4oAwI5PH//tgxPEADOzRTewwasHkrOn88w4Z+sS9PZaVNG5EcUYKdQKjDFZ3UrtRwNSFuIq1M/Y6mr0rSzpz/72nkqxwwvfYpnK2SiyjF+Skfl9pT3+xeii4R9RFbhledBKZsaCigcYY2MUGEnFo/09hqupl1RI0QCpR6gVoDSwo8JSiwkAs5TkGJKvpYlkhvoQ2uniwYc9kbaN554o87aVvlLC2xMiZutj76LWIYge04RFmsPun/nS6uvXUYTCxFKTjXzqSLX/HKGoeJRxwCwFrFyj1jRY6BTKgL9WFrZmIQjIJALVWYc3CdICQiVWT0FSP+X1xaD7vtLcuDMUkkQVyyEJmI2kSG8KG//tQxPiADeTHT+ekbInIKKn9hI2RZj8VAEEGiCiRo6RxKugqnhX7zmS3qlMqegLiU5TRFQ6Z9XK0ju5I5tvzYsZJqucYtrn/+d3Mz8//6OTYv4CHzK42qOya+24eNmphkJpFBu6ulYYRPoprAN4vfpZTlr9fVnTlKCE9o6IlhKKEzpvFgCLMg/GyGOMNQ0HJdOrbY+djCA2K+uIqXnnMy//1Iei0YS+aKkNzWU/vpfRP3+Fn+fA8KIHVvADK/AZJVs/r7sO9n33cb7W1hLuruP/7YMTlAA6pZ0/nsGrJrpmpvPMOIFc4iQk72QCJSE+fSpZEtt/F8MNUGXXAUBNAxgCeg0PQSSgGXE3DUSB5aepQLYvHP+xie90pFO+hxul05Sp9XJYuQlYe82aCSe9j3+nsxHS/4f///Qoh0IouXJZTIsn/bFqQJD5Afe4GucN5ZiV+3Kq6IVjNMEApxCAHIGdGAvHKJGJ8QgFSli1aDdJO4OCbfKhO36JzpWbNIy8J1fHlOqYp8uHzMPqxSujBV+O5rSzPWnz0lBl2d3mCBc2MBppPGB5RAg53jbizVseu0curY5fYeVCryIhVJskhOZiCEj16FaMxEh8hAiKPAxidI5FKNP/7YMTsgA6ZXUfsGG6JvyVpvYSNiV0e40qyYdtj7ScIOV3Uonh1kjBB1NS1pUTe3aGqkp2AZG0uV51T9iMyhwlDqwucM31PKlluh5/9lMp3jHPY+lP/KTJvs352j+NiqCaDK/5jmoaV+qirJmGVCSJIKmAdgE8KiOA6luEMCTkgGWTZmFhJF5ESoC0txF0wWaw6DAIrFwZW0qWqhkrlja5w2XFCUHIWlEE6A5iJOGSYMa/6YG46j+T29/tXcX8469//n4za7pJwDqvQzzsNVdqI1te48Kt2r1p+KoS/mZhUVkhBSWqScGB3wyLkhaAOTGVSOe67Bmyv2AZcfY0+GxADIQwfUP/7YMTyAA5Jb03sGG7JjhmpPPMOGGpMKmpJ6Wr1SRJv9vCv+JHerm70otUzbqTpZZYLLBIy0y5guocOAgGMkkggxsQuULp0WnkcD3j6ElkjLfehj25qWhUKbQTmphxSEyVFrEsoCROuLDo4SkMDFsrrzxg+KhW1lWd51GX9b9r1bl5WPsInAi/rPp+SjWFAgwJD3g6DEoRPsJbQRDYiDgiFDK4DKAi5pxBC0a5t0SuFWP1O9QmDwnTRU4FB4qT76nO7iYpURkgFO6yheCl0w8KVStWqUspi6vB/GRQHYEiQpVlY9PGYG2rXod3IMCi6FvncpKTvMtl2OF+f8z8yIs8pWNzPKv/7UMT/AA5JW0nnmHDJw5Oo/PYNWU93COH8I7w5InHQifUypl9/LWdK/k4rTE4HgGd/2o0Z4GQAnYFkSk157f3/iMkXESzMaaTCcylA2gmI4ubm1BDVoZRKjJPEuJtJRdQEiWiAc0xCdpeXk2zdvC7i0nee/PdWTm+Tr8a+Zg6/vyYSQT9Vzb5Mzl4VwwMJKS08PemI8SCiBe1YrKzBDe5cokQnLmMXJF1lKmx9VaWdi5dENEEBN0vOVYgd9Ig9Li3SXkWZ/Di+32f5dENU8Hz/+2DE6oAM+MlJ7CRsQbIQqT2GGVDQpE0hAnaPQXMzCSEjKC3Ed0JMHinOvaKfGTyItc+suUPzzseEiGeu5ZpqG3/vdfaTZdJT9W5e/dX09TOc/I9/mX8qjWw77RliC+9b/TXJWJu4dURkkEqUFWBqgEUYAQM0UW44RWE2S6pyVo/pwZNXKzS03h96r7mq5Mg7GZbBVQOsBCptlsIirkDZjeGpzjWbF2MwckJU8iSq1ge2wHNnUWcGO5/6f975uVgiuiLvO2Rd69E32xt3sn/6J//jk2qIfKuqRUiIJLucQDECZTwbqtJCSUbpPhCBcyxJV6cyVSNtPGHCpWVLH3Z6/ma74cb/+1DE+AAOPStH7DBrCa4aKTzzDfgKoilrJ7mCoR0nekWZStLAW6tC0M8+O0vnHpHkLcitdf02W8hNNNNu26XVwyqag35HP7Zuc/0S9+5WF+DeeK/u5iMq5ZzNEglOWGTBzOapDBmcelbI46sOwFn4ewk0s2Ukvy4hUKW69EQQAlQRkO2xcYXRLGRmFhX06tK4TSAsjC7gkhzI0anCKlGf4pmicUyOQPvadePTi5NDwnAIZSGQqhNlws1AiNCir3xdsQ0MTZS7uaeFSAlFSVhI//tgxOaADhFhQ+wYbsnDmig89g2ZiwFSvQvJY8UeZ1k01HmWwEzeuRrJmi8FjEp17K7jYMOhNC/yUhUJ5ByRYe0ZpDehclCDBdDybmZd+KZ/fqF0WJIilte+5+90acKj/KvmE75ep+tv+1P0z65zSv7Jz5S8ZdL15ISeZeFVTVUa3gfID6jAvmpAwlWJKU6uofhIQwsCxI8YNqEpjpWU7xElgcQrC2VMOlPUpGBCou1zyH4FYDFC+GEvfLdBOBa3LDLLsutBl+mZDkN5bfuez+Psvx//f374/+/+eyrueJy93WFohXZjHlBpEmBxCFrwPdrLEfJfgZRRMxJixqA6XT1tzhMt//tgxO2ADgkvQ+eMVwm9nSg9lg1YENN6znrQokRLPDGzf8HxDwgO59PZRzTvzCww8keGOJCUo04ABzg+E4qaOg0TPn5o+RIkgSS+PHrUzuFqzoQZjtnT3XaYSqqpdEORq/UcFYkiqEMUyaLOO5abd1ZzSWXTAWVDHPQIT8WF6cvrKZiSzU4Z1elyFm4+Kd8+UjOORW5UxRdONPST2cJrUWAhQPk2BlB4YNcOAR+fijplVVlqWWlLNK1VXP/SU5iXhkEdEarAqBFIwyRCjM3LHtUCdptmTu5DQUcAqyJMU9FPKvVZIYzlYfTqAiRTfJX9nBUw1RGcYqFs6ZWcl+xGXRrTyBRj//tQxPWADejTP+wwbImjEeb49I2RGMQh0FQC4PhIqARpJIj3mSTVuXAzOhNaE4886MGrVc7Q5u8xDshiqUrUio0ZVPN/U7acZKcHS0ORYA2DUmKyCVi18Zy9FBZqRHSW9s8c9yBtSp2EMTV+NkdU9s8zZzI/Rizkes3h7D45IslEOaAIACTiSjhkVLuEpd0lftc5VPb9l/oqMXd3llE6VRguAEwB1wX5KKWOX04EiaApJLxNniqQYtkiVWxRNlGkVaxzWI6inKuQoxhN/cLl6//7YMTnAAzwhTXHpM4BjZnneYSNmO008MUhxZSOGW/FJuszSlciKlxE//5mZ+wxMBBxsPNHnS9pweNFQ4gys09Xb9H4tbUoQ0vEspd0gLKDeGFmc485Ug/omUYBwkEhSQNiQwlhlEq0NGLsB0iOGWsioxuecqbUzHhYJwuTmZ1IpmpDNRu4JZsNVTQVN7Auv/6mJghznv6J+nC02t/c31vWZW5tz7u/l/x+ej8aUGiHiGZI24kkXMKCGb/shic0PrZdMERyHQ7oCV1OdeuM2smMyas409utCrG0z9MiJZnpd6CIz1SiybrigfFBc+LCFo1zlzYDI3NHNa1R4xG5UVjFOqTt/f/7UMT5gA0cyzXMJG0BiZxmeYYNIBWrv/6lGWhnhmS6OJNALkb4B9dFD1Q9MpzPtM7yRRH4snCQpA9Eoo6U83HVGImPDyolibD1Sj+8IlM+KRzeSk+9J1LmS36Zhywrg0CDwAKPCaBZhZLpIShoQjgyehsV0WESTx9f6GtdbbZHESAAw1QELPqO9KVSpEIXtKLi+mzsriX0zSSJJqduqMFSjyy7dpCHPNoOZgqVHEkKMsWcIhBCWhIUEYsPQIyRx7Xuaea/WXLsMmGBw+SsYoT/+1DE8QANBQEvx5hugZmVprj0jR2vkm0O2dKlKresj0tRQ+ljvfbaWNpEoCqCECTVTEbeRpCRurOSIC490hQ2d1jdUzKIAmh12qIJYAEmw0FB6VhQep6HhUG0Co8PvNz6Dj6SDA4Bx+ebUVmYXPNdYgsKHmKoQF1Ob+3o/2JqgHhniGdrda0mjmAB4ts6BolJWLYmhkcEonimRkYClZRcIRke7K+Vc/JdE4nEIPGaVaN1M6bCL/XmbbwWFhYPqLPUKBRoQMuKVIWw3TeNU+1B//tQxOcAC5CfM+ewY8GGGKY88w3goylAjqJhxixCt1Yuy27ZtYZtI6cN7f/rZG0SjbMgUE3421VVks/Qk8hAMmiqxVAxe+ZSCoYNFRTamWUplKsIiNPOl5lTVSTlTHrL6WkMCxIyBh5BFinPSbNNAaTzRZnG4UhS0CZ56sUu60/QvUqibX/7W2NEkj+EFCG1bRQn1+SkRgKQHEgg5oXRNKt9ko+rtsa3mbQZt6Rh0QFBGAUqHA00yaARaLYoTFRho4fEQgMn5OAH31yqdFq1nP/7YMTlgAyAcyusJGXBaQsl9PSMuHHWNGceSs6gAWpsOUNV1ffBMqozuyWNooECAh+EZQSONW94LXuwRIUADREZ1ZI6hn6yWdsixnYjuqMKwpEhFVs/YqWtsBfaRGULpsj3OFCzyzUpwXDFGFMiNMSCWhCbPXHKVUxeIHIDwA3f2+zc23Tdgzt2+trbRJLsCMSavkx74nJi9YIbLzNqCcTZAkH+GXAenzJtcNNQdEnmb/u3Gy8MxzP+11Lqg/QVcbNHwOODwoUDDFAkYD0SiJ11b3g407fUai5KiXQwB2PbOmLVKteOnoXe8d9b1U6W3a2SIgkgl4DOAZaS7NTD27jINU88MP/7UMT+AAyYmzPnpMNBaRYl9YSMuMLPIoMHlnQZdnH3RJtuQNGEQ+xS3IyWRO9knKREcsyLRpJLJft1+uZBxMXDaVj2jnngiIBDFhhQWPgSsMXhG55nJC/91vs77cLrLdtG0SCQB6EnAyzzsLxGFGayS/SINWosRFJYKooEU1Ci3pMjKs7L1TEV3Pk0qSXWwvydiU3pp9sg/vV41us9Me2zvvDyIzYhk4YQcoOd6mGKaU66nN//6a/739/m//Nc0f/s969t0ubkSJACZABqaST/+1DE/AALpGsvp6DCgYMa5b2EjPi53nOZZqKR2IslXgyMJkRSamCaU0QrSDCgSsxlIcCgaf7avOEvMq6gjZITxk1KpyoTonbyZeufoDQmPJvaVb7i9sXS87V2AAgnSvzd9zV9ttS6Va9rddd7o0igUAChgcmWT1iau2Me7bgVZG/DASpqbMtdwtDpJP4V7SKswhsMEE5KvK1jsoaOdsx2cklJLdu+p9IHUjQeCQMh8NngoC71SvMP31KBZbGEVkATqJ+t3X7v9WGle222aRBI//tQxPqADNyZLawkw4GAmmV09Al4LeiylfaqS/ukT8lpECIcCMKMC/iDBmKgwWKZ0aDATB49xUV+w7vvVzuTF675mommyCDgDhGB9KI4i0hRaGVKUxoIpJOTfU0o6mljP6KezU8fmemBZURmZ1tjRJITHMTxYOVFSVtwjhHTWJEjaOXDZK+1sQNaMPaoYEWKY0HYnFG2GNLoQ2wYsoZEZEioE5gSKioSHnrg2eDIAYfUYrxo9wss0hiJO5c/y7dXec/+inLUQ/W66qNtBFA9Qf/7UMT0gAy4ayunmGeJfhzldYMMsPAGZDwEQK8lhXKxoVTKqla+isVWGRSvFyyR4B5GQFWCxtrHX2NcqphWNZYcdmpN7G1jlyr+by1bMZwoCdWCyjR4NFoK71nfJSQdSVW4keOyxJ///zv1gFVMQU1FMy45OS41VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVMQU1FMy45OS41VVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVX/+1DE7wAMBMUvrBhrwWuT5bWDDLhVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV//tQxO8AC8R/LewkZcGEmeU08YpoVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVf/7EMTWA8AAAf4AAAAgAAA0gAAABFVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVV",
/* 84 105 cow bell */    "A7":  "data:audio/mp3;base64,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",
/* 85 Rim click */       "Bb7": "data:audio/mp3;base64,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",
/* 86 107 flam */        "B7":  "data:audio/mp3;base64,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",
/* 87 108 hh accent */   "C8":  "data:audio/mp3;base64,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"

};