# tutorial2

## Summary

This tutorial introduces you to the use of computer networks for sharing data for drawing.

This tutorial only pre-requisite is tutorial0.md

## Concepts

In this tutorial, two different computers will be used:

### Sender computer

We draw on this computer and send the drawing.

### Receiver computer

We receive the drawing on this computer.

### Canvas

The canvas is a graphics environment on the sender or receiver computer where we draw.

The canvas has a dimension of 256 x 256 pixels.

The canvas has a white background.

### Drawing

The drawing is made on the sender computer by clicking and dragging the mouse.

The drawing is a line with the following features:

* Black stroke
* 1 pixel stroke width
* 256 vertices maximum
* Older vertices get deleted to make space for newer vertices

## Installation

The sender computer must have Processing installed, which is available at [https://processing.org/](https://processing.org/).

The receiver computer must have openFrameworks installed, which is available at [https://openframeworks.cc/](https://openframeworks.cc/).

## Setup

Follow this instructions in this order:

* Receiver computer: follows the instructions on tutorial0 for port forwarding.
* Receiver computer: shares its public IP address and target port with the sender computer.
* Receiver computer: runs the openFrameworks code.
* Sender computer: runs the Processing code and draws.



## Processing

ArrayList

PVector

## openFrameworks

ofPolyline

vertices



### Parameters


* posX: horizontal position of circle center
* posY: vertical position of circle center
* diameter: size of the circle
* colorR: red amount of fill color
* colorG: green amount of fill color
* colorB: blue amount of fill color

## Drawn documentation

![00.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/00.jpg "00.jpg") 

![01.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/01.jpg "01.jpg") 

![02.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/02.jpg "02.jpg") 

![03.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/03.jpg "03.jpg") 

![04.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/04.jpg "04.jpg") 

![05.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/05.jpg "05.jpg") 

![06.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/06.jpg "06.jpg") 

![07.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/07.jpg "07.jpg") 

![08.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/08.jpg "08.jpg") 

![09.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/09.jpg "09.jpg") 

![10.jpg](https://github.com/montoyamoraga/localhost-for-arts/raw/master/docs/10.jpg "10.jpg")
