# Cutter: A free and open-source reverse engineering platform

Cutter is a reverse engineering platform based on the QEMU emulator and the Capstone disassembly engine. It provides a graphical user interface for various binary analysis tasks.

## Key Features

- Disassembly and code navigation
- Cross-references and call graph visualization
- Debugging support
- Scripting and plugin system
- Supports multiple file formats (ELF, PE, Mach-O, etc.)

## Usage

To get started with Cutter, follow these steps:

1. Download and install Cutter from the official website: https://cutter.re/downloads.html
2. Launch Cutter and open a binary file using the "Open File" option.
3. Explore the various panels and views within the Cutter interface, such as the disassembly view, the functions list, the imports/exports view, and the hexdump.
4. Use the navigation and analysis tools to explore the binary, follow control flow, and identify interesting functionalities.
5. Utilize the scripting and plugin system to automate tasks or extend Cutter's functionality.

## Cheatsheet

| Action | Shortcut |
| --- | --- |
| Open file | Ctrl+O |
| Save session | Ctrl+S |
| Disassembly view | Ctrl+D |
| Hexdump view | Ctrl+H |
| Functions list | Ctrl+F |
| Imports/Exports | Ctrl+I |
| Search for a symbol | Ctrl+F |
| Follow cross-references | Ctrl+X |
| Go to address | Ctrl+G |
| Debug binary | Ctrl+P |
| Script editor | Ctrl+R |
| Plugin manager | Ctrl+M |

For more detailed information and usage examples, please refer to the Cutter documentation: https://cutter.re/docs/