# Contributing to Reversing Bits Cheatsheets

Thank you for considering contributing to **Reversing Bits Cheatsheets**! Your contributions help improve these resources for everyone involved in assembly programming and reverse engineering. Here's how you can contribute:

## Guidelines

### Code of Conduct

Please read our [Code of Conduct](CODE_OF_CONDUCT.md) to keep our community approachable and respectful.

### Issues

- **Reporting Bugs**: Use the issue tracker to report bugs or unexpected behavior. Before creating an issue, please check if it has already been reported.
- **Feature Requests**: If you have ideas for new tools or features to include, or suggestions for improvement, you can open an issue with the label `enhancement`.

### Pull Requests

- **Fixing Bugs**: If you're addressing a bug, please reference the issue in your pull request.
- **Adding Features**: For new features, please discuss them in an issue before implementing to ensure they align with the project's goals.
- **Documentation**: Contributions to documentation are always welcome. If you've found a typo, or if you think something can be explained better, feel free to make the changes and submit them.

### How to Contribute

1. **Fork the Repository**: Fork this repository to your own GitHub account.

2. **Clone Your Fork**: Clone your fork to your local machine.

    ```bash
    git clone git@github.com:yourusername/reversingBits.git
    ```

3. **Create a Branch**: Create a new branch for your changes. 

    ```bash
    git checkout -b feature/your-feature-name
    ```

4. **Make Your Changes**: Edit the files or add new content as necessary. 

5. **Commit Your Changes**: Commit your changes to your branch. 

    ```bash
    git add path/to/your/changed/file
    git commit -m "A descriptive commit message"
    ```

6. **Push to GitHub**: Push your branch to your fork on GitHub.

    ```bash
    git push origin feature/your-feature-name
    ```

7. **Open a Pull Request**: Go to the original repository on GitHub and click on 'New pull request'. Select your fork and branch to start the pull request process.

### Pull Request Checklist

- Ensure your code follows the project's coding standards.
- Make sure your pull request has a clear title and description.
- If you've added new functionality, please include documentation or update existing documentation.
- Include appropriate tests if applicable.

### Style Guidelines

- **Markdown Style**: Use proper Markdown formatting. Ensure your markdown is clean and readable. Tools like [Markdownlint](https://github.com/markdownlint/markdownlint) can help.
- **Commit Messages**: Write clear, concise commit messages following the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) format where possible.

### Community

Join our community for discussions, support, and to collaborate on features:
- **GitHub Discussions**: Use this for general discussions or to ask questions about contributing.
- **Issues**: Use this for bug reports, feature requests, or any changes to the repository.

### License

By contributing to this project, you agree that your contributions will be licensed under the repository's [MIT License](LICENSE.md).

---

Thank you for your interest in helping to improve this project. Every contribution, big or small, makes a difference!
