/*
 * Copyright (c) 2009, Martin Rosekeit
 * Copyright (c) 2009-2010, Fabian Greif
 * Copyright (c) 2012-2013, 2017-2018, Niklas Hauser
 *
 * This file is part of the modm project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
// ----------------------------------------------------------------------------

#ifndef MESSAGE_HPP
#define MESSAGE_HPP

#include <modm/communication/xpcc.hpp>

/// @ingroup modm_test_test_communication_xpcc
struct Message
{
	Message(const xpcc::Header& header, const modm::SmartPointer& payload) :
		header(header), payload(payload)
	{
	}

	bool
	operator == (const Message& other) {
		return ((header == other.header) && (payload == other.payload));
	}

	xpcc::Header header;
	modm::SmartPointer payload;
};

#endif
