/*
 * Copyright (c) 2016, Sascha Schade
 *
 * This file is part of the modm project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
// ----------------------------------------------------------------------------

#ifndef ADNS_9800_SROM_A5_HPP
#define ADNS_9800_SROM_A5_HPP

static constexpr uint16_t firmware_length = 3070;

static constexpr uint8_t firmware_data[firmware_length] =
{
0x03, 0xa5, 0x6d, 0x12, 0x65, 0x99, 0x1e, 0xbe, 0xdf, 0x1c, 0xb8, 0xf2, 0x47, 0x0c, 0x9a, 0x97,
0x8d, 0x79, 0x51, 0x01, 0x8e, 0x81, 0x8a, 0x8e, 0x93, 0xbe, 0xdf, 0x3c, 0xdb, 0x34, 0xea, 0x56,
0x2e, 0xde, 0x1f, 0x9d, 0xb8, 0xf2, 0x41, 0xea, 0x50, 0x3b, 0xe3, 0x4e, 0x1e, 0xbe, 0xdf, 0x1d,
0xb8, 0xd3, 0x05, 0x88, 0x73, 0x41, 0x08, 0x92, 0xa6, 0xce, 0x1e, 0xbe, 0xf4, 0x7e, 0x54, 0x1d,
0xb8, 0xf2, 0x66, 0x2f, 0xdc, 0x1b, 0x95, 0xa8, 0xb3, 0xe4, 0x2b, 0xb5, 0xe8, 0x52, 0x26, 0xce,
0xff, 0x5d, 0x38, 0xf2, 0x66, 0x4e, 0xfd, 0x97, 0x77, 0x19, 0x50, 0xa3, 0x4d, 0x2a, 0xe9, 0xcc,
0xb2, 0xb5, 0x99, 0x42, 0xcb, 0xd1, 0xf6, 0x72, 0x55, 0x02, 0x79, 0xdb, 0xcb, 0x63, 0x50, 0x4a,
0x88, 0x16, 0x87, 0x94, 0x74, 0x13, 0xec, 0x5c, 0x06, 0x56, 0x58, 0xb5, 0x0f, 0x5a, 0x6f, 0x4f,
0x4c, 0x9f, 0x16, 0xbe, 0x6b, 0x34, 0x34, 0xae, 0x67, 0xd9, 0xb0, 0x49, 0x8e, 0xd4, 0xf4, 0xc5,
0x89, 0x53, 0x19, 0x59, 0x67, 0xd7, 0x01, 0x6f, 0x45, 0xc5, 0x02, 0xf4, 0x0a, 0x43, 0xcf, 0x8d,
0xed, 0xf8, 0xa0, 0xf4, 0x5c, 0x0a, 0xec, 0xfa, 0x49, 0x58, 0xb9, 0x04, 0x29, 0x0b, 0xcf, 0x5b,
0xaf, 0xac, 0x89, 0x28, 0x8e, 0x98, 0x44, 0x07, 0x38, 0xaa, 0x00, 0x1f, 0xfd, 0x66, 0x92, 0x72,
0x4f, 0xb4, 0xcd, 0x61, 0xac, 0xb7, 0xdc, 0x95, 0x0a, 0xa6, 0x7b, 0x60, 0x53, 0x1c, 0xf6, 0x5e,
0x07, 0x73, 0x2e, 0x4d, 0x98, 0x75, 0xa2, 0x37, 0xde, 0xb7, 0x53, 0x5a, 0x33, 0x0b, 0x65, 0x4b,
0x42, 0x66, 0x3f, 0xd9, 0xa3, 0xd3, 0x0d, 0x38, 0x3f, 0x26, 0x3a, 0xea, 0x74, 0x19, 0x63, 0x35,
0xba, 0xc6, 0x98, 0xf7, 0x3e, 0x57, 0xae, 0xdd, 0x6d, 0x0b, 0xc2, 0x1e, 0x83, 0x52, 0x1d, 0x38,
0x20, 0x94, 0x1f, 0x57, 0xb8, 0x3d, 0x2d, 0xc4, 0xe2, 0x25, 0x49, 0x0e, 0xd6, 0xc4, 0x1f, 0xd8,
0xe7, 0xd2, 0x92, 0x75, 0x5d, 0x07, 0xd7, 0x56, 0x8b, 0xac, 0x4f, 0xec, 0x1b, 0x1d, 0x45, 0x05,
0xc0, 0x80, 0xe0, 0xe9, 0x24, 0x27, 0x90, 0xc9, 0x13, 0x24, 0x2f, 0xa3, 0x3e, 0x5c, 0x5c, 0xe2,
0x57, 0xce, 0x11, 0x46, 0x53, 0x11, 0x1d, 0x9d, 0x8b, 0x76, 0x79, 0xda, 0x1c, 0x39, 0x71, 0x93,
0x92, 0x96, 0x83, 0xad, 0xb4, 0x60, 0xe2, 0x71, 0x2c, 0xaf, 0xb4, 0xb4, 0xab, 0x2a, 0xb4, 0xfe,
0x36, 0xf7, 0xae, 0x2e, 0xef, 0x77, 0x29, 0xf9, 0x71, 0xdf, 0xe3, 0xb4, 0x0f, 0x7e, 0x2b, 0x1d,
0x2f, 0xed, 0x68, 0xee, 0x3b, 0xcf, 0xb8, 0x70, 0xee, 0x34, 0xc9, 0x45, 0x85, 0xe0, 0x83, 0xb4,
0x9f, 0xa8, 0x37, 0xee, 0x58, 0x68, 0xb4, 0xae, 0x52, 0x8c, 0xb9, 0x44, 0x87, 0xc5, 0x49, 0x20,
0x06, 0x2d, 0x01, 0x1c, 0x25, 0xd2, 0x02, 0xfc, 0xa3, 0xd2, 0x9c, 0x8e, 0xfd, 0xa8, 0x5d, 0x9c,
0xeb, 0xcc, 0xa7, 0xd0, 0x3b, 0x9c, 0x4a, 0xcd, 0xce, 0x9c, 0x58, 0xb5, 0xa8, 0x21, 0x00, 0x13,
0xec, 0xc3, 0x30, 0x20, 0xb6, 0xa6, 0x37, 0xed, 0xf1, 0x10, 0x18, 0xc8, 0x82, 0x97, 0x3a, 0xe6,
0x7e, 0xac, 0xb7, 0xc7, 0x4e, 0x15, 0x98, 0x04, 0xfb, 0xa5, 0x58, 0x6c, 0x6a, 0xdf, 0x71, 0x5b,
0x85, 0x01, 0x6d, 0x13, 0xa6, 0xba, 0x7b, 0x5c, 0x1a, 0xa7, 0x79, 0x45, 0xed, 0xbb, 0x57, 0x6c,
0x5e, 0xd2, 0x39, 0x4e, 0xd9, 0xf4, 0x08, 0x75, 0x6a, 0xaa, 0x3f, 0x7f, 0x99, 0x33, 0x81, 0xbb,
0x42, 0x81, 0x0c, 0xf0, 0x41, 0x55, 0x84, 0xc3, 0x45, 0x38, 0x87, 0x7b, 0xb4, 0xea, 0xd0, 0x83,
0x6f, 0xac, 0xe4, 0x34, 0x4c, 0x9e, 0xde, 0xdd, 0xb8, 0x0a, 0x7f, 0x1c, 0x5b, 0xb5, 0x58, 0x11,
0x6c, 0x67, 0x4f, 0x33, 0x48, 0x03, 0xd0, 0x2e, 0xbd, 0xaf, 0x1c, 0xe9, 0xd6, 0x9a, 0xfc, 0xdb,
0x11, 0x42, 0x89, 0xf2, 0xcf, 0x53, 0x41, 0x00, 0xab, 0xc8, 0x13, 0x4f, 0xd1, 0x10, 0xd7, 0x20,
0xa1, 0xb6, 0xcf, 0x4f, 0x9a, 0xe3, 0xef, 0xdc, 0x30, 0x3d, 0xb7, 0x4e, 0xd6, 0x00, 0x36, 0xde,
0x48, 0x21, 0xf1, 0xf6, 0x5b, 0x04, 0x15, 0x1b, 0xa8, 0x6f, 0xfb, 0x9f, 0xf3, 0xff, 0x06, 0x1e,
0xef, 0xeb, 0x84, 0xba, 0x45, 0xc5, 0x58, 0x68, 0xc0, 0x8f, 0x10, 0x08, 0xb1, 0xb5, 0x65, 0x01,
0xc1, 0x11, 0xd5, 0x3c, 0x1f, 0x3e, 0xb8, 0x28, 0x62, 0xcd, 0x94, 0xe1, 0x63, 0x11, 0x2d, 0x91,
0x80, 0xb2, 0x93, 0x93, 0x64, 0xab, 0x52, 0x66, 0x47, 0x1b, 0x70, 0x21, 0x43, 0x74, 0xcb, 0x1c,
0x6f, 0xa9, 0xb2, 0x06, 0xfe, 0xdf, 0x12, 0x5c, 0xdf, 0x7d, 0x9e, 0xce, 0x9e, 0xb0, 0x1a, 0x62,
0x26, 0x4b, 0x64, 0xeb, 0x5c, 0xef, 0x88, 0xa4, 0xd1, 0x86, 0xb7, 0x0a, 0xa0, 0x2e, 0xee, 0x4a,
0x70, 0x95, 0xed, 0xc4, 0x3d, 0x3c, 0x50, 0x83, 0x8a, 0x8f, 0xc2, 0x2c, 0xcd, 0x22, 0x81, 0xdf,
0x35, 0xde, 0x12, 0xf7, 0x59, 0x96, 0x78, 0xd4, 0x72, 0x91, 0xe6, 0xe0, 0xc2, 0xe1, 0xc9, 0x2c,
0x81, 0x47, 0x50, 0x5c, 0xec, 0x1f, 0x1f, 0xcc, 0xac, 0xbd, 0x69, 0xd5, 0xa3, 0x35, 0x3c, 0x9a,
0xf2, 0x9a, 0x63, 0x27, 0x1b, 0x4c, 0x92, 0x87, 0x0c, 0x77, 0x90, 0x02, 0x0d, 0x5c, 0x9b, 0xbc,
0x2f, 0xe9, 0x66, 0x7f, 0xb2, 0x4a, 0x26, 0x99, 0x90, 0x74, 0xa5, 0x91, 0xfa, 0xa4, 0x6d, 0x8e,
0xf4, 0x2a, 0xab, 0x0a, 0xbf, 0x3e, 0xc8, 0x33, 0x29, 0xe0, 0x15, 0x88, 0x44, 0x85, 0xd1, 0x7a,
0xa7, 0x6d, 0x8e, 0xd5, 0xe8, 0x2f, 0x23, 0xa7, 0x75, 0xc9, 0xff, 0xb5, 0x4a, 0xa0, 0x93, 0xe4,
0x23, 0x20, 0xa0, 0x95, 0xb9, 0x30, 0xc1, 0x11, 0x82, 0x30, 0x92, 0xe6, 0x23, 0x28, 0x31, 0x34,
0x2a, 0xbb, 0x29, 0x81, 0x6e, 0xb3, 0x24, 0xa8, 0x51, 0xc5, 0x11, 0x30, 0xe5, 0xb5, 0x49, 0xf3,
0xa5, 0xed, 0xa0, 0xb2, 0x26, 0xaf, 0x59, 0x0e, 0xe0, 0x05, 0xd6, 0x03, 0xb2, 0x26, 0xac, 0x38,
0x8c, 0x15, 0xe8, 0x31, 0x21, 0x9e, 0x23, 0x28, 0xbd, 0x29, 0xe8, 0x5e, 0x0e, 0x86, 0xe5, 0xe9,
0x3d, 0x90, 0x2a, 0x45, 0xca, 0xb6, 0x97, 0x0d, 0x77, 0x84, 0xc9, 0xa6, 0xbe, 0x3e, 0xd7, 0xc8,
0x51, 0x96, 0x6c, 0x4d, 0x39, 0x11, 0xce, 0x35, 0x34, 0x54, 0xc1, 0x65, 0xc9, 0xfb, 0x80, 0x16,
0xf8, 0x9f, 0x5e, 0x33, 0x36, 0x5e, 0xfe, 0x9f, 0x17, 0xa6, 0x03, 0x6f, 0x13, 0xb3, 0x79, 0x5b,
0xfb, 0x18, 0x9e, 0x5d, 0x6a, 0x71, 0x36, 0x9d, 0xc8, 0x05, 0xbf, 0xe7, 0x6c, 0xde, 0x97, 0x0c,
0x4e, 0x00, 0x62, 0xc7, 0x5d, 0x98, 0xb5, 0xd0, 0x8e, 0xe6, 0x3e, 0x3f, 0xdb, 0xab, 0xa4, 0x6a,
0x5c, 0xce, 0xeb, 0xe2, 0xc8, 0xa6, 0x1c, 0x76, 0x23, 0xea, 0x1d, 0x25, 0xa4, 0x7b, 0x7b, 0xa7,
0xf1, 0xfa, 0x40, 0x7a, 0x54, 0xf4, 0x00, 0x29, 0xcb, 0x22, 0xa8, 0xe8, 0x52, 0xc7, 0xa7, 0x91,
0x50, 0x4c, 0x9b, 0xe2, 0x2b, 0xeb, 0xbb, 0x90, 0x63, 0x06, 0x08, 0x9d, 0x4c, 0x66, 0xba, 0x92,
0xa7, 0x0a, 0xef, 0xc5, 0x49, 0xb0, 0xfe, 0x05, 0xb7, 0xa7, 0x9f, 0x4b, 0xda, 0xe4, 0xd0, 0x2a,
0x26, 0x1d, 0x78, 0x82, 0xc3, 0x85, 0x54, 0xb0, 0x57, 0xfb, 0x9b, 0xc4, 0x8b, 0x48, 0xa9, 0x44,
0x78, 0xf4, 0x42, 0x06, 0x0f, 0x59, 0xb9, 0x10, 0x00, 0x87, 0x4d, 0xf8, 0x7e, 0x7a, 0xf6, 0xf4,
0xef, 0x5c, 0x40, 0x80, 0xc4, 0x88, 0x06, 0x0e, 0x93, 0x5f, 0x37, 0x9e, 0xba, 0x8f, 0x3d, 0xcb,
0xc4, 0xb9, 0xaa, 0xf1, 0xbe, 0xf9, 0x50, 0x1d, 0x08, 0xd3, 0xf2, 0x6c, 0xe0, 0x91, 0x3d, 0xe6,
0x4e, 0x1e, 0xa4, 0xf7, 0x3f, 0x03, 0xd3, 0xb3, 0xf9, 0x0b, 0x4b, 0xd7, 0x3c, 0x9b, 0xae, 0xd2,
0x1e, 0x2a, 0x85, 0xf7, 0x59, 0x5c, 0x02, 0x47, 0x94, 0x95, 0x61, 0xb5, 0xb6, 0xdb, 0x6a, 0x8a,
0xe9, 0x4d, 0x46, 0xc6, 0x3b, 0x4b, 0x52, 0xcd, 0x46, 0x32, 0x59, 0x78, 0x66, 0x31, 0x27, 0xc4,
0x75, 0x94, 0x93, 0xa9, 0xd4, 0x11, 0xc7, 0x16, 0xf5, 0xc9, 0xc4, 0xaa, 0xa5, 0xb9, 0x71, 0x42,
0x45, 0x5b, 0x7e, 0x08, 0xe2, 0xc7, 0x1c, 0x0f, 0xfa, 0xd8, 0x71, 0x52, 0x6c, 0x4d, 0x68, 0xd3,
0x2f, 0xdf, 0xe5, 0x39, 0x65, 0xb4, 0xa5, 0x3d, 0x2a, 0xac, 0x3f, 0x3d, 0xd5, 0x44, 0x03, 0x15,
0x8a, 0xc5, 0x9a, 0x11, 0xb1, 0x21, 0xce, 0x97, 0x84, 0xfa, 0xd4, 0x39, 0x6f, 0x42, 0x02, 0xbb,
0xe9, 0x99, 0x4d, 0x11, 0x2b, 0xd1, 0xfb, 0xa7, 0x85, 0x89, 0x0d, 0x30, 0x97, 0xc5, 0x0b, 0xcf,
0xe5, 0xe1, 0xa9, 0x20, 0x1b, 0xce, 0xa3, 0xec, 0x11, 0x44, 0x56, 0x12, 0xaf, 0x3c, 0x06, 0x47,
0xf9, 0x19, 0x79, 0x7d, 0xda, 0xbe, 0xf1, 0x85, 0x75, 0xa1, 0x1c, 0x22, 0xab, 0x6c, 0xde, 0x49,
0x15, 0x8c, 0x04, 0xe4, 0x10, 0x87, 0xb5, 0x49, 0xf5, 0xb5, 0xab, 0x83, 0xf4, 0xaa, 0xdc, 0xfb,
0xd6, 0x98, 0xc2, 0x86, 0x82, 0x8b, 0xe4, 0xeb, 0x33, 0x98, 0xa5, 0xe7, 0x0f, 0xae, 0xce, 0x1e,
0xba, 0x8f, 0x1c, 0xb8, 0x23, 0x87, 0x3a, 0x67, 0xcc, 0xfb, 0x04, 0x61, 0xd7, 0x6f, 0x8f, 0x9c,
0xbb, 0x11, 0xd9, 0x91, 0xa8, 0x57, 0x6f, 0x0b, 0xe4, 0xca, 0xf9, 0xb9, 0x52, 0xb1, 0x90, 0x03,
0x76, 0xbc, 0x8e, 0x80, 0x08, 0x00, 0x23, 0xee, 0xfe, 0x3d, 0x4e, 0x6e, 0xff, 0x79, 0xcc, 0x59,
0x86, 0xdf, 0x9d, 0xa4, 0x27, 0x8f, 0x4b, 0x76, 0xf9, 0x33, 0x73, 0xc6, 0xd9, 0x12, 0x31, 0xa3,
0x72, 0x25, 0x7e, 0x0e, 0x1e, 0xaa, 0x2b, 0x97, 0x3b, 0xb7, 0x5a, 0x75, 0xff, 0x3f, 0x6b, 0x36,
0x58, 0x71, 0xf7, 0x2f, 0x8b, 0xc5, 0x88, 0x65, 0x90, 0x80, 0x34, 0x9a, 0x17, 0x9d, 0x8d, 0xfa,
0xc0, 0x72, 0xa4, 0xda, 0x28, 0x91, 0x16, 0xbf, 0x5f, 0x4f, 0x06, 0xcd, 0xae, 0xae, 0x5c, 0x77,
0x69, 0x13, 0x33, 0x75, 0xcb, 0x7e, 0x77, 0x2f, 0x6a, 0x26, 0x4c, 0x6e, 0x6b, 0x24, 0x69, 0x25,
0xde, 0x4e, 0x9c, 0xe9, 0x48, 0x62, 0xe5, 0x56, 0x2c, 0xaa, 0x75, 0x17, 0xbe, 0xc1, 0x0c, 0xa8,
0x54, 0x64, 0xe5, 0x80, 0x98, 0x50, 0xc9, 0x0b, 0xf8, 0x51, 0x41, 0x68, 0xd2, 0x1c, 0x6e, 0xb4,
0x1b, 0xbc, 0x39, 0xc8, 0x70, 0xf5, 0x1c, 0xa0, 0x20, 0x29, 0xaa, 0x5b, 0x77, 0xcd, 0x70, 0xa2,
0x1d, 0x0d, 0x50, 0xf4, 0xe2, 0xa4, 0xf2, 0x25, 0x7e, 0x0e, 0x1c, 0xc5, 0x1a, 0x53, 0xfd, 0xf9,
0xb8, 0x40, 0xc2, 0x3d, 0xcb, 0x96, 0x43, 0x10, 0xd8, 0x62, 0xc6, 0xac, 0xa9, 0x22, 0xb6, 0x2e,
0xcc, 0x7c, 0x32, 0x2c, 0xda, 0x9f, 0x77, 0x0d, 0xd0, 0xf6, 0x03, 0xae, 0xc9, 0xc6, 0x55, 0xfb,
0xe4, 0xbd, 0x58, 0x2c, 0xb3, 0xef, 0xa8, 0xe6, 0x9a, 0xe8, 0x89, 0xc1, 0x90, 0xb1, 0x42, 0xf2,
0x8b, 0x5a, 0x7c, 0x48, 0x64, 0x31, 0xb4, 0x52, 0x16, 0x5e, 0x0f, 0x4b, 0x98, 0x30, 0xf6, 0x40,
0x8d, 0x9d, 0x6c, 0xbc, 0xa3, 0x6d, 0xef, 0x29, 0xde, 0xa6, 0x3d, 0xae, 0x6b, 0xce, 0xfb, 0xd9,
0x69, 0xa9, 0x11, 0xe0, 0x50, 0x03, 0x20, 0x0b, 0xe6, 0xb2, 0x5a, 0x18, 0x29, 0x76, 0xb7, 0x47,
0x55, 0xdc, 0x2c, 0x2c, 0xc6, 0x0e, 0x9e, 0x9f, 0x9d, 0x99, 0xb0, 0xe2, 0xc2, 0x3d, 0xdb, 0xb7,
0xf2, 0x95, 0x95, 0x7b, 0x67, 0x30, 0xcc, 0x31, 0xc3, 0x90, 0x88, 0x52, 0xe5, 0x0f, 0x1f, 0xcb,
0x17, 0x48, 0x28, 0x52, 0x15, 0xfc, 0x93, 0x77, 0xed, 0x30, 0x34, 0x3b, 0x45, 0xdf, 0xd1, 0xc3,
0x10, 0x68, 0xf2, 0xda, 0x01, 0xb5, 0x18, 0x12, 0xae, 0x8d, 0x09, 0x14, 0x61, 0x44, 0xc7, 0xe3,
0xec, 0xf9, 0x04, 0xaf, 0xa9, 0x7b, 0x76, 0xb7, 0xf1, 0xef, 0x67, 0xff, 0x90, 0x0f, 0xd7, 0x09,
0xe8, 0x3e, 0xb7, 0xed, 0x4f, 0x35, 0x86, 0x0e, 0x68, 0xb9, 0x3e, 0x50, 0x33, 0x45, 0xff, 0xd5,
0xd6, 0xc3, 0x91, 0xfa, 0xa7, 0x47, 0xe1, 0x0b, 0xb1, 0xb9, 0x7d, 0x31, 0xc0, 0x15, 0xa0, 0x8d,
0x39, 0xc0, 0xe5, 0xa7, 0x83, 0xf4, 0xcb, 0x04, 0x6f, 0xa2, 0x4a, 0x12, 0xfe, 0xdd, 0x49, 0x0e,
0xdd, 0x8e, 0xee, 0xfd, 0x0b, 0xaf, 0xbe, 0x69, 0x7c, 0xc4, 0xc3, 0x66, 0x8c, 0x9e, 0x64, 0xa8,
0x52, 0x04, 0x2a, 0x09, 0xcf, 0xba, 0xe8, 0xf8, 0xa5, 0xcb, 0x5f, 0x9d, 0x84, 0x54, 0xbe, 0x48,
0xc1, 0xc6, 0x10, 0x78, 0xe8, 0xd0, 0xd6, 0x9f, 0xfc, 0x7a, 0xf1, 0xd5, 0x1e, 0x0c, 0x5c, 0x2a,
0xdf, 0xd9, 0x39, 0x30, 0xc5, 0xc3, 0x90, 0x75, 0x5a, 0x91, 0xb0, 0x2b, 0x50, 0x2b, 0x54, 0x20,
0x91, 0x4d, 0xb2, 0x77, 0xcd, 0x32, 0x56, 0xd2, 0xae, 0xf0, 0xe5, 0x9e, 0x7e, 0x61, 0x02, 0x5b,
0x3d, 0x56, 0xd0, 0x8b, 0x99, 0x87, 0xd2, 0x9b, 0x15, 0xb4, 0x36, 0xf1, 0x3f, 0x5a, 0xaf, 0x0a,
0xb7, 0xd2, 0x85, 0x34, 0x63, 0xaa, 0x28, 0x9a, 0x0a, 0x31, 0xf4, 0xab, 0x50, 0x2b, 0x75, 0x69,
0xf4, 0x75, 0xd6, 0x88, 0x2a, 0x00, 0xa3, 0xfa, 0xd5, 0xd4, 0xc2, 0x89, 0x6e, 0x37, 0xd0, 0x85,
0x9e, 0x58, 0xb2, 0x6f, 0xfd, 0x7f, 0xd4, 0x14, 0x94, 0x2d, 0x81, 0x56, 0xcf, 0xc3, 0xa7, 0x11,
0x48, 0x9d, 0xa7, 0x84, 0x76, 0xc9, 0x27, 0xcb, 0xb5, 0x61, 0xe1, 0x6a, 0x07, 0xb2, 0xb9, 0x56,
0xb7, 0xfa, 0xb6, 0xf1, 0xe2, 0x9b, 0xbd, 0x56, 0x31, 0xa8, 0x2e, 0x9a, 0xc5, 0xee, 0xb2, 0x45,
0x85, 0xcd, 0x7a, 0xfe, 0x50, 0x33, 0x47, 0x81, 0xd5, 0x4a, 0xb5, 0x14, 0x92, 0x9a, 0x10, 0x71,
0xb7, 0x2e, 0xd7, 0x30, 0xf9, 0x10, 0xe0, 0x57, 0x49, 0x48, 0x84, 0x40, 0x66, 0x8c, 0x7f, 0x63,
0x2c, 0x5a, 0x2c, 0x0a, 0xc9, 0x6e, 0xf8, 0x6c, 0xf0, 0xd4, 0x48, 0x78, 0xd3, 0x31, 0x4f, 0x88,
0x45, 0xfa, 0xf0, 0x7c, 0xa0, 0x58, 0xb0, 0x16, 0x1f, 0x1d, 0x80, 0x75, 0xdd, 0xef, 0x8f, 0x5a,
0x26, 0x26, 0x6b, 0x1d, 0xf8, 0x6d, 0x82, 0x73, 0xb3, 0xd6, 0xa8, 0xc2, 0xee, 0xda, 0x5e, 0x9f,
0xb8, 0x5c, 0xf6, 0xe5, 0x19, 0x11, 0xa5, 0x85, 0x74, 0x03, 0x8b, 0x32, 0x11, 0x60, 0x1d, 0x3a,
0x0a, 0x5f, 0x92, 0x58, 0x7a, 0x7b, 0x22, 0x98, 0x2e, 0x7f, 0x49, 0xdc, 0x04, 0xd5, 0x8e, 0x26,
0x39, 0x30, 0xfd, 0xfa, 0x8a, 0x5f, 0xb3, 0x1a, 0xfe, 0xa3, 0x63, 0x71, 0x80, 0x27, 0xa4, 0x6b,
0x4c, 0xef, 0x62, 0x38, 0x54, 0xb3, 0x13, 0x45, 0xd7, 0x8f, 0x20, 0x0b, 0x1b, 0xab, 0xbd, 0xc4,
0xad, 0xce, 0x99, 0x30, 0x6b, 0xd4, 0x34, 0x53, 0x3b, 0xab, 0x72, 0xde, 0xa8, 0x12, 0x98, 0x11,
0x5c, 0xd2, 0x88, 0x6c, 0x33, 0x39, 0x76, 0x78, 0x94, 0x2a, 0xbe, 0x5f, 0x39, 0x7d, 0x46, 0x51,
0x86, 0x36, 0xf8, 0xb2, 0xd8, 0x91, 0x7d, 0x90, 0x2d, 0x07, 0xe5, 0xb4, 0x4f, 0x0e, 0x78, 0x9e,
0x1d, 0xf3, 0x4c, 0x59, 0x99, 0x9e, 0xce, 0x9c, 0xf1, 0x79, 0x12, 0x05, 0x34, 0x33, 0xb9, 0x77,
0xbf, 0x2b, 0x77, 0x1a, 0xf8, 0xcf, 0x30, 0x0a, 0x8b, 0x43, 0xcf, 0x9b, 0x57, 0x29, 0x14, 0x97,
0x0f, 0xf1, 0x77, 0xf8, 0xba, 0x2a, 0x99, 0xf2, 0x2e, 0xe0, 0x4c, 0xdb, 0x58, 0x91, 0xc8, 0x4f,
0x89, 0xf8, 0xc3, 0xa7, 0xdc, 0x24, 0xa8, 0xbb, 0xb9, 0x61, 0xe3, 0x2f, 0xe6, 0x3b, 0x5d, 0xe4,
0x24, 0x48, 0x84, 0x88, 0x7d, 0xf9, 0x1c, 0x19, 0xe7, 0x6d, 0xac, 0x93, 0x34, 0x49, 0x82, 0x9c,
0x98, 0x1b, 0xd8, 0x23, 0x67, 0x39, 0xf6, 0x4c, 0xe9, 0xf7, 0x03, 0x21, 0x2a, 0xf3, 0x9c, 0xbb,
0xf1, 0x8e, 0xc6, 0x8c, 0x0e, 0x88, 0xc3, 0xa7, 0xdf, 0x55, 0xec, 0x67, 0xc6, 0xf8, 0x56, 0x84,
0x6e, 0xe9, 0xb8, 0x9a, 0x56, 0xf3, 0x8d, 0x8e, 0xd6, 0xc9, 0xf2, 0x81, 0x63, 0xc1, 0x5f, 0x02,
0x41, 0x5e, 0x31, 0x22, 0xb3, 0xe2, 0xf3, 0x9f, 0x3f, 0x7d, 0x35, 0xcb, 0x75, 0xe1, 0xa1, 0xfa,
0x43, 0xcf, 0xed, 0x31, 0x27, 0xf0, 0x39, 0x56, 0x32, 0xdf, 0x74, 0x08, 0x76, 0x7e, 0x1f, 0x54,
0xe9, 0xe5, 0x6b, 0xc3, 0x66, 0xe7, 0x83, 0xd5, 0x8b, 0x07, 0x84, 0x6f, 0xf6, 0xab, 0x6b, 0xac,
0xb2, 0x27, 0x30, 0x0b, 0x63, 0x0c, 0x5c, 0x18, 0x74, 0x68, 0xb6, 0xf1, 0x3f, 0x7b, 0x4b, 0x5b,
0x97, 0xd9, 0x57, 0x99, 0xcb, 0xd7, 0x8c, 0x97, 0xce, 0xde, 0x37, 0x2c, 0xe0, 0x96, 0x26, 0x39,
0x78, 0x94, 0x96, 0x94, 0x0c, 0xc6, 0x16, 0xc7, 0x4f, 0xf8, 0x62, 0xe7, 0xa4, 0xe8, 0x86, 0xad,
0x9e, 0x86, 0xea, 0xf5, 0x00, 0xbe, 0xc1, 0x5d, 0x9e, 0xee, 0xfd, 0x28, 0xd2, 0x69, 0x32, 0x6e,
0x91, 0xd0, 0x81, 0x17, 0xcd, 0x46, 0x53, 0x82, 0xd6, 0x8d, 0xeb, 0x50, 0x6d, 0x1b, 0x1d, 0x96,
0xbf, 0x3c, 0xcd, 0xf1, 0x7f, 0x23, 0x62, 0x98, 0xbd, 0x3a, 0x83, 0x82, 0xbb, 0x7b, 0x8f, 0x7e,
0xff, 0x10, 0xa0, 0xc2, 0x6e, 0xbf, 0xe7, 0x98, 0x58, 0xe2, 0x0e, 0x97, 0xa1, 0xa2, 0x6f, 0x93,
0xb5, 0x4b, 0x87, 0x84, 0xd7, 0x90, 0x08, 0x76, 0x38, 0x5a, 0x5e, 0xff, 0xa1, 0x29, 0x27, 0x84,
0x62, 0x15, 0x67, 0xbe, 0xda, 0xe7, 0x0a, 0xaf, 0x5c, 0x2c, 0x23, 0x87, 0x3a, 0x67, 0xed, 0x48,
0xd6, 0x31, 0xbf, 0x5a, 0x28, 0x59, 0x4b, 0xf6, 0x87, 0xf2, 0x0a, 0x95, 0x28, 0x9b, 0x55, 0x12,
0x13, 0x4d, 0xef, 0x35, 0x21, 0x0d, 0xfa, 0xdf, 0x33, 0x09, 0x6d, 0x13, 0x61, 0xff, 0xa5, 0xa0,
0x22, 0x3a, 0x1f, 0x6a, 0x1e, 0x77, 0x3f, 0x33, 0xf7, 0x48, 0x22, 0xa1, 0x79, 0xb0, 0xf2, 0xd3,
0x67, 0xfa, 0xe7, 0xcc, 0xd1, 0xf2, 0xe1, 0x9e, 0x75, 0xde, 0x5c, 0x4e, 0x9d, 0xfd, 0xf7, 0xac,
0x91, 0x14, 0xb3, 0x46, 0xa7, 0x03, 0xd5, 0x68, 0x76, 0x81, 0x47, 0x52, 0x8c, 0x6c, 0x78, 0x86,
0x6c, 0x1f, 0xd2, 0x66, 0x0b, 0x3c, 0xe3, 0x07, 0x25, 0x07, 0x19, 0xea, 0xc4, 0x99, 0xf2, 0x39,
0xe0, 0x77, 0xb5, 0xbd, 0x3a, 0x87, 0xa3, 0x10, 0x9b, 0x67, 0x77, 0xbd, 0x4c, 0xb9, 0xa1, 0xed,
0x6d, 0x41, 0x15, 0xea, 0x25, 0xe3, 0x90, 0x9b, 0x82, 0x26, 0xe7, 0xfe, 0x41, 0xef, 0xdc, 0xd5,
0x85, 0x09, 0xa1, 0x42, 0x87, 0x4d, 0xbe, 0xa4, 0xfa, 0xce, 0x06, 0x8e, 0x7f, 0x5d, 0x89, 0x11,
0x95, 0x43, 0x50, 0x13, 0x82, 0x07, 0x4b, 0xb8, 0x52, 0xc2, 0x10, 0x24, 0x13, 0x05, 0x80, 0x02,
0x26, 0x9c, 0xfe, 0x63, 0x3e, 0x58, 0x0f, 0xea, 0x52, 0x93, 0x82, 0x39, 0xc7, 0xe8, 0x6f, 0x2a,
0x30, 0xb5, 0x06, 0x0e, 0x38, 0x6c, 0xdb, 0x24, 0x69, 0x41, 0x80, 0x47, 0x73, 0x54, 0x94, 0x1f,
0xbf, 0xae, 0xcf, 0x03, 0x04, 0x58, 0x0a, 0x19, 0x34, 0xb1, 0x9d, 0x95, 0x8d, 0x4a, 0xe4, 0xcb,
0x33, 0x6b, 0x8a, 0x08, 0x37, 0x9a, 0x4a, 0x77, 0x64, 0xab, 0x74, 0x38, 0xb6, 0xf1, 0x3f, 0x7b,
0x6a, 0x26, 0xaf, 0x4a, 0x15, 0x17, 0x9b, 0xb1, 0xbc, 0xed, 0x9f, 0x75, 0xa9, 0xf9, 0xc2, 0xf6,
0xee, 0x78, 0xcd, 0x99, 0xa0, 0x61, 0xb0, 0x83, 0x20, 0xdc, 0x6b, 0xca, 0x80, 0x60, 0x50, 0x12,
0x78, 0x11, 0x32, 0xbf, 0xdb, 0xe0, 0xef, 0xc6, 0x12, 0xd8, 0x06, 0xdb, 0x67, 0x1c, 0xd4, 0x44,
0x8b, 0xb1, 0x6b, 0x21, 0x36, 0x5f, 0x52, 0xe4, 0xeb, 0x14, 0xea, 0xc1, 0x8b, 0x49, 0x8d, 0x38,
0xcf, 0xa7, 0xc8, 0xce, 0xd7, 0xcf, 0x8e, 0x16, 0xb2, 0x58, 0x97, 0x9a, 0x30, 0xb0, 0x02, 0x74,
0xa1, 0xb8, 0xf4, 0x38, 0x61, 0xe0, 0x7f, 0x07, 0x08, 0x10, 0x46, 0x94, 0x49, 0x47, 0x6c, 0x0f,
0xb9, 0xe2, 0xe0, 0x02, 0x27, 0x5b, 0xbf, 0xe1, 0xdd, 0x79, 0x6c, 0xe1, 0x7f, 0x46, 0xd2, 0xce,
0xdc, 0xa8, 0x7b, 0x68, 0xab, 0x3e, 0xed, 0xf4, 0xfe, 0xde, 0x08, 0x3f, 0xc3, 0x4b, 0x95, 0xae,
0x70, 0xfd, 0x33, 0xfd, 0x5d, 0xcd, 0xb8, 0xc4, 0x86, 0xb1, 0xea, 0xca, 0xd1, 0xd8, 0xd1, 0x8a,
0x25, 0xb5, 0x6e, 0x15, 0x7b, 0x99, 0xb8, 0x77, 0x13, 0x63, 0x19, 0x59, 0x37, 0x26, 0xa9, 0x59,
0xd3, 0x76, 0xc8, 0x6a, 0x37, 0xf4, 0x4e, 0x74, 0xca, 0x3e, 0x4e, 0xee, 0xdc, 0xd2, 0x8d, 0x19,
0x86, 0x23, 0x1a, 0xd8, 0x73, 0x63, 0xe8, 0xcd, 0x53, 0x5c, 0xfe, 0xde, 0x22, 0xfe, 0x5b, 0xc1,
0xa0, 0x95, 0x24, 0x14, 0xc1, 0xbd, 0x7f, 0xa5, 0x0a, 0x1d, 0xea, 0x4a, 0x90, 0xe9, 0x62, 0xca,
0x1e, 0x1a, 0xc9, 0x97, 0x90, 0x6a, 0x30, 0x28, 0x54, 0xc2, 0xc4, 0x98, 0x75, 0xf1, 0x60, 0x5a,
0xe0, 0xef, 0xdc, 0x37, 0x33, 0xf0, 0x9a, 0x72, 0xb2, 0x26, 0xa2, 0x3d, 0x5f, 0x54, 0x3b, 0x55,
0x25, 0x36, 0x3f, 0x7c, 0x98, 0x60, 0x48, 0xb2, 0x47, 0x64, 0x59, 0x0c, 0x13, 0x13, 0x84, 0x80,
0xb7, 0xc4, 0xf5, 0x06, 0x2f, 0xd1, 0xde, 0x21, 0x49, 0x38, 0xbc, 0x65, 0x8b, 0x1c, 0x46, 0xae,
0xeb, 0xd4, 0x06, 0x91, 0x05, 0x01, 0x96, 0xe4, 0xea, 0x76, 0x09, 0x2b, 0xb1, 0x30, 0xa6, 0x88,
0x28, 0xd4, 0xc0, 0x90, 0x05, 0xb5, 0x43, 0x14, 0x80, 0x63, 0xe6, 0x39, 0x50, 0x2c, 0x85, 0x7d,
0xae, 0x10, 0x60, 0xe3, 0x23, 0x7c, 0xfe, 0x86, 0xfb, 0x67, 0xf0, 0x68, 0x8e, 0x4e, 0x3e, 0x2d,
0xa9, 0xf4, 0xd2, 0x5b, 0xa6, 0x6f, 0x4f, 0x1b, 0x6d, 0x19, 0xa7, 0x72, 0xa6, 0xbc, 0x59, 0xb1,
0x31, 0x47, 0x34, 0x1e, 0x15, 0xdf, 0xf4, 0x38, 0xbb, 0x05, 0x27, 0x5f, 0xac, 0xe9, 0x3e, 0x84,
0x99, 0x21, 0x87, 0x0d, 0x51, 0xb4, 0x6c, 0x32, 0x02, 0xfd, 0x4e, 0x58, 0x59, 0xcc, 0xf7, 0x72,
0xcc, 0x8b, 0x5a, 0xef, 0xf6, 0xcd, 0x8a, 0x3f, 0xe0, 0xfe, 0x4f, 0x0f, 0x48, 0xc3, 0x8e, 0xf6,
0x11, 0xfc, 0xce, 0x5b, 0x24, 0x40, 0x83, 0x47, 0xc6, 0x82, 0x07, 0xab, 0x7a, 0x26, 0x4f, 0xdb,
0x88, 0x26, 0xfe, 0xdb, 0x63, 0x74, 0xab, 0xfe, 0x46, 0x76, 0x5b, 0x75, 0x47, 0xd3, 0xe5, 0x09,
0x69, 0x66, 0xc7, 0xfe, 0x9a, 0xd7, 0x6c, 0x32, 0x93, 0x39, 0x99, 0x19, 0x71, 0xb2, 0x87, 0x65,
0xc9, 0xb8, 0xc4, 0xe3, 0xd5, 0xbe, 0xc4, 0x72, 0xf5, 0xa1, 0xa9, 0xb5, 0xb1, 0x75, 0xad, 0xba,
0xa4, 0x93, 0xd2, 0x96, 0xef, 0x10, 0x3c, 0x84, 0x33, 0xe0, 0x9e, 0xc6, 0xeb, 0x84, 0xd3, 0x20,
0x54, 0x6b, 0x18, 0x2c, 0xa4, 0x52, 0x22, 0x78, 0x08, 0x77, 0xb8, 0x52, 0x09, 0x4f, 0xe9, 0x06,
0x82, 0x65, 0xed, 0x39, 0xd1, 0x20, 0xa3, 0xc4, 0xeb, 0x35, 0xe8, 0x52, 0x26, 0xaf, 0xdc, 0x3a,
0xf6, 0x4f, 0xfd, 0x59, 0x30, 0xe2, 0x46, 0x0e, 0x7f, 0x5d, 0x6f, 0xda, 0x50, 0x7e
};
#endif
