/*
 * Copyright (c) 2016, Sascha Schade
 *
 * This file is part of the modm project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
// ----------------------------------------------------------------------------

#ifndef ADNS_9800_SROM_A4_HPP
#define ADNS_9800_SROM_A4_HPP

static constexpr uint16_t firmware_length = 3070;

static constexpr uint8_t firmware_data[firmware_length] =
{
0x03, 0xa4, 0x6e, 0x16, 0x6d, 0x41, 0xf4, 0x8f, 0x95, 0x6a, 0xa1, 0xe1, 0x5c, 0xeb, 0xb1, 0x2a,
0xa0, 0xb4, 0x16, 0x82, 0x62, 0x71, 0x5d, 0x0b, 0xbe, 0x01, 0xeb, 0x4a, 0x61, 0x54, 0x42, 0x98,
0x76, 0x63, 0x98, 0xb8, 0x60, 0x4a, 0xe1, 0x17, 0x27, 0x99, 0x3f, 0xce, 0x9d, 0x88, 0x9b, 0x4b,
0x6d, 0x31, 0xc7, 0xe7, 0xba, 0xa2, 0x66, 0x88, 0xb5, 0xb4, 0xd2, 0xb5, 0x6b, 0xd8, 0xcd, 0x91,
0x5b, 0xea, 0xd2, 0x9c, 0x29, 0x72, 0xcb, 0xeb, 0x1e, 0x60, 0xe7, 0x26, 0x3f, 0xf5, 0xfc, 0x6c,
0xd3, 0x11, 0x0c, 0xa9, 0x51, 0x30, 0x4c, 0xd3, 0x77, 0x37, 0x2b, 0x6f, 0x13, 0x89, 0x7f, 0x44,
0x22, 0xa7, 0xcc, 0xfa, 0x55, 0x09, 0x90, 0xa2, 0xc6, 0x0e, 0x9e, 0x9f, 0xbc, 0xfa, 0x59, 0x2f,
0xd6, 0x36, 0xc2, 0xfd, 0x78, 0x72, 0x47, 0xed, 0x39, 0xd1, 0x20, 0xc2, 0xe7, 0x4c, 0xfb, 0x74,
0x6c, 0x51, 0x26, 0xb6, 0xf9, 0x7a, 0x57, 0x0d, 0x98, 0xb2, 0xe6, 0x4e, 0x1e, 0x9f, 0x9d, 0xbc,
0xd3, 0x24, 0xca, 0xf7, 0x6c, 0x5a, 0x1d, 0xac, 0xb0, 0xf4, 0x4b, 0x14, 0x8b, 0x94, 0xaa, 0xb7,
0xcd, 0xf9, 0x61, 0x62, 0x46, 0x0e, 0x9e, 0x9f, 0x92, 0xa8, 0xe0, 0x54, 0xf9, 0x39, 0xd1, 0x01,
0x63, 0xa5, 0x42, 0x74, 0xeb, 0x81, 0x6a, 0xa6, 0x9a, 0x37, 0x1f, 0x8a, 0x81, 0x70, 0xf9, 0xd0,
0x3c, 0xd3, 0xce, 0xea, 0xf5, 0xd2, 0x5c, 0x7d, 0xc2, 0x76, 0x3d, 0x40, 0x5e, 0xd9, 0xc6, 0x03,
0x11, 0x19, 0x66, 0xf2, 0xa7, 0xd2, 0xfa, 0xa2, 0xaf, 0xf4, 0x6c, 0x02, 0x6a, 0x5a, 0x06, 0x00,
0xe0, 0x72, 0x93, 0x91, 0x90, 0x7b, 0x19, 0x80, 0xbb, 0x0b, 0x9e, 0xcc, 0x9a, 0x50, 0xc9, 0x80,
0x91, 0x29, 0x8e, 0xc1, 0xe4, 0xc4, 0xfb, 0xb7, 0x9b, 0xf5, 0xf8, 0x57, 0xde, 0xe9, 0x39, 0x71,
0xbc, 0x61, 0x55, 0x34, 0x08, 0xe1, 0xb2, 0x76, 0xac, 0xb7, 0x50, 0xa5, 0xcc, 0xa9, 0x27, 0x96,
0x0d, 0x31, 0x89, 0x8a, 0x00, 0x4c, 0x46, 0x17, 0x1c, 0x83, 0xb2, 0x47, 0x08, 0x8f, 0xfe, 0xe9,
0x55, 0xdf, 0x07, 0x49, 0xb7, 0xa4, 0xd0, 0x96, 0x87, 0xd0, 0x1a, 0x06, 0xb7, 0xda, 0x97, 0xa6,
0x2e, 0x9d, 0x2f, 0x6f, 0xc7, 0xb0, 0x8d, 0x7a, 0x05, 0x99, 0x07, 0x28, 0x80, 0x2b, 0x37, 0xce,
0x4b, 0x47, 0x5a, 0x4f, 0x21, 0x16, 0xf4, 0xea, 0x44, 0x5c, 0x8f, 0x37, 0x19, 0x9e, 0x4a, 0x0a,
0x7e, 0x7c, 0xda, 0x09, 0xd8, 0xb9, 0x04, 0x8f, 0x68, 0xcc, 0x6e, 0x8d, 0x6d, 0x46, 0xb4, 0x71,
0xe4, 0x13, 0x50, 0xd2, 0x27, 0xa5, 0x14, 0x86, 0xc6, 0x8c, 0xf8, 0x19, 0xc4, 0xc6, 0xb3, 0xae,
0xbc, 0x7a, 0x93, 0x9a, 0xf4, 0x59, 0x9e, 0xf6, 0x3f, 0x7f, 0x92, 0x21, 0x9d, 0xec, 0xa7, 0xe9,
0x63, 0xa6, 0xb8, 0x39, 0xfb, 0xd6, 0x8e, 0x4c, 0x0d, 0xa8, 0x1e, 0xf6, 0x63, 0xaf, 0x5d, 0x6e,
0x12, 0x13, 0xcc, 0x84, 0xcb, 0xcb, 0x17, 0x99, 0x99, 0xa9, 0x33, 0x35, 0xf8, 0x99, 0xd4, 0xe2,
0x47, 0x9b, 0x3b, 0x25, 0xed, 0x9b, 0xe1, 0x70, 0x05, 0xb9, 0xc0, 0xbe, 0x9b, 0xee, 0xfa, 0xd5,
0x85, 0xe2, 0x65, 0x3c, 0x77, 0x44, 0x4b, 0x24, 0x7f, 0x68, 0xd6, 0xac, 0xbd, 0x22, 0x20, 0x46,
0x82, 0xec, 0x98, 0xe7, 0xc1, 0x49, 0x51, 0x50, 0x26, 0x6d, 0xa0, 0xde, 0xa1, 0xbb, 0xb1, 0x5a,
0x6f, 0x2b, 0x2e, 0xaa, 0xd4, 0x7a, 0xb9, 0xd4, 0x7b, 0xec, 0xe7, 0xb1, 0x79, 0x79, 0xa1, 0x1b,
0xa2, 0xa5, 0xea, 0xb0, 0xa2, 0x54, 0xea, 0x26, 0x67, 0xb4, 0xff, 0xbe, 0x8a, 0xbf, 0x64, 0x2a,
0x5e, 0x6f, 0x87, 0xd7, 0x5d, 0x69, 0xe7, 0x9c, 0xeb, 0xe7, 0x40, 0xe9, 0x92, 0xad, 0xc9, 0xa6,
0xde, 0x6f, 0xed, 0x46, 0x1f, 0xf5, 0x44, 0x10, 0xf2, 0x8e, 0x73, 0x2f, 0xff, 0xc8, 0x9f, 0xf5,
0x69, 0x41, 0x54, 0x3e, 0x3a, 0xf4, 0xe8, 0xf3, 0x60, 0xae, 0xe0, 0x3c, 0x5c, 0xdf, 0x5e, 0xd9,
0xd3, 0xd8, 0xdb, 0x56, 0xcb, 0xf6, 0x2a, 0xcc, 0x8d, 0x1f, 0x11, 0x0a, 0xb5, 0xbd, 0x75, 0x40,
0x22, 0xd7, 0x59, 0x26, 0x2f, 0x1c, 0x1d, 0xf8, 0x78, 0xa3, 0xfa, 0xc8, 0xb4, 0x0f, 0xbc, 0x19,
0x51, 0xf9, 0x99, 0xb1, 0x01, 0x60, 0xd3, 0x26, 0x63, 0x79, 0x52, 0xc9, 0xdd, 0x69, 0x25, 0xe5,
0xca, 0x60, 0x63, 0x17, 0x0b, 0xe0, 0x08, 0x12, 0xa2, 0x05, 0xe6, 0x0d, 0x50, 0x2d, 0x9c, 0x9b,
0x7c, 0x47, 0xec, 0x90, 0x6f, 0x6c, 0x2f, 0xf1, 0xe2, 0x11, 0x81, 0xd3, 0x83, 0xf0, 0x28, 0x73,
0x4f, 0x22, 0xc9, 0x53, 0xac, 0xf4, 0x1e, 0xef, 0xcb, 0x27, 0xfd, 0xee, 0x6b, 0x64, 0xf4, 0xd9,
0x0d, 0x04, 0x2d, 0xf3, 0x2b, 0x0f, 0xc7, 0x9c, 0x8a, 0x21, 0xf1, 0x50, 0x70, 0x6f, 0x6d, 0x63,
0xd6, 0xa3, 0xa9, 0xba, 0xd5, 0x7d, 0xd4, 0x82, 0xc7, 0x3c, 0x8f, 0x69, 0xb5, 0x0b, 0xf3, 0xbe,
0x2f, 0x76, 0xe2, 0x2c, 0xf9, 0x25, 0x45, 0x41, 0x41, 0x11, 0xd5, 0x3e, 0x1f, 0x3c, 0x7c, 0xdb,
0x1c, 0x4c, 0x9e, 0xdc, 0xf9, 0xe1, 0xc0, 0xeb, 0xc1, 0xf5, 0x0a, 0x76, 0x1e, 0xfe, 0x71, 0xbb,
0x30, 0x82, 0x60, 0x13, 0xe4, 0x44, 0xf2, 0xb2, 0x67, 0xa8, 0x83, 0x25, 0xc0, 0xf6, 0x5b, 0x63,
0x5f, 0x9a, 0x8f, 0xba, 0xc0, 0xcf, 0x0d, 0x8c, 0x1d, 0x4f, 0xb8, 0x4f, 0x2b, 0x50, 0x69, 0xd0,
0x0d, 0x81, 0xbf, 0xf7, 0xbb, 0xef, 0xfa, 0x48, 0x3a, 0x21, 0x0d, 0xa8, 0xe7, 0xaa, 0x61, 0xc7,
0x94, 0x7c, 0xbc, 0x54, 0x8b, 0x73, 0x8c, 0xc7, 0x76, 0xe9, 0x8c, 0x85, 0x3f, 0xf9, 0x32, 0x16,
0x58, 0x55, 0x39, 0x14, 0x21, 0x31, 0x34, 0xeb, 0x10, 0xbf, 0x08, 0xf1, 0x96, 0x77, 0xc5, 0x08,
0x33, 0xc9, 0xec, 0x1b, 0x7f, 0xb8, 0x53, 0x2c, 0x2e, 0x0a, 0x81, 0x90, 0x6c, 0xb6, 0x3f, 0x8a,
0x76, 0x99, 0x1e, 0xe7, 0x56, 0x7c, 0xdd, 0xee, 0x15, 0x89, 0x8c, 0x65, 0x61, 0x82, 0xb0, 0x22,
0x0b, 0xa4, 0x9d, 0xb9, 0x26, 0x60, 0x3a, 0x2c, 0x4b, 0xb5, 0x3e, 0xf5, 0x28, 0xaf, 0x02, 0xc4,
0x52, 0x87, 0x82, 0x6e, 0x1d, 0x2f, 0x8d, 0x39, 0xd9, 0xd4, 0x08, 0x24, 0xba, 0x36, 0xcd, 0x09,
0xf2, 0xf1, 0x10, 0x03, 0x69, 0xbc, 0xd9, 0xc5, 0xa9, 0xdc, 0xe7, 0xfc, 0x75, 0xc5, 0xa9, 0xd3,
0xc6, 0xca, 0xee, 0xce, 0xf8, 0xee, 0xde, 0x1d, 0x58, 0xd7, 0xd4, 0x3b, 0x55, 0x09, 0x95, 0x96,
0x90, 0x25, 0x16, 0x83, 0x93, 0x05, 0x6a, 0xb4, 0x94, 0x04, 0x2b, 0xb7, 0x2d, 0x86, 0xf2, 0xeb,
0x3b, 0x25, 0xf0, 0x2e, 0xcf, 0x25, 0x23, 0x65, 0x44, 0x83, 0x4c, 0x09, 0x52, 0xa7, 0x75, 0xc9,
0x1e, 0x77, 0xce, 0xc9, 0x41, 0xa1, 0xa9, 0x55, 0x6b, 0x03, 0x46, 0x78, 0x53, 0xe4, 0xc7, 0x0c,
0x7b, 0xdf, 0x36, 0x23, 0x4e, 0x51, 0x16, 0xb3, 0xcf, 0xd3, 0x97, 0xbc, 0x9a, 0x01, 0xa7, 0xbb,
0x66, 0x98, 0x68, 0x7c, 0x13, 0x65, 0xad, 0x50, 0x63, 0x71, 0x7e, 0x9e, 0x7f, 0xed, 0xf8, 0x75,
0x50, 0x8f, 0x24, 0xba, 0x56, 0x09, 0x2e, 0x8f, 0x3c, 0xf0, 0x96, 0x3a, 0x00, 0x0c, 0x2e, 0x0c,
0x96, 0x82, 0x89, 0xdb, 0xa9, 0xdd, 0xe8, 0x3c, 0x08, 0xaf, 0x86, 0xf8, 0x0a, 0xb4, 0x34, 0xe1,
0xeb, 0x6e, 0x68, 0x3c, 0xa1, 0xe1, 0xa1, 0x8a, 0xcb, 0x85, 0xc7, 0xac, 0x8c, 0xd6, 0x30, 0xcd,
0xbc, 0x3b, 0xb6, 0x28, 0x5d, 0xcc, 0x47, 0xf8, 0x16, 0xaf, 0x1a, 0x2e, 0x26, 0x8f, 0x3c, 0xe6,
0xf5, 0x76, 0xc4, 0x59, 0xc7, 0xc2, 0xf5, 0xf2, 0x6e, 0xae, 0x2c, 0xfb, 0xa5, 0xac, 0x7a, 0x6a,
0xcc, 0x8e, 0x68, 0x7d, 0x08, 0x32, 0xdb, 0xae, 0x4a, 0x45, 0x8e, 0xb6, 0xee, 0xfe, 0x5a, 0x9e,
0x7f, 0xff, 0x79, 0x90, 0xa3, 0xc8, 0x16, 0x2e, 0x04, 0xee, 0x5e, 0x65, 0xeb, 0x73, 0xe6, 0xbb,
0x34, 0xc6, 0xf5, 0x63, 0x57, 0x49, 0x29, 0x71, 0x72, 0xd7, 0x9f, 0x07, 0xab, 0x2b, 0x04, 0xeb,
0x2f, 0xb1, 0x58, 0xa6, 0x9d, 0x87, 0x79, 0x7d, 0x21, 0x01, 0x18, 0xec, 0xf2, 0x93, 0xfa, 0x43,
0x7b, 0x68, 0x2d, 0xe4, 0x35, 0xc1, 0x54, 0x74, 0xec, 0xb1, 0xbe, 0xe3, 0x1a, 0xfe, 0x4b, 0x6b,
0x72, 0x0f, 0xe3, 0x78, 0x2a, 0xba, 0xb2, 0xbc, 0x7c, 0x81, 0xdb, 0x74, 0x9f, 0x1c, 0x89, 0xe1,
0x2b, 0x60, 0x01, 0xb2, 0xcd, 0x8f, 0xcd, 0x99, 0x81, 0xd4, 0x2a, 0xf6, 0xcc, 0x49, 0x1a, 0xe1,
0x30, 0x42, 0x0d, 0x1b, 0x6d, 0x29, 0x45, 0xf4, 0x25, 0x3d, 0xcb, 0x21, 0x79, 0xd0, 0x0f, 0xf0,
0x4a, 0x66, 0x2c, 0x09, 0x53, 0xe1, 0x30, 0x23, 0xca, 0x9f, 0x94, 0xda, 0x14, 0x98, 0x09, 0x25,
0xcc, 0x27, 0x11, 0x69, 0x8c, 0xb2, 0x4c, 0xfe, 0x6c, 0x3a, 0x7f, 0xbd, 0x04, 0x03, 0xf1, 0x09,
0x93, 0xff, 0xc5, 0x80, 0x6b, 0xc5, 0xf0, 0x79, 0xac, 0xd3, 0x8e, 0x1b, 0xc9, 0xcd, 0x70, 0xa3,
0x38, 0x1a, 0x62, 0x0e, 0x76, 0x42, 0x64, 0x02, 0xc9, 0xd4, 0x17, 0x84, 0x56, 0xb6, 0x62, 0xfe,
0xfa, 0x01, 0xa4, 0xae, 0xa1, 0x8f, 0xa7, 0x08, 0xab, 0x54, 0x0f, 0x81, 0xc3, 0xd3, 0x54, 0x6a,
0x5c, 0xfb, 0x37, 0x7b, 0x04, 0x2b, 0xb9, 0x1c, 0xab, 0x75, 0x4f, 0x81, 0x97, 0xa2, 0xa4, 0xf8,
0x83, 0xa5, 0xed, 0xe1, 0xc0, 0x00, 0x93, 0xe7, 0xfa, 0xe7, 0xcc, 0xfb, 0x25, 0x23, 0x53, 0x67,
0x7e, 0x9f, 0xbd, 0xfc, 0x22, 0x67, 0x44, 0xee, 0x3c, 0x6d, 0x28, 0x52, 0x09, 0x78, 0xd0, 0x94,
0xda, 0x76, 0x7d, 0xcb, 0xa0, 0xdc, 0x70, 0xd1, 0x60, 0x33, 0x51, 0x54, 0xe7, 0x50, 0x62, 0x36,
0xbc, 0x70, 0x56, 0x3f, 0x3c, 0xec, 0x06, 0x43, 0x1d, 0xc8, 0x92, 0x90, 0x1d, 0x5c, 0xf3, 0x60,
0xfb, 0xb4, 0xdf, 0x01, 0xf0, 0xc3, 0xf0, 0x38, 0x9f, 0x67, 0x48, 0x4a, 0xb7, 0xd7, 0x0d, 0xc9,
0xb1, 0xfb, 0xb6, 0x9e, 0xfe, 0x66, 0x8a, 0xc7, 0x8c, 0x62, 0xa1, 0xb0, 0x22, 0xd8, 0xfa, 0xe7,
0xcc, 0xe4, 0xa1, 0xb0, 0x43, 0x3c, 0x9f, 0x9e, 0x08, 0xc3, 0x84, 0x55, 0xc1, 0x62, 0x11, 0xb1,
0x41, 0x28, 0x97, 0x8e, 0x49, 0x53, 0x92, 0x84, 0x5d, 0x1a, 0x21, 0xa2, 0x70, 0x21, 0x97, 0x8e,
0x28, 0x83, 0x04, 0x4b, 0xc1, 0x62, 0xf0, 0xc0, 0xb4, 0xa9, 0x87, 0xcf, 0xcb, 0x57, 0xbb, 0x56,
0x98, 0xf1, 0xf7, 0x1c, 0x1b, 0xb7, 0x7d, 0xda, 0xa1, 0xb0, 0x43, 0xf9, 0xdd, 0x7b, 0xc2, 0x76,
0xcf, 0xbf, 0xad, 0x9b, 0x23, 0x95, 0x09, 0x4d, 0xb5, 0xab, 0x62, 0x36, 0x2e, 0xee, 0xca, 0x55,
0x9e, 0xaf, 0x5c, 0x0c, 0x23, 0x87, 0x3a, 0x67, 0xce, 0xbd, 0x80, 0xd3, 0x87, 0xcf, 0x87, 0xfc,
0xba, 0x97, 0xf9, 0xd2, 0x90, 0xd2, 0x85, 0xc8, 0x8f, 0xcd, 0xbb, 0x95, 0xc4, 0x35, 0xc5, 0x3a,
0xa1, 0x4f, 0x94, 0x15, 0x53, 0xaf, 0x38, 0xdf, 0x41, 0x49, 0x11, 0x5c, 0xb1, 0x30, 0x8b, 0x76,
0x56, 0x0c, 0x2c, 0xf4, 0xb0, 0x48, 0xf6, 0x43, 0x79, 0xf9, 0xb1, 0x1c, 0x53, 0xd3, 0x2c, 0x38,
0xca, 0x55, 0x9e, 0xaf, 0x5e, 0x5f, 0x50, 0xe6, 0xb6, 0x6f, 0xf3, 0xfb, 0xd5, 0x32, 0xd5, 0xaa,
0xfb, 0x81, 0xfa, 0x26, 0x6f, 0x9f, 0xcf, 0xcf, 0x4d, 0x18, 0x41, 0x66, 0x06, 0x44, 0x0a, 0xde,
0xf5, 0x09, 0xd8, 0xc7, 0x21, 0x6a, 0x20, 0x35, 0xb3, 0x37, 0x9d, 0x2e, 0x7e, 0x60, 0x2b, 0x1f,
0x69, 0x45, 0xfd, 0x47, 0xb6, 0x7f, 0xcd, 0xea, 0x95, 0x5c, 0x57, 0xa2, 0xad, 0x0b, 0xe2, 0x3d,
0xac, 0x62, 0xb6, 0x1e, 0xee, 0x09, 0x1c, 0x59, 0x24, 0xe4, 0xa4, 0xcf, 0x08, 0x74, 0x12, 0x80,
0x88, 0x86, 0x80, 0x3b, 0x26, 0xb9, 0x64, 0xd0, 0x87, 0x00, 0xfa, 0x4f, 0xfc, 0xdb, 0x07, 0x4c,
0xdf, 0xd4, 0x58, 0xce, 0xc3, 0x0b, 0x2e, 0x78, 0x8a, 0x7d, 0x40, 0xb6, 0xf8, 0x65, 0x35, 0xe8,
0x33, 0xc5, 0x08, 0x73, 0x45, 0xe9, 0xd4, 0x11, 0x62, 0xe4, 0x94, 0xd9, 0x0d, 0x6a, 0x85, 0x74,
0x44, 0x21, 0xa3, 0xd0, 0x08, 0x52, 0xc4, 0xac, 0x38, 0x85, 0xaa, 0x13, 0x9e, 0xfe, 0x4d, 0x4c,
0xf3, 0xb7, 0x6d, 0x51, 0xd7, 0xfd, 0x28, 0x85, 0x25, 0x0a, 0x63, 0x4e, 0xdf, 0x80, 0x75, 0x1d,
0x29, 0x52, 0x45, 0x81, 0x14, 0x01, 0x82, 0x9f, 0xc0, 0x8d, 0xa3, 0x56, 0xa3, 0x48, 0x59, 0x15,
0xf1, 0xcc, 0x72, 0x46, 0x38, 0xfa, 0x18, 0x13, 0xa6, 0x8d, 0x77, 0xc2, 0x57, 0x6c, 0x19, 0x31,
0x1e, 0x32, 0x73, 0x5f, 0x8c, 0x30, 0x6e, 0x15, 0x8d, 0xe0, 0xcf, 0x74, 0x4a, 0x20, 0xeb, 0x3a,
0x36, 0xd2, 0xf8, 0x9d, 0x16, 0xbf, 0x5d, 0x05, 0x75, 0xb7, 0x60, 0x6e, 0x01, 0x49, 0x72, 0xa4,
0x2f, 0x7b, 0xec, 0xda, 0x39, 0x69, 0x8f, 0xe2, 0xe0, 0x7d, 0x33, 0x52, 0x44, 0x41, 0xa1, 0x88,
0x24, 0x5e, 0xe9, 0xa2, 0x61, 0x7f, 0xa6, 0x54, 0xa8, 0x26, 0x3f, 0x3c, 0xd7, 0xb3, 0x51, 0xf7,
0xbf, 0x7a, 0x66, 0x47, 0xa9, 0xb8, 0x53, 0x36, 0x6c, 0x2f, 0x2a, 0x05, 0x4e, 0x0e, 0x76, 0xea,
0x3e, 0x5f, 0x22, 0x5c, 0xd7, 0x86, 0xfe, 0xbe, 0xe1, 0xd8, 0xef, 0xf5, 0x67, 0x0b, 0x63, 0xe5,
0x76, 0xec, 0x66, 0xa6, 0x41, 0xfe, 0x36, 0x02, 0xd0, 0x7c, 0xe6, 0xce, 0xd7, 0xb9, 0xef, 0x03,
0x43, 0xbc, 0x0d, 0xb9, 0xce, 0xbd, 0x25, 0x01, 0xee, 0xa0, 0xab, 0x28, 0x75, 0x7c, 0x9a, 0x32,
0x8e, 0x1e, 0xb3, 0x58, 0x2d, 0x87, 0x2a, 0x6e, 0x88, 0x52, 0x39, 0x53, 0xd8, 0xda, 0x98, 0xad,
0x90, 0x7f, 0xfa, 0x60, 0x45, 0xa9, 0x99, 0x11, 0x92, 0x26, 0x11, 0xff, 0xda, 0xaf, 0x2b, 0x75,
0x56, 0x8d, 0x45, 0xc1, 0x8f, 0x62, 0x2f, 0x01, 0x27, 0xfb, 0x92, 0x26, 0x87, 0x2d, 0x87, 0x14,
0xb5, 0x56, 0xa9, 0x68, 0x84, 0xab, 0x8b, 0x56, 0xf3, 0x8c, 0x15, 0x56, 0x87, 0x51, 0xa4, 0xd8,
0xd4, 0xa7, 0x6d, 0x68, 0xc6, 0x4d, 0xb1, 0xef, 0x0d, 0x18, 0xa3, 0x40, 0x5d, 0x06, 0x49, 0xc9,
0xe2, 0xed, 0x07, 0x2f, 0xe0, 0x8b, 0xfa, 0xe9, 0x39, 0xff, 0x12, 0x07, 0x59, 0x5e, 0xf2, 0xbd,
0xfe, 0xdd, 0x5b, 0x5c, 0x22, 0x71, 0x8b, 0x11, 0x42, 0x02, 0xab, 0x0a, 0x9a, 0x17, 0xab, 0x7c,
0x65, 0x17, 0x0a, 0xc8, 0x99, 0x86, 0xac, 0xb0, 0x22, 0xe7, 0x0b, 0x00, 0x55, 0x9a, 0x11, 0xbe,
0x05, 0x12, 0x24, 0x1f, 0x2c, 0x7b, 0x51, 0x8e, 0x6b, 0xa2, 0x34, 0x4d, 0x29, 0x38, 0x97, 0xc4,
0x8a, 0xbd, 0x6b, 0x21, 0x36, 0xdc, 0xbc, 0xea, 0x5f, 0xb8, 0x9a, 0x17, 0xb4, 0x7c, 0x97, 0x06,
0xfe, 0xbe, 0xe7, 0xf9, 0xad, 0x50, 0x2d, 0x7e, 0x68, 0xf3, 0x7b, 0xd7, 0xf1, 0x88, 0x1d, 0xa7,
0xa5, 0xe4, 0x1c, 0xe4, 0xb7, 0x2c, 0xfa, 0xf3, 0x7b, 0x2b, 0x93, 0x3d, 0x0f, 0x5c, 0x25, 0x6b,
0x89, 0x59, 0xbf, 0x02, 0xef, 0xa0, 0x84, 0x9e, 0x5e, 0xdb, 0x5c, 0x7a, 0x52, 0xab, 0xea, 0x09,
0x36, 0x56, 0xb8, 0x32, 0xf9, 0xd3, 0xd8, 0x3b, 0x7b, 0xeb, 0x1c, 0x06, 0x29, 0xc6, 0xe8, 0xd2,
0x2f, 0x7d, 0x73, 0xf5, 0x77, 0x33, 0x63, 0x1d, 0x4f, 0x3d, 0xc6, 0xcc, 0xc7, 0xe4, 0xa4, 0x15,
0x01, 0x7c, 0xfc, 0x6c, 0x5d, 0xd9, 0x58, 0x72, 0x7f, 0xe8, 0x8d, 0xc7, 0xaa, 0x6e, 0x88, 0xb3,
0xda, 0x95, 0x54, 0xc2, 0x89, 0x6e, 0x37, 0x31, 0x45, 0x1a, 0x50, 0xaf, 0x5c, 0x0c, 0x23, 0x87,
0x44, 0x24, 0x9b, 0xf4, 0x5c, 0xd3, 0x1a, 0x88, 0x34, 0x73, 0x96, 0x45, 0x36, 0x4d, 0xa4, 0x03,
0xea, 0x89, 0xf9, 0x9e, 0xd0, 0x83, 0x5f, 0xc3, 0x98, 0x25, 0xaa, 0x81, 0x4b, 0x72, 0x85, 0x4c,
0x42, 0xa2, 0x46, 0xde, 0xd9, 0xa4, 0x40, 0xfb, 0x1a, 0x17, 0x99, 0x3e, 0x30, 0x63, 0x09, 0x10,
0xb7, 0x60, 0xb6, 0x67, 0xdc, 0x9b, 0xd7, 0x7d, 0xda, 0xbe, 0xb3, 0x94, 0x0b, 0xa3, 0x6f, 0xc8,
0xb9, 0x09, 0xfe, 0xbe, 0xe4, 0xd8, 0xfc, 0xda, 0x5a, 0x97, 0xb7, 0x9d, 0x4c, 0x53, 0xb4, 0x4b,
0xc9, 0xbd, 0x5a, 0xbe, 0x92, 0xd6, 0x6c, 0x78, 0x18, 0x57, 0x51, 0x16, 0xa0, 0xc2, 0x3b, 0x5a,
0x9d, 0x41, 0x4f, 0xbd, 0x99, 0xf1, 0x79, 0x33, 0x6c, 0x74, 0x8b, 0x10, 0x29, 0xef, 0x32, 0x47,
0xad, 0xdd, 0xcb, 0xad, 0x50, 0xe0, 0xd8, 0x99, 0xd8, 0x63, 0x0c, 0x47, 0xa4, 0x82, 0x40, 0xe0,
0x84, 0x69, 0xd5, 0x16, 0x90, 0x04, 0xd4, 0x58, 0xcd, 0xb2, 0x02, 0x8a, 0xeb, 0x3c, 0x1a, 0x4a,
0xfc, 0x8b, 0xdc, 0xfd, 0x44, 0x70, 0xc4, 0x56, 0x17, 0xc5, 0x2a, 0x13, 0xd5, 0x49, 0xd9, 0x12,
0x72, 0x24, 0x3c, 0x58, 0x9b, 0x9a, 0xa7, 0x4c, 0x5b, 0x73, 0x81, 0x2a, 0x08, 0xfc, 0xba, 0xb6,
0xab, 0x27, 0x54, 0xa2, 0x0c, 0x90, 0x09, 0xd9, 0x61, 0x08, 0x4f, 0x95, 0xa0, 0x04, 0x68, 0x94,
0x89, 0x95, 0x96, 0xf1, 0xc6, 0x50, 0x4c, 0x98, 0xd0, 0x69, 0xb5, 0x42, 0xe2, 0x4a, 0x8a, 0xfe,
0x9e, 0x63, 0xad, 0x2f, 0xb5, 0x2f, 0x01, 0xdb, 0x92, 0x9b, 0xec, 0x52, 0x44, 0xcf, 0x0c, 0xbb,
0x1c, 0x98, 0x47, 0x2f, 0x9a, 0x21, 0xdb, 0x74, 0x7f, 0x11, 0x9f, 0xe1, 0x07, 0xdc, 0x7a, 0x15,
0xc6, 0x81, 0xc3, 0xcc, 0x55, 0x39, 0x51, 0x1a, 0x47, 0x52, 0x7b, 0xf3, 0x34, 0x2a, 0xea, 0xc4,
0x64, 0x28, 0x7b, 0x7b, 0xe5, 0xc8, 0x30, 0x63, 0x9b, 0x8a, 0x51, 0x1f, 0xd2, 0x64, 0x09, 0x1b,
0x8d, 0x6e, 0xf4, 0x8e, 0x92, 0xfa, 0x1e, 0x7f, 0xa1, 0x2a, 0x46, 0x46, 0xe6, 0x83, 0xe6, 0x06,
0xc1, 0x70, 0xa2, 0x85, 0x49, 0x4d, 0x62, 0xe0, 0x7f, 0x16, 0x0f, 0xdd, 0x7f, 0xb8, 0x79, 0x4f,
0x53, 0x85, 0xc8, 0x76, 0xbc, 0x83, 0x2d, 0x1a, 0xec, 0xf1, 0xe9, 0x41, 0x69, 0x6c, 0xf2, 0x0f,
0x76, 0x1a, 0x7d, 0x8a, 0x93, 0x54, 0x6c, 0xe3, 0xe5, 0x0b, 0x45, 0x4b, 0xc3, 0x55, 0x68, 0x4e,
0xc2, 0x5b, 0x6f, 0x1b, 0x89, 0x83, 0x73, 0xef, 0xb8, 0xfe, 0x03, 0xec, 0xdb, 0xc8, 0xfb, 0x83,
0xcc, 0xf0, 0x4a, 0x74, 0xc1, 0x4b, 0xa1, 0x0a, 0xfd, 0xf2, 0xef, 0x4d, 0x50, 0x1e, 0x56, 0x26,
0x24, 0x9f, 0x77, 0x7f, 0x58, 0xc2, 0x40, 0x3b, 0x55, 0x15, 0x85, 0xcb, 0xa2, 0xb6, 0x2e, 0x81,
0x7a, 0xd0, 0x3c, 0x50, 0xf5, 0x6b, 0x41, 0xe2, 0x22, 0x89, 0x31, 0xde, 0xc3, 0x3c, 0xb9, 0x78,
0x7d, 0xe9, 0xd0, 0x1a, 0x00, 0x45, 0x56, 0xe5, 0x9f, 0xbf, 0x08, 0x11, 0xe5, 0x07, 0x0c, 0x43,
0x94, 0x92, 0x84, 0x42, 0x28, 0x66, 0x75, 0xdb, 0x86, 0x2f, 0xfe, 0x1c, 0x8f, 0x85, 0x9d, 0x19,
0xf2, 0x27, 0x18, 0x8b, 0x66, 0x54, 0x9a, 0xe3, 0xe5, 0x14, 0x34, 0xfe, 0xa7, 0xf8, 0xb2, 0xda,
0xaa, 0x02, 0xbf, 0xca, 0x97, 0x99, 0x3a, 0xe2, 0x77, 0x2b, 0x55, 0x0e, 0x32, 0xf8, 0xec, 0x7f,
0x2b, 0x09, 0xf1, 0x49, 0x90, 0x02, 0xd4, 0x6e, 0x81, 0xfe, 0xf9, 0x4f, 0x4d, 0xf9, 0xc7, 0xee,
0xe1, 0x37, 0x08, 0x8e, 0x68, 0xb4, 0x27, 0xdd, 0x67, 0x4c, 0xe9, 0x68, 0x5d, 0xdd, 0x63, 0x18,
0x9f, 0x99, 0xa2, 0x15, 0x08, 0x54, 0xa5, 0xf7, 0x13, 0x60, 0x55, 0xb5, 0x49, 0x18, 0x13, 0x04,
0x39, 0xb4, 0xf5, 0x37, 0x6b, 0x8a, 0xe6, 0x2f, 0x6b, 0x57, 0x72, 0x70, 0x86, 0xb3, 0xf3, 0x82,
0x6a, 0x66, 0xd0, 0x41, 0xd2, 0xff, 0x5b, 0xe0, 0xef, 0xc6, 0x73, 0x9a, 0xe3, 0x11, 0xf3, 0x55,
0x46, 0x41, 0xa0, 0x86, 0x24, 0xbf, 0x2b, 0x44, 0x85, 0x6b, 0x14, 0xea, 0x16, 0x39, 0x9a, 0x2b,
0x49, 0xb0, 0xfe, 0x05, 0x8c, 0x46, 0xc7, 0x2f, 0x4e, 0x96, 0xb2, 0x39, 0xd5, 0x3f, 0xfa, 0x05,
0x68, 0x41, 0xea, 0xcf, 0x7b, 0x26, 0xbc, 0x3b, 0xe8, 0xc8, 0x96, 0x0d, 0x7c, 0x01, 0x42, 0x51,
0x00, 0xd7, 0x09, 0xa3, 0x43, 0x44, 0xab, 0x43, 0x8f, 0x41, 0xbc, 0x3b, 0xc9, 0x8a, 0xa9, 0xcb,
0xc8, 0xdb, 0xf6, 0xfc, 0xd3, 0x19, 0x68, 0xb8, 0xc0, 0x8f, 0x08, 0x32, 0xf1, 0xec, 0x84, 0x80,
0x1e, 0xb9, 0x29, 0x12, 0x0c, 0x29, 0xcc, 0x9c, 0xd0, 0x10, 0xa7, 0xd6, 0x8a, 0xe9, 0xf6, 0xfa,
0x8d, 0x7e, 0x95, 0x2e, 0x57, 0xcf, 0x8e, 0x38, 0x6b, 0x35, 0xf0, 0x2f, 0xa6, 0x4f, 0x2a, 0x7b,
0x4b, 0x1e, 0x62, 0x81, 0x78, 0xb0, 0x48, 0x40, 0x7f, 0xdb, 0x7f, 0x4e, 0x1b, 0x8f, 0xf8, 0x0d,
0x1f, 0x28, 0x08, 0x95, 0x62, 0xc0, 0xea, 0x94, 0xf8, 0xd4, 0x92, 0xa6, 0xb7, 0x32, 0xba, 0x36,
0xc2, 0xf8, 0x66, 0x57, 0x89, 0x44, 0x8a, 0x9b, 0x6e, 0x39, 0x98, 0xc2, 0x86, 0x62, 0xb8, 0x02,
0x06, 0x4d, 0xeb, 0x7f, 0xfd, 0xd9, 0x18, 0xe1, 0x3c, 0x52, 0x91, 0x80, 0xe9, 0xe5, 0x41, 0xff,
0x12, 0xe6, 0x43, 0xfa, 0x69, 0xf8, 0x3b, 0xba, 0x48, 0xd1, 0xa8, 0x0f, 0x3c, 0x2e, 0x5e, 0x12,
0x58, 0x97, 0x25, 0x5e, 0x15, 0x29, 0xf0, 0x05, 0x33, 0xc1, 0x31, 0xc5, 0xaf, 0x87, 0x6b, 0x9f,
0xee, 0x39, 0x0d, 0x12, 0x76, 0x44, 0xeb, 0xf6, 0x59, 0x71, 0x6e, 0xe0, 0xd6, 0x78, 0xbc, 0xd9,
0x91, 0x26, 0x17, 0x28, 0xea, 0x02, 0xb4, 0x96, 0xc5, 0x35, 0xd9, 0x31, 0xd2, 0x57, 0x48, 0x4b,
0x69, 0xa3, 0x65, 0x5b, 0xf3, 0xbd, 0x79, 0x46, 0xb0, 0x43, 0xf6, 0xac, 0x9b, 0x44, 0xed, 0x81,
0xb4, 0xa0, 0xb5, 0xa0, 0xb1, 0x48, 0x02, 0x08, 0x01, 0xd0, 0x11, 0xaf, 0xe6, 0x5d, 0xc8, 0x55,
0x88, 0xba, 0x43, 0xe3, 0x4d, 0x3c, 0x81, 0xb6, 0x89, 0x1a, 0x4a, 0xfb, 0x6a, 0xdd, 0x88, 0x7d,
0xa1, 0x8b, 0x77, 0xdf, 0x95, 0x95, 0x35, 0x38, 0x80, 0x77, 0xdc, 0xb0, 0xeb, 0x2b, 0xc8, 0x87,
0xe8, 0x02, 0x2d, 0xd9, 0xb3, 0x0f, 0xf1, 0xa1, 0xe7, 0x03, 0xb5, 0x29, 0xf6, 0xf3, 0x10, 0x92,
0xe2, 0x30, 0xd2, 0x86, 0x85, 0x91, 0xd8, 0xb5, 0xaf, 0x5b, 0x73, 0x23, 0x43, 0x62, 0xc1, 0x66,
0x28, 0xb4, 0xad, 0x5f, 0x78, 0x53, 0x05, 0x69, 0x50, 0x22, 0xc6, 0x0e, 0x9e, 0x9f, 0x9d, 0xb8,
0xd3, 0x05, 0x69, 0x50, 0x03, 0x65, 0x29, 0xb1, 0xe0, 0x42, 0xe7, 0x4c, 0xfb, 0x55, 0x09, 0x90,
0xa2, 0xc6, 0xef, 0x3d, 0xf8, 0x72, 0x66, 0x2f, 0xdc, 0x3a, 0xf6, 0x4f, 0xfd, 0x59, 0x30, 0xe2,
0x27, 0xcc, 0xfb, 0x55, 0x09, 0x71, 0x41, 0xe1, 0x21, 0xa1, 0xa1, 0xc0, 0xe3, 0x25, 0xa9, 0xd0,
0x22, 0xc6, 0xef, 0x5c, 0x1b, 0xb4, 0xea, 0x56, 0x2e, 0xbf, 0xfc, 0x5b, 0x34, 0xcb, 0x14, 0x8b,
0x94, 0xaa, 0xb7, 0xec, 0x5a, 0x36, 0xcf, 0x1c, 0xba, 0xf6, 0x9f, 0xdc, 0x35, 0xf3,
};
#endif
