# Adafruit Feather M4 Express

The Feather M4 Express features an ATSAMD51J19 (a 120MHz Cortex M4 with
floating point support, 512KB Flash and 192KB RAM), plus a number of extra
peripherals for support.

[Main Product Page](https://www.adafruit.com/product/3857)

[User Guide](https://learn.adafruit.com/adafruit-feather-m4-express-atsamd51)

## Board Details

### Pins available
The Feather boards have dimensions of 51mm x 23mm for a fairly compact form
factor. That does, however, limit the number of pins broken out on the board.

Out of 51 GPIO pins on the SAMD51J19, only 22 have pads for the breakout headers.
One of these, labeled AREF (PA03), is connected directly to 3.3V and thus cannot
be used for IO. (This is due to a problem with the chip itself; the DAC will not
function without this connection. If the DAC is not needed, the trace can be
cut and the pin used as desired.)

There are seven other pins not broken out but used for devices on-board:
six are used for a 2MB QSPI Flash, and one for the 'Neopixel', Adafruit's
name for a WS2812 RGB LED.

Pins PA30-PA31 have pads on the underside of the board for the Serial Wire
Debug Interface (SWCLK and SWDIO, respectively), allowing connection to a
debug probe.

The [pinouts](https://learn.adafruit.com/adafruit-feather-m4-express-atsamd51/pinouts)
page in the User Guide has further information, photos, and a useful diagram
showing the various pin functions. (This diagram does have some errors, however;
the most noticeable being the labeling of several pins as outputs for TC6 & TC7,
Timer/Counters which are not present on the chip.)

### Board labeling

Most pins broken out on the board are labeled Arduino-style, with A0-A5 having
'analog' functions, and 0-13 (not all of which are available) for 'digital'.
A few pins are labeled for specific functions, e.g. SPI, I2C, etc. All pins
are aliased in 'board.hpp' to their GPIO equivalents; the 'digital' (0-13)
pin aliases are prefixed with a 'D'.

## Clocks

Although the SAMD51 has pins available for crystal oscillators XOSC1 and XOSC2,
there are no crystals installed on this board for their use. There is, however,
a 32kHz crystal for the XOSC32K oscillator.

Typically, an FDPLL is used as the system clock after bootup is complete; and
using XOSC32K as a reference for it is not reliable. Even when using the workaround
prescibed in Item 2.13 of the [Errata](https://ww1.microchip.com/downloads/aemDocuments/documents/MCU32/ProductDocuments/Errata/SAM-D5x-E5x-Family-Silicon-Errata-and-Data-Sheet-Clarification-DS80000748.pdf),
the result is usually failure.

The simplest solution is to source a GCLK generator with the 48MHz DFLL, and
use a division factor that creates a suitable reference frequency for the FDPLL
(e.g. 1-2MHz). It can be done with the DFLL in open- or closed-loop mode, but
in order to meet the USB timing specs, closed-loop with XOSC32K as reference is
used here.

## Programming

The Feather M4 has a [UF2](https://github.com/microsoft/uf2) bootloader. By
using a utility to convert the '.elf' files (generated by scons or make) to
'.uf2' files, it is then possible to copy the uf2 file directly to the board.

In modm, the conversion utility is called 'elf2uf2.py' (in tools/modm_tools),
and is incorporated into the build system. Use 'scons uf2' or 'make uf2' to
create the uf2 file.

Alternatively, the bootloader on the Feather is compatible with [BOSSA](https://www.shumatech.com/web/products/bossa);
so another method is to use 'scons program-bossac' or 'make program-bossac' to
load your program into flash.

With either method, you must press the reset button twice to get the board into
bootloader mode before flashing with BOSSA or UF2 copying. (In bootloader mode,
a volume named FEATHERBOOT will be mounted; and that is where the UF2 file
should be copied.)

