## 2024-10-01: 2024q3 release

This release covers everything from 2024-07-01 and has been tested with avr-gcc
v12.2.0 from Upstream and arm-none-eabi-gcc v12.2.1 from xpack.

Breaking changes:

- Deprecate `modm::allocator::Dynamic` in favor of `std::allocator`.
- STM32 FDCAN queue mode is switched from queue to FIFO mode.

Features:

- Add empty polyfill for fibers when module is not selected.
- Replace modm containers implementation with libstdc++.
- Add support for a custom allocator in the `modm:ui` module.
- Add IWDG driver for STM32H7.
- Add FDCAN driver for STM32H7.
- Support for STM32C0 devices.

Integrated Projects:

- ETL upgraded to v20.38.17.
- STM32F3 headers upgraded to v2.3.8.
- STM32F7 headers upgraded to v1.2.9.
- STM32F4 headers upgraded to v2.6.10.
- STM32G4 headers upgraded to v1.2.4.
- STM32C0 headers upgraded to v1.2.0.
- STM32U0 headers added at v1.1.0.

Fixes:

- Fix `modm::GraphicDisplay::clearPixel()` implementation.
- Fix wrong ADC channel selection on STM32C0/G0/F0.
- Fix fiber poll timeout when yield takes too long.
- Fix infinite loop in fiber poll when duration is 0.
- Ensure fiber poll minimum duration is 1µs/1ms.
- Add missing device definitions to CMSIS-DSP headers.
- Fix zero initialization of FDCAN message RAM leading to wrong CAN filters.

New development boards:

- NUCLEO-C031C6 as `modm:board:nucleo-c031c6`.

Known bugs:

- STM32F723 is missing support to use built-in USB HS PHY. See #1171.
- OpenOCD cannot enable SWO on STM32H7 targets. See #1079.
- Compiling Protothreads and Resumable Functions is broken on GCC13. See #1012.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.
- STM32F7: D-Cache not enabled by default. See #485.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Caleb Chalmers (@calebchalmers) 🎉
- Christopher Durand (@chris-durand)
- Jörg Ebeling (@Apehaenger) 🎉
- Kaelin Laundry (@WasabiFan)
- Marco Miralles (@minco3) 🎉
- Matthew Arnold (@MatthewMArnold) 🎉
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)

PR #1209 -> 2024q3.

<details>
<summary>Detailed changelog</summary>

#### 2024-09-26: Add support for STM32C0

PR #1188 -> a7cfe65.  
Tested in hardware by @Apehaenger and @salkinium.

#### 2024-09-25: Add FDCAN driver for STM32H7

Queue Mode will send CAN frames in priority order according to their
arbitration ID. This is inconsistent with modm's software-managed queue
which is a strict FIFO. To make the behavior of the driver consistent
with an end-to-end FIFO order, we disable Queue Mode by default.

There is a new lbuild option, `tx_hw_queue_mode`, which allows the user
to opt back into the old behavior if desired. This is mostly intended
for if they also set `buffer.tx` to zero and optionally increase
`message_ram.tx_fifo_elements`.

PR #1206 -> 3614dc0.  
Tested in hardware by @WasabiFan and @chris-durand.

#### 2024-08-22: Add IWDG driver for STM32H7

PR #1204 -> 5ae26dd.  
Tested in hardware by @salkinium.

#### 2024-08-13: Fix fiber poll functions

PR #1196 -> 1319de9.  
Tested in hardware by @salkinium.

#### 2024-08-08: Add custom allocator to `modm:ui` module

Add support for custom allocators to all related classes.

PR #1184 -> 31bbf48.  
Tested by @MatthewMArnold.

#### 2024-07-21: Replace modm containers with libstdc++

Backwards compatible wrapping of standard containers:

- `modm::Pair` -> `std::pair`.
- `modm::DynamicArray` -> `std::vector`.
- `modm::DoublyLinkedList` -> `std::list`.
- `modm::LinkedList` -> `std::list`.

PR #1195 -> 5fcd015.  
Tested by @chris-durand.

#### 2024-07-07: Fiber polyfill

Empty implementations for `modm::this_fiber::yield()` and
`modm::this_fiber::get_id()`.

PR #1172 -> 6a6802a.  
Tested in hardware by @salkinium.

</details>
