## 2024-07-01: 2024q2 release

This release covers everything from 2024-04-01 and has been tested with avr-gcc
v12.2.0 from Upstream and arm-none-eabi-gcc v12.2.1 from xpack.

Breaking changes:

- The STM32 UART peripheral moves the buffer configuration from lbuild to C++.
- Renames `modm::fiber::yield()` to `modm::this_fiber::yield()`.
- Renames `modm::fiber::sleep()` to `modm::this_fiber::sleep_for()`.

Features:

- Added `:platform:cortex-m:linkerscript.flash_reserved` option to reserve space
  at the end of FLASH.
- Add DMA capabilities to STM32F0/G0 ADC.
- Implement full atomics interface for AVR and STM32.
- Implement C++ concurrency interface for fibers.
- Add fiber stack overflow detection on ARMv8-M.

Integrated Projects:

- nlohmann/json added at v3.11.3.

Fixes:

- Communicate `:platform:cortex-m:linkerscript.flash_offset` to dfu-util tool.
- Fix flash section erasing on STM32G4.
- Fix static initialization guard implementation.

New device drivers:

- AS5600 absolute encoder driver as `modm:driver:as5600`.

Known bugs:

- STM32F723 is missing support to use built-in USB HS PHY. See #1171.
- OpenOCD cannot enable SWO on STM32H7 targets. See #1079.
- Compiling Protothreads and Resumable Functions is broken on GCC13. See #1012.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.
- STM32F7: D-Cache not enabled by default. See #485.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Akos Becsey (@becseya) 🎉
- Christopher Durand (@chris-durand)
- Daniel Waldhäusl
- Dima Barsky (@kapacuk)
- Hannes Ellinger (@el-han) 🎉
- Henrik Hose (@hshose)
- Niklas Hauser (@salkinium)
- Thomas Sommer (@TomSaw)

PR #1175 -> 2024q2.

<details>
<summary>Detailed changelog</summary>

#### 2024-06-24: Move buffer configuration from lbuild to C++ for STM32

The buffer configuration is now implemented in C++.
Please replace any `modm::platform::U(s)artN` type with:

```cpp
using namespace modm::platform;
// Using only hardware buffers for Tx and Rx (both 1 symbol)
using UartN = BufferedUart<U(s)artHalN>;
// using only TX software buffer
using UartN = BufferedUart<U(s)artHalN, UartTxBuffer<512>>;
// using only RX software buffer
using UartN = BufferedUart<U(s)artHalN, UartRxBuffer<256>>;
// using both TX and RX software buffers
using UartN = BufferedUart<U(s)artHalN, UartTxBuffer<512>, UartRxBuffer<256>>;
```

PR #1156 -> cf7769b.  
Tested in hardware by @kapacuk and @salkinium.

#### 2024-06-17: Add AS5600 absolute encoder driver

PR #1166 -> 55c88ba.  
Tested in hardware by @tomsaw.

#### 2024-06-16: Add fiber stack overflow detection on ARMv8-M

PR #1168 -> 6be3199.  
Tested in hardware by @salkinium.

#### 2024-05-20: Implement concurrency interface for fibers

PR #1026 -> 39a9f4d.  
Tested in hardware by @salkinium.

#### 2024-05-20: Implement all atomics for AVR and STM32

PR #1164 -> 8a924f9.  
Tested in hardware by @salkinium.

#### 2024-05-19: Add DMA capabilities to STM32F0/G0 ADC

PR #1136 -> 901a3dc.  
Tested in hardware by @victorandrehc.

#### 2024-05-19: Fix STM32G4 flash erase

PR #1146 -> 71becdc.  
Tested in hardware by @hshose.

</details>
