## 2024-04-01: 2024q1 release

This release covers everything from 2024-01-01 and has been tested with avr-gcc
v12.2.0 from Upstream and arm-none-eabi-gcc v12.2.1 from xpack.

Breaking changes:

- TinyUSB v0.16 implements a DFU class in addition to a DFU *runtime* class.
  Therefore the `modm:tinyusb:config:device.dfu` option was renamed to
  `device.dfu_rt` to align with the TinyUSB naming.
- TinyUSB v0.16 improves support for using two USB ports at the same time. A
  differnt port can now be chosen for device and host classes. In addition, the
  HS peripheral may be operated in FS mode, therefore the `modm:tinyusb:speed`
  option was renamed to `modm:tinyusb:max-speed` since it now has a different
  meaning.
- Remove the separate `hosted-rpi` Raspberry Pi target in favor of plain
  `hosted-linux`. Its GPIO implementation based on wiringPi is removed.

Features:

- Add USB High-Speed support to all development boards with ULPI interface.
- Catch accidental use of Newlib's printf implementation.
- Fibers are now implemented for ARM64, albeit only on Linux and macOS.
- Add BDMA driver for STM32H7.
- DMA support for ADC driver on STM32F3 and STM32G4.
- Support for ADC conversion sequences on STM32F3 and STM32G4.
- Add Prescaler+Counter constexpr algorithm and use it in `Iwdg::initialize()`.
- Add PWM modes, break input and comparator to Timer driver on STM32.
- CMake generator now works with multiple lbuild repositories.
- Allow setting I2C interrupt priority for STM32 and SAMx7x.

Integrated Projects:

- TinyUSB upgraded to v0.16.0.
- STM32G0 headers upgraded to v1.4.4.
- STM32G4 headers upgraded to v1.2.3.
- STM32H5 headers upgraded to v1.2.0.
- STM32H7 headers upgraded to v1.10.4.
- STM32L5 headers upgraded to v1.0.6.
- STM32U5 headers upgraded to v1.4.0.
- STM32WB headers upgraded to v1.12.1.

Fixes:

- Fix `Rcc::enable()` for STM32H7 comparator.
- Fix Timer 23 and 24 counter size on STM32H7.
- Fix ADC asynchronous clock on STM32H7.
- Fix DMA enable on STM32G0.
- Fix reconfiguring DMAMUX requests.
- Fix ADC sampling time configuration on STM32F3.
- Separate ULPI clock from USB clock on STM32 to allow using OTGHS in FS mode.
- Stack alignment underneath promise in fiber tasks.
- Move `Iwdg` driver to `modm::platform::Iwdg` namespace.
- Fix flash page size for large F103, F105 and F107 devices.

New development boards:

- DISCO-F401VC as `modm:disco-f401vc`.
- NUCLEO-G070RB as `modm:nucleo-g070rb`.
- DISCO-F411VE as `modm:disco-f411ve`.

New device drivers:

- AS5047 absolute encoder driver as `modm:driver:as5047`.

Known bugs:

- OpenOCD cannot enable SWO on STM32H7 targets. See #1079.
- Compiling Protothreads and Resumable Functions is broken on GCC13. See #1012.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.
- STM32F7: D-Cache not enabled by default. See #485.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Carl Treudler (@cajt)
- Christopher Durand (@chris-durand)
- Daniel Waldhäusl
- Dima Barsky (@kapacuk) 🎉
- Henrik Hose (@hshose)
- Michael Jossen (@Javask) 🎉
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Thomas Sommer (@TomSaw)
- Victor Costa (@victorandrehc)

PR #1153 -> 2024q1.

<details>
<summary>Detailed changelog</summary>

#### 2024-03-15: Allow I2C interrupt priority to be set

PR #1143 -> 734de07 and PR #1148 -> e1d8a17.  

#### 2024-03-09: Adapt CMake generator to multiple lbuild repositories

PR #1140 -> 1a89fbe.  
Tested in hardware by @Javask.

#### 2024-03-08: Extend Timer features for STM32G0

PR #1134 -> a371df6.  
Tested in hardware by @victorandrehc.

#### 2024-03-08: Add AS5047 absolute encoder driver

PR #1138 -> dbfd93b.  
Tested in hardware by @hshose.

#### 2024-03-06: Add DISCO-F411VE board support

PR #1135 -> 009bb06.  
Tested in hardware by @tomsaw.

#### 2024-02-06: Use Prescaler+Counter algorithm for `Iwdg::initialize()`

PR #1127 -> 23036e3.  
Tested in hardware by @salkinium.

#### 2024-02-05: Add DMA and conversion sequence support to STM32F3/G4 ADC

PR #1126 -> fe4cbc5.  
Tested in hardware by @chris-durand.

#### 2024-02-02: Add NUCLEO-G070RB board support

PR #1125 -> 6de70ba.  
Tested in hardware by @chris-durand.

#### 2024-02-01: Add BDMA driver for STM32H7

PR #1115 -> 2e40ab4.  
Tested in hardware by @chris-durand.

#### 2024-01-21: Implement Fibers for ARM64

New targets with `-arm64` suffix, `-x86_64` is implicit for backwards
compatibility:

- `hosted-linux-arm64`
- `hosted-darwin-arm64`

Removed `hosted-rpi` target, as wiringPi is deprecated and thus the target lost
its only peripheral.

PR #1113 -> 623a13b.  
Tested in hardware by @salkinium (Apple Silicon M2) and @rleh (Raspberry Pi).

#### 2024-01-14: Catch Newlib's printf usage

This previously lead to cryptic linking failures due to a missing heap
implementation. Now any use of `printf` without including the `modm:printf`
module will lead to a linking failure with a proper error description.

PR #1120 -> 7318c28.  
Tested by @salkinium.

#### 2024-01-05: Upgrade TinyUSB to v0.16.0

PR #1116 -> 1f210c1.  
Tested in hardware by @salkinium with **high** impact on TinyUSB configuration.

#### 2024-01-05: Add DISCO-F401VC board support

PR #1117 -> 2381c61.  
Tested in hardware by @cajt.

#### 2024-01-04: Miscellaneous fixes for STM32H7 and STM32G0

PR #1114 -> 8bcbe25.  
Tested in hardware by @chris-durand.

</details>
