## 2024-01-01: 2023q4 release

This release covers everything from 2023-10-01 and has been tested with avr-gcc
v12.2.0 from Upstream and arm-none-eabi-gcc v12.2.1 from xpack.

Features:

- STM32H7 SPI driver with DMA support.

Integrated Projects:

- ETL upgraded to v20.38.10.
- LVGL upgraded to v8.3.11.
- Nanopb upgraded to v0.4.8.
- STM32G0 headers upgraded to v1.4.3.
- STM32F4 headers upgraded to v2.6.9.
- STM32U5 headers upgraded to v1.3.1.

Fixes:

- Fix SPI clocks on Nucleo-H723ZG boards.
- Do not require protothreads to use SPI with fibers.
- Place main stack in DMA-able SRAM on STM32H7.

New device drivers:

- BMI088 IMU driver as `modm:driver:bmi088`.

Known bugs:

- Fibers are not implemented for ARM64 targets. See #1111.
- OpenOCD cannot enable SWO on STM32H7 targets. See #1079.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Christopher Durand (@chris-durand)
- Jens Böckmann (@jensboe) 🎉
- Niklas Hauser (@salkinium)
- Sergey Pluzhnikov (@ser-plu)

PR #1112 -> 2023q4.

<details>
<summary>Detailed changelog</summary>

#### 2023-10-04: Add STM32H7 SPI driver with DMA support

PR #1052 -> 53796b0.  
Tested in hardware by @chris-durand.

#### 2023-10-05: Add BMI088 driver

PR #1052 -> a771042.  
Tested in hardware by @chris-durand.

</details>
