## 2023-07-01: 2023q2 release

This release covers everything from 2023-04-05 and has been tested with avr-gcc
v12.2.0 from Upstream and arm-none-eabi-gcc v12.2.1 from xpack.

Breaking changes:

- GCC12 requirement for C++23.
- `-fsingle-precision-constant` default compile flag has been removed.
- Removed deprecated `Timer::setPeriod(uint32_t)` in favor of`std::chrono` units.

Features:

- SAMx7x DAC, ADC, DMA, and CAN drivers.
- Enabled C++23 and C23.
- STM32 IWDG driver.
- Fibers are now backward compatible with protothreads and resumable functions.
- Support for STM32G0B/C devices with shared interrupts.

Integrated Projects:

- LVGL upgraded to v8.3.7.
- Pico-SDK upgraded to v1.5.1.
- STM32F1 headers upgraded to v4.3.4.
- STM32F2 headers upgraded to v2.2.6.
- STM32L1 headers upgraded to v2.3.3.
- CMSIS-DSP upgraded to v1.14.4.
- SAMx7x upgraded to v3.0.
- TinyUSB upgraded to v0.15.0.

Fixes:

- Moving average type selection.
- SysTick clock access from both cores on RP2040.
- FDCAN driver on STM32 tx message queue.
- STM32 I2C NACK flag is acknowledged for instances >1.
- Fix arithmetic overflow in `Timer::setPeriod` on STM32.
- Validate calculated CRC on MS5611 driver.

New development boards:

- Adafruit Feather-M4 as `modm:feather-m4`.

New device drivers:

- MAX31865 temperature sensor as `modm:driver:max31865`.
- Internal cycle counter as `modm:driver:cycle_counter`.
- MCP3008 ADC driver as `modm:driver:mcp3008`.

Known bugs:

- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Christopher Durand (@chris-durand)
- Daniel Waldhäusl 🎉
- Henrik Hose (@hshose)
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Rasmus Kleist (@rasmuskleist)
- Sascha Schade (@strongly-typed)
- Sergey Pluzhnikov (@ser-plu)
- Thomas Rush (@tarush53)
- Victor Costa (@victorandrehc)
- Vivien Henry (@lukh)

PR #1044 -> 2023q2.

<details>
<summary>Detailed changelog</summary>

#### 2023-06-20: Extend support for ELF2UF2 tool to STM32 and SAM

PR #1038 -> b05df3e.  
Tested in hardware by @tarush53.

#### 2023-06-09: Remove `-fsingle-precision-constant` compile flag

PR #1037 -> 2384756 with medium-impact in floating point variables.  
Tested in hardware by @salkinium.

#### 2023-06-08: Add Adafruit Feather-M4 board support

PR #1032 -> 81b86be.  
Tested in hardware by @tarush53.

#### 2023-06-07: Add support for STM32G0B/C devices

PR #1036 -> 768d749.  
Tested in hardware by @chris-durand.

#### 2023-06-01: Add MCP3008 ADC driver

PR #1028 -> eda224e.  
Tested in hardware by @chris-durand.

#### 2023-05-19: Add complementary channels to TIM driver on STM32

PR #1018 -> 45ae68a.  
Tested in hardware by @ser-plu.

#### 2023-05-15: Implement Protothreads/Resumables using Fibers

PR #1001 -> 45ae68a.  
Tested in hardware by @salkinium.

#### 2023-05-13: Fix FDCAN transmission queue on STM32

PR #1017 -> 9d33843.  
Tested in hardware by @ser-plu, @chris-durand, and @rleh.

#### 2023-05-09: Add MCAN driver for SAMx7x

PR #955 -> bfafcd3.  
Tested in hardware by @rleh.

#### 2023-05-05: Add IWDG driver for STM32

PR #1009 -> d772940.  
Tested in hardware by Daniel Waldhäusl.

#### 2023-05-03: Fix RP2040 multicore access to modm::Clock

PR #1010 -> 389a9c3.  
Tested in hardware by @salkinium.

#### 2023-05-02: Add MAX31865 temperature sensor

PR #993 -> 65bbccf.  
Tested in hardware by @hshose.

#### 2023-04-19: Add ADC driver for SAMx7x

PR #998 -> c7c4c57.  
Tested in hardware by @chris-durand.

#### 2023-04-12: Add DAC and DMA driver for SAMx7x

PR #987 -> 94580b4.  
Tested in hardware by @chris-durand.

#### 2023-04-08: Fix STM32 SPI configuration while running

PR #994 -> 972b74b.  
Tested in hardware by @chris-durand.

</details>
