## 2023-04-06: 2023q1 release

This release covers everything from 2023-01-01 and has been tested with avr-gcc
v12.2.0 from Upstream and arm-none-eabi-gcc 12.2.rel1 from Arm.


Breaking changes:

- SAMV71 Xplained Ultra button polarity.

Features:

- External main clock on SAMx7x.
- SAMx7x SPI driver.
- SAM GpioInverted.
- CANFD large frame support.
- SAM SoftwareGpioPort.
- SAMx7x Timer/counter driver.
- SAMx7x PWM generator driver.
- GCC 12.
- Ability to coredump from GDB directly.
- JLink support.
- Support for STM32U5 devices.
- Repetition Counter on STM32 Advanced Control Timers.
- ADC scan mode, DMA mode and external trigger for STM32F1/F2/F37/F4/F7/L1.
- SAMx7x I2C driver.

Integrated Projects:

- ETL upgraded to v20.35.14.

Fixes:

- Multiple fixes for I²C NACK handling on STM32.
- On Nucleo-F103RB GpioB4 is now usable.
- Systick frequency on SAMx7x.
- Fix static member variable initialization.

New development boards:

- Nucleo-U575ZI-Q as `modm:nucleo-u575zi-q`.
- SAME70 Xplained as `modm:board:same70-xplained`.

New device drivers:

- LSM6DSO imu as `modm:driver:lsm6dso`.
- MS5837 pressure/temperature sensor as `modm:driver:ms5837`.
- AT24MAC402 I2C Eeprom as `modm:driver:at24mac402`.

Known bugs:

- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Christopher Durand (@chris-durand)
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Victor Costa (@victorandrehc) 🎉
- Sascha Schade (@strongly-typed)
- Vivien Henry (@lukh)
- Luiz Gili (@lgili) 🎉
- Mattis Kieffer (@mat-kie) 🎉
- Rasmus Kleist (@rasmuskleist)
- Sebastian Birke (@se-bi)

PR #995 -> 2023q1.

<details>
<summary>Detailed changelog</summary>

#### 2023-04-08: Fix static member variable initialization

Fixes `__cxa_guard_acquire` to construct a static member variable only once!

PR #995 -> 2023q1.  
Tested in hardware by @salkinium.

#### 2023-04-06: Add SAMx7x I2C driver

Including an unittest and examples.

PR #954 -> d1938eb.  
Tested in hardware by @chris-durand.

#### 2023-04-06: Add AT24MAC402 I2C EEPROM driver

This also adds generic support for I2C eeproms with 8 bit addressing.

PR #954 -> d1938eb.  
Tested in hardware by @chris-durand.

#### 2023-04-01: Add ADC DMA mode and external trigger for STM32F1/F2/F37/F4/F7/L1

PR #982 -> 04ed0a5.  
Tested in hardware by @victorandrehc.

#### 2023-03-27: Fix systick frequency on SAMx7x

PR #986 -> 589aea7.  
Tested in hardware by @chris-durand.

#### 2023-03-19: Add support for Repetition Counter on STM32 Advanced Control Timers

PR #981 -> 740fd51.  
Tested in hardware by @victorandrehc.

#### 2023-03-14: Add BSP for SAM E70 Xplained with multiple examples

PR #969 -> a38feca.  
Tested in hardware by @lgili.

#### 2023-03-14: Separate the rx handling part of the XPCC dispatcher

PR #970 -> 2273bae.  
Tested in hardware by @se-bi.

#### 2023-03-13: Add STM32U5 support

Support for all devices of the new STM32U5 family with Cortex-M33 core.
UART and RCC platform drivers are adapted and a BSP for the Nucleo-U575ZI-Q
is also included.

PR #843 -> 8a3a20b.  
Tested in hardware by @rleh.

#### 2023-03-13: Add ADC scan mode supprot for STM32F1/F2/F37/F4/F7/L1

PR #976 -> 08cd479.  
Tested in hardware by @victorandrehc.

#### 2023-03-06: Refactor tooling and add JLink support

- Refactor modm_tools module and debug tooling
- Add JLink debug probe support
- Add ITM and RTT on NUCLEO-64 board

PR #965 -> 241b0d1.  
Tested in hardware by @salkinium.

#### 2023-03-06: Enable GpioB4 on Nucleo-F103RB

PR #967 -> 416ced6.  
Tested in hardware by @strongly-typed.

#### 2023-02-28: Always inline DMA IRQ handler to reduce IRQ latency on STM32

PR #964 -> d982a85.  
Tested in hardware by @strongly-typed.

#### 2023-02-20: Add ability to coredump from GDB directly

PR #961 -> eb2748e.  
Tested in hardware by @salkinium.

#### 2023-02-18: GCC 12 update

- Adapt code and build system to GCC12
- Split AVR Mega Pro unittests into three
- Fix function call in ADC examples

PR #940 -> 923f9c1.  
Tested in hardware by @salkinium.

#### 2023-02-15: Add Nucleo-H723ZG OpenOCD config

PR #960 -> 3cee015.  
Tested in hardware by @mat-kie and @rleh.

#### 2023-02-07: Add support for PWM generator on SAMx7x

PR #957 -> 190bc78.  
Tested in hardware by @chris-durand.

#### 2023-02-06: Add support for timer/counter on SAMx7x

PR #956 -> 95713ee.  
Tested in hardware by @chris-durand.

#### 2023-02-05: Add MS5837 pressure/temperature sensor driver

PR #942 -> 8179e6b.  
Tested in hardware by @lukh.

#### 2023-02-04: Add support for SoftwareGpioPort on SAM

Also adds support for inverted pins in GpioSet.

PR #952 -> afdb5ba.  
Tested in hardware by @chris-durand.

#### 2023-02-04: Add CANFD large frame support

PR #882 -> e4b1a4a.  
Tested in hardware by @rasmuskleist / @twast92.

#### 2023-02-04: Multiple fixes for I²C on STM32

- Fix stm32-extended I2C driver NACK handling
- Start next I2C transaction also when previous failed with NACK
- Do not set invalid I2C_CR1_NOSTRETCH bit in master mode

PR #947 -> ba61a34 and PR #951 -> c347f00.  
Tested in hardware by @chris-durand.

#### 2023-02-01: Add ST LSM6DSO imu driver

PR #950 -> 13ea578.  
Tested in hardware by @rleh.

#### 2023-01-16: Add PLL disable function on STM32

PR #944 -> 0f0505f.  
Tested in hardware by @chris-durand.

#### 2023-01-12: Add support for GpioInverted on SAM

PR #941 -> 4f50d00.  
Tested in hardware by @chris-durand.

#### 2023-01-12: Add SPI support for SAMx7x

PR #938 -> c93dd2c.  
Tested in hardware by @chris-durand.

#### 2023-01-03: Add external main clock support on SAMx7x

PR #939 -> 0259ad2.  
Tested in hardware by @chris-durand.

</details>
