## 2023-01-01: 2022q4 release

This release covers everything from 2022-10-01 and has been tested with avr-gcc
v10.2.0 from Upstream and arm-none-eabi-gcc 10.3-2022.07 from Arm.

Breaking changes:

- None.

Features:

- Basic ADC support for SAMx7x devices.

Integrated Projects:

- printf upgraded to v6.1.0.
- CMSIS-DSP upgraded to v1.14.2.
- TinyUSB upgraded to v0.14.0.
- FreeRTOS upgraded to 202212.
- FatFS upgraded to v0.15.
- LVGL upgraded to v8.3.4.
- NanoPB upgraded to v0.4.7.
- ETL upgraded to v20.35.6.
- STM32L5 headers upgraded to v1.12.0.
- STM32H7 headers upgraded to v1.10.3.

Fixes:

- STM32G4 ADC channel mapping.
- Initialize frame buffer memory in MonochromeGraphicDisplay.
- Only configure BDTR register for timers with complementary PWM.
- Fix SAMx7x b-variant USART defines.

New development boards:

- None.

New device drivers:

- None.

Known bugs:

- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Christopher Durand (@chris-durand)
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Sergey Pluzhnikov (@ser-plu) 🎉

PR #937 -> 2022q4.

<details>
<summary>Detailed changelog</summary>

#### 2022-12-04: Add basic SAMx7x ADC driver

PR #935 -> 7330500.  
Tested in hardware by @chris-durand.

</details>
