## 2022-10-01: 2022q3 release

This release covers everything from 2022-07-01 and has been tested with avr-gcc
v10.2.0 from Upstream and arm-none-eabi-gcc 10.3-2022.07 from Arm.

Breaking changes:

- `Uart` peripheral renamed to `Usart` on SAMG5 devices for consistency.
- `GCLK` peripheral has been refactored for all SAM devices.

Features:

- RP2040 external flash size option.
- RP2040 ADC driver.
- Resolution configuration for DS18B20 driver.
- Use GPIO signal to configure STM32 Timers.
- Support for SAMx5x and SAMx7x devices.

Integrated Projects:

- printf upgraded to v6.0.0.
- LVGL upgraded to v8.3.2.
- ETL upgraded to v20.34.0.
- Pico-SDK upgraded to v1.4.0.
- STM32G0 headers upgraded to v1.4.2.
- STM32F7 headers upgraded to v1.2.8.

Fixes:

- SpiMaster compilation with GCC11.
- Using RTT with multiple channels.
- Relocation of lbuild outpath in `modm:build:make` module.
- Deadlock RP2040 DMA driver due to counter overflow.
- Fix compilation of moving average for floating-point type.
- SAMD `setInput(InputType)` does not always reset to floating anymore.

New development boards:

- Feather-RP2040 as `modm:board:feather-rp2040`.
- ThingPlus-RP2040 as `modm:board:thingplus-rp2040`.
- SAMV71 Xplained Ultra as `modm:board:samv71-xplained-ultra`.
- SAME54 Xplained Pro as `modm:board:same54-xplained-pro`.
- SAMD21 Xplained Pro as `modm:board:samd21-xplained-pro`.

New device drivers:

- ADS7828 ADC as `modm:driver:ads7828`.
- MCP9902/3/4 temperature sensor as `modm:driver:mcp990x`.
- ST7789 display driver as `modm:driver:st7789`.

Known bugs:

- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Artiom (@Artiom9) 🎉
- Christopher Durand (@chris-durand)
- Jonas Kazem Andersen (@JKazem)
- Lucas Mösch (@lmoesch)
- Niklas Hauser (@salkinium)
- Nikolay Semenov (@cocasema)
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)
- Steven Macías (@StevenMacias)

PR #917 -> 2022q3.

<details>
<summary>Detailed changelog</summary>

#### 2022-09-30: Add SAMx5x/x7x device support

Also adds SAMV71 Xplained Ultra and SAME54 Xplained Pro board support packages
and examples. For consistency with other SAM devices, the SAMG `Uart` peripheral
has been renamed to `Usart` in a breaking change. The `GCLK` peripheral has been
refactored for consistency across and to remove hard-coded design choices.

PR #827 -> 8230fef.  
Tested in hardware by @chris-durand with **high impact** on SAM devices.

#### 2022-08-23: Add ST7789 display driver

PR #902 -> 516b2b3.  
Tested in hardware by @cocasema.

#### 2022-08-18: Add ThingPlus-RP2040 BSP

PR #900 -> 874c8d6.  
Tested in hardware by @cocasema.

#### 2022-08-18: Add RP2040 ADC driver

PR #899 -> 490e868.  
Tested in hardware by @cocasema.

#### 2022-08-17: Add Feather-RP2040 BSP

Also adds an option to set the flash size of the external flash chip.

PR #898 -> cceb801.  
Tested in hardware by @cocasema.

#### 2022-08-09: Add MCP9902/3/4 temperature sensor

PR #894 -> 0fd53a8.  
Tested in hardware by @chris-durand.

#### 2022-07-23: Add Nanopb with SCons integration

PR #657 -> 6b5b4ce.  
Tested in hardware by @lmoesch.

#### 2022-07-17: Add ADS7828 ADC driver

PR #887 -> 0cd2bc9.  
Tested in hardware by @JKazem.

</details>
