## 2022-07-01: 2022q2 release

This release covers everything from 2022-04-01 and has been tested with avr-gcc
v11.2.0 from upstream and arm-none-eabi-gcc 10.3-2021.10 from Arm.

Breaking changes:

- None.

Features:

- Custom OpenOCD binary path.
- IRQ handlers for RP2040.
- Expose transmission complete flag on STM32 UART.
- Half transfer handler for STM32 DMA.
- Timer `SlaveModeTrigger::Internal0`/`Internal3` for STM32F4.
- UI Button group refactoring.
- MovingAverage filter refactoring.
- Support for std::chrono in STM32 timer API.

Integrated Projects:

- ETL upgraded to v20.29.3.
- CrashCatcher updated to latest version.

Fixes:

- Fix STM32F7 linker script issue causing memory corruption on some devices.
- STM32H7 RCC clock output.
- CAN system clock frequencies for Nucleo-F446RE/Nucleo-F446ZE boards.
- Cortex-M ITM when `buffer.tx` option not set.
- `Rcc::disable()` on STM32 disabling unrelated clocks.
- Fix `GpioSampler` difference computation.
- Fix missing DMAable capability for DTCM RAM on STM32F7.

New development boards:

- Support for revision B-02 of the DISCO-F469NI development board as
  `modm:disco-f469ni:b-02`.

New device drivers:

- MAX31855 thermocouple-to-digital converter as `modm:driver:max31855`
- ADS101X ADC as `modm:driver:ads101x`
- MS5611 pressure sensor as `modm:driver:ms5611`

Known bugs:

- Cannot set breakpoints on specific lines in debug profile. See #777.
- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special thank you to our first timers 🎉:

- Christopher Durand (@chris-durand)
- Jonas Kazem Andersen (@JKazem) 🎉
- Niklas Hauser (@salkinium)
- Nikolay Semenov (@cocasema) 🎉
- Raphael Lehmann (@rleh)
- Rasmus Kleist (@rasmuskleist)
- Sarah Vilete (@sarahvilete) 🎉
- Sascha Schade (@strongly-typed)
- Sebastian Birke (@se-bi)
- Sebastian Tibor Bakonyvari (@twast92) 🎉
- Thomas Rush (@tarush53) 🎉
- Thomas Sommer (@TomSaw)
- Vivien Henry (@lukh)
- xgzeng 🎉

PR #875 -> 2022q2.

<details>
<summary>Detailed changelog</summary>

#### 2022-06-31: Add support for std::chrono in STM32 timer API

PR #873 -> c949daf.

#### 2022-06-08: MovingAverage filter refactoring

And `reset()` function added.

PR #872 -> 7b5827f.  
Tested by @TomSaw.

#### 2022-05-31: Fix Cortex-M ITM

ITM was previously not working when buffer.tx option was not set.

PR #866 -> 90774be.  
Tested in hardware by @xgzeng.

#### 2022-05-21: UI Button group refactoring

PR #864 -> 55d5911.  
Tested by @TomSaw.

#### 2022-05-11: Add support for revision b-02 of DISCO-F469NI development board

PR #862 -> 4885c53.  
Tested in hardware by @se-bi, @rleh and @salkinium.

#### 2022-05-08: Fix missing CAN system clock frequencies for Nucleo-F446RE/Nucleo-F446ZE boards

PR #861 -> 87b6405.  
Tested in hardware by @strongly-typed.

#### 2022-05-07: Add Timer `SlaveModeTrigger::Internal0`/`Internal3` for STM32F4

PR #859 -> c7bd876.

#### 2022-05-04: Add half transfer handler for STM32 DMA

PR #858 -> dab6c79.

#### 2022-05-03: Add MS5611 pressure sensor driver

PR #851 -> ab9bcee.  
Tested in hardware by @rasmuskleist.

#### 2022-05-01: Expose transmission complete flag on STM32 UART

PR #856 -> 0e3d280.  
Tested in hardware by @strongly-typed.

#### 2022-05-01: Add ADS101X ADC driver

PR #854 -> 596eafa.  
Tested in hardware by @JKazem.

#### 2022-04-30: Fix STM32H7 RCC clock output

PR #853 -> 6e7c12f.  
Tested in hardware by @chris-durand.

#### 2022-04-22: Add MAX31855 thermocouple-to-digital converter driver

PR #850 -> 2e34b11.  
Tested in hardware by @rasmuskleist / @sarahvilete.

#### 2022-04-18: Implement IRQ handlers for RP2040

PR #848 -> 599e0ba.  
Tested in hardware by @cocasema.

#### 2022-04-13: Add support for custom OpenOCD binary path

PR #846 -> 98a2483.  
Tested in hardware by @cocasema.

</details>
