## 2022-04-01: 2022q1 release

This release covers everything from 2022-01-01 and has been tested with avr-gcc
v11.2.0 from upstream and arm-none-eabi-gcc 10.3-2021.10 from Arm.

Breaking changes:

- Removed all functions marked deprecated for >1 year.

Features:

- STM32L5 support.
- Raspberry Pi PR2040 support.
- Microchip SAM timer driver.
- Improved project and Doxygen documentation.
- STM32G4 internal flash driver.
- TinyUSB on STM32G4.

Integrated Projects:

- ETL upgraded to v20.27.1.
- TinyUSB upgraded to v0.13.0.
- LVGL upgraded to v8.2.0.

Fixes:

- Issues when using TinyUSB and FreeRTOS together solved.
- Fix TinyUSB crash when reading device descriptor.
- TinyUSB correctly chooses fullspeed port on STM32 by default.
- Fix SPI bug in handling of CPHA/CPOL on Microchip SAM.
- Read unique ID correctly on SAMG55.
- Fix GPIO peripheral connect method on Microchip SAM.
- Heap allocator defaults to Newlib on devices with one continuous RAM section.
- FreeRTOS now always supports static allocation.

New development boards:

- Support for newer revision (B-03) of the DISCO-F469NI development board
  as `modm:disco-f469ni:b-03`.
- Nucleo-L552ZE-Q as `modm:board:nucleo-l552ze-q`.
- RP-PICO as `modm:board:rp-pico`.

New device drivers:

- ADIS16470 inertial measurement unit driver as `modm:driver:adis16470`.

Known bugs:

- Cannot set breakpoints on specific lines in debug profile. See #777.
- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special thank you to our first timers 🎉:

- Andrey Kunitsyn (@andryblack)
- Christopher Durand (@chris-durand)
- Jeff McBride (@mcbridejc)
- Kaelin Laundry (@WasabiFan)
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Rasmus Kleist (@rasmuskleist) 🎉
- Steven Macías (@StevenMacias)
- Thomas Sommer (@TomSaw)

PR #842 -> 2022q1.

<details>
<summary>Detailed changelog</summary>

#### 2022-03-17: Enable flash driver for STM32G4

PR #838 -> f7dff92.  
Tested in hardware by @rasmuskleist.

#### 2022-02-28: I²C driver for RP2040

PR #830 -> 21ba120.  
Tested in hardware by @andryblack and @rleh.

#### 2022-02-14: Add configuration version for DISCO-F469NI

PR #819 -> b18385c.

#### 2022-02-09: Add driver for SAMG timer channels

PR #823 -> f5cdf6a.  
Tested in hardware by @mcbridejc.

#### 2022-02-09: Fix GPIO peripheral connect method on Atmel SAM

PR #822 -> c868f59.  
Tested in hardware by @mcbridejc.

#### 2022-02-08: Read unique ID correctly for SAMG55

PR #824 -> 845840e.  
Tested in hardware by @mcbridejc.

#### 2022-02-08: Fix SPI bug in handling of CPHA/CPOL

PR #821 -> ac46099.  
Tested in hardware by @mcbridejc.

#### 2022-01-31: Fix issues when using TinyUSB and FreeRTOS together

PR #816 -> 3f3ff3d.  
Tested in hardware by @rleh.

#### 2022-01-24: Add ADIS16470 inertial measurement unit driver

PR #805 -> b153186.  
Tested in hardware by @rleh.

#### 2022-01-24: Add Raspberry Pi RP2040 support

Support for the Raspberry Pi microcontroller RP2040 with two ARM Cortex M0+
cores.
This includes support platform drivers for clock, DMA, GPIO, UART, SPI,
USB (TinyUSB) and a board support package for the Raspberry Pi _Pico_
development board.

PR #806 -> 1c9c0b6.  
Tested in hardware by @andryblack, @rleh and @salkinium.

#### 2022-01-19: Add STM32L5 support

Support for all devices of the new STM32L5 family with Cortex-M33 core.
ADC, DMA, FreeRTOS and RCC platform drivers are adapted and a BSP for the
Nucleo-L552ZE-Q is also included.

PR #800 -> 187ddd8.  
Tested in hardware by @chris-durand.

</details>
