## 2022-01-01: 2021q4 release

This release covers everything from 2021-10-01 and has been tested with avr-gcc
v10.2.0 from Upstream and arm-none-eabi-gcc 10.3-2021.10 from Arm.

Breaking changes:

- `modm:driver:encoder_input.bitbang` has changed its API.
- `modm::Saturated` class has been completely refactored.

Features:

- STM32F1 internal flash driver.
- Use FreeRTOS with static memory by default.
- SAMG UART driver.
- SAMG ADC driver.
- STM32F4 Ethernet support via FreeRTOS+TCP.
- STM32F4 and STM32F7 DMA support.
- VSCode IDE support via `modm:ide:vscode`.
- Experimental support for fibers.
- Vector table remap into SRAM on Cortex-M0+ and STM32F0.
- STM32H7 DMA driver.

Integrated Projects:

- ETL added at v20.22.0.
- TinyUSB upgraded to v0.12.0.
- FreeRTOS upgraded to 202112.00.
- LVGL upgraded to v8.1.0.

Fixes:

- Remove heap dependency for static virtual destructors.
- Correct STM32G4/L4+ voltage scaling and boost mode.
- Move main stack to DMA-able memory for STM32F4.
- Linkerscript alignment issues for copy sections.
- Zero SRAM after uploading to prevent false positive RTT identifier.
- Off-by-One error in EXTI IRQ handler.
- DMA data fixes for STM32G0, L4, H7 and WL.
- Do not reset STM32 Advanced Timer RCR during configuration.

New development boards:

- NUCLEO-L053R8 as `modm:board:nucleo-l053r8`.

New device drivers:

- TMP12{1,3,5} temperature sensor as `modm:driver:tmp12x`.
- Encoder Input via STM32 Timer as `modm:driver:encoder_input`.
- MCP7941X RTC driver with EUI-48/64 and EEPROM as `modm:driver:mcp7941x`.
- ADS816X ADC diver as `modm:driver:ads816x`.

Known bugs:

- Cannot set breakpoints on specific lines in debug profile. See #777.
- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special thank you to our first timers 🎉:

- Andrey Kunitsyn (@andryblack) 🎉
- Christopher Durand (@chris-durand)
- Jacob Schultz Andersen (@jasa)
- Jeff McBride (@mcbridejc)
- Kaelin Laundry (@WasabiFan)
- Niklas Hauser (@salkinium)
- Odin Holmes (@odinthenerd) 🎉
- Pavel Pletenev (@ASMfreaK)
- Raphael Lehmann (@rleh)
- Sebastian Birke (@se-bi)
- Steven Macías (@StevenMacias) 🎉
- Thomas Sommer (@TomSaw)

PR #797 -> 2021q4.

<details>
<summary>Detailed changelog</summary>

#### 2021-12-31: Add ADS816X ADC driver

PR #796 -> 3ba71c9.  
Tested in hardware by @rleh.

#### 2021-12-31: Add STM32H7 DMA driver

PR #772 -> e3c0321.  
Tested in hardware by @chris-durand.

#### 2021-12-19: Add MCP7941X RTC driver

PR #748 -> 5a9ad25.  
Tested in hardware by @rleh.

#### 2021-12-14: Refactor modm::Saturated

PR #780 -> c0a8c51.  
Tested in hardware by @TomSaw with **high impact** on API.

#### 2021-11-18: Add vector table remap on Cortex-M0+ and STM32F0

PR #773 -> fdbb45b.  
Tested in hardware by @chris-durand.

#### 2021-11-15: Add encoder input driver via STM32 timers

PR #775 -> d46c09d.  
Tested in hardware by @TomSaw.

#### 2021-10-29: Add basic support for fibers

You must enable the hidden repository option `modm:__fibers` to use them.

PR #743 -> 3936a28.  
Tested in hardware by @salkinium.

#### 2021-10-29: Add VSCode IDE integration

PR #764 -> 6b4d656.  
Tested by @rleh and @salkinium.

#### 2021-10-28: Add DMA driver for STM32F4 and STM32F7

PR #629 -> 5dcdf1d.  
Tested in hardware by @rleh.

#### 2021-10-25: Fix linkerscript alignment issues

This fixes copying data sections with the wrong alignment.

PR #763 -> b78acd5.  
Tested in hardware by @salkinium with **high impact** on `.fastcode` section.

#### 2021-10-23: Add SAMG ADC driver

PR #753 -> 82bc4a9.  
Tested in hardware by @mcbridejc.

#### 2021-10-22: Add SAMG UART driver

PR #761 -> 6e9f000.  
Tested in hardware by @mcbridejc.

#### 2021-10-21: Add NUCLEO-L053R8 board and example

PR #756 -> 0d6a937.  
Tested in hardware by @salkinium.

#### 2021-10-21: Add TMP12x temperature sensor driver

PR #757 -> 624ce10.  
Tested in hardware by @chris-durand.

#### 2021-10-19: FreeRTOS with static memory

Adds static allocation support when used without `modm:platform:heap` module.

PR #750 -> 9e50a16.  
Tested in hardware by @andryblack and @salkinium.

#### 2021-10-14: Weak operator delete

Static virtual C++ destructors can emit operator delete, this marks the
operators as weak which prevents pulling in Newlib.

PR #747 -> 387a625.  
Tested in hardware by @delphi and @salkinium.

#### 2021-10-12: Add ETL module

PR #667 -> 2ef7a29.  
Tested in hardware by @rleh and @salkinium.

#### 2021-10-10: Add STM32F1 flash driver

PR #745 -> f4c7492.  
Tested in hardware by @delphi.

</details>
