## 2021-10-01: 2021q3 release

This release covers everything from 2021-07-01 and has been tested with avr-gcc
v10.2.0 from Upstream and arm-none-eabi-gcc 10.3-2021.07 from Arm.

Breaking changes:

- STM32 EXTI configuration moved into separate `modm:platform:exti` module.
- STM32F3 ADC flags API made consistent with rest of ADC implementations.
- AVR SPI mode 1/2 was swapped.
- Interface SPI mode 3/4 was swapped.
- Configuration of CMSIS-DSP module is now done via `<arm_math_local.h>` file.

Features:

- STM32H7 support.
- SAMG55 support with USB and SPI drivers.
- SAMV70 support.
- STM32F1 ADC calibration.
- Adding silicon revision to `modm:target` option with `/revN` suffix.
- `modm_initialize_platform()` hook called right after startup.
- Strict IRQ name validation: Never wonder again why your IRQ isn't called!
- Much faster lbuild generation of `modm:platform:gpio` due to fewer files.
- New `modm:platform:exti` module for STM32 with optional IRQ handlers.

Integrated Projects:

- LVGL upgraded to v8.0.2.
- TinyUSB upgraded to v0.11.0.
- FreeRTOS upgraded to 202107.
- CMSIS-DSP upgraded to v5.8.0.

Fixes:

- Longer modm::delay_ms implementation.
- Lower C++ binary size due to not using `atexit` function.
- SPI mode 3/4 was swapped in interface, mode 1/2 swapped on AVR.
- Enable FPU in assembly before startup script.
- Fix inconsistent flags API for STM32F3 ADC.
- Refactored GpioConnector to remove `template< Peripheral _ >` signal
  boilerplate.

New development boards:

- NUCLEO-H743ZI as `modm:board:nucleo-h743zi`.
- NUCLEO-H723ZG as `modm:board:nucleo-h723zg`.
- Smart Response XE as `modm:board:srxe`.
- SAM G55 Xplained Pro as `modm:board:samg55-xplained-pro`.
- DevEBox STM32H750VB as `modm:board:devebox-stm32h750vb`.

New device drivers:

- ST7586S display as `modm:driver:st7586s`.

Known bugs:

- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Christopher Durand (@chris-durand)
- Daniel Krebs (@daniel-k)
- Henrik Hose (@hshose) 🎉
- Jakob Riepler (@XDjackieXD) 🎉
- Jeff McBride (@mcbridejc)
- Niklas Hauser (@salkinium)
- Thomas Sommer (@TomSaw)
- Tomasz Wasilczyk (@twasilczyk) 🎉
- Valeriy Osipov (@SgtPepperFTW) 🎉

PR #742 -> 2021q3.

<details>
<summary>Detailed changelog</summary>

#### 2021-09-30: Upgrade CMSIS-DSP to v5.8.0

The `:cmsis:dsp` module options were removed in favor of letting the user
define them freely using a `<arm_math_local.h>` config file.

PR #742 -> 12bb41b.  
Tested in hardware by @salkinium with **medium impact** on config.

#### 2021-09-29: Refactor GPIO implementations

New implementation generates fewer files, which speeds up `lbuild build`
significantly for devices with many pins. EXTI implementation was moved into
its own module with an optional IRQ handler abstraction. Refactored signals
implementation to remove dragging around `template< Peripheral _ >` boilerplate.

PR #686 -> 30e24e6.  
Tested in hardware by @salkinium with **high impact** on EXTI code.

#### 2021-09-22: Add SAMV70 support

On custom hardware.

PR #681 -> 9036666.  
Tested in hardware by @twasilczyk.

#### 2021-09-17: Strict IRQ name validation

Validates `MODM_ISR(name)` at compile time to you never declare the wrong
IRQ that won't get called.

PR #685 -> 6057873.  
Tested in hardware by @salkinium with low impact on `MODM_ISR(name)`.

#### 2021-09-16: Add DevEBox STM32H750VB board and example

PR #678 -> b4eddeb.  
Tested in hardware by @hshose.

#### 2021-09-10: Add SAMG55 SPI driver

PR #680 -> f4d5d6c.  
Tested in hardware by @mcbridejc.

#### 2021-09-09: Add SAMG55 USB driver via TinyUSB

PR #679 -> 93bba13.  
Tested in hardware by @mcbridejc.

#### 2021-09-09: Add SAMG55 support

Also adds SAM G55 Xplained Pro board and example.

PR #676 -> c148bf8.  
Tested in hardware by @mcbridejc.

#### 2021-09-07: Add ST7586S display driver

PR #673 -> 2c22fae.  
Tested in hardware by @twasilczyk.

#### 2021-08-23: Smart Response XE board and example

Adds support for the ATmega128RFA1 and the Smart Response XE board.

PR #669 -> a173bde.  
Tested in hardware by @twasilczyk.

#### 2021-07-15: Add STM32H7 support

Also adds NUCLEO-H743ZI and NUCLEO-H723ZG boards and examples.

PR #652 -> 80ed738.  
Tested in hardware @chris-durand and @salkinium.

</details>
