## 2021-07-01: 2021q2 release

This release covers everything from 2021-04-01 and has been tested with avr-gcc
v10.1.0 from Upstream and arm-none-eabi-gcc 2020q4 from Arm.

Breaking changes:

- TinyUSB updated from v0.8.0 to v0.10.1 with breaking changes to their APIs.
- FreeRTOS configuration must be done by the user via the headers
  `<FreeRTOSConfigLocal.h>` and `<FreeRTOSIPConfigLocal.h>`.
- `modm::GraphicDisplay` API changed due to change in color management.
- New color types and API.
- New CMake build system has different API without top-level Makefile.

Features:

- STM32L0 support.
- Real-Time Transport (RTT) support via OpenOCD v0.11.
- FDCAN driver for STM32G4 (only for standard messages).
- DMA support for all STM32 devices, except F2/F4/F7.
- Better graphical display and color support.
- New CMake build system for better IDE integration.
- Top-level build scripts relicensed as BSD to allow easier adaptation.
- LPUART driver for STM32.
- DAC driver with DMA support for STM32.
- Non-allocating util classes `modm::inplace_any` and `modm::inplace_function`.

Integrated Projects:

- LVGL added at v8.0.1.
- Petit FatFs added at v0.03a.
- FatFs upgraded to v0.14b.
- TinyUSB upgraded to v0.10.1.
- FreeRTOS upgraded to 202012 LTS.

Fixes:

- OpenOCD ITM configuration for logging.
- Much more accurate nanosecond delay.
- realloc with NULL pointer calls malloc when using TLSF allocator.

New development boards:

- NUCLEO-L031K6 as `modm:board:nucleo-l031k6`.
- NUCLEO-F072RB as `modm:board:nucleo-f072rb`.
- NUCLEO-L496ZG-P as `modm:board:nucleo-l496zg-p`.
- NUCLEO-F091RC as `modm:board:nucleo-f091rc`.

New device drivers:

- SH1106 display as `modm:driver:sh1106`.
- STTS22H thermometer as `modm:driver:stts22h`.

Known bugs:

- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors:

- Christopher Durand (@chris-durand)
- Jacob Schultz Andersen (@jasa)
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)
- Thomas Sommer (@TomSaw)

PR #597 -> 2021q2.

<details>
<summary>Detailed changelog</summary>

#### 2021-06-16: More accurate modm::delay implementation

PR #642 -> cc15b1a.  
Tested in hardware by @salkinium.

#### 2021-06-07: Extend DMA driver for even more STM32 devices

PR #632 -> 8896b5b.  
Tested in hardware by @chris-durand.

#### 2021-06-06: Add DAC driver with DMA support

PR #632 -> 9cbea26.  
Tested in hardware by @chris-durand.

#### 2021-05-20: Refactor color implementation

PR #616 -> a105072 with **high impact** on color types.  
Tested by @TomSaw.

#### 2021-05-10: Add LPUART driver for STM32

PR #614 -> 897579e.  
Tested in hardware by @rleh.

#### 2021-05-08: Add STTS22H temperature driver

PR #544 -> 9e7ec34.  
Tested in hardware by @chris-durand.

#### 2021-05-08: New CMake build system

PR #568 -> 98b1337 with **high impact** on CMake build systems.  
Tested by @jasa and @salkinium.

#### 2021-05-07: Add SH1106 display driver

PR #627 -> 7d7490d.  
Tested in hardware by @TomSaw.

#### 2021-04-22: Specialize modm::GraphicDisplay for monochrome and color

To enable optimizations for different color formats, the graphic display base
classes are refactored into monochrome and color classes.

PR #604 -> 295dbc3 with medium impact on display drivers and graphics code.  
Tested in hardware by @TomSaw.

#### 2021-04-14: Adapt DMA driver for more STM32 devices

PR #608 -> 8ca2f35.  
Tested in hardware by @rleh.

#### 2021-04-13: Add FDCAN driver for STM32G4

PR #607 -> 2d2199b.  
Tested in hardware by @chris-durand.

#### 2021-04-12: Add RTT support via OpenOCD

PR #610 -> 1375ff1.  
Tested in hardware by @salkinium.

#### 2021-04-11: Upgrade FreeRTOS to 202012 LTS

The default configuration modm provides changed, and now only provides the bare
minimum config and the remainder needs to be user-provided via the headers
`<FreeRTOSConfigLocal.h>` and `<FreeRTOSIPConfigLocal.h>`

PR #566 -> 1375ff1 with **high impact** on configuration management.  
Tested in hardware by @salkinium.

#### 2021-04-06: Integrate Petit FatFs v0.03a and upgrade FatFs to v0.14a

PR #566 -> 1f5d06e.  
Tested in hardware by @salkinium.

#### 2021-04-06: Upgrade TinyUSB to v0.9.0

TinyUSB is breaking their own API quite often, so existing applications must be
adapted. Any modm wrapper APIs are unaffected. See module docs for additional
customization via the `<tusb_config_local.h>` header.

PR #566 -> 1f5d06e with **high impact** on TinyUSB API.  
Tested in hardware by @salkinium.

#### 2021-04-06: Integrate LVGL v7.11 for Cortex-M

PR #603 -> e0d1327.  
Tested in hardware by @rleh and @salkinium.

#### 2021-04-02: Add STM32L0 support

Also adds NUCLEO-L031K6 board and example.

PR #600 -> 0cf1c65.  
Tested in hardware @chris-durand.

</details>
