## 2021-04-01: 2021q1 release

This release covers everything from 2021-01-01 and has been tested with avr-gcc
v10.1.0 from Upstream and arm-none-eabi-gcc 2020q4 from Arm.

Breaking changes:

- `Uart::initialize()` arguments and behaviour changed on STM32.
- Complete rewrite of TCS34xx color sensor driver.

Features:

- Update AVR libstdc++ to C++20.
- Enable C++20 with GCC10.
- Ethernet support via FreeRTOS-TCP and LAN8720a.
- STM32: optional UART buffers per direction.
- Using relative paths in ELF files to easier archiving.
- Dark mode for Doxypress documentation.
- Makefile build system generator.
- Better Windows installation instructions.

Fixes:

- STM32F4/F7: Overdrive mode.
- STM32G4: TIM2 and TIM5 as 32-bit timer.
- STM32F0: ADC temperature calibration.
- STM32G4: ADC clock.
- SAMD21 Mini BSP fixes.
- Windows: Uploading via AvrDude.

New development boards:

- NUCLEO-F439ZI as `modm:board:nucleo-f439zi`.
- NUCLEO-F446ZE as `modm:board:nucleo-f446ze`.
- NUCLEO-F767ZI as `modm:board:nucleo-f767zi`.
- NUCLEO-L452RE as `modm:board:nucleo-l452re`.

New device drivers:

- MMC5603 compass as `modm:driver:mmc5603`.
- LAN8720a ethernet transceiver as `modm:driver:lan8720a`.
- STUSB4500 USB-PD controller as `modm:driver:stusb4500`.
- Bit-banged encoder input as `modm:driver:encoder_input.bitbang`.
- Touch2046/TSC2046 touchscreen controller as `modm:driver:touch2046`.

Known bugs:

- C++20 is not fully implemented by GCC10 yet, however modm does not use all
  features yet anyways. See #326.
- Nanosecond delay may be inaccurate. See #495.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.
- `arm-none-eabi-gdb` TUI and GDBGUI interfaces are not supported on Windows.
  See #591.

Many thanks to all our contributors.
A special shoutout to first timers 🎉:

- Cerem Cem ASLAN (@ceremcem) 🎉
- Christopher Durand (@chris-durand)
- David Hebbeker (@dhebbeker)
- Jacob Schultz Andersen (@jasa) 🎉
- Mike Wolfram (@mikewolfram)
- Nicolai Bruhn (@nicoBruhn) 🎉
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)
- Thomas Sommer (@TomSaw) 🎉
- Vivien Henry (@lukh)

PR #597 -> 2021q1.

<details>
<summary>Detailed changelog</summary>

#### 2021-03-31: Add Touch2046/TSC2046 touchscreen controller

Also adds NUCLEO-L452RE board and example.

PR #600 -> b1e5588.  
Tested by @rleh.

#### 2021-03-26: Add Makefile build system generator

PR #557 -> df47974.  
Tested by @salkinium.

#### 2021-03-22: Add Bit-banged encoder input driver

PR #580 -> df47974.  
Tested in hardware by @TomSaw.

#### 2021-03-16: Rewrite TCS34xx color sensors

Breaking changes: Entire API was rewritten.

PR #578 -> 850b554 with **high impact** on TCS34xx driver.  
Tested in hardware by @TomSaw.

#### 2021-03-06: Add STUSB4500 USB-PD controller driver

PR #574 -> 1a11b08.  
Tested in hardware by @rleh.

#### 2021-03-06: Add NUCLEO-F439ZI board and example

PR #571 -> 165adf0.  
Tested in hardware by @rleh.

#### 2021-02-26: Refactor SCons build system

Adds relative paths in ELF file.

PR #558 -> 1fc3805.  
Tested by @salkinium.

#### 2021-02-23: Refactor UART HAL

Makes UART buffers individually optional by setting their size to zero.
Breaking changes:

- `Uart::initialize(IrqPriority, Parity)` -> `Uart::initialize(Parity, WordLength)`.
- Word length is not automatically set to 9-bits when setting parity anymore.
- `UartHal::setLastBitClockPulse(LastBitClockPulse)` removed.
- `UartHal::setSpiClock(SpiClock)` -> `UartHal::setSpiClock(SpiClock, LastBitClockPulse)`.
- You must now manually call `UartHal::{en,dis}ableOperation()` before modifying UartHal.

PR #564 -> 62b63f5 with **high impact** on STM32 targets.  
Tested in hardware by @salkinium.

#### 2021-02-18: Add Ethernet support via FreeRTOS-TCP and LAN8720a

Also adds NUCLEO-F767ZI board.

PR #466 -> d8be0a2.  
Tested in hardware by @mikewolfram.

#### 2021-01-14: Add MMC5603 compass driver

PR #556 -> fb2ff58.  
Tested in hardware by @salkinium.

#### 2021-01-14: Fix STM32F0 ADC temperature sensor

PR #526 -> 3ecad35 with low impact on STM32F0 targets.  
Tested in hardware by @chris-durand.

#### 2021-01-10: Add NUCLEO-F446ZE board and example

PR #533 -> 02b1571.  
Tested in hardware by @chris-durand.

#### 2021-01-10: Enable C++20

PR #521 -> 8c322a2 with low impact on all targets.  
Tested in hardware by all.

#### 2021-01-10: Update avr libstdc++ submodule to C++20 version

PR #535 -> 038657c with low impact on AVR targets.  
Tested in hardware by @chris-durand.

</details>
