## 2021-01-01: Virtual 2020q4 release

This is a virtual release only for reference that covers everything from
2020-10-01.

Breaking changes:

- SAMD GPIO connector API is rewritten.

Features:

- Added a `.clang-format` for automated code styling.
- Update FatFS from v0.09 to v0.13.

Fixes:

- STM32F3: Fix missing HsiDiv2 in PllSource.
- FreeRTOS: Fix SystemCoreClock linking.
- Proper lookup of all IOStream `operator<<` overloads.

New development boards:

- NUCLEO-F334R8 as `modm:board:nucleo-f334r8`.
- NUCLEO-G431KB as `modm:board:nucleo-g431kb`.
- NUCLEO-G431RB as `modm:board:nucleo-g431rb`.

No new device drivers.

Known bugs:

- Nanosecond delay may be inaccurate. See #495.
- STM32F7: D-Cache not enabled by default. See #485.
- `lbuild build` and `lbuild clean` do not remove all previously generated files
  when the configuration changes. See #285.
- Generating modm on Windows creates paths with `\` that are not compatible with
  Unix. See #310.

Many thanks to all our contributors:

- Christopher Durand (@chris-durand)
- Erik Henriksson (@henrikssn)
- Jeff McBride (@mcbridejc)
- Mike Wolfram (@mikewolfram)
- Niklas Hauser (@salkinium)
- Raphael Lehmann (@rleh)
- Sascha Schade (@strongly-typed)

<details>
<summary>Detailed changelog</summary>

#### 2020-12-16: Add NUCLEO-G431RB board and example

PR #490 -> 195f7e1.  
Tested in hardware by @rleh.

#### 2020-11-16: Add NUCLEO-G431KB board and example

PR #499 -> 276f5b3.  
Tested in hardware by @mcbridejc.

#### 2020-11-04: Update FatFs to v0.13

PR #497 -> 7df2e7d with **medium impact** on all targets.  
Tested in hardware by @salkinium.

#### 2020-10-07: Rewrite of SAMD GPIO connector API

PR #482 -> dc56af2 with **high impact** on SAMD targets.  
Tested in hardware by @henrikssn.

#### 2020-10-06: Add NUCLEO-F334R8 board and example

PR #489 -> 85eec34.  
Tested in hardware by @rleh.

</details>
